/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg;

import com.sap.security.saml2.cfg.SAML2EntranceLocationMappingsImpl;
import com.sap.security.saml2.cfg.SAML2ModifiableLocalSPImpl;
import com.sap.security.saml2.cfg.SAML2UpdateableProviderBase;
import com.sap.security.saml2.cfg.enums.SAML2Binding;
import com.sap.security.saml2.cfg.enums.SAML2IdPSelectionMode;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.interfaces.read.SAML2BackChannelSecurityPolicy;
import com.sap.security.saml2.cfg.interfaces.read.SAML2CfgAuthenticationContext;
import com.sap.security.saml2.cfg.interfaces.read.SAML2CfgUMEAttribute;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalProvider;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalSP;
import com.sap.security.saml2.cfg.interfaces.read.SAML2MetadataSettings;
import com.sap.security.saml2.cfg.interfaces.read.SAML2RedirectApplicationConfiguration;
import com.sap.security.saml2.cfg.interfaces.write.SAML2ModifiableLocalProvider;
import com.sap.security.saml2.cfg.interfaces.write.SAML2ModifiableLocalSP;
import com.sap.tc.logging.Location;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class SAML2LocalSPImpl
extends SAML2UpdateableProviderBase
implements SAML2LocalSP {
    private static final Location LOCATION = Location.getLocation(SAML2LocalSPImpl.class);
    protected static final String CFG_SHEET_NAME = "sp";
    private SAML2LocalProvider localProvider;
    protected static final String KEY_AFFILIATION = "affiliation";
    protected static final String KEY_ASSERTION_CONSUMER_SUPPORTED_BINDINGS = "supported_bindings_acs";
    protected static final String KEY_SINGLE_LOGOUT_SUPPORTED_BINDINGS = "supported_bindings_slo";
    protected static final String KEY_MANAGE_NAME_ID_SUPPORTED_BINDINGS = "supported_bindings_mni";
    protected static final String KEY_ASK_FOR_PREFERRED_IDP = "ask_for_preferred_idp";
    protected static final String KEY_IDP_SELECTION_MODE = "idp_selection_mode";
    protected static final String KEY_PROXY_COUNT = "proxy_count";
    protected static final String KEY_USE_INTERNAL_IDP_DISCOVERY_READ_SERVICE = "use_internal_cdc_read_service";
    protected static final String KEY_USE_EXTERNAL_IDP_DISCOVERY_READ_SERVICE = "use_external_cdc_read_service";
    protected static final String KEY_EXTERNAL_IDP_DISCOVERY_READ_SERVICE_URL = "external_cdc_read_service_url";
    protected static final String KEY_DEFAULT_ENTRANCE_LOCATION = "default_entrance_location";
    protected static final String KEY_IDP_INITIATED_SSO_ENABLED = "idp_initiated_sso_enabled";
    protected static final String KEY_SP_INITIATED_SSO_ENABLED = "sp_initiated_sso_enabled";
    protected static final String KEY_IDP_INITIATED_SLO_ENABLED = "idp_initiated_slo_enabled";
    protected static final String KEY_SP_INITIATED_SLO_ENABLED = "sp_initiated_slo_enabled";
    protected static final String KEY_IDP_INITIATED_MNI_ENABLED = "idp_initiated_mni_enabled";
    protected static final String KEY_SP_INITIATED_MNI_ENABLED = "sp_initiated_mni_enabled";
    protected static final String KEY_RELAXATION_LEVEL = "relaxation_level";
    private SAML2EntranceLocationMappingsImpl entranceLocationMappings;

    SAML2LocalSPImpl(String cfgPath, SAML2LocalProvider localProvider) {
        super(cfgPath, CFG_SHEET_NAME);
        this.localProvider = localProvider;
    }

    @Override
    public String getAffiliation() {
        return this.readProperty(KEY_AFFILIATION);
    }

    @Override
    public String getAssertionConsumerLocationHardCoded() {
        return "/saml2/sp/acs";
    }

    @Override
    public int getDomainRelaxLevel() {
        return this.readIntProperty(KEY_RELAXATION_LEVEL, -1);
    }

    @Override
    public Set<SAML2Binding> getAssertionConsumerSupportedBindings() {
        return this.readSupportedBindings(KEY_ASSERTION_CONSUMER_SUPPORTED_BINDINGS);
    }

    @Override
    public String getSingleLogoutLocationHardCoded() {
        return "/saml2/sp/slo";
    }

    @Override
    public String getManageNameIDLocationHardCoded() {
        return "/saml2/sp/mni";
    }

    @Override
    public Set<SAML2Binding> getSingleLogoutSupportedBindings() {
        return this.readSupportedBindings(KEY_SINGLE_LOGOUT_SUPPORTED_BINDINGS);
    }

    @Override
    public Set<SAML2Binding> getManageNameIDSupportedBindings() {
        return this.readSupportedBindings(KEY_MANAGE_NAME_ID_SUPPORTED_BINDINGS);
    }

    @Override
    public Integer getProxyCount() {
        return this.readIntProperty(KEY_PROXY_COUNT, 1);
    }

    @Override
    public SAML2IdPSelectionMode getIdPSelectionMode() {
        SAML2IdPSelectionMode defaultSelectionMode = this.isToAskForPreferredIdP() ? SAML2IdPSelectionMode.MANUAL : SAML2IdPSelectionMode.AUTOMATIC;
        return this.readIdPSelectionMode(KEY_IDP_SELECTION_MODE, defaultSelectionMode);
    }

    @Override
    public boolean isToUseInternalIdPDiscoveryReadService() {
        return Boolean.parseBoolean(this.readProperty(KEY_USE_INTERNAL_IDP_DISCOVERY_READ_SERVICE));
    }

    @Override
    public boolean isToUseExternalIdPDiscoveryReadService() {
        return Boolean.parseBoolean(this.readProperty(KEY_USE_EXTERNAL_IDP_DISCOVERY_READ_SERVICE));
    }

    @Override
    public String getExternalIdPDiscoveryReadServiceUrl() {
        return this.readProperty(KEY_EXTERNAL_IDP_DISCOVERY_READ_SERVICE_URL);
    }

    @Override
    public String getDefaultEntranceLocation() {
        return this.readProperty(KEY_DEFAULT_ENTRANCE_LOCATION);
    }

    @Override
    public String getEntranceLocation(String key) {
        return this.readEntranceLocationMappings().getEntranceLocation(key);
    }

    @Override
    public Map<String, String> getEntranceLocations() {
        return this.readEntranceLocationMappings().getEntranceLocationMappings();
    }

    @Override
    public String getArtifactResolutionLocationHardCoded() {
        return this.localProvider.getArtifactResolutionLocationHardCoded();
    }

    @Override
    public Set<SAML2Binding> getArtifactResolutionSupportedBindings() {
        return this.localProvider.getArtifactResolutionSupportedBindings();
    }

    @Override
    public int getArtifactValidityPeriodInSeconds() {
        return this.localProvider.getArtifactValidityPeriodInSeconds();
    }

    @Override
    public Certificate getCertificateForSignature() throws SAML2ConfigurationException {
        return this.localProvider.getCertificateForSignature();
    }

    @Override
    public int getClockSkewToleranceInSeconds() {
        return this.localProvider.getClockSkewToleranceInSeconds();
    }

    @Override
    public String getEncryptionKeyPairName() {
        return this.localProvider.getEncryptionKeyPairName();
    }

    @Override
    public String getKeyStoreViewName() {
        return this.localProvider.getKeyStoreViewName();
    }

    @Override
    public String getTrustedCAsViewName() {
        return this.localProvider.getTrustedCAsViewName();
    }

    @Override
    public SAML2ModifiableLocalProvider getModifiableLocalProvider() throws SAML2ConfigurationException {
        return this.localProvider.getModifiableLocalProvider();
    }

    @Override
    public String getName() {
        return this.localProvider.getName();
    }

    @Override
    public byte[] getID() {
        return this.localProvider.getID();
    }

    @Override
    public PrivateKey getPrivateKeyForEncryption() throws SAML2ConfigurationException {
        return this.localProvider.getPrivateKeyForEncryption();
    }

    @Override
    public PrivateKey getPrivateKeyForSignature() throws SAML2ConfigurationException {
        return this.localProvider.getPrivateKeyForSignature();
    }

    @Override
    public PublicKey getPublicKeyForEncryption() throws SAML2ConfigurationException {
        return this.localProvider.getPublicKeyForEncryption();
    }

    @Override
    public Certificate getCertificateForEncryption() throws SAML2ConfigurationException {
        return this.localProvider.getCertificateForEncryption();
    }

    @Override
    public String getSigningKeyPairName() {
        return this.localProvider.getSigningKeyPairName();
    }

    @Override
    public boolean isToIncludeCertInSignature() {
        return this.localProvider.isToIncludeCertInSignature();
    }

    @Override
    public boolean isToSignMetadata() {
        return this.localProvider.isToSignMetadata();
    }

    @Override
    public boolean issueSAPLogonTickets() {
        return this.localProvider.issueSAPLogonTickets();
    }

    @Override
    public synchronized SAML2BackChannelSecurityPolicy getBackChannelSecurityPolicy() {
        return this.localProvider.getBackChannelSecurityPolicy();
    }

    @Override
    public SAML2MetadataSettings getMetadataSettings() {
        return this.localProvider.getMetadataSettings();
    }

    @Override
    public Collection<SAML2CfgAuthenticationContext> getAuthenticationContexts() {
        return this.localProvider.getAuthenticationContexts();
    }

    @Override
    public SAML2CfgAuthenticationContext getAuthenticationContextByName(String name) {
        return this.localProvider.getAuthenticationContextByName(name);
    }

    @Override
    public SAML2CfgAuthenticationContext getAuthenticationContextByAlias(String alias) {
        return this.localProvider.getAuthenticationContextByAlias(alias);
    }

    @Override
    public Collection<SAML2CfgUMEAttribute> getUMEAttributes() {
        return this.localProvider.getUMEAttributes();
    }

    @Override
    public SAML2CfgUMEAttribute getUMEAttributeByAlias(String alias) {
        return this.localProvider.getUMEAttributeByAlias(alias);
    }

    @Override
    public boolean isToAskForPreferredIdP() {
        return Boolean.parseBoolean(this.readProperty(KEY_ASK_FOR_PREFERRED_IDP, "false"));
    }

    @Override
    public boolean isPlainHTTPConnectionsEnabled() {
        return this.localProvider.isPlainHTTPConnectionsEnabled();
    }

    @Override
    public String getCustomLogonPageAlias() {
        return this.localProvider.getCustomLogonPageAlias();
    }

    @Override
    public int getIssueInstantValidityNotBeforeInMinutes() {
        return this.localProvider.getIssueInstantValidityNotBeforeInMinutes();
    }

    @Override
    public int getIssueInstantValidityNotAfterInMinutes() {
        return this.localProvider.getIssueInstantValidityNotAfterInMinutes();
    }

    @Override
    public SAML2ModifiableLocalSP getModifiableLocalSP() throws SAML2ConfigurationException {
        return new SAML2ModifiableLocalSPImpl(this.getCfgPath(), this);
    }

    @Override
    protected synchronized void cleanCachedObjects() {
        this.entranceLocationMappings = null;
    }

    private synchronized SAML2EntranceLocationMappingsImpl readEntranceLocationMappings() {
        if (this.isStateDeleted()) {
            throw new IllegalStateException("Configuration for SAML2 Provider is already deleted. Configuration path: " + this.getCfgPath());
        }
        if (this.entranceLocationMappings == null) {
            this.entranceLocationMappings = new SAML2EntranceLocationMappingsImpl(this);
        }
        return this.entranceLocationMappings;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("\nSP cfg path: ").append(super.toString());
        builder.append("\n").append(this.localProvider);
        builder.append("\nAsk user for prefered IdP: ").append(this.isToAskForPreferredIdP());
        builder.append("\nIdP selection mode: ").append((Object)this.getIdPSelectionMode());
        builder.append("\nUse internal IdP discovery read service: ").append(this.isToUseInternalIdPDiscoveryReadService());
        builder.append("\nUse external IdP discovery read service: ").append(this.isToUseExternalIdPDiscoveryReadService());
        builder.append("\nExternal IdP discovery read service url: ").append(this.getExternalIdPDiscoveryReadServiceUrl());
        builder.append("\nAffiliation: ").append(this.getAffiliation());
        builder.append("\nProxy Count: ").append(this.getProxyCount());
        builder.append("\nACS supported bindings: ").append(this.getAssertionConsumerSupportedBindings());
        builder.append("\nSLO supported bindings: ").append(this.getSingleLogoutSupportedBindings());
        builder.append("\nMNI supported bindings: ").append(this.getManageNameIDSupportedBindings());
        builder.append("\nDefault entrance location: ").append(this.getDefaultEntranceLocation());
        builder.append("\nEntrance location mappings: ").append(this.getEntranceLocations());
        builder.append("\nIdP-Initiated SSO enabled: ").append(this.isIdPInitiatedSSOEnabled());
        builder.append("\nIdP-Initiated SLO enabled: ").append(this.isIdPInitiatedSLOEnabled());
        builder.append("\nIdP-Initiated MNI enabled: ").append(this.isIdPInitiatedMNIEnabled());
        builder.append("\nSP-Initiated SSO enabled: ").append(this.isSPInitiatedSSOEnabled());
        builder.append("\nSP-Initiated SLO enabled: ").append(this.isSPInitiatedSLOEnabled());
        builder.append("\nSP-Initiated MNI enabled: ").append(this.isSPInitiatedMNIEnabled());
        builder.append("\n");
        return builder.toString();
    }

    @Override
    public boolean isIdPInitiatedSLOEnabled() {
        return Boolean.parseBoolean(this.readProperty(KEY_IDP_INITIATED_SLO_ENABLED, "true"));
    }

    @Override
    public boolean isIdPInitiatedSSOEnabled() {
        return Boolean.parseBoolean(this.readProperty(KEY_IDP_INITIATED_SSO_ENABLED, "true"));
    }

    @Override
    public boolean isSPInitiatedSLOEnabled() {
        return Boolean.parseBoolean(this.readProperty(KEY_SP_INITIATED_SLO_ENABLED, "true"));
    }

    @Override
    public boolean isSPInitiatedSSOEnabled() {
        return Boolean.parseBoolean(this.readProperty(KEY_SP_INITIATED_SSO_ENABLED, "true"));
    }

    @Override
    public boolean isIdPInitiatedMNIEnabled() {
        return Boolean.parseBoolean(this.readProperty(KEY_IDP_INITIATED_MNI_ENABLED));
    }

    @Override
    public boolean isSPInitiatedMNIEnabled() {
        return Boolean.parseBoolean(this.readProperty(KEY_SP_INITIATED_MNI_ENABLED));
    }

    @Override
    public SAML2RedirectApplicationConfiguration getRedirectApplicationConfiguration() {
        return this.localProvider.getRedirectApplicationConfiguration();
    }
}

