/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg;

import com.sap.security.saml2.cfg.SAML2CfgObject;
import com.sap.security.saml2.cfg.SAML2SubCfgObjectBase;
import com.sap.security.saml2.cfg.enums.DigestAlgorithm;
import com.sap.security.saml2.cfg.enums.SAML2MetadataContactPersonType;
import com.sap.security.saml2.cfg.interfaces.read.SAML2MetadataSettings;
import com.sap.security.saml2.cfg.interfaces.write.SAML2MetadataSettingsSetter;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import com.sap.security.saml2.cfg.util.CfgConstants;
import com.sap.security.saml2.cfg.util.CfgUtils;
import java.text.MessageFormat;
import java.util.Locale;

public class SAML2MetadataSettingsImpl
extends SAML2SubCfgObjectBase
implements SAML2MetadataSettings,
SAML2MetadataSettingsSetter {
    private static final String TOSTRING_PATTERN = "Public Access Enabled: {0}\nOrg Language: {1}\nOrg Name: {2}\nOrg DisplayName: {3}\nContact Type: {4}\nContact Company: {5}\nContact GivenName: {6}\nContact Surname: {7}\nContact Email: {8}\nContact Phone: {9}\nDigest Algorithm: {10}\nCfg path: {11}";
    private static final String RELATIVE_PATH = "metadata_settings";
    private static final String KEY_IS_PUBLIC_ACCESS_ENABLED = "public_access_enabled";
    private static final String KEY_ORG_LANGUAGE = "org_language";
    private static final String KEY_ORG_NAME = "org_name";
    private static final String KEY_ORG_DISPLAY_NAME = "org_display_name";
    private static final String KEY_ORG_URL = "org_url";
    private static final String KEY_CONTACT_TYPE = "contact_type";
    private static final String KEY_CONTACT_COMPANY = "contact_company";
    private static final String KEY_CONTACT_GIVEN_NAME = "contact_given_name";
    private static final String KEY_CONTACT_SURNAME = "contact_surname";
    private static final String KEY_CONTACT_EMAIL = "contact_email";
    private static final String KEY_CONTACT_PHONE = "contact_phone";
    private static final String KEY_DIGEST_ALGORITHM = "digest_algorithm";
    private boolean isPublicAccessEnabled;
    private String orgLanguage;
    private String orgName;
    private String orgDisplayName;
    private String orgURL;
    private SAML2MetadataContactPersonType contactType;
    private String contactCompany;
    private String contactGivenName;
    private String contactSurname;
    private String contactEmail;
    private String contactPhone;
    private DigestAlgorithm digestAlgorithm;

    public SAML2MetadataSettingsImpl() {
    }

    public SAML2MetadataSettingsImpl(SAML2CfgObject parent) {
        super(parent, RELATIVE_PATH);
    }

    @Override
    protected void readConfiguration() {
        DigestAlgorithm digAlgorithm;
        this.isPublicAccessEnabled = Boolean.parseBoolean(this.readProperty(KEY_IS_PUBLIC_ACCESS_ENABLED, "false"));
        this.orgLanguage = this.readProperty(KEY_ORG_LANGUAGE);
        this.orgName = this.readProperty(KEY_ORG_NAME);
        this.orgDisplayName = this.readProperty(KEY_ORG_DISPLAY_NAME);
        this.orgURL = this.readProperty(KEY_ORG_URL);
        String contactTypeString = this.readProperty(KEY_CONTACT_TYPE);
        if (!CfgUtils.isEmpty(contactTypeString)) {
            contactTypeString = contactTypeString.toUpperCase(Locale.ENGLISH);
            this.contactType = SAML2MetadataContactPersonType.valueOf(contactTypeString);
        }
        this.contactCompany = this.readProperty(KEY_CONTACT_COMPANY);
        this.contactGivenName = this.readProperty(KEY_CONTACT_GIVEN_NAME);
        this.contactSurname = this.readProperty(KEY_CONTACT_SURNAME);
        this.contactEmail = this.readProperty(KEY_CONTACT_EMAIL);
        this.contactPhone = this.readProperty(KEY_CONTACT_PHONE);
        this.digestAlgorithm = CfgConstants.DEFAULT_DIGEST;
        String digestAlgorithmString = this.readProperty(KEY_DIGEST_ALGORITHM);
        if (digestAlgorithmString != null && digestAlgorithmString.length() > 0 && (digAlgorithm = DigestAlgorithm.getDigestAlgorithm(digestAlgorithmString)) != null) {
            this.digestAlgorithm = digAlgorithm;
        }
    }

    @Override
    protected void createAndWriteConfiguration(SAML2CfgObject parent) throws CfgStorageException {
        this.createConfiguration(parent, RELATIVE_PATH);
        this.setProperty(KEY_IS_PUBLIC_ACCESS_ENABLED, this.isPublicAccessEnabled);
        this.setProperty(KEY_ORG_DISPLAY_NAME, this.orgDisplayName);
        this.setProperty(KEY_ORG_NAME, this.orgName);
        this.setProperty(KEY_ORG_LANGUAGE, this.orgLanguage);
        this.setProperty(KEY_ORG_URL, this.orgURL);
        this.setProperty(KEY_CONTACT_COMPANY, this.contactCompany);
        this.setProperty(KEY_CONTACT_EMAIL, this.contactEmail);
        this.setProperty(KEY_CONTACT_GIVEN_NAME, this.contactGivenName);
        this.setProperty(KEY_CONTACT_SURNAME, this.contactSurname);
        this.setProperty(KEY_CONTACT_TYPE, this.contactType == null ? null : this.contactType.name());
        this.setProperty(KEY_CONTACT_PHONE, this.contactPhone);
        this.setProperty(KEY_DIGEST_ALGORITHM, this.digestAlgorithm == null ? null : this.digestAlgorithm.getName());
        this.writeConfiguration();
    }

    @Override
    public boolean isPublicAccessEnabled() {
        return this.isPublicAccessEnabled;
    }

    @Override
    public void setPublicAccessEnabled(boolean isEnabled) {
        this.isPublicAccessEnabled = isEnabled;
    }

    @Override
    public String toString() {
        return MessageFormat.format(TOSTRING_PATTERN, new Object[]{this.isPublicAccessEnabled, this.orgName, this.orgDisplayName, this.orgLanguage, this.contactType, this.contactCompany, this.contactGivenName, this.contactSurname, this.contactEmail, this.contactPhone, this.digestAlgorithm, super.toString()});
    }

    @Override
    public String getContactCompany() {
        return this.contactCompany;
    }

    @Override
    public String getContactEmail() {
        return this.contactEmail;
    }

    @Override
    public String getContactGivenName() {
        return this.contactGivenName;
    }

    @Override
    public String getContactPhone() {
        return this.contactPhone;
    }

    @Override
    public String getContactSurname() {
        return this.contactSurname;
    }

    @Override
    public SAML2MetadataContactPersonType getContactType() {
        return this.contactType;
    }

    @Override
    public String getOrganizationDisplayName() {
        return this.orgDisplayName;
    }

    @Override
    public String getOrganizationLanguage() {
        return this.orgLanguage;
    }

    @Override
    public String getOrganizationName() {
        return this.orgName;
    }

    @Override
    public String getOrganizationURL() {
        return this.orgURL;
    }

    @Override
    public void setContactCompany(String contactCompany) {
        this.contactCompany = contactCompany;
    }

    @Override
    public void setContactEmail(String contactEmail) {
        this.contactEmail = contactEmail;
    }

    @Override
    public void setContactGivenName(String contactGivenName) {
        this.contactGivenName = contactGivenName;
    }

    @Override
    public void setContactPhone(String contactPhone) {
        this.contactPhone = contactPhone;
    }

    @Override
    public void setContactSurname(String contactSurname) {
        this.contactSurname = contactSurname;
    }

    @Override
    public void setContactType(SAML2MetadataContactPersonType contactType) {
        this.contactType = contactType;
    }

    @Override
    public void setOrgDisplayName(String orgDisplayName) {
        this.orgDisplayName = orgDisplayName;
    }

    @Override
    public void setOrgLanguage(String orgLanguage) {
        this.orgLanguage = orgLanguage;
    }

    @Override
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @Override
    public void setOrgURL(String orgURL) {
        this.orgURL = orgURL;
    }

    @Override
    public void setDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
    }

    @Override
    public DigestAlgorithm getDigestAlgorithm() {
        return this.digestAlgorithm;
    }
}

