/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg;

import com.sap.security.saml2.cfg.SAML2CfgObject;
import com.sap.security.saml2.cfg.SAML2UpdateableCfgObjectBase;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.security.SAML2CfgSecurityManager;
import com.sap.security.saml2.cfg.storage.CfgPropertySetter;
import com.sap.security.saml2.cfg.storage.CfgStorageException;

abstract class SAML2ModifiableCfgObjectBase
extends SAML2CfgObject {
    private static final byte STATE_INITIAL_CREATE = 2;
    private static final byte STATE_INITIAL_MODIFY = 4;
    private static final byte STATE_FINAL_WRITTEN = 8;
    private static final byte STATE_FINAL_DELETED = 16;
    private byte state;
    private CfgPropertySetter propertySetter;
    private SAML2UpdateableCfgObjectBase originator;

    SAML2ModifiableCfgObjectBase(SAML2CfgObject parent, String propertySheetName) {
        this.setCfgPath(parent.getCfgPath());
        this.setCfgPropertySheet(propertySheetName);
        this.propertySetter = this.getPropertySetter();
        this.state = (byte)2;
    }

    SAML2ModifiableCfgObjectBase(String cfgRootPath, String propertySheetName, SAML2UpdateableCfgObjectBase originator) throws SAML2ConfigurationException {
        super(cfgRootPath, propertySheetName, true);
        if (originator == null) {
            throw new SAML2ConfigurationException("SAML2 originator could not be null");
        }
        this.originator = originator;
        this.propertySetter = this.getPropertySetter();
        this.state = (byte)4;
    }

    public SAML2UpdateableCfgObjectBase writeCfgObject() throws SAML2ConfigurationException {
        if (this.state == 8) {
            throw new SAML2ConfigurationException("This modifiable provider is already written");
        }
        if (this.state == 16) {
            throw new SAML2ConfigurationException("This modifiable provider is already deleted");
        }
        SAML2CfgSecurityManager.getInstance().checkWritePermission();
        if (this.state == 2) {
            try {
                this.createAndSetAnonymousSubCfg();
            }
            catch (CfgStorageException e) {
                throw new SAML2ConfigurationException("Could not create configuration object", e);
            }
        }
        try {
            super.write(this.propertySetter);
        }
        catch (CfgStorageException e) {
            throw new SAML2ConfigurationException("Could not write configuration object", e);
        }
        this.state = (byte)8;
        return this.updateOriginator();
    }

    public void deleteCfgObject() throws SAML2ConfigurationException {
        if (this.state == 16) {
            throw new SAML2ConfigurationException("This modifiable provider is already deleted");
        }
        SAML2CfgSecurityManager.getInstance().checkWritePermission();
        try {
            super.deleteCfgObject(this);
        }
        catch (CfgStorageException e) {
            throw new SAML2ConfigurationException("Could not delete configuration object", e);
        }
        this.updateOriginator();
        this.state = (byte)16;
    }

    protected SAML2UpdateableCfgObjectBase updateOriginator() {
        if (this.originator != null) {
            this.originator.update();
        }
        return this.originator;
    }

    protected void setProperty(String key, String value) {
        this.propertySetter.setProperty(key, value);
    }

    protected void setProperty(String key, String[] values) {
        this.propertySetter.setProperty(key, values);
    }

    protected void setProperty(String key, Boolean value) {
        if (value != null) {
            this.propertySetter.setProperty(key, value.toString());
        } else {
            this.propertySetter.setProperty(key, (String)null);
        }
    }

    protected void setProperty(String key, Integer value) {
        if (value != null) {
            this.propertySetter.setProperty(key, value.toString());
        } else {
            this.propertySetter.setProperty(key, (String)null);
        }
    }
}

