/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg;

import com.sap.security.saml2.cfg.SAML2ExternalCDCReaderImpl;
import com.sap.security.saml2.cfg.SAML2ModifiableCfgObjectBase;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.interfaces.read.SAML2ExternalCDCReader;
import com.sap.security.saml2.cfg.interfaces.write.SAML2ModifiableExternalCDCReader;
import com.sap.security.saml2.cfg.util.CfgConstants;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.SimpleLogger;
import java.util.List;

public class SAML2ModifiableExternalCDCReaderImpl
extends SAML2ModifiableCfgObjectBase
implements SAML2ModifiableExternalCDCReader {
    public static final Location LOCATION = Location.getLocation(SAML2ModifiableExternalCDCReaderImpl.class);
    private SAML2ExternalCDCReader originator;

    public SAML2ModifiableExternalCDCReaderImpl(SAML2ExternalCDCReaderImpl originator) throws SAML2ConfigurationException {
        super("external_cdc_reader", "cfg", originator);
        this.originator = originator;
    }

    @Override
    public void setRedirectURLWhitelist(List<String> allowedRedirectURLs) {
        String[] values = null;
        if (allowedRedirectURLs != null) {
            values = allowedRedirectURLs.toArray(new String[allowedRedirectURLs.size()]);
        }
        this.setProperty("allowed_redirect_urls", values);
    }

    @Override
    public SAML2ExternalCDCReader write() throws SAML2ConfigurationException {
        String changeLogOldValue = this.originator.toString();
        SAML2ExternalCDCReaderImpl result = (SAML2ExternalCDCReaderImpl)super.writeCfgObject();
        SimpleLogger.log((int)300, (Category)CfgConstants.CHANGE_LOG_CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_cfg.001019", (String)"SAML2 External CDC read service settings was changed. Old version: [{0}], new version: [{1}]..", (Object[])new Object[]{changeLogOldValue, result});
        return result;
    }
}

