/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg;

import com.sap.security.saml2.cfg.SAML2ExternalCDCWriterImpl;
import com.sap.security.saml2.cfg.SAML2ModifiableCfgObjectBase;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.interfaces.read.SAML2ExternalCDCWriter;
import com.sap.security.saml2.cfg.interfaces.write.SAML2ModifiableExternalCDCWriter;
import com.sap.security.saml2.cfg.util.CfgConstants;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.SimpleLogger;
import java.util.List;

public class SAML2ModifiableExternalCDCWriterImpl
extends SAML2ModifiableCfgObjectBase
implements SAML2ModifiableExternalCDCWriter {
    public static final Location LOCATION = Location.getLocation(SAML2ModifiableExternalCDCWriterImpl.class);
    private SAML2ExternalCDCWriter originator;

    public SAML2ModifiableExternalCDCWriterImpl(SAML2ExternalCDCWriterImpl originator) throws SAML2ConfigurationException {
        super("external_cdc_writer", "cfg", originator);
        this.originator = originator;
    }

    @Override
    public void setAdditionalIdPs(List<String> allowedAdditionalIdPs) {
        if (allowedAdditionalIdPs == null) {
            this.setProperty("allowed_additional_idps", (String[])null);
        } else {
            String[] values = allowedAdditionalIdPs.toArray(new String[allowedAdditionalIdPs.size()]);
            this.setProperty("allowed_additional_idps", values);
        }
    }

    @Override
    public void setRedirectURLWhitelist(List<String> allowedURLs) {
        String[] values = null;
        if (allowedURLs != null) {
            values = allowedURLs.toArray(new String[allowedURLs.size()]);
        }
        this.setProperty("allowed_redirect_url", values);
    }

    @Override
    public void setDomainRelaxationLevel(Integer relaxLevel) {
        this.setProperty("domain_relax_level", relaxLevel);
    }

    @Override
    public void setCDCMaxAge(Integer maxAge) {
        this.setProperty("cdc_max_age", maxAge);
    }

    @Override
    public SAML2ExternalCDCWriter write() throws SAML2ConfigurationException {
        String changeLogOldValue = this.originator.toString();
        SAML2ExternalCDCWriterImpl result = (SAML2ExternalCDCWriterImpl)super.writeCfgObject();
        SimpleLogger.log((int)300, (Category)CfgConstants.CHANGE_LOG_CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_cfg.001013", (String)"SAML2 External CDC write service settings was changed. Old version: [{0}], new version: [{1}].", (Object[])new Object[]{changeLogOldValue, result});
        return result;
    }
}

