/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg;

import com.sap.security.saml2.cfg.SAML2GlobalSettingsImpl;
import com.sap.security.saml2.cfg.SAML2ModifiableCfgObjectBase;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.interfaces.read.SAML2GlobalSettings;
import com.sap.security.saml2.cfg.interfaces.write.SAML2ModifiableGlobalSettings;
import com.sap.security.saml2.cfg.util.CfgConstants;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.SimpleLogger;

public class SAML2ModifiableGlobalSettingsImpl
extends SAML2ModifiableCfgObjectBase
implements SAML2ModifiableGlobalSettings {
    private static final long serialVersionUID = 1L;
    public static final Location LOCATION = Location.getLocation(SAML2ModifiableGlobalSettingsImpl.class);
    private SAML2GlobalSettings originator;

    public SAML2ModifiableGlobalSettingsImpl(SAML2GlobalSettingsImpl originator) throws SAML2ConfigurationException {
        super("global_settings", "global_settings", originator);
        this.originator = originator;
    }

    @Override
    public void setControlFlag(Integer flag) {
        this.setProperty("control_flag", flag);
    }

    @Override
    public void setExpiredArtifactsCleanTimeoutInMinutes(Integer timeout) {
        this.setProperty("expired_artifacts_clean_timeout", timeout);
    }

    @Override
    public void setExpiredAssertionsCleanTimeoutInMinutes(Integer timeout) {
        this.setProperty("expired_assertions_clean_timeout", timeout);
    }

    @Override
    public void setExpiredIdPSessionsCleanTimeoutInMinutes(Integer timeout) {
        this.setProperty("expired_idp_sessions_clean_timeout", timeout);
    }

    @Override
    public void setLockObtainingTimeoutInSeconds(Integer timeout) {
        this.setProperty("lock_obtaining_timeout", timeout);
    }

    @Override
    public void setVersion(Integer version) {
        this.setProperty("version", version);
    }

    @Override
    public SAML2GlobalSettings write() throws SAML2ConfigurationException {
        String changeLogOldValue = this.originator.toString();
        SAML2GlobalSettingsImpl result = (SAML2GlobalSettingsImpl)super.writeCfgObject();
        SimpleLogger.log((int)300, (Category)CfgConstants.CHANGE_LOG_CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_cfg.001002", (String)"SAML2 global settings was changed. Old version: [{0}], new version: [{1}].", (Object[])new Object[]{changeLogOldValue, result});
        return result;
    }
}

