/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg;

import com.sap.security.saml2.cfg.SAML2AffiliationImpl;
import com.sap.security.saml2.cfg.SAML2IdPAuthenticationContextImpl;
import com.sap.security.saml2.cfg.SAML2LocalIdPImpl;
import com.sap.security.saml2.cfg.SAML2ModifiableProviderBase;
import com.sap.security.saml2.cfg.enums.SAML2Binding;
import com.sap.security.saml2.cfg.enums.SAML2BindingDirection;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalIdP;
import com.sap.security.saml2.cfg.interfaces.write.SAML2AffiliationSetter;
import com.sap.security.saml2.cfg.interfaces.write.SAML2IdPAuthenticationContextSetter;
import com.sap.security.saml2.cfg.interfaces.write.SAML2ModifiableLocalIdP;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import com.sap.security.saml2.cfg.util.CfgConstants;
import com.sap.security.saml2.cfg.util.CfgUtils;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.SimpleLogger;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class SAML2ModifiableLocalIdPImpl
extends SAML2ModifiableProviderBase
implements SAML2ModifiableLocalIdP {
    private static final Location LOCATION = Location.getLocation(SAML2ModifiableLocalIdPImpl.class);
    private SAML2LocalIdP originator;
    private Collection<SAML2AffiliationSetter> affiliations;
    private Collection<SAML2IdPAuthenticationContextSetter> idpAuthnContexts;

    SAML2ModifiableLocalIdPImpl(SAML2LocalIdPImpl originator) throws SAML2ConfigurationException {
        super(originator.getCfgPath(), "idp", originator);
        this.originator = originator;
    }

    @Override
    public SAML2LocalIdPImpl writeProvider() throws SAML2ConfigurationException {
        String changeLogOldValue = this.originator.toString();
        super.writeProvider();
        try {
            if (this.affiliations != null) {
                this.deleteSubConfiguration("affiliations");
                for (SAML2AffiliationSetter affiliationSetter : this.affiliations) {
                    if (affiliationSetter == null) continue;
                    SAML2AffiliationImpl affiliation = (SAML2AffiliationImpl)affiliationSetter;
                    affiliation.createAndWriteConfiguration(this, "affiliations");
                }
            }
        }
        catch (CfgStorageException e) {
            throw new SAML2ConfigurationException("Could not write affiliations", e);
        }
        try {
            if (this.idpAuthnContexts != null) {
                this.deleteSubConfiguration("authn_context_mappings");
                for (SAML2IdPAuthenticationContextSetter authnContextSetter : this.idpAuthnContexts) {
                    if (authnContextSetter == null) continue;
                    SAML2IdPAuthenticationContextImpl mapping = (SAML2IdPAuthenticationContextImpl)authnContextSetter;
                    mapping.createAndWriteConfiguration(this, "authn_context_mappings");
                }
            }
        }
        catch (CfgStorageException e) {
            throw new SAML2ConfigurationException("Could not write authentication context mappings", e);
        }
        SAML2LocalIdPImpl result = (SAML2LocalIdPImpl)this.updateOriginator();
        SimpleLogger.log((int)300, (Category)CfgConstants.CHANGE_LOG_CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_cfg.001005", (String)"SAML2 local identity provider settings was changed. Old version: [{0}], new version: [{1}].", (Object[])new Object[]{changeLogOldValue, result});
        return result;
    }

    @Override
    public void setAffiliations(Collection<SAML2AffiliationSetter> affiliations) {
        this.affiliations = affiliations;
    }

    @Override
    public void setAssertionValidityNotAfterInMinutes(int minutes) {
        this.setProperty("assertion_validity_not_after", minutes);
    }

    @Override
    public void setAssertionValidityNotBeforeInMinutes(int minutes) {
        this.setProperty("assertion_validity_not_before", minutes);
    }

    @Override
    public void setProxyRestriction(Integer proxyRestriction) {
        this.setProperty("proxy_restriction", proxyRestriction);
    }

    @Override
    public void setProxyingEnforced(Boolean isToEnforce) {
        this.setProperty("is_proxying_enforced", isToEnforce);
    }

    @Override
    public void setUseInternalIdPDiscoveryWriteService(Boolean isToUseInternal) {
        this.setProperty("use_internal_cdc_write_service", isToUseInternal);
    }

    @Override
    public void setUseExternalIdPDiscoveryWriteService(Boolean isToUseExternal) {
        this.setProperty("use_external_cdc_write_service", isToUseExternal);
    }

    @Override
    public void setExternalIdPDiscoveryWriteServiceUrl(String url) {
        this.setProperty("external_cdc_write_service_url", url);
    }

    @Override
    public void setCDCDomain(String domain) {
        this.setProperty("cdc_domain", domain);
    }

    @Override
    public void setCDCDomainRelaxationLevel(int relaxLevel) {
        this.setProperty("cdc_relaxation_level", relaxLevel);
    }

    @Override
    public void setCDCMaxAge(int maxAge) {
        this.setProperty("cdc_max_age", maxAge);
    }

    @Override
    public void setDefaultAuthnContextNamesHTTP(List<String> authnContextNames) {
        String[] dbAuthnContextNames = null;
        if (authnContextNames != null && !authnContextNames.isEmpty()) {
            dbAuthnContextNames = authnContextNames.toArray(new String[authnContextNames.size()]);
        }
        this.setProperty("default_authn_contexts_http", dbAuthnContextNames);
    }

    @Override
    public void setDefaultAuthnContextNamesHTTPS(List<String> authnContextNames) {
        String[] dbAuthnContextNames = null;
        if (authnContextNames != null && !authnContextNames.isEmpty()) {
            dbAuthnContextNames = authnContextNames.toArray(new String[authnContextNames.size()]);
        }
        this.setProperty("default_authn_contexts_https", dbAuthnContextNames);
    }

    @Override
    public void setGlobalSessionLifetimeInSeconds(int sessionLifetime) {
        this.setProperty("global_session_lifetime", sessionLifetime);
    }

    @Override
    public void setIdPAuthnContexts(Collection<SAML2IdPAuthenticationContextSetter> authnContexts) {
        this.idpAuthnContexts = authnContexts;
    }

    @Override
    public void setMultipleGlobalSessionsAllowed(boolean isAllowed) {
        this.setProperty("multiple_global_sessions_allowed", isAllowed);
    }

    @Override
    public void setSingleLogoutSupportedBindings(Set<SAML2Binding> bindings) {
        String[] bindingNames = CfgUtils.serializeSAML2Bindings(bindings);
        this.setProperty("supported_bindings_slo", bindingNames);
    }

    @Override
    public void setSingleSignOnSupportedBindings(Set<SAML2Binding> bindings) {
        String[] bindingNames = CfgUtils.serializeSAML2Bindings(bindings);
        this.setProperty("supported_bindings_sso", bindingNames);
    }

    @Override
    public void setManageNameIDSupportedBindings(Set<SAML2Binding> bindings) {
        String[] bindingNames = CfgUtils.serializeSAML2Bindings(bindings);
        this.setProperty("supported_bindings_mni", bindingNames);
    }

    @Override
    public void setIdPInitiatedSingleLogoutDirection(SAML2BindingDirection direction) {
        if (direction != null) {
            this.setProperty("idp_initiated_slo_direction", direction.name());
        }
    }

    @Override
    public void setIdPInitiatedSLOEnabled(Boolean isEnabled) {
        this.setProperty("idp_initiated_slo_enabled", isEnabled);
    }

    @Override
    public void setIdPInitiatedSSOEnabled(Boolean isEnabled) {
        this.setProperty("idp_initiated_sso_enabled", isEnabled);
    }

    @Override
    public void setIdPInitiatedMNIEnabled(Boolean isEnabled) {
        this.setProperty("idp_initiated_mni_enabled", isEnabled);
    }

    @Override
    public void setSPInitiatedSLOEnabled(Boolean isEnabled) {
        this.setProperty("sp_initiated_slo_enabled", isEnabled);
    }

    @Override
    public void setSPInitiatedSSOEnabled(Boolean isEnabled) {
        this.setProperty("sp_initiated_sso_enabled", isEnabled);
    }

    @Override
    public void setSPInitiatedMNIEnabled(Boolean isEnabled) {
        this.setProperty("sp_initiated_mni_enabled", isEnabled);
    }

    @Override
    public void setDisplaySAML2ErrorPageEnabled(Boolean isEnabled) {
        this.setProperty("display_saml2_error_page_enabled", isEnabled);
    }

    @Override
    public void setAddSessionNotOnOrAfter(Boolean isToAdd) {
        this.setProperty("add_session_not_on_or_after", isToAdd);
    }
}

