/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg;

import com.sap.security.saml2.cfg.SAML2BackChannelSecurityPolicyImpl;
import com.sap.security.saml2.cfg.SAML2CfgAuthenticationContextImpl;
import com.sap.security.saml2.cfg.SAML2CfgUMEAttributeImpl;
import com.sap.security.saml2.cfg.SAML2KeystoreWrapper;
import com.sap.security.saml2.cfg.SAML2LocalProviderImpl;
import com.sap.security.saml2.cfg.SAML2MetadataSettingsImpl;
import com.sap.security.saml2.cfg.SAML2ModifiableProviderBase;
import com.sap.security.saml2.cfg.SAML2RedirectApplicationConfigurationImpl;
import com.sap.security.saml2.cfg.enums.SAML2Binding;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.interfaces.read.SAML2CfgAuthenticationContext;
import com.sap.security.saml2.cfg.interfaces.read.SAML2CfgUMEAttribute;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalProvider;
import com.sap.security.saml2.cfg.interfaces.write.SAML2BackChannelSecurityPolicySetter;
import com.sap.security.saml2.cfg.interfaces.write.SAML2CfgAuthenticationContextSetter;
import com.sap.security.saml2.cfg.interfaces.write.SAML2CfgUMEAttributeSetter;
import com.sap.security.saml2.cfg.interfaces.write.SAML2MetadataSettingsSetter;
import com.sap.security.saml2.cfg.interfaces.write.SAML2ModifiableLocalProvider;
import com.sap.security.saml2.cfg.interfaces.write.SAML2RedirectApplicationConfigurationSetter;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import com.sap.security.saml2.cfg.util.CfgConstants;
import com.sap.security.saml2.cfg.util.CfgUtils;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.SimpleLogger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SAML2ModifiableLocalProviderImpl
extends SAML2ModifiableProviderBase
implements SAML2ModifiableLocalProvider {
    private static final String PROPERTY_COMMENTS = "Property sheet \"common\" contains the common settings for SAML2 Service and Identity Providers (like provider name, keystore, signing and encryption keys, etc.).\n \nPossible properties are:\n  \"name\" - contains the name of this Local Provider\n  \"keystore_view\" - contains the keystore, where the keys and certificates are stored\n  \"signing_keypair\" - contains the alias of the keypair, which will be used to sign the issued SAML2 tokens\n  \"encryption_keypair\" - contains the alias of the keypair, which will be used to encrypt the issued SAML2 tokens\n  \"include_cert_in_signature\" - specify, whether to include the certificate in the signatures of the issued SAML2 token. Possible values are \"true\" or \"false\". By default is \"false\"\n  \"sign_metadata\" - specify, whether to sign the issued SAML2 metadata. Possible values are \"true\" or \"false\". By default is \"false\"\n  \"plain_http_enabled\" - specify, whether HTTP communication is allowed. Possible values are \"true\" or \"false\". By default is \"false\", which means that only HTTPS is allowed.\n  \"clock_skew_tolerance\" - specify clock skew in seconds, which will be used in all time checks.\n  \"issue_instant_not_before\" - specify the maximum minutes before the current time, when received SAML2 token is considered as valid. The check is based on token's \"IssueInstant\" timestamp.\n  \"issue_instant_not_after\" - specify the maximum minutes after the current time, when received SAML2 token is considered as valid. The check is based on token's \"IssueInstant\" timestamp.\n  \nExample content:\n  name=idp.sap.com\n  plain_http_enabled=true\n  sign_metadata=true\n  keystore_view=saml2.jks\n  signing_keypair=idp.sap.com\n  encryption_keypair=idp.sap.com";
    private static final Location LOCATION = Location.getLocation(SAML2ModifiableLocalProviderImpl.class);
    private SAML2BackChannelSecurityPolicyImpl backChannelSecurity;
    private SAML2MetadataSettingsImpl metadataSettings;
    private Collection<SAML2CfgAuthenticationContextSetter> authnContexts;
    private Collection<SAML2CfgUMEAttributeSetter> umeAttributes;
    private String originalKeystoreViewName;
    private String newKeystoreViewName;
    private String originalTrustedCAsViewName;
    private String newTrustedCAsViewName;
    private SAML2LocalProvider originator;
    private Collection<SAML2CfgAuthenticationContext> originalAuthnContexts;
    private Collection<SAML2CfgUMEAttribute> originalUMEAttributes;
    private SAML2RedirectApplicationConfigurationImpl redirectApplicationConfiguration;

    SAML2ModifiableLocalProviderImpl(SAML2LocalProviderImpl originator) throws SAML2ConfigurationException {
        super(originator.getCfgPath(), "common", originator);
        this.originalKeystoreViewName = originator.getKeyStoreViewName();
        this.originalTrustedCAsViewName = originator.getTrustedCAsViewName();
        this.originalAuthnContexts = originator.getAuthenticationContexts();
        this.originalUMEAttributes = originator.getUMEAttributes();
        this.originator = originator;
        this.setPropertySheetComments(PROPERTY_COMMENTS);
    }

    @Override
    public SAML2LocalProviderImpl writeProvider() throws SAML2ConfigurationException {
        this.checkAuthnContexts(this.authnContexts);
        this.checkUMEAttributes(this.umeAttributes);
        String changeLogOldValue = this.originator.toString();
        super.writeProvider();
        if (this.backChannelSecurity != null) {
            try {
                this.backChannelSecurity.createAndWriteConfiguration(this);
            }
            catch (CfgStorageException e) {
                throw new SAML2ConfigurationException("Could not write back channel security policy", e);
            }
        }
        if (this.metadataSettings != null) {
            try {
                this.metadataSettings.createAndWriteConfiguration(this);
            }
            catch (CfgStorageException e) {
                throw new SAML2ConfigurationException("Could not write metadata settings", e);
            }
        }
        try {
            SAML2CfgAuthenticationContextImpl authnContext;
            Map<String, SAML2CfgAuthenticationContextSetter> authnContextsForWriting = CfgUtils.obtainStandardSAML2AuthenticationContexts();
            if (this.authnContexts != null) {
                this.deleteSubConfiguration("authentication_contexts");
                for (SAML2CfgAuthenticationContextSetter authenticationContextSetter : this.authnContexts) {
                    if (authenticationContextSetter == null) continue;
                    authnContext = (SAML2CfgAuthenticationContextImpl)authenticationContextSetter;
                    String name = authnContext.getName();
                    authnContextsForWriting.put(name, authnContext);
                }
                for (SAML2CfgAuthenticationContextSetter authenticationContextSetter : authnContextsForWriting.values()) {
                    if (authenticationContextSetter == null) continue;
                    authnContext = (SAML2CfgAuthenticationContextImpl)authenticationContextSetter;
                    authnContext.createAndWriteConfiguration(this, "authentication_contexts");
                }
            } else if (this.originalAuthnContexts == null || this.originalAuthnContexts.isEmpty()) {
                for (SAML2CfgAuthenticationContextSetter authenticationContextSetter : authnContextsForWriting.values()) {
                    if (authenticationContextSetter == null) continue;
                    authnContext = (SAML2CfgAuthenticationContextImpl)authenticationContextSetter;
                    authnContext.createAndWriteConfiguration(this, "authentication_contexts");
                }
            }
        }
        catch (CfgStorageException e) {
            throw new SAML2ConfigurationException("Could not write authentication contexts", e);
        }
        if (this.redirectApplicationConfiguration != null) {
            try {
                this.deleteSubConfiguration("redirect_sites");
                this.redirectApplicationConfiguration.createAndWriteConfiguration(this);
            }
            catch (CfgStorageException e) {
                throw new SAML2ConfigurationException("Could not write redirect application configuration", e);
            }
        }
        try {
            HashMap<String, SAML2CfgUMEAttributeSetter> umeAttributesForWriting = null;
            if (this.umeAttributes != null && !this.umeAttributes.isEmpty()) {
                umeAttributesForWriting = new HashMap();
                for (SAML2CfgUMEAttributeSetter umeAttributeSetter : this.umeAttributes) {
                    if (umeAttributeSetter == null) continue;
                    SAML2CfgUMEAttributeImpl umeAttribute = (SAML2CfgUMEAttributeImpl)umeAttributeSetter;
                    String alias = umeAttribute.getAlias();
                    umeAttributesForWriting.put(alias, umeAttribute);
                }
            } else if (this.originalUMEAttributes == null || this.originalUMEAttributes.isEmpty()) {
                umeAttributesForWriting = new HashMap<String, SAML2CfgUMEAttributeSetter>();
            }
            if (umeAttributesForWriting != null) {
                this.deleteSubConfiguration("ume_attributes");
                Map<String, SAML2CfgUMEAttributeSetter> predefineAttributes = CfgUtils.obtainPredefinedSAML2UMEAttributes();
                umeAttributesForWriting.putAll(predefineAttributes);
                for (SAML2CfgUMEAttributeSetter umeAttributeSetter : umeAttributesForWriting.values()) {
                    if (umeAttributeSetter == null) continue;
                    SAML2CfgUMEAttributeImpl umeAttribute = (SAML2CfgUMEAttributeImpl)umeAttributeSetter;
                    umeAttribute.createAndWriteConfiguration(this, "ume_attributes");
                }
            }
        }
        catch (CfgStorageException e) {
            throw new SAML2ConfigurationException("Could not write ume attributes", e);
        }
        if (this.newKeystoreViewName != null && this.newKeystoreViewName.length() > 0 && !this.newKeystoreViewName.equals(this.originalKeystoreViewName)) {
            SAML2KeystoreWrapper.getInstance().grantKeystorePermissions(this.newKeystoreViewName);
        }
        if (this.newTrustedCAsViewName != null && this.newTrustedCAsViewName.length() > 0 && !this.newTrustedCAsViewName.equals(this.originalTrustedCAsViewName)) {
            SAML2KeystoreWrapper.getInstance().grantKeystorePermissions(this.newTrustedCAsViewName);
        }
        SAML2LocalProviderImpl result = (SAML2LocalProviderImpl)this.updateOriginator();
        SimpleLogger.log((int)300, (Category)CfgConstants.CHANGE_LOG_CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_cfg.001003", (String)"SAML2 local provider settings was changed. Old version: [{0}], new version: [{1}].", (Object[])new Object[]{changeLogOldValue, result});
        return result;
    }

    private void checkAuthnContexts(Collection<SAML2CfgAuthenticationContextSetter> authnContexts) throws SAML2ConfigurationException {
        if (authnContexts != null) {
            for (SAML2CfgAuthenticationContextSetter authnContext : authnContexts) {
                SAML2CfgAuthenticationContextImpl authnContextImpl = (SAML2CfgAuthenticationContextImpl)authnContext;
                String name = authnContextImpl.getName();
                if (name == null || name.length() < 1) {
                    throw new SAML2ConfigurationException("Cannot write authentication context with empty name: " + name);
                }
                String alias = authnContextImpl.getAlias();
                if (alias != null && alias.length() >= 1) continue;
                throw new SAML2ConfigurationException("Cannot write authentication context with empty alias: " + alias);
            }
        }
    }

    private void checkUMEAttributes(Collection<SAML2CfgUMEAttributeSetter> umeAttributes) throws SAML2ConfigurationException {
        if (umeAttributes != null) {
            for (SAML2CfgUMEAttributeSetter umeAttribute : umeAttributes) {
                SAML2CfgUMEAttributeImpl umeAttributeImpl = (SAML2CfgUMEAttributeImpl)umeAttribute;
                String name = umeAttributeImpl.getName();
                if (name == null || name.length() < 1) {
                    throw new SAML2ConfigurationException("Cannot write ume attribute with empty name: " + name);
                }
                String alias = umeAttributeImpl.getAlias();
                if (alias != null && alias.length() >= 1) continue;
                throw new SAML2ConfigurationException("Cannot write ume attribute with empty alias: " + alias);
            }
        }
    }

    @Override
    public void setName(String name) {
        this.setProviderName(name);
    }

    @Override
    public void setArtifactResolutionSupportedBindings(Set<SAML2Binding> bindings) {
        String[] bindingNames = CfgUtils.serializeSAML2Bindings(bindings);
        this.setProperty("supported_bindings_ars", bindingNames);
    }

    @Override
    public void setArtifactValidityPeriodInSeconds(int seconds) {
        this.setProperty("artifact_validity", seconds);
    }

    @Override
    public void setClockSkewToleranceInSeconds(int seconds) {
        this.setProperty("clock_skew_tolerance", seconds);
    }

    @Override
    public void setEncryptionKeyPairName(String keypair) {
        this.setProperty("encryption_keypair", keypair);
    }

    @Override
    public void setIsToIncludeCertInSignature(boolean isToIncludeCertInSignature) {
        this.setProperty("include_cert_in_signature", isToIncludeCertInSignature);
    }

    @Override
    public void setIsToSignMetadata(boolean isToSignMethadata) {
        this.setProperty("sign_metadata", isToSignMethadata);
    }

    public void setIsToUseSecondaryKeysForMetadata(Boolean isToUseSecondaryKeys) {
        this.setProperty("use_secondary_keys_for_metadata", isToUseSecondaryKeys);
    }

    @Override
    public void setKeyStoreViewName(String viewName) {
        this.setProperty("keystore_view", viewName);
        this.newKeystoreViewName = viewName;
    }

    @Override
    public void setTrustedCAsViewName(String viewName) {
        this.setProperty("trusted_ca_view", viewName);
        this.newTrustedCAsViewName = viewName;
    }

    @Override
    public void setSigningKeyPairName(String keypair) {
        this.setProperty("signing_keypair", keypair);
    }

    public void setSecondarySigningKeyPairName(String keypair) {
        this.setProperty("secondary_signing_keypair", keypair);
    }

    @Override
    public void setIssueSAPLogonTickets(boolean isToIssue) {
        this.setProperty("issue_sap_logon_tickets", isToIssue);
    }

    @Override
    public void setBackChannelSecurityPolicy(SAML2BackChannelSecurityPolicySetter policy) {
        this.backChannelSecurity = (SAML2BackChannelSecurityPolicyImpl)policy;
    }

    @Override
    public void setMetadataSettings(SAML2MetadataSettingsSetter metadataSettings) {
        this.metadataSettings = (SAML2MetadataSettingsImpl)metadataSettings;
    }

    @Override
    public void setAuthenticationContexts(Collection<SAML2CfgAuthenticationContextSetter> authnContexts) {
        this.authnContexts = authnContexts;
    }

    @Override
    public void setUMEAttributes(Collection<SAML2CfgUMEAttributeSetter> umeAttributes) {
        this.umeAttributes = umeAttributes;
    }

    @Override
    public void setPlainHTTPConnectionsEnabled(Boolean isEnabled) {
        this.setProperty("plain_http_enabled", isEnabled);
    }

    @Override
    public void setCustomLogonPageAlias(String alias) {
        this.setProperty("custom_logon_page_alias", alias);
    }

    @Override
    public void setIssueInstantValidityNotBeforeInMinutes(Integer notBefore) {
        this.setProperty("issue_instant_not_before", notBefore);
    }

    @Override
    public void setIssueInstantValidityNotAfterInMinutes(Integer notAfter) {
        this.setProperty("issue_instant_not_after", notAfter);
    }

    @Override
    public void setRedirectApplicationConfiguration(SAML2RedirectApplicationConfigurationSetter redirectApplicationConfiguration) {
        this.redirectApplicationConfiguration = (SAML2RedirectApplicationConfigurationImpl)redirectApplicationConfiguration;
    }
}

