/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg;

import com.sap.security.saml2.cfg.SAML2EntranceLocationMappingsImpl;
import com.sap.security.saml2.cfg.SAML2LocalSPImpl;
import com.sap.security.saml2.cfg.SAML2ModifiableProviderBase;
import com.sap.security.saml2.cfg.enums.SAML2Binding;
import com.sap.security.saml2.cfg.enums.SAML2IdPSelectionMode;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalSP;
import com.sap.security.saml2.cfg.interfaces.write.SAML2ModifiableLocalSP;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import com.sap.security.saml2.cfg.util.CfgConstants;
import com.sap.security.saml2.cfg.util.CfgUtils;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.SimpleLogger;
import java.util.Map;
import java.util.Set;

public class SAML2ModifiableLocalSPImpl
extends SAML2ModifiableProviderBase
implements SAML2ModifiableLocalSP {
    private static final Location LOCATION = Location.getLocation(SAML2ModifiableLocalSPImpl.class);
    private SAML2EntranceLocationMappingsImpl entranceLocationMappings;
    private SAML2LocalSP originator;

    SAML2ModifiableLocalSPImpl(String cfgPath, SAML2LocalSPImpl originator) throws SAML2ConfigurationException {
        super(cfgPath, "sp", originator);
        this.originator = originator;
    }

    @Override
    public SAML2LocalSPImpl writeProvider() throws SAML2ConfigurationException {
        String changeLogOldValue = this.originator.toString();
        super.writeProvider();
        if (this.entranceLocationMappings != null) {
            try {
                this.entranceLocationMappings.createAndWriteConfiguration(this);
            }
            catch (CfgStorageException e) {
                throw new SAML2ConfigurationException("Could not write entrance location mappings", e);
            }
        }
        SAML2LocalSPImpl result = (SAML2LocalSPImpl)this.updateOriginator();
        SimpleLogger.log((int)300, (Category)CfgConstants.CHANGE_LOG_CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_cfg.001004", (String)"SAML2 local service provider settings was changed. Old version: [{0}], new version: [{1}].", (Object[])new Object[]{changeLogOldValue, result});
        return result;
    }

    @Override
    public void setAffiliation(String affiliation) {
        this.setProperty("affiliation", affiliation);
    }

    @Override
    public void setAssertionConsumerSupportedBindings(Set<SAML2Binding> bindings) {
        String[] bindingNames = CfgUtils.serializeSAML2Bindings(bindings);
        this.setProperty("supported_bindings_acs", bindingNames);
    }

    @Override
    public void setDomainRelaxLevel(int relaxLevel) {
        this.setProperty("relaxation_level", relaxLevel);
    }

    @Override
    public void setSingleLogoutSupportedBindings(Set<SAML2Binding> bindings) {
        String[] bindingNames = CfgUtils.serializeSAML2Bindings(bindings);
        this.setProperty("supported_bindings_slo", bindingNames);
    }

    @Override
    public void setManageNameIDSupportedBindings(Set<SAML2Binding> bindings) {
        String[] bindingNames = CfgUtils.serializeSAML2Bindings(bindings);
        this.setProperty("supported_bindings_mni", bindingNames);
    }

    @Override
    public void setAskForPreferredIdP(Boolean isToAsk) {
        this.setProperty("ask_for_preferred_idp", isToAsk);
    }

    @Override
    public void setIdPSelectionMode(SAML2IdPSelectionMode selectionMode) {
        if (selectionMode != null) {
            this.setProperty("idp_selection_mode", selectionMode.name());
        } else {
            this.setProperty("idp_selection_mode", (String)null);
        }
    }

    @Override
    public void setProxyCount(Integer proxyCount) {
        this.setProperty("proxy_count", proxyCount);
    }

    @Override
    public void setUseInternalIdPDiscoveryReadService(Boolean isToUseInternal) {
        this.setProperty("use_internal_cdc_read_service", isToUseInternal);
    }

    @Override
    public void setUseExternalIdPDiscoveryReadService(Boolean isToUseExternal) {
        this.setProperty("use_external_cdc_read_service", isToUseExternal);
    }

    @Override
    public void setExternalIdPDiscoveryReadServiceUrl(String url) {
        this.setProperty("external_cdc_read_service_url", url);
    }

    @Override
    public void setDefaultEntranceLocation(String relativeUrl) {
        this.setProperty("default_entrance_location", relativeUrl);
    }

    @Override
    public void setEntranceLocations(Map<String, String> locations) {
        this.entranceLocationMappings = new SAML2EntranceLocationMappingsImpl();
        this.entranceLocationMappings.setEntranceLocationMappings(locations);
    }

    @Override
    public void setIdPInitiatedSLOEnabled(Boolean isEnabled) {
        this.setProperty("idp_initiated_slo_enabled", isEnabled);
    }

    @Override
    public void setIdPInitiatedSSOEnabled(Boolean isEnabled) {
        this.setProperty("idp_initiated_sso_enabled", isEnabled);
    }

    @Override
    public void setIdPInitiatedMNIEnabled(Boolean isEnabled) {
        this.setProperty("idp_initiated_mni_enabled", isEnabled);
    }

    @Override
    public void setSPInitiatedSLOEnabled(Boolean isEnabled) {
        this.setProperty("sp_initiated_slo_enabled", isEnabled);
    }

    @Override
    public void setSPInitiatedSSOEnabled(Boolean isEnabled) {
        this.setProperty("sp_initiated_sso_enabled", isEnabled);
    }

    @Override
    public void setSPInitiatedMNIEnabled(Boolean isEnabled) {
        this.setProperty("sp_initiated_mni_enabled", isEnabled);
    }
}

