/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg;

import com.sap.security.saml2.cfg.SAML2CfgSetterFactory;
import com.sap.security.saml2.cfg.SAML2ModifiableCfgObjectBase;
import com.sap.security.saml2.cfg.SAML2PoliciesConfigImpl;
import com.sap.security.saml2.cfg.SAML2PolicyIdPCustomizedDataImpl;
import com.sap.security.saml2.cfg.SAML2PolicyImpl;
import com.sap.security.saml2.cfg.enums.ComparisonMethod;
import com.sap.security.saml2.cfg.enums.SAML2PolicyType;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.exceptions.SAML2PolicyAlreadyExistsException;
import com.sap.security.saml2.cfg.interfaces.read.SAML2Policy;
import com.sap.security.saml2.cfg.interfaces.write.SAML2ModifiablePolicy;
import com.sap.security.saml2.cfg.interfaces.write.SAML2PolicyIdPCustomizedDataSetter;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import com.sap.security.saml2.cfg.util.CfgConstants;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.SimpleLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SAML2ModifiablePolicyImpl
extends SAML2ModifiableCfgObjectBase
implements SAML2ModifiablePolicy {
    private static final Location LOCATION = Location.getLocation(SAML2ModifiablePolicyImpl.class);
    private Collection<SAML2PolicyIdPCustomizedDataSetter> trustedIdPsData;
    private SAML2PoliciesConfigImpl parent;
    private SAML2PolicyImpl originator;
    private boolean isNewPolicy = false;
    private String policyName;

    SAML2ModifiablePolicyImpl(SAML2PoliciesConfigImpl parent) {
        super(parent, "policy");
        this.parent = parent;
        this.isNewPolicy = true;
    }

    SAML2ModifiablePolicyImpl(SAML2PolicyImpl originator) throws SAML2ConfigurationException {
        super(originator.getCfgPath(), "policy", originator);
        this.originator = originator;
    }

    @Override
    public void setAuthnContextsForIdP(String idpName, List<String> authnContexts) {
        if (this.trustedIdPsData == null) {
            this.trustedIdPsData = new ArrayList<SAML2PolicyIdPCustomizedDataSetter>();
        }
        for (SAML2PolicyIdPCustomizedDataSetter setterTmp : this.trustedIdPsData) {
            if (!((SAML2PolicyIdPCustomizedDataImpl)setterTmp).getIdPName().equals(idpName)) continue;
            setterTmp.setAuthnContexts(authnContexts);
            return;
        }
        SAML2PolicyIdPCustomizedDataSetter setter = SAML2CfgSetterFactory.getInstance().createSAML2PolicyIdPCustomizedData();
        setter.setIdPName(idpName);
        setter.setAuthnContexts(authnContexts);
        this.trustedIdPsData.add(setter);
    }

    @Override
    public void setIdPCustomizedData(String idpName, List<String> authnContexts, ComparisonMethod comparison) {
        if (this.trustedIdPsData == null) {
            this.trustedIdPsData = new ArrayList<SAML2PolicyIdPCustomizedDataSetter>();
        }
        for (SAML2PolicyIdPCustomizedDataSetter setterTmp : this.trustedIdPsData) {
            if (!((SAML2PolicyIdPCustomizedDataImpl)setterTmp).getIdPName().equals(idpName)) continue;
            setterTmp.setAuthnContexts(authnContexts);
            setterTmp.setRequestedAuthnContextComparisonMethod(comparison);
            return;
        }
        SAML2PolicyIdPCustomizedDataSetter setter = SAML2CfgSetterFactory.getInstance().createSAML2PolicyIdPCustomizedData();
        setter.setIdPName(idpName);
        setter.setAuthnContexts(authnContexts);
        setter.setRequestedAuthnContextComparisonMethod(comparison);
        this.trustedIdPsData.add(setter);
    }

    @Override
    public void setAuthnContextsHTTP(List<String> authnContexts) {
        if (authnContexts != null) {
            String[] authnContextNames = authnContexts.toArray(new String[authnContexts.size()]);
            this.setProperty("authn_contexts_http", authnContextNames);
        } else {
            this.setProperty("authn_contexts_http", (String[])null);
        }
    }

    @Override
    public void setAuthnContextsHTTPS(List<String> authnContexts) {
        if (authnContexts != null) {
            String[] authnContextNames = authnContexts.toArray(new String[authnContexts.size()]);
            this.setProperty("authn_contexts_https", authnContextNames);
        } else {
            this.setProperty("authn_contexts_https", (String[])null);
        }
    }

    @Override
    public void setType(SAML2PolicyType type) {
        if (type == null) {
            this.setProperty("type", SAML2PolicyType.NONE.name());
        } else {
            this.setProperty("type", type.name());
        }
    }

    public void setName(String name) {
        this.policyName = name;
        this.setProperty("policy_name", name);
    }

    @Override
    public SAML2Policy writePolicy() throws SAML2ConfigurationException {
        SAML2PolicyImpl result;
        String changeLogOldValue = null;
        if (this.isNewPolicy) {
            if (this.parent.getAllPolicyNames().contains(this.policyName)) {
                LOCATION.errorT("Policy with name: {0} already exists. \nDetails of the existing policy: {1}", new Object[]{this.policyName, this.parent.getPolicy(this.policyName)});
                throw new SAML2PolicyAlreadyExistsException("Policy with name: " + this.policyName + " already exists");
            }
        } else {
            changeLogOldValue = this.originator.toString();
        }
        super.writeCfgObject();
        try {
            this.deleteSubConfiguration("trusted_idps_customized_data");
            if (this.trustedIdPsData != null) {
                for (SAML2PolicyIdPCustomizedDataSetter setter : this.trustedIdPsData) {
                    if (setter == null) continue;
                    SAML2PolicyIdPCustomizedDataImpl setterImpl = (SAML2PolicyIdPCustomizedDataImpl)setter;
                    setterImpl.createAndWriteConfiguration(this, "trusted_idps_customized_data");
                }
            }
        }
        catch (CfgStorageException e) {
            throw new SAML2ConfigurationException("Could not write trusted idps data", e);
        }
        if (this.isNewPolicy) {
            result = new SAML2PolicyImpl(this.getCfgPath());
            this.parent.createdNewPolicy(result);
            SimpleLogger.log((int)300, (Category)CfgConstants.CHANGE_LOG_CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_cfg.001014", (String)"SAML2 Policy with name: [{0}] was created. Details of policy: [{1}].", (Object[])new Object[]{result.getName(), result});
        } else {
            result = (SAML2PolicyImpl)this.updateOriginator();
            SimpleLogger.log((int)300, (Category)CfgConstants.CHANGE_LOG_CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_cfg.001015", (String)"SAML2 Policy with name: [{0}] was changed. Old version: [{1}], new version: [{2}].", (Object[])new Object[]{this.originator.getName(), changeLogOldValue, result});
        }
        return result;
    }
}

