/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg;

import com.sap.security.saml2.cfg.SAML2CfgObject;
import com.sap.security.saml2.cfg.SAML2EndpointImpl;
import com.sap.security.saml2.cfg.SAML2ModifiableCfgObjectBase;
import com.sap.security.saml2.cfg.SAML2UpdateableProviderBase;
import com.sap.security.saml2.cfg.enums.SAML2Service;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.interfaces.write.SAML2EndpointSetter;
import com.sap.security.saml2.cfg.interfaces.write.SAML2ModifiableProvider;
import java.util.Collection;

abstract class SAML2ModifiableProviderBase
extends SAML2ModifiableCfgObjectBase
implements SAML2ModifiableProvider {
    private String providerName;

    SAML2ModifiableProviderBase(SAML2CfgObject parent, String propertySheetName) {
        super(parent, propertySheetName);
    }

    SAML2ModifiableProviderBase(String cfgRootPath, String propertySheetName, SAML2UpdateableProviderBase originator) throws SAML2ConfigurationException {
        super(cfgRootPath, propertySheetName, originator);
    }

    @Override
    public SAML2UpdateableProviderBase writeProvider() throws SAML2ConfigurationException {
        return (SAML2UpdateableProviderBase)super.writeCfgObject();
    }

    public void deleteProvider() throws SAML2ConfigurationException {
        super.deleteCfgObject();
    }

    protected void setProviderName(String name) {
        this.setProperty("name", name);
        this.providerName = name;
    }

    protected String getProviderName() {
        return this.providerName;
    }

    protected void checkEndpoints(Collection<SAML2EndpointSetter> endpoints) throws SAML2ConfigurationException {
        if (endpoints != null && !endpoints.isEmpty()) {
            boolean defaultSSOEndpointFound = false;
            boolean defaultACSEndpointFound = false;
            boolean defaultSLOEndpointFound = false;
            boolean defaultARSEndpointFound = false;
            for (SAML2EndpointSetter endpointSetter : endpoints) {
                SAML2EndpointImpl endpoint = (SAML2EndpointImpl)endpointSetter;
                if (!endpoint.isDefault()) continue;
                SAML2Service endpointService = endpoint.getService();
                if (SAML2Service.SINGLE_SIGN_ON_SERVICE == endpointService) {
                    if (defaultSSOEndpointFound) {
                        throw new SAML2ConfigurationException("Cannot configure more than one default endpoints for Single Sign-on Service endpoints");
                    }
                    defaultSSOEndpointFound = true;
                    continue;
                }
                if (SAML2Service.ASSERTION_CONSUMER_SERVICE == endpointService) {
                    if (defaultACSEndpointFound) {
                        throw new SAML2ConfigurationException("Cannot configure more than one default endpoints for Assertion Consumer Service endpoints");
                    }
                    defaultACSEndpointFound = true;
                    continue;
                }
                if (SAML2Service.SINGLE_LOGOUT_SERVICE == endpointService) {
                    if (defaultSLOEndpointFound) {
                        throw new SAML2ConfigurationException("Cannot configure more than one default endpoints for Single Logout Service endpoints");
                    }
                    defaultSLOEndpointFound = true;
                    continue;
                }
                if (SAML2Service.ARTIFACT_RESOLUTION_SERVICE != endpointService) continue;
                if (defaultARSEndpointFound) {
                    throw new SAML2ConfigurationException("Cannot configure more than one default endpoints for Artifact Resolution Service endpoints");
                }
                defaultARSEndpointFound = true;
            }
        }
    }
}

