/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg;

import com.sap.security.saml2.cfg.SAML2CfgObject;
import com.sap.security.saml2.cfg.SAML2EndpointImpl;
import com.sap.security.saml2.cfg.SAML2ExtensionSupplierDescriptorImpl;
import com.sap.security.saml2.cfg.SAML2ModifiableProviderBase;
import com.sap.security.saml2.cfg.SAML2TrustedIdPImpl;
import com.sap.security.saml2.cfg.SAML2TrustedIdPsConfigImpl;
import com.sap.security.saml2.cfg.enums.ComparisonMethod;
import com.sap.security.saml2.cfg.enums.DigestAlgorithm;
import com.sap.security.saml2.cfg.enums.EncryptionAlgorithm;
import com.sap.security.saml2.cfg.enums.EncryptionOption;
import com.sap.security.saml2.cfg.enums.ResponseRequirementType;
import com.sap.security.saml2.cfg.enums.SAML2Binding;
import com.sap.security.saml2.cfg.enums.SAML2NameIdFormat;
import com.sap.security.saml2.cfg.enums.SignatureOption;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.interfaces.SAML2Config;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalProvider;
import com.sap.security.saml2.cfg.interfaces.read.SAML2TrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2IdentityFederationTrustedIdP;
import com.sap.security.saml2.cfg.interfaces.write.SAML2EndpointSetter;
import com.sap.security.saml2.cfg.interfaces.write.SAML2ExtensionSupplierSetter;
import com.sap.security.saml2.cfg.interfaces.write.SAML2ModifiableTrustedIdP;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2IdentityFederationTrustedIdPSetter;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2NameIdFormatEmailSetter;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2NameIdFormatEmailTrustedIdPSetter;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2NameIdFormatKerberosTrustedIdPSetter;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2NameIdFormatPersistentTrustedIdPSetter;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2NameIdFormatTransientTrustedIdPSetter;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2NameIdFormatUnspecifiedSetter;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2NameIdFormatUnspecifiedTrustedIdPSetter;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2NameIdFormatWindowsSetter;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2NameIdFormatX509TrustedIdPSetter;
import com.sap.security.saml2.cfg.nameidformat.SAML2IdentityFederationTrustedIdPImpl;
import com.sap.security.saml2.cfg.nameidformat.SAML2IdentityFederationTrustedIdPOldDataImpl;
import com.sap.security.saml2.cfg.nameidformat.SAML2NameIdFormatEmailImpl;
import com.sap.security.saml2.cfg.nameidformat.SAML2NameIdFormatEmailTrustedIdPImpl;
import com.sap.security.saml2.cfg.nameidformat.SAML2NameIdFormatKerberosTrustedIdPImpl;
import com.sap.security.saml2.cfg.nameidformat.SAML2NameIdFormatPersistentTrustedIdPImpl;
import com.sap.security.saml2.cfg.nameidformat.SAML2NameIdFormatTransientTrustedIdPImpl;
import com.sap.security.saml2.cfg.nameidformat.SAML2NameIdFormatUnspecifiedImpl;
import com.sap.security.saml2.cfg.nameidformat.SAML2NameIdFormatUnspecifiedTrustedIdPImpl;
import com.sap.security.saml2.cfg.nameidformat.SAML2NameIdFormatWindowsImpl;
import com.sap.security.saml2.cfg.nameidformat.SAML2NameIdFormatX509TrustedIdPImpl;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import com.sap.security.saml2.cfg.util.CfgConstants;
import com.sap.security.saml2.cfg.util.CfgUtils;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.SimpleLogger;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class SAML2ModifiableTrustedIdPImpl
extends SAML2ModifiableProviderBase
implements SAML2ModifiableTrustedIdP {
    private static final Location LOCATION = Location.getLocation(SAML2ModifiableTrustedIdPImpl.class);
    private Collection<SAML2EndpointSetter> endpoints;
    private List<SAML2ExtensionSupplierSetter> extensionSupplierDescriptors;
    private SAML2NameIdFormatEmailImpl nameIdFormatEmail;
    private SAML2NameIdFormatEmailTrustedIdPImpl nameIdFormatEmailTrustedIdP;
    private SAML2NameIdFormatUnspecifiedImpl nameIdFormatUnspecified;
    private SAML2NameIdFormatUnspecifiedTrustedIdPImpl nameIdFormatUnspecifiedTrustedIdP;
    private SAML2NameIdFormatTransientTrustedIdPImpl nameIdFormatTransientTrustedIdP;
    private SAML2NameIdFormatPersistentTrustedIdPImpl nameIdFormatPersistentTrustedIdP;
    private SAML2NameIdFormatKerberosTrustedIdPImpl nameIdFormatKerberosTrustedIdP;
    private SAML2NameIdFormatX509TrustedIdPImpl nameIdFormatX509TrustedIdP;
    private SAML2NameIdFormatWindowsImpl nameIdFormatWindows;
    private Map<String, SAML2IdentityFederationTrustedIdPImpl> identityFederations = new HashMap<String, SAML2IdentityFederationTrustedIdPImpl>();
    private boolean newTrustedIdPCreation;
    private SAML2TrustedIdPsConfigImpl parent;
    private SAML2TrustedIdPImpl originator;

    SAML2ModifiableTrustedIdPImpl(SAML2TrustedIdPsConfigImpl parent) {
        super(parent, "trusted_idp");
        this.newTrustedIdPCreation = true;
        this.parent = parent;
    }

    SAML2ModifiableTrustedIdPImpl(SAML2TrustedIdPImpl originator) throws SAML2ConfigurationException {
        super(originator.getCfgPath(), "trusted_idp", originator);
        this.originator = originator;
    }

    @Override
    public SAML2TrustedIdPImpl writeProvider() throws SAML2ConfigurationException {
        SAML2TrustedIdPImpl result;
        String changeLogOldValue = null;
        if (this.newTrustedIdPCreation) {
            String providerName = this.getProviderName();
            SAML2TrustedIdP existingTrustedIdP = this.parent.getTrustedIdP(providerName);
            if (existingTrustedIdP != null) {
                LOCATION.errorT("Trusted identity provider with name: {0} already exists. \nDetails of the existing provider: {1}", new Object[]{providerName, existingTrustedIdP});
                throw new SAML2ConfigurationException("Trusted Identity Provider with name: " + providerName + " already exists");
            }
        } else {
            changeLogOldValue = this.originator.toString();
        }
        this.checkEndpoints(this.endpoints);
        super.writeProvider();
        try {
            if (this.endpoints != null) {
                this.deleteSubConfiguration("endpoints");
                for (SAML2EndpointSetter endpointSetter : this.endpoints) {
                    if (endpointSetter == null) continue;
                    SAML2EndpointImpl endpoint = (SAML2EndpointImpl)endpointSetter;
                    endpoint.createAndWriteConfiguration(this, "endpoints");
                }
            }
        }
        catch (CfgStorageException e) {
            throw new SAML2ConfigurationException("Could not write endpoints", e);
        }
        try {
            if (this.extensionSupplierDescriptors != null) {
                this.deleteSubConfiguration("ext_suppliers");
                for (SAML2ExtensionSupplierSetter descriptor : this.extensionSupplierDescriptors) {
                    SAML2ExtensionSupplierDescriptorImpl descriptorImpl = (SAML2ExtensionSupplierDescriptorImpl)descriptor;
                    descriptorImpl.createConfiguration(this, "ext_suppliers");
                }
            }
        }
        catch (CfgStorageException e) {
            throw new SAML2ConfigurationException("Could not write extension supplier descriptors", e);
        }
        try {
            if (this.identityFederations != null && this.identityFederations.size() > 0) {
                TreeSet<String> nameIdFormats = new TreeSet<String>(this.identityFederations.keySet());
                for (String nameIdFormat : nameIdFormats) {
                    SAML2IdentityFederationTrustedIdPImpl identityFederation = this.identityFederations.get(nameIdFormat);
                    if (identityFederation == null) continue;
                    identityFederation.createAndWriteConfiguration(this);
                }
            }
        }
        catch (CfgStorageException e) {
            throw new SAML2ConfigurationException("Could not write identity federations", e);
        }
        try {
            if (this.nameIdFormatEmail != null) {
                this.nameIdFormatEmail.createAndWriteConfiguration(this);
            }
            if (this.nameIdFormatEmailTrustedIdP != null) {
                this.nameIdFormatEmailTrustedIdP.createAndWriteConfiguration(this);
            }
            if (this.nameIdFormatKerberosTrustedIdP != null) {
                this.nameIdFormatKerberosTrustedIdP.createAndWriteConfiguration(this);
            }
            if (this.nameIdFormatPersistentTrustedIdP != null) {
                this.nameIdFormatPersistentTrustedIdP.createAndWriteConfiguration(this);
            }
            if (this.nameIdFormatTransientTrustedIdP != null) {
                this.nameIdFormatTransientTrustedIdP.createAndWriteConfiguration(this);
            }
            if (this.nameIdFormatUnspecified != null) {
                this.nameIdFormatUnspecified.createAndWriteConfiguration(this);
            }
            if (this.nameIdFormatUnspecifiedTrustedIdP != null) {
                this.nameIdFormatUnspecifiedTrustedIdP.createAndWriteConfiguration(this);
            }
            if (this.nameIdFormatWindows != null) {
                this.nameIdFormatWindows.createAndWriteConfiguration(this);
            }
            if (this.nameIdFormatX509TrustedIdP != null) {
                this.nameIdFormatX509TrustedIdP.createAndWriteConfiguration(this);
            }
        }
        catch (CfgStorageException e) {
            throw new SAML2ConfigurationException("Could not write nameId-formats", e);
        }
        if (this.newTrustedIdPCreation) {
            SAML2TrustedIdPsConfigImpl trustedIdPsConfig = this.getParent();
            SAML2Config config = trustedIdPsConfig.getParent();
            SAML2LocalProvider localProvider = config.getLocalProvidersConfiguration().getLocalProvider();
            result = new SAML2TrustedIdPImpl(this.getCfgPath(), localProvider);
            trustedIdPsConfig.createdNewTrustedIdP(result);
            SimpleLogger.log((int)300, (Category)CfgConstants.CHANGE_LOG_CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_cfg.001006", (String)"A new SAML2 trusted identity provider with name: [{0}] was created. Details of the new provider: [{1}].", (Object[])new Object[]{this.getProviderName(), result});
        } else {
            result = (SAML2TrustedIdPImpl)this.updateOriginator();
            SimpleLogger.log((int)300, (Category)CfgConstants.CHANGE_LOG_CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_cfg.001008", (String)"SAML2 trusted identity provider with name: [{0}] was changed. Old version: [{1}], new version: [{2}].", (Object[])new Object[]{this.originator.getName(), changeLogOldValue, result});
        }
        return result;
    }

    @Override
    public void setAuthenticationContextNames(List<String> authnContexts) {
        if (authnContexts != null) {
            String[] authnContextNames = authnContexts.toArray(new String[authnContexts.size()]);
            this.setProperty("authn_contexts", authnContextNames);
        } else {
            this.setProperty("authn_contexts", (String[])null);
        }
    }

    @Override
    public void setRequestedAuthnContextComparisonMethod(ComparisonMethod comparison) {
        this.setProperty("requested_comparison_method", comparison != null ? comparison.getName() : null);
    }

    @Override
    public void setDefaultNameIdFormat(SAML2NameIdFormat nameIdFormat) {
        if (nameIdFormat != null) {
            this.setProperty("default_name_id_format", nameIdFormat.getName());
        }
    }

    @Override
    public void setExtensionSupplierDescriptors(List<SAML2ExtensionSupplierSetter> extensionSuppliers) {
        this.extensionSupplierDescriptors = extensionSuppliers;
    }

    @Override
    public void setDescription(String description) {
        this.setProperty("description", description);
    }

    @Override
    public SAML2IdentityFederationTrustedIdPSetter getIdentityFederation(String nameIdFormat) {
        SAML2IdentityFederationTrustedIdPSetter result = this.getExistingIdentityFederationSetter(nameIdFormat);
        if (result == null) {
            result = new SAML2IdentityFederationTrustedIdPImpl();
            result.setNameIdFormat(nameIdFormat);
        }
        return result;
    }

    public SAML2IdentityFederationTrustedIdPSetter getExistingIdentityFederationSetter(String nameIdFormat) {
        SAML2IdentityFederationTrustedIdPImpl result = null;
        if (this.originator != null) {
            SAML2IdentityFederationTrustedIdP identityFederation = this.originator.getIdentityFederation(nameIdFormat);
            if (identityFederation instanceof SAML2IdentityFederationTrustedIdPImpl) {
                String cfgPathOfExistingIdentityFederation = ((SAML2IdentityFederationTrustedIdPImpl)identityFederation).getCfgPath();
                result = new SAML2IdentityFederationTrustedIdPImpl(this.originator, cfgPathOfExistingIdentityFederation, true);
            } else if (identityFederation instanceof SAML2IdentityFederationTrustedIdPOldDataImpl) {
                result = new SAML2IdentityFederationTrustedIdPImpl((SAML2IdentityFederationTrustedIdPOldDataImpl)identityFederation);
            }
        }
        return result;
    }

    public String getCfgPathOfExistingIdentityFederation(String nameIdFormat) {
        SAML2IdentityFederationTrustedIdP identityFederation;
        String result = null;
        if (this.originator != null && (identityFederation = this.originator.getIdentityFederation(nameIdFormat)) instanceof SAML2IdentityFederationTrustedIdPImpl) {
            result = ((SAML2IdentityFederationTrustedIdPImpl)identityFederation).getCfgPath();
        }
        return result;
    }

    @Override
    public void setIdentityFederation(SAML2IdentityFederationTrustedIdPSetter identityFederation) {
        SAML2IdentityFederationTrustedIdPImpl identityFederationImpl = (SAML2IdentityFederationTrustedIdPImpl)identityFederation;
        String nameIdFormat = identityFederationImpl.getNameIdFormat();
        if (!CfgUtils.isEmpty(nameIdFormat)) {
            SAML2IdentityFederationTrustedIdPImpl previousEntry = this.identityFederations.put(nameIdFormat, identityFederationImpl);
            if (previousEntry != null && LOCATION.beWarning()) {
                LOCATION.warningT("There was already set identity federation for nameId format: {0} and it will be overwritten with the new one. \n  Old identity federation setter: {1}\n  New identity federation setter: {2}", new Object[]{previousEntry, identityFederationImpl});
            }
        } else if (LOCATION.beWarning()) {
            LOCATION.warningT("Identity federation does not have configured nameId format. Details: {0}", new Object[]{identityFederationImpl});
        }
    }

    @Override
    public void setIdentityFederations(Collection<SAML2IdentityFederationTrustedIdPSetter> identityFederations) {
        if (identityFederations != null) {
            for (SAML2IdentityFederationTrustedIdPSetter identityFederationSetter : identityFederations) {
                this.setIdentityFederation(identityFederationSetter);
            }
        }
    }

    @Override
    public void setNameIdFormatEmail(SAML2NameIdFormatEmailSetter nameIdFormat) {
        this.nameIdFormatEmail = (SAML2NameIdFormatEmailImpl)nameIdFormat;
    }

    public void setNameIdFormatEmail(SAML2NameIdFormatEmailTrustedIdPSetter nameIdFormat) {
        this.nameIdFormatEmailTrustedIdP = (SAML2NameIdFormatEmailTrustedIdPImpl)nameIdFormat;
    }

    @Override
    public void setNameIdFormatKerberos(SAML2NameIdFormatKerberosTrustedIdPSetter nameIdFormat) {
        this.nameIdFormatKerberosTrustedIdP = (SAML2NameIdFormatKerberosTrustedIdPImpl)nameIdFormat;
    }

    @Override
    public void setNameIdFormatPersistent(SAML2NameIdFormatPersistentTrustedIdPSetter nameIdFormat) {
        this.nameIdFormatPersistentTrustedIdP = (SAML2NameIdFormatPersistentTrustedIdPImpl)nameIdFormat;
    }

    @Override
    public void setNameIdFormatTransient(SAML2NameIdFormatTransientTrustedIdPSetter nameIdFormat) {
        this.nameIdFormatTransientTrustedIdP = (SAML2NameIdFormatTransientTrustedIdPImpl)nameIdFormat;
    }

    @Override
    public void setNameIdFormatUnspecified(SAML2NameIdFormatUnspecifiedSetter nameIdFormat) {
        this.nameIdFormatUnspecified = (SAML2NameIdFormatUnspecifiedImpl)nameIdFormat;
    }

    public void setNameIdFormatUnspecified(SAML2NameIdFormatUnspecifiedTrustedIdPSetter nameIdFormat) {
        this.nameIdFormatUnspecifiedTrustedIdP = (SAML2NameIdFormatUnspecifiedTrustedIdPImpl)nameIdFormat;
    }

    @Override
    public void setNameIdFormatWindows(SAML2NameIdFormatWindowsSetter nameIdFormat) {
        this.nameIdFormatWindows = (SAML2NameIdFormatWindowsImpl)nameIdFormat;
    }

    @Override
    public void setNameIdFormatX509(SAML2NameIdFormatX509TrustedIdPSetter nameIdFormat) {
        this.nameIdFormatX509TrustedIdP = (SAML2NameIdFormatX509TrustedIdPImpl)nameIdFormat;
    }

    @Override
    public void setRequireSignedAssertions(SignatureOption require) {
        if (require != null) {
            this.setProperty("require_signed_assertions", require.name());
        }
    }

    @Override
    public void setRequireSignedAuthnResponses(SignatureOption require) {
        if (require != null) {
            this.setProperty("require_signed_authn_responses", require.name());
        }
    }

    @Override
    public void setRequiredEncryptedAuthnResponseElements(EncryptionOption encOption) {
        if (encOption != null) {
            this.setProperty("required_encrypted_authn_response_elements", encOption.name());
        }
    }

    @Override
    public void setResponseRequirementType(ResponseRequirementType type) {
        if (type != null) {
            this.setProperty("response_requirement_acs_type", type.name());
        } else {
            this.setProperty("response_requirement_acs_type", (String)null);
        }
    }

    @Override
    public void setResponseRequirementAssertionConsumerIndex(int index) {
        this.setProperty("response_requirement_acs_index", index);
    }

    @Override
    public void setResponseRequirementAssertionConsumerURL(String url) {
        this.setProperty("response_requirement_acs_url", url);
    }

    @Override
    public void setResponseRequirementBinding(SAML2Binding binding) {
        if (binding != null) {
            this.setProperty("response_requirement_binding", binding.getName());
        }
    }

    @Override
    public void setSignAuthnRequests(SignatureOption signAuthnRequests) {
        if (signAuthnRequests != null) {
            this.setProperty("sign_authn_requests", signAuthnRequests.name());
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.setProperty("enabled", enabled);
    }

    @Override
    public void setEncryptSingleLogoutSubject(boolean encryptSLOSubject) {
        this.setProperty("encrypt_slo_subject", encryptSLOSubject);
    }

    @Override
    public void setEncryptManageNameIDSubject(boolean encryptMNISubject) {
        this.setProperty("encrypt_mni_subject", encryptMNISubject);
    }

    @Override
    public void setEncryptManageNameIDNewID(boolean encryptMNINewID) {
        this.setProperty("encrypt_mni_new_id", encryptMNINewID);
    }

    @Override
    public void setEncryptionAlgorithm(EncryptionAlgorithm encAlgorithm) {
        if (encAlgorithm != null) {
            this.setProperty("enc_algorithm", encAlgorithm.getName());
        }
    }

    @Override
    public void setDigestAlgorithm(DigestAlgorithm sigAlgorithm) {
        if (sigAlgorithm != null) {
            this.setProperty("sig_algorithm", sigAlgorithm.getName());
        }
    }

    @Override
    public void setEncryptionCertificateName(String certificateName) {
        this.setProperty("enc_cert", certificateName);
    }

    @Override
    public void setEndpoints(Collection<SAML2EndpointSetter> endpoints) {
        this.endpoints = endpoints;
    }

    @Override
    public void setName(String name) {
        this.setProviderName(name);
    }

    @Override
    public void setRequireEncryptedSingleLogoutSubject(boolean requireEncryption) {
        this.setProperty("require_encrypted_slo_subject", requireEncryption);
    }

    @Override
    public void setRequireEncryptedManageNameIDNewID(boolean requireEncryption) {
        this.setProperty("require_encrypted_mni_new_id", requireEncryption);
    }

    @Override
    public void setRequireEncryptedManageNameIDSubject(boolean requireEncryption) {
        this.setProperty("require_encrypted_mni_subject", requireEncryption);
    }

    @Override
    public void setRequireSignedArtifactResolutionMessages(SignatureOption signOption) {
        if (signOption != null) {
            this.setProperty("require_signed_ars_messages", signOption.name());
        }
    }

    @Override
    public void setRequireSignedSingleLogoutMessages(SignatureOption signOption) {
        if (signOption != null) {
            this.setProperty("require_signed_slo_messages", signOption.name());
        }
    }

    @Override
    public void setRequireSignedManageNameIDMessages(SignatureOption signOption) {
        this.setProperty("require_signed_mni_messages", signOption != null ? signOption.name() : null);
    }

    @Override
    public void setSignArtifactResolutionMessages(SignatureOption signOption) {
        if (signOption != null) {
            this.setProperty("sign_ars_messages", signOption.name());
        }
    }

    @Override
    public void setSignSingleLogoutMessages(SignatureOption signOption) {
        if (signOption != null) {
            this.setProperty("sign_slo_messages", signOption.name());
        }
    }

    @Override
    public void setSignManageNameIDMessages(SignatureOption signOption) {
        this.setProperty("sign_mni_messages", signOption != null ? signOption.name() : null);
    }

    @Override
    public void setSigningCertificateName(String certificateName) {
        this.setProperty("signing_cert", certificateName);
    }

    @Override
    public void setSecondarySigningCertificateName(String certificateName) {
        this.setProperty("secondary_signing_cert", certificateName);
    }

    protected SAML2TrustedIdPsConfigImpl getParent() {
        return this.parent;
    }

    @Override
    public SAML2NameIdFormatPersistentTrustedIdPSetter getNameIdFormatPersistent() {
        return new SAML2NameIdFormatPersistentTrustedIdPImpl((SAML2CfgObject)this.originator, true);
    }

    @Override
    public SAML2NameIdFormatTransientTrustedIdPSetter getNameIdFormatTransient() {
        return new SAML2NameIdFormatTransientTrustedIdPImpl((SAML2CfgObject)this.originator, true);
    }
}

