/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg;

import com.sap.security.saml2.cfg.SAML2CfgObject;
import com.sap.security.saml2.cfg.SAML2ConfigImpl;
import com.sap.security.saml2.cfg.SAML2EndpointImpl;
import com.sap.security.saml2.cfg.SAML2ModifiableProviderBase;
import com.sap.security.saml2.cfg.SAML2TrustedSPImpl;
import com.sap.security.saml2.cfg.SAML2TrustedSPsConfigImpl;
import com.sap.security.saml2.cfg.enums.DigestAlgorithm;
import com.sap.security.saml2.cfg.enums.EncryptionAlgorithm;
import com.sap.security.saml2.cfg.enums.EncryptionOption;
import com.sap.security.saml2.cfg.enums.SAML2NameIdFormat;
import com.sap.security.saml2.cfg.enums.SignatureOption;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalProvider;
import com.sap.security.saml2.cfg.interfaces.read.SAML2TrustedSP;
import com.sap.security.saml2.cfg.interfaces.write.SAML2EndpointSetter;
import com.sap.security.saml2.cfg.interfaces.write.SAML2ModifiableTrustedSP;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2NameIdFormatEmailSetter;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2NameIdFormatEmailTrustedSPSetter;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2NameIdFormatKerberosTrustedSPSetter;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2NameIdFormatPersistentTrustedSPSetter;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2NameIdFormatTransientTrustedSPSetter;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2NameIdFormatUnspecifiedSetter;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2NameIdFormatUnspecifiedTrustedSPSetter;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2NameIdFormatWindowsSetter;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2NameIdFormatWindowsTrustedSPSetter;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2NameIdFormatX509TrustedSPSetter;
import com.sap.security.saml2.cfg.nameidformat.SAML2NameIdFormatEmailImpl;
import com.sap.security.saml2.cfg.nameidformat.SAML2NameIdFormatEmailTrustedSPImpl;
import com.sap.security.saml2.cfg.nameidformat.SAML2NameIdFormatKerberosTrustedSPImpl;
import com.sap.security.saml2.cfg.nameidformat.SAML2NameIdFormatPersistentTrustedSPImpl;
import com.sap.security.saml2.cfg.nameidformat.SAML2NameIdFormatTransientTrustedSPImpl;
import com.sap.security.saml2.cfg.nameidformat.SAML2NameIdFormatUnspecifiedImpl;
import com.sap.security.saml2.cfg.nameidformat.SAML2NameIdFormatUnspecifiedTrustedSPImpl;
import com.sap.security.saml2.cfg.nameidformat.SAML2NameIdFormatWindowsImpl;
import com.sap.security.saml2.cfg.nameidformat.SAML2NameIdFormatWindowsTrustedSPImpl;
import com.sap.security.saml2.cfg.nameidformat.SAML2NameIdFormatX509TrustedSPImpl;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import com.sap.security.saml2.cfg.util.CfgConstants;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.SimpleLogger;
import java.util.Collection;

public class SAML2ModifiableTrustedSPImpl
extends SAML2ModifiableProviderBase
implements SAML2ModifiableTrustedSP {
    private static final Location LOCATION = Location.getLocation(SAML2ModifiableTrustedSPImpl.class);
    private Collection<SAML2EndpointSetter> endpoints;
    private SAML2NameIdFormatEmailImpl nameIdFormatEmail;
    private SAML2NameIdFormatEmailTrustedSPImpl nameIdFormatEmailTrustedSP;
    private SAML2NameIdFormatUnspecifiedImpl nameIdFormatUnspecified;
    private SAML2NameIdFormatUnspecifiedTrustedSPImpl nameIdFormatUnspecifiedTrustedSP;
    private SAML2NameIdFormatTransientTrustedSPImpl nameIdFormatTransientTrustedSP;
    private SAML2NameIdFormatPersistentTrustedSPImpl nameIdFormatPersistentTrustedSP;
    private SAML2NameIdFormatKerberosTrustedSPImpl nameIdFormatKerberosTrustedSP;
    private SAML2NameIdFormatX509TrustedSPImpl nameIdFormatX509TrustedSP;
    private SAML2NameIdFormatWindowsImpl nameIdFormatWindows;
    private SAML2NameIdFormatWindowsTrustedSPImpl nameIdFormatWindowsTrustedSP;
    private boolean newTrustedSPCreation;
    private SAML2TrustedSPsConfigImpl parent;
    private SAML2TrustedSPImpl originator;

    public SAML2ModifiableTrustedSPImpl(SAML2TrustedSPsConfigImpl parent) {
        super(parent, "trusted_sp");
        this.newTrustedSPCreation = true;
        this.parent = parent;
    }

    public SAML2ModifiableTrustedSPImpl(SAML2TrustedSPImpl originator) throws SAML2ConfigurationException {
        super(originator.getCfgPath(), "trusted_sp", originator);
        this.originator = originator;
    }

    @Override
    public SAML2TrustedSPImpl writeProvider() throws SAML2ConfigurationException {
        SAML2TrustedSPImpl result;
        String changeLogOldValue = null;
        if (this.newTrustedSPCreation) {
            String providerName = this.getProviderName();
            SAML2TrustedSP existingTrustedSP = this.parent.getTrustedSP(providerName);
            if (existingTrustedSP != null) {
                LOCATION.errorT("Trusted service provider with name: {0} already exists. \nDetails of the existing provider: {1}", new Object[]{providerName, existingTrustedSP});
                throw new SAML2ConfigurationException("Trusted Service Provider with name: " + providerName + " already exists");
            }
        } else {
            changeLogOldValue = this.originator.toString();
        }
        this.checkEndpoints(this.endpoints);
        super.writeProvider();
        try {
            if (this.endpoints != null) {
                this.deleteSubConfiguration("endpoints");
                for (SAML2EndpointSetter endpointSetter : this.endpoints) {
                    if (endpointSetter == null) continue;
                    SAML2EndpointImpl endpoint = (SAML2EndpointImpl)endpointSetter;
                    endpoint.createAndWriteConfiguration(this, "endpoints");
                }
            }
        }
        catch (CfgStorageException e) {
            throw new SAML2ConfigurationException("Could not write endpoints", e);
        }
        try {
            if (this.nameIdFormatEmail != null) {
                this.nameIdFormatEmail.createAndWriteConfiguration(this);
            }
            if (this.nameIdFormatEmailTrustedSP != null) {
                this.nameIdFormatEmailTrustedSP.createAndWriteConfiguration(this);
            }
            if (this.nameIdFormatKerberosTrustedSP != null) {
                this.nameIdFormatKerberosTrustedSP.createAndWriteConfiguration(this);
            }
            if (this.nameIdFormatPersistentTrustedSP != null) {
                this.nameIdFormatPersistentTrustedSP.createAndWriteConfiguration(this);
            }
            if (this.nameIdFormatTransientTrustedSP != null) {
                this.nameIdFormatTransientTrustedSP.createAndWriteConfiguration(this);
            }
            if (this.nameIdFormatUnspecified != null) {
                this.nameIdFormatUnspecified.createAndWriteConfiguration(this);
            }
            if (this.nameIdFormatUnspecifiedTrustedSP != null) {
                this.nameIdFormatUnspecifiedTrustedSP.createAndWriteConfiguration(this);
            }
            if (this.nameIdFormatWindows != null) {
                this.nameIdFormatWindows.createAndWriteConfiguration(this);
            }
            if (this.nameIdFormatWindowsTrustedSP != null) {
                this.nameIdFormatWindowsTrustedSP.createAndWriteConfiguration(this);
            }
            if (this.nameIdFormatX509TrustedSP != null) {
                this.nameIdFormatX509TrustedSP.createAndWriteConfiguration(this);
            }
        }
        catch (CfgStorageException e) {
            throw new SAML2ConfigurationException("Could not write nameId-formats", e);
        }
        if (this.newTrustedSPCreation) {
            SAML2TrustedSPsConfigImpl trustedSPsConfig = this.getParent();
            SAML2ConfigImpl config = trustedSPsConfig.getParent();
            SAML2LocalProvider localProvider = config.getLocalProvidersConfiguration().getLocalProvider();
            result = new SAML2TrustedSPImpl(this.getCfgPath(), localProvider);
            trustedSPsConfig.createdNewTrustedSP(result);
            SimpleLogger.log((int)300, (Category)CfgConstants.CHANGE_LOG_CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_cfg.001009", (String)"A new SAML2 trusted service provider with name: [{0}] was created. Details of the new provider: [{1}].", (Object[])new Object[]{this.getProviderName(), result});
        } else {
            result = (SAML2TrustedSPImpl)this.updateOriginator();
            SimpleLogger.log((int)300, (Category)CfgConstants.CHANGE_LOG_CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_cfg.001011", (String)"SAML2 trusted service provider with name: [{0}] was changed. Old version: [{1}], new version: [{2}].", (Object[])new Object[]{this.originator.getName(), changeLogOldValue, result});
        }
        return result;
    }

    @Override
    public void setAuthnResponseElementsToEncrypt(EncryptionOption encOption) {
        if (encOption != null) {
            this.setProperty("authn_response_elements_to_encrypt", encOption.name());
        }
    }

    @Override
    public void setDefaultNameIdFormat(SAML2NameIdFormat nameIdFormat) {
        this.setProperty("default_name_id_format", nameIdFormat != null ? nameIdFormat.getName() : null);
    }

    @Override
    public void setDescription(String description) {
        this.setProperty("description", description);
    }

    @Override
    public void setSPProvidedIDUMEAttributeName(String name) {
        this.setProperty("sp_provided_id_ume_attr_name", name);
    }

    @Override
    public void setSPProvidedIDUMEAttributeNamespace(String namespace) {
        this.setProperty("sp_provided_id_ume_attr_ns", namespace);
    }

    @Override
    public void setNameIdFormatEmail(SAML2NameIdFormatEmailSetter nameIdFormat) {
        this.nameIdFormatEmail = (SAML2NameIdFormatEmailImpl)nameIdFormat;
    }

    @Override
    public void setNameIdFormatEmail(SAML2NameIdFormatEmailTrustedSPSetter nameIdFormat) {
        this.nameIdFormatEmailTrustedSP = (SAML2NameIdFormatEmailTrustedSPImpl)nameIdFormat;
    }

    @Override
    public void setNameIdFormatKerberos(SAML2NameIdFormatKerberosTrustedSPSetter nameIdFormat) {
        this.nameIdFormatKerberosTrustedSP = (SAML2NameIdFormatKerberosTrustedSPImpl)nameIdFormat;
    }

    @Override
    public void setNameIdFormatPersistent(SAML2NameIdFormatPersistentTrustedSPSetter nameIdFormat) {
        this.nameIdFormatPersistentTrustedSP = (SAML2NameIdFormatPersistentTrustedSPImpl)nameIdFormat;
    }

    @Override
    public void setNameIdFormatTransient(SAML2NameIdFormatTransientTrustedSPSetter nameIdFormat) {
        this.nameIdFormatTransientTrustedSP = (SAML2NameIdFormatTransientTrustedSPImpl)nameIdFormat;
    }

    @Override
    public void setNameIdFormatUnspecified(SAML2NameIdFormatUnspecifiedSetter nameIdFormat) {
        this.nameIdFormatUnspecified = (SAML2NameIdFormatUnspecifiedImpl)nameIdFormat;
    }

    @Override
    public void setNameIdFormatUnspecified(SAML2NameIdFormatUnspecifiedTrustedSPSetter nameIdFormat) {
        this.nameIdFormatUnspecifiedTrustedSP = (SAML2NameIdFormatUnspecifiedTrustedSPImpl)nameIdFormat;
    }

    @Override
    public void setNameIdFormatWindows(SAML2NameIdFormatWindowsSetter nameIdFormat) {
        this.nameIdFormatWindows = (SAML2NameIdFormatWindowsImpl)nameIdFormat;
    }

    @Override
    public void setNameIdFormatWindows(SAML2NameIdFormatWindowsTrustedSPSetter nameIdFormat) {
        this.nameIdFormatWindowsTrustedSP = (SAML2NameIdFormatWindowsTrustedSPImpl)nameIdFormat;
    }

    @Override
    public void setNameIdFormatX509(SAML2NameIdFormatX509TrustedSPSetter nameIdFormat) {
        this.nameIdFormatX509TrustedSP = (SAML2NameIdFormatX509TrustedSPImpl)nameIdFormat;
    }

    @Override
    public void setRequireSignedAuthnRequests(SignatureOption requireSigning) {
        if (requireSigning != null) {
            this.setProperty("require_signed_authn_requests", requireSigning.name());
        }
    }

    @Override
    public void setSignAssertions(SignatureOption signAssertions) {
        if (signAssertions != null) {
            this.setProperty("sign_assertions", signAssertions.name());
        }
    }

    @Override
    public void setSignAuthnResponses(SignatureOption signResponses) {
        if (signResponses != null) {
            this.setProperty("sign_authn_responses", signResponses.name());
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.setProperty("enabled", enabled);
    }

    @Override
    public void setEncryptSingleLogoutSubject(boolean encryptSLOSubject) {
        this.setProperty("encrypt_slo_subject", encryptSLOSubject);
    }

    @Override
    public void setEncryptManageNameIDNewID(boolean encryptMNINewID) {
        this.setProperty("encrypt_mni_new_id", encryptMNINewID);
    }

    @Override
    public void setEncryptManageNameIDSubject(boolean encryptMNISubject) {
        this.setProperty("encrypt_mni_subject", encryptMNISubject);
    }

    @Override
    public void setEncryptionAlgorithm(EncryptionAlgorithm encAlgorithm) {
        if (encAlgorithm != null) {
            this.setProperty("enc_algorithm", encAlgorithm.getName());
        }
    }

    @Override
    public void setDigestAlgorithm(DigestAlgorithm sigAlgorithm) {
        if (sigAlgorithm != null) {
            this.setProperty("sig_algorithm", sigAlgorithm.getName());
        }
    }

    @Override
    public void setEncryptionCertificateName(String certificateName) {
        this.setProperty("enc_cert", certificateName);
    }

    @Override
    public void setEndpoints(Collection<SAML2EndpointSetter> endpoints) {
        this.endpoints = endpoints;
    }

    @Override
    public void setName(String name) {
        this.setProviderName(name);
    }

    @Override
    public void setRequireEncryptedSingleLogoutSubject(boolean requireEncryption) {
        this.setProperty("require_encrypted_slo_subject", requireEncryption);
    }

    @Override
    public void setRequireEncryptedManageNameIDNewID(boolean requireEncryption) {
        this.setProperty("require_encrypted_mni_new_id", requireEncryption);
    }

    @Override
    public void setRequireEncryptedManageNameIDSubject(boolean requireEncryption) {
        this.setProperty("require_encrypted_mni_subject", requireEncryption);
    }

    @Override
    public void setRequireSignedArtifactResolutionMessages(SignatureOption signOption) {
        if (signOption != null) {
            this.setProperty("require_signed_ars_messages", signOption.name());
        }
    }

    @Override
    public void setRequireSignedSingleLogoutMessages(SignatureOption signOption) {
        if (signOption != null) {
            this.setProperty("require_signed_slo_messages", signOption.name());
        }
    }

    @Override
    public void setRequireSignedManageNameIDMessages(SignatureOption signOption) {
        this.setProperty("require_signed_mni_messages", signOption != null ? signOption.name() : null);
    }

    @Override
    public void setSignArtifactResolutionMessages(SignatureOption signOption) {
        if (signOption != null) {
            this.setProperty("sign_ars_messages", signOption.name());
        }
    }

    @Override
    public void setSignSingleLogoutMessages(SignatureOption signOption) {
        if (signOption != null) {
            this.setProperty("sign_slo_messages", signOption.name());
        }
    }

    @Override
    public void setSignManageNameIDMessages(SignatureOption signOption) {
        this.setProperty("sign_mni_messages", signOption != null ? signOption.name() : null);
    }

    @Override
    public void setSigningCertificateName(String certificateName) {
        this.setProperty("signing_cert", certificateName);
    }

    @Override
    public void setSecondarySigningCertificateName(String certificateName) {
        this.setProperty("secondary_signing_cert", certificateName);
    }

    protected SAML2TrustedSPsConfigImpl getParent() {
        return this.parent;
    }

    @Override
    public SAML2NameIdFormatPersistentTrustedSPSetter getNameIdFormatPersistent() {
        return new SAML2NameIdFormatPersistentTrustedSPImpl((SAML2CfgObject)this.originator, true);
    }

    @Override
    public SAML2NameIdFormatTransientTrustedSPSetter getNameIdFormatTransient() {
        return new SAML2NameIdFormatTransientTrustedSPImpl((SAML2CfgObject)this.originator, true);
    }
}

