/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg;

import com.sap.security.saml2.cfg.SAML2CfgObject;
import com.sap.security.saml2.cfg.SAML2ConfigImpl;
import com.sap.security.saml2.cfg.SAML2ModifiablePolicyImpl;
import com.sap.security.saml2.cfg.SAML2PolicyImpl;
import com.sap.security.saml2.cfg.SAML2UpdateableCfgObjectBase;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.exceptions.SAML2PolicyAlreadyExistsException;
import com.sap.security.saml2.cfg.exceptions.SAML2ProviderAlreadyExistsException;
import com.sap.security.saml2.cfg.interfaces.SAML2PoliciesConfig;
import com.sap.security.saml2.cfg.interfaces.read.SAML2Policy;
import com.sap.security.saml2.cfg.interfaces.write.SAML2ModifiablePolicy;
import com.sap.security.saml2.cfg.storage.CfgChangeEvent;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import com.sap.security.saml2.cfg.storage.StorageChangedListener;
import com.sap.security.saml2.cfg.util.CfgConstants;
import com.sap.security.saml2.cfg.util.CfgUtils;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.SimpleLogger;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class SAML2PoliciesConfigImpl
extends SAML2CfgObject
implements SAML2PoliciesConfig,
StorageChangedListener {
    private static final long serialVersionUID = 1L;
    static final String CFG_NODE_POLICIES_REL_PATH = "/policies";
    private static final Location LOCATION = Location.getLocation(SAML2PoliciesConfigImpl.class);
    private SAML2ConfigImpl parent;
    private Map<String, SAML2Policy> policiesByName = new HashMap<String, SAML2Policy>();
    private Map<String, SAML2Policy> updateablePolicies = new HashMap<String, SAML2Policy>();
    private Map<String, String> policyNamesByPath = new HashMap<String, String>();

    public SAML2PoliciesConfigImpl(SAML2ConfigImpl parent) throws SAML2ConfigurationException {
        super(String.valueOf(parent.getCfgPath()) + CFG_NODE_POLICIES_REL_PATH, null, false);
        this.parent = parent;
        try {
            this.registerAsStorageListener(this);
            LOCATION.debugT("SAML2 Policy Storage listener registered for path " + this.getCfgPath());
        }
        catch (CfgStorageException e) {
            LOCATION.traceThrowableT(500, "Could not register storage listener for policies configuration with path: {0}", new Object[]{this.getCfgPath()}, (Throwable)e);
        }
        this.loadCache();
        this.traceCache();
    }

    private void loadCache() throws SAML2ConfigurationException {
        this.policiesByName.clear();
        this.updateablePolicies.clear();
        this.policyNamesByPath.clear();
        try {
            String[] policiesPaths = this.getSubCfgPaths();
            if (policiesPaths == null || policiesPaths.length == 0) {
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("There are no policies to load");
                }
                return;
            }
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Policies paths are: {0}", new Object[]{Arrays.asList(policiesPaths)});
            }
            String[] stringArray = policiesPaths;
            int n = policiesPaths.length;
            int n2 = 0;
            while (n2 < n) {
                String policyPath = stringArray[n2];
                if (!CfgUtils.isEmpty(policyPath)) {
                    SAML2PolicyImpl policy = new SAML2PolicyImpl(policyPath);
                    String policyName = policy.getName();
                    if (CfgUtils.isEmpty(policyName)) {
                        if (LOCATION.beDebug()) {
                            LOCATION.debugT("Policy with path: {0} does not have a name. It cannot be added to the policies list", new Object[]{policyPath});
                        }
                    } else {
                        this.policiesByName.put(policyName, policy);
                        this.updateablePolicies.put(policyPath, policy);
                        this.policyNamesByPath.put(policyPath, policyName);
                    }
                }
                ++n2;
            }
        }
        catch (CfgStorageException e) {
            throw new SAML2ConfigurationException("Could not load policies", e);
        }
    }

    private void traceCache() {
        LOCATION.debugT(" policiesByName: " + this.policiesByName + "\n\n updateablePolicies: " + this.updateablePolicies + "\n\n policyNamesByPath: " + this.policyNamesByPath);
    }

    @Override
    public SAML2ModifiablePolicy createPolicy(String name) throws SAML2PolicyAlreadyExistsException, SAML2ConfigurationException {
        return this.getModifiablePolicy(name, false);
    }

    private synchronized SAML2ModifiablePolicy getModifiablePolicy(String name, boolean couldUseExisting) throws SAML2PolicyAlreadyExistsException, SAML2ConfigurationException {
        if (CfgUtils.isEmpty(name)) {
            throw new SAML2ConfigurationException("Policy name cannot be empty");
        }
        if (this.policiesByName.containsKey(name)) {
            if (!couldUseExisting) {
                throw new SAML2ProviderAlreadyExistsException("Policy with name: " + name + " already exists");
            }
            SAML2Policy policy = this.policiesByName.get(name);
            SAML2ModifiablePolicy modifiablePolicy = policy.getModifiablePolicy();
            return modifiablePolicy;
        }
        SAML2ModifiablePolicyImpl modifiablePolicy = new SAML2ModifiablePolicyImpl(this);
        modifiablePolicy.setName(name);
        return modifiablePolicy;
    }

    @Override
    public void deletePolicy(String name) throws SAML2ConfigurationException {
        SAML2Policy policy = this.getPolicy(name);
        if (policy == null) {
            throw new SAML2ConfigurationException("Policy " + name + " does not exists");
        }
        SAML2PolicyImpl policyImpl = (SAML2PolicyImpl)policy;
        String policyImplToString = null;
        if (LOCATION.beDebug()) {
            policyImplToString = policyImpl.toString();
        }
        String cfgPath = policyImpl.getCfgPath();
        SAML2ModifiablePolicyImpl modifiablePolicy = (SAML2ModifiablePolicyImpl)policyImpl.getModifiablePolicy();
        modifiablePolicy.deleteCfgObject();
        this.removePolicyFromCache(name, policy, cfgPath);
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Deleted policy: {0}", new Object[]{policyImplToString});
        }
        SimpleLogger.log((int)300, (Category)CfgConstants.CHANGE_LOG_CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_cfg.001016", (String)"SAML2 Policy with name: [{0}] was deleted.", (Object[])new Object[]{name});
    }

    private void removePolicyFromCache(String name, SAML2Policy policy, String cfgPath) {
        this.updateablePolicies.remove(cfgPath);
        this.policiesByName.remove(name);
        this.policyNamesByPath.remove(cfgPath);
    }

    @Override
    public Collection<SAML2Policy> getAllPolicies() {
        return this.policiesByName.values();
    }

    @Override
    public Collection<String> getAllPolicyNames() {
        return this.policiesByName.keySet();
    }

    @Override
    public SAML2Policy getPolicy(String policyName) {
        return this.policiesByName.get(policyName);
    }

    @Override
    public void storageChanged(CfgChangeEvent event) {
        LOCATION.entering("storageChanged");
        CfgChangeEvent[] detailedEvents = event.getDetailedChangeEvents();
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Received detailed change events: {0}", new Object[]{Arrays.asList(detailedEvents)});
        }
        this.traceCache();
        CfgChangeEvent lastEvent = detailedEvents[detailedEvents.length - 1];
        String lastEventPath = lastEvent.getPath();
        int action = lastEvent.getAction();
        String pathToPolicy = CfgUtils.extractRelativePathToFirstSubNode(lastEventPath, this.getCfgPath());
        LOCATION.debugT("Last event path: " + lastEventPath + ", Event action: " + action + ", Path to policy: " + pathToPolicy);
        if (CfgUtils.isOneSubNode(lastEventPath, this.getCfgPath()) && action == 2) {
            LOCATION.debugT("Case DELETE");
            this.handleEventForDeletedPolicy(pathToPolicy);
        } else if (lastEventPath.endsWith("policy") && action == 1) {
            LOCATION.debugT("Case CREATE");
            this.handleEventForCreatedPolicy(pathToPolicy);
        } else {
            LOCATION.debugT("Case UPDATE");
            this.handleEventForUpdatedPolicy(pathToPolicy);
        }
        this.traceCache();
        LOCATION.exiting("storageChanged");
    }

    private synchronized void handleEventForCreatedPolicy(String cfgPath) {
        SAML2PolicyImpl policyImpl;
        String name;
        if (this.updateablePolicies.containsKey(cfgPath)) {
            return;
        }
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Received event for created policy with path: {0}", new Object[]{cfgPath});
        }
        if (CfgUtils.isEmpty(name = (policyImpl = new SAML2PolicyImpl(cfgPath)).getName())) {
            if (LOCATION.beWarning()) {
                LOCATION.warningT("Policy does not have a name. Could not be added to the policies list");
            }
        } else {
            this.addPolicyToCache(name, policyImpl.getCfgPath(), policyImpl);
        }
    }

    private void addPolicyToCache(String name, String cfgPath, SAML2PolicyImpl policy) {
        this.policiesByName.put(name, policy);
        this.updateablePolicies.put(cfgPath, policy);
        this.policyNamesByPath.put(cfgPath, name);
    }

    private synchronized void handleEventForDeletedPolicy(String cfgPath) {
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Received event for deleted policy with path: {0}", new Object[]{cfgPath});
        }
        this.removePolicyFromCacheByPath(cfgPath);
    }

    private void removePolicyFromCacheByPath(String cfgPath) {
        this.updateablePolicies.remove(cfgPath);
        String name = this.policyNamesByPath.remove(cfgPath);
        this.policiesByName.remove(name);
    }

    private synchronized void handleEventForUpdatedPolicy(String cfgPath) {
        SAML2UpdateableCfgObjectBase updateableObject = (SAML2UpdateableCfgObjectBase)((Object)this.updateablePolicies.get(cfgPath));
        if (updateableObject != null) {
            updateableObject.update();
        } else if (LOCATION.beDebug()) {
            LOCATION.debugT("There is no policy to update with path: {0}", new Object[]{cfgPath});
        }
    }

    protected synchronized void createdNewPolicy(SAML2PolicyImpl policy) {
        String name = policy.getName();
        if (CfgUtils.isEmpty(name)) {
            if (LOCATION.beWarning()) {
                LOCATION.warningT("Policy does not have a name. Could not be added to the policies list");
            }
        } else {
            this.addPolicyToCache(name, policy.getCfgPath(), policy);
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Created policy: {0}", new Object[]{policy});
            }
        }
    }

    void destroy() {
        try {
            this.unregisterAsStorageListener(this);
        }
        catch (CfgStorageException e) {
            LOCATION.traceThrowableT(500, "Could not unregister storage listener for policies with path: {0}", new Object[]{this.getCfgPath()}, (Throwable)e);
        }
    }
}

