/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg;

import com.sap.security.saml2.cfg.SAML2AnonymousSubCfgObjectBase;
import com.sap.security.saml2.cfg.SAML2CfgObject;
import com.sap.security.saml2.cfg.enums.ComparisonMethod;
import com.sap.security.saml2.cfg.interfaces.read.SAML2PolicyIdPCustomizedData;
import com.sap.security.saml2.cfg.interfaces.write.SAML2PolicyIdPCustomizedDataSetter;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import com.sap.tc.logging.Location;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class SAML2PolicyIdPCustomizedDataImpl
extends SAML2AnonymousSubCfgObjectBase
implements SAML2PolicyIdPCustomizedData,
SAML2PolicyIdPCustomizedDataSetter {
    private static final Location LOCATION = Location.getLocation(SAML2PolicyIdPCustomizedDataImpl.class);
    private static final String TOSTRING_PATTERN = "Customized Trusted IdP: \nIdP Name: {0},\nAuthnContexts: {1},\nRequested authentication context comparison method: {2},\nCfg path: {3}";
    private static final String KEY_IDP_NAME = "idp_name";
    private static final String KEY_AUTHN_CONTEXTS = "authn_contexts";
    private static final String KEY_REQUESTED_AUTHN_CONTEXT_COMPARISON_METHOD = "requested_comparison_method";
    private String idpName;
    private List<String> authnContexts;
    private ComparisonMethod comparisonMethod;

    public SAML2PolicyIdPCustomizedDataImpl() {
    }

    public SAML2PolicyIdPCustomizedDataImpl(SAML2CfgObject parent, String subPath, String propertySheet) {
        super(parent, subPath, propertySheet);
    }

    @Override
    public List<String> getAuthnContexts() {
        return this.authnContexts;
    }

    @Override
    public ComparisonMethod getRequestedAuthnContextComparisonMethod() {
        return this.comparisonMethod;
    }

    @Override
    public String getIdPName() {
        return this.idpName;
    }

    @Override
    public void setAuthnContexts(List<String> authnContexts) {
        this.authnContexts = authnContexts;
    }

    @Override
    public void setRequestedAuthnContextComparisonMethod(ComparisonMethod comparison) {
        this.comparisonMethod = comparison;
    }

    @Override
    public void setIdPName(String idpName) {
        this.idpName = idpName;
    }

    @Override
    protected void readConfiguration() {
        this.readConfiguration(false);
    }

    @Override
    protected void readConfiguration(boolean isWriteMode) {
        this.idpName = this.readProperty(KEY_IDP_NAME);
        String[] authnContextsArray = this.readArrayProperty(KEY_AUTHN_CONTEXTS);
        if (authnContextsArray != null) {
            this.authnContexts = new ArrayList<String>(authnContextsArray.length);
            String[] stringArray = authnContextsArray;
            int n = authnContextsArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (string != null) {
                    this.authnContexts.add(string);
                }
                ++n2;
            }
        }
        this.comparisonMethod = ComparisonMethod.getComparisonMethod(this.readProperty(KEY_REQUESTED_AUTHN_CONTEXT_COMPARISON_METHOD));
    }

    @Override
    protected void createAndWriteConfiguration(SAML2CfgObject parent, String subPath) throws CfgStorageException {
        super.createConfiguration(parent, subPath);
        this.setProperty(KEY_IDP_NAME, this.idpName);
        if (this.authnContexts != null && !this.authnContexts.isEmpty()) {
            String[] authnContextsArray = this.authnContexts.toArray(new String[this.authnContexts.size()]);
            this.setProperty(KEY_AUTHN_CONTEXTS, authnContextsArray);
        }
        this.setProperty(KEY_REQUESTED_AUTHN_CONTEXT_COMPARISON_METHOD, this.comparisonMethod == null ? null : this.comparisonMethod.getName());
        super.writeConfiguration();
    }

    @Override
    public String toString() {
        return MessageFormat.format(TOSTRING_PATTERN, this.idpName, this.authnContexts, this.comparisonMethod, super.toString());
    }
}

