/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg;

import com.sap.security.saml2.cfg.SAML2ModifiablePolicyImpl;
import com.sap.security.saml2.cfg.SAML2PolicyIdPCustomizedDataImpl;
import com.sap.security.saml2.cfg.SAML2UpdateableCfgObjectBase;
import com.sap.security.saml2.cfg.enums.SAML2PolicyType;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.interfaces.read.SAML2Policy;
import com.sap.security.saml2.cfg.interfaces.read.SAML2PolicyIdPCustomizedData;
import com.sap.security.saml2.cfg.interfaces.write.SAML2ModifiablePolicy;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import com.sap.security.saml2.cfg.util.CfgUtils;
import com.sap.tc.logging.Location;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class SAML2PolicyImpl
extends SAML2UpdateableCfgObjectBase
implements SAML2Policy {
    private static final String TOSTRING_PATTERN = "Policy Details: \nCfg Path: {0}, \nName: {1}, \nType: {2},\nAuthn Contexts HTTP: {3},\nAuthn Contexts HTTPS: {4},\nCustomized IdPs: {5}";
    private static final Location LOCATION = Location.getLocation(SAML2PolicyImpl.class);
    protected static final String KEY_POLICY_NAME = "policy_name";
    protected static final String KEY_TYPE = "type";
    protected static final String KEY_AUTHN_CONTEXTS_HTTP = "authn_contexts_http";
    protected static final String KEY_AUTHN_CONTEXTS_HTTPS = "authn_contexts_https";
    protected static final String CFG_SHEET_NAME = "policy";
    protected static final String CFG_SUB_PATH_TRUSTED_IDPS_CUSTOMIZED_DATA = "trusted_idps_customized_data";
    private Map<String, SAML2PolicyIdPCustomizedData> trustedIdPsCustomizedData;

    SAML2PolicyImpl(String cfgPath) {
        super(cfgPath, CFG_SHEET_NAME);
    }

    @Override
    protected synchronized void cleanCachedObjects() {
        this.trustedIdPsCustomizedData = null;
    }

    @Override
    public synchronized List<SAML2PolicyIdPCustomizedData> getAllIdPsCustomizedData() {
        if (this.trustedIdPsCustomizedData == null) {
            this.readTrustedIdPsCustomizedData();
        }
        ArrayList<SAML2PolicyIdPCustomizedData> result = new ArrayList<SAML2PolicyIdPCustomizedData>(this.trustedIdPsCustomizedData.values());
        return result;
    }

    @Override
    public synchronized List<String> getAuthnContextsForIdP(String idpName) {
        if (this.trustedIdPsCustomizedData == null) {
            this.readTrustedIdPsCustomizedData();
        }
        for (SAML2PolicyIdPCustomizedData trustedIdPAuthnContexts : this.trustedIdPsCustomizedData.values()) {
            if (!idpName.equals(trustedIdPAuthnContexts.getIdPName())) continue;
            return trustedIdPAuthnContexts.getAuthnContexts();
        }
        return null;
    }

    @Override
    public synchronized SAML2PolicyIdPCustomizedData getIdPCustomizedData(String idpName) {
        if (this.trustedIdPsCustomizedData == null) {
            this.readTrustedIdPsCustomizedData();
        }
        return this.trustedIdPsCustomizedData.get(idpName);
    }

    @Override
    public List<String> getAuthnContextsHTTP() {
        return this.readMultiValueProperty(KEY_AUTHN_CONTEXTS_HTTP);
    }

    @Override
    public List<String> getAuthnContextsHTTPS() {
        return this.readMultiValueProperty(KEY_AUTHN_CONTEXTS_HTTPS);
    }

    @Override
    public SAML2PolicyType getType() {
        String typeString = this.readProperty(KEY_TYPE);
        if (CfgUtils.isEmpty(typeString)) {
            return SAML2PolicyType.NONE;
        }
        return SAML2PolicyType.valueOf(typeString.toUpperCase(Locale.ENGLISH));
    }

    @Override
    public String getName() {
        return this.readProperty(KEY_POLICY_NAME);
    }

    private synchronized void readTrustedIdPsCustomizedData() {
        if (this.isStateDeleted()) {
            throw new IllegalStateException("Policy is already deleted. Configuration path: " + this.getCfgPath());
        }
        this.trustedIdPsCustomizedData = new HashMap<String, SAML2PolicyIdPCustomizedData>();
        String[] sheets = null;
        try {
            sheets = this.getSubCfgPropertySheetNames(CFG_SUB_PATH_TRUSTED_IDPS_CUSTOMIZED_DATA);
        }
        catch (CfgStorageException e) {
            LOCATION.traceThrowableT(500, "Could not load configuration for trusted idps authn contexts", (Throwable)e);
        }
        if (sheets != null) {
            String[] stringArray = sheets;
            int n = sheets.length;
            int n2 = 0;
            while (n2 < n) {
                String sheet = stringArray[n2];
                SAML2PolicyIdPCustomizedDataImpl trustedIdPCustomizedData = new SAML2PolicyIdPCustomizedDataImpl(this, CFG_SUB_PATH_TRUSTED_IDPS_CUSTOMIZED_DATA, sheet);
                String idpName = trustedIdPCustomizedData.getIdPName();
                if (!CfgUtils.isEmpty(idpName)) {
                    this.trustedIdPsCustomizedData.put(idpName, trustedIdPCustomizedData);
                } else {
                    LOCATION.warningT("Could not read IdP customized configuration which does not have IdP name. Policy name: {0}. IdP customized data: {1}", new Object[]{this.getName(), trustedIdPCustomizedData});
                }
                ++n2;
            }
        }
    }

    @Override
    public SAML2ModifiablePolicy getModifiablePolicy() throws SAML2ConfigurationException {
        return new SAML2ModifiablePolicyImpl(this);
    }

    @Override
    public String toString() {
        return MessageFormat.format(TOSTRING_PATTERN, new Object[]{super.toString(), this.getName(), this.getType(), this.getAuthnContextsHTTP(), this.getAuthnContextsHTTPS(), this.getAllIdPsCustomizedData()});
    }
}

