/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg;

import com.sap.security.saml2.cfg.SAML2CfgObject;
import com.sap.security.saml2.cfg.SAML2SubCfgObjectBase;
import com.sap.security.saml2.cfg.interfaces.read.SAML2RedirectApplicationConfiguration;
import com.sap.security.saml2.cfg.interfaces.write.SAML2RedirectApplicationConfigurationSetter;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import java.util.HashMap;
import java.util.Set;

public class SAML2RedirectApplicationConfigurationImpl
extends SAML2SubCfgObjectBase
implements SAML2RedirectApplicationConfiguration,
SAML2RedirectApplicationConfigurationSetter {
    public static final String DEFAULT_SITE = "default_site";
    public static final String DEFAULT_SITE_KEY = "default_site";
    public static final String REDIRECT_SITES_SUBTREE = "redirect_sites";
    private static final long serialVersionUID = 3193689705204259726L;
    protected HashMap<String, String> redirectURLs;
    protected SAML2DefaultRedirectSite defaultSiteCfg;

    public SAML2RedirectApplicationConfigurationImpl() {
        this.defaultSiteCfg = new SAML2DefaultRedirectSite();
        this.redirectURLs = new HashMap();
    }

    public SAML2RedirectApplicationConfigurationImpl(SAML2CfgObject parent) {
        super(parent, REDIRECT_SITES_SUBTREE);
        this.defaultSiteCfg = new SAML2DefaultRedirectSite(this);
    }

    private SAML2RedirectApplicationConfigurationImpl(HashMap<String, String> redirectURLs2) {
        this.redirectURLs = redirectURLs2;
        this.defaultSiteCfg = new SAML2DefaultRedirectSite();
    }

    @Override
    public String getDefaultRedirectSite() {
        return this.defaultSiteCfg.getDefaultSite();
    }

    @Override
    public Set<String> getRedirectSites() {
        return this.redirectURLs.keySet();
    }

    @Override
    public String getRedirectURL(String redirectSite) {
        return this.redirectURLs.get(redirectSite);
    }

    @Override
    public void setDefaultRedirectURL(String redirectUrl) {
        this.defaultSiteCfg.setDefaultSite(redirectUrl);
    }

    @Override
    public void setRedirectURL(String redirectSite, String redirectUrl) {
        this.redirectURLs.put(redirectSite, redirectUrl);
    }

    @Override
    protected void readConfiguration() {
        String[] keys;
        this.redirectURLs = new HashMap();
        String[] stringArray = keys = this.getCfgPropertySheetKeys();
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            this.redirectURLs.put(key, this.readProperty(key));
            ++n2;
        }
    }

    @Override
    public String toString() {
        return "Redirect URLS: " + this.redirectURLs.toString() + "\tDefault Site: " + this.getDefaultRedirectSite();
    }

    @Override
    protected void createAndWriteConfiguration(SAML2CfgObject parent) throws CfgStorageException {
        super.createConfiguration(parent, REDIRECT_SITES_SUBTREE);
        for (String key : this.redirectURLs.keySet()) {
            String value = this.redirectURLs.get(key);
            this.setProperty(key, value);
        }
        super.writeConfiguration();
        this.defaultSiteCfg.createAndWriteConfiguration(this);
    }

    @Override
    public SAML2RedirectApplicationConfigurationSetter getModifiableSAML2RedirectApplicationConfiguration() {
        SAML2RedirectApplicationConfigurationImpl ret = new SAML2RedirectApplicationConfigurationImpl(this.redirectURLs);
        ret.setDefaultRedirectURL(this.getDefaultRedirectSite());
        return ret;
    }

    protected class SAML2DefaultRedirectSite
    extends SAML2SubCfgObjectBase {
        private static final long serialVersionUID = -2750135162210664152L;
        private String defaultSite;

        protected SAML2DefaultRedirectSite() {
        }

        protected SAML2DefaultRedirectSite(SAML2CfgObject parent) {
            super(parent, "default_site");
        }

        @Override
        protected void createAndWriteConfiguration(SAML2CfgObject parent) throws CfgStorageException {
            super.createConfiguration(parent, "default_site");
            this.setProperty("default_site", this.defaultSite);
            super.writeConfiguration();
        }

        @Override
        protected void readConfiguration() {
            this.defaultSite = this.readProperty("default_site");
        }

        protected void setDefaultSite(String defaultSite) {
            this.defaultSite = defaultSite;
        }

        protected String getDefaultSite() {
            return this.defaultSite;
        }
    }
}

