/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg;

import com.sap.security.saml2.cfg.SAML2CfgFactory;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.interfaces.SAML2Config;
import com.sap.security.saml2.cfg.interfaces.SAML2SPConfiguration;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalSP;
import com.sap.security.saml2.cfg.interfaces.read.SAML2TrustedIdP;

public class SAML2SPConfigurationImpl
implements SAML2SPConfiguration {
    private SAML2Config saml2Config;

    @Deprecated
    public SAML2SPConfigurationImpl() throws SAML2ConfigurationException {
        this.saml2Config = SAML2CfgFactory.getSAML2GlobalConfig().getDefaultSAML2Configuration();
    }

    public SAML2SPConfigurationImpl(String saml2ConfigName) throws SAML2ConfigurationException {
        this.saml2Config = SAML2CfgFactory.getSAML2GlobalConfig().getSAML2Configuration(saml2ConfigName);
        if (this.saml2Config == null) {
            throw new SAML2ConfigurationException("Service Provider could not load local service provider configuration.");
        }
        boolean isSPEnabled = this.saml2Config.getLocalProvidersConfiguration().isServiceProviderEnabled();
        if (!isSPEnabled) {
            throw new SAML2ConfigurationException("Local Service Provider is disabled.");
        }
    }

    @Override
    public SAML2LocalSP getLocalSP() {
        return this.saml2Config.getLocalProvidersConfiguration().getLocalSP();
    }

    @Override
    public SAML2TrustedIdP getTrustedIdP(String name) {
        return this.saml2Config.getTrustedIdPsConfiguration().getTrustedIdP(name);
    }

    @Override
    public SAML2TrustedIdP getTrustedIdP(byte[] id) {
        return this.saml2Config.getTrustedIdPsConfiguration().getTrustedIdPByID(id);
    }
}

