/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg;

import com.sap.tc.logging.Location;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public class SAML2StaticConfiguration {
    private static final List<String> DEFAULT_SAML2_DOMAINS = Arrays.asList("sap.com/saml2_cfg", "sap.com/saml2_commons", "sap.com/saml2_sp", "sap.com/saml2_idp");
    private static final String CONFIGURATION_FILE = "staticconfiguration/cfg.properties";
    private static final String PROPERTY_KEY_SAML2_DOMAINS = "saml2.domains";
    private static final Location LOCATION = Location.getLocation(SAML2StaticConfiguration.class);
    private static final SAML2StaticConfiguration INSTANCE = new SAML2StaticConfiguration();
    private List<String> saml2Domains = new ArrayList<String>();

    private SAML2StaticConfiguration() {
        try {
            InputStream in = this.getClass().getClassLoader().getResourceAsStream(CONFIGURATION_FILE);
            if (in == null) {
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("Could not find SAML2 static configuration file: {0}. Will be used the default settings", new Object[]{CONFIGURATION_FILE});
                }
                this.saml2Domains.addAll(DEFAULT_SAML2_DOMAINS);
            } else {
                Properties properties = new Properties();
                properties.load(in);
                ArrayList<String> domains = new ArrayList<String>();
                String saml2DomainPropertyValue = properties.getProperty(PROPERTY_KEY_SAML2_DOMAINS);
                if (saml2DomainPropertyValue != null && saml2DomainPropertyValue.length() > 0) {
                    StringTokenizer tokenizer = new StringTokenizer(saml2DomainPropertyValue, ",");
                    while (tokenizer.hasMoreElements()) {
                        String elem = ((String)tokenizer.nextElement()).trim();
                        if (elem.length() <= 0) continue;
                        domains.add(elem);
                    }
                }
                if (!domains.isEmpty()) {
                    this.saml2Domains.addAll(domains);
                } else {
                    if (LOCATION.beDebug()) {
                        LOCATION.debugT("There are not any saml2 domains configured as comma separated list in the configuration file: {0}. Will be used the default ones", new Object[]{CONFIGURATION_FILE});
                    }
                    this.saml2Domains.addAll(DEFAULT_SAML2_DOMAINS);
                }
            }
        }
        catch (Exception e) {
            if (LOCATION.beWarning()) {
                LOCATION.traceThrowableT(400, "Could not obtain the SAML2 static configuration from file: {0}. Will be used the default settings", new Object[]{CONFIGURATION_FILE}, (Throwable)e);
            }
            this.saml2Domains.addAll(DEFAULT_SAML2_DOMAINS);
        }
    }

    public static final SAML2StaticConfiguration getInstance() {
        return INSTANCE;
    }

    public List<String> getSAML2Domains() {
        return this.saml2Domains;
    }
}

