/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg;

import com.sap.security.saml2.cfg.SAML2CfgObject;
import com.sap.security.saml2.cfg.storage.CfgPropertySetter;
import com.sap.security.saml2.cfg.storage.CfgStorageException;

public abstract class SAML2SubCfgObjectBase
extends SAML2CfgObject {
    private static final String CFG_PROPERTY_SHEET = "cfg";
    private static final byte STATE_READING = 2;
    private static final byte STATE_WRITING = 4;
    private static final byte STATE_WRITTEN = 8;
    private byte state;
    private CfgPropertySetter propertySetter;

    public SAML2SubCfgObjectBase() {
        this.state = (byte)4;
    }

    public SAML2SubCfgObjectBase(SAML2CfgObject parent, String subPath) {
        super(String.valueOf(parent.getCfgPath()) + "/" + subPath, CFG_PROPERTY_SHEET, true);
        this.state = (byte)2;
        this.readConfiguration();
    }

    protected String readProperty(String key) {
        return this.readProperty(key, null);
    }

    protected String readProperty(String key, String defaultValue) {
        return this.getPropertyValue(key, defaultValue).getValue();
    }

    protected String[] readArrayProperty(String key) {
        return this.getPropertyValue(key, null).getValues();
    }

    protected void setProperty(String key, String value) {
        this.propertySetter.setProperty(key, value);
    }

    protected void setProperty(String key, String[] values) {
        this.propertySetter.setProperty(key, values);
    }

    protected void setProperty(String key, boolean value) {
        this.propertySetter.setProperty(key, "" + value);
    }

    protected void setProperty(String key, int value) {
        this.propertySetter.setProperty(key, "" + value);
    }

    protected abstract void readConfiguration();

    protected abstract void createAndWriteConfiguration(SAML2CfgObject var1) throws CfgStorageException;

    protected void createConfiguration(SAML2CfgObject parent, String subPath) throws CfgStorageException {
        if (this.state != 4) {
            throw new IllegalStateException("This anonymous sub configuration is intended only for reading");
        }
        this.setCfgPath(String.valueOf(parent.getCfgPath()) + "/" + subPath);
        this.setCfgPropertySheet(CFG_PROPERTY_SHEET);
        this.propertySetter = this.getPropertySetter();
    }

    protected void writeConfiguration() throws CfgStorageException {
        if (this.state == 2) {
            throw new IllegalStateException("This anonymous sub configuration is intended only for reading");
        }
        if (this.state == 8) {
            throw new IllegalStateException("This anonymous sub configuration is already written");
        }
        super.write(this.propertySetter);
        this.state = (byte)8;
    }
}

