/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg;

import com.sap.security.saml2.cfg.SAML2EndpointImpl;
import com.sap.security.saml2.cfg.SAML2ExtensionSupplierDescriptorImpl;
import com.sap.security.saml2.cfg.SAML2KeystoreWrapper;
import com.sap.security.saml2.cfg.SAML2LocalProviderImpl;
import com.sap.security.saml2.cfg.SAML2ModifiableTrustedIdPImpl;
import com.sap.security.saml2.cfg.SAML2UpdateableProviderBase;
import com.sap.security.saml2.cfg.enums.ComparisonMethod;
import com.sap.security.saml2.cfg.enums.DigestAlgorithm;
import com.sap.security.saml2.cfg.enums.EncryptionAlgorithm;
import com.sap.security.saml2.cfg.enums.EncryptionOption;
import com.sap.security.saml2.cfg.enums.ResponseRequirementType;
import com.sap.security.saml2.cfg.enums.SAML2Binding;
import com.sap.security.saml2.cfg.enums.SAML2NameIdFormat;
import com.sap.security.saml2.cfg.enums.SAML2Service;
import com.sap.security.saml2.cfg.enums.SignatureOption;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.interfaces.read.SAML2CfgUMEAttribute;
import com.sap.security.saml2.cfg.interfaces.read.SAML2Endpoint;
import com.sap.security.saml2.cfg.interfaces.read.SAML2ExtensionSupplierDescriptor;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalProvider;
import com.sap.security.saml2.cfg.interfaces.read.SAML2TrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2IdentityFederationTrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatEmailTrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatKerberosTrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatPersistentTrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatTransientTrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatUnspecifiedTrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatWindowsTrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatX509TrustedIdP;
import com.sap.security.saml2.cfg.interfaces.write.SAML2ModifiableTrustedIdP;
import com.sap.security.saml2.cfg.nameidformat.SAML2IdentityFederationTrustedIdPImpl;
import com.sap.security.saml2.cfg.nameidformat.SAML2IdentityFederationTrustedIdPOldDataImpl;
import com.sap.security.saml2.cfg.nameidformat.SAML2NameIdFormatCfgObjectBaseTrustedIdP;
import com.sap.security.saml2.cfg.nameidformat.SAML2NameIdFormatEmailTrustedIdPImpl;
import com.sap.security.saml2.cfg.nameidformat.SAML2NameIdFormatKerberosTrustedIdPImpl;
import com.sap.security.saml2.cfg.nameidformat.SAML2NameIdFormatPersistentTrustedIdPImpl;
import com.sap.security.saml2.cfg.nameidformat.SAML2NameIdFormatTransientTrustedIdPImpl;
import com.sap.security.saml2.cfg.nameidformat.SAML2NameIdFormatUnspecifiedTrustedIdPImpl;
import com.sap.security.saml2.cfg.nameidformat.SAML2NameIdFormatWindowsTrustedIdPImpl;
import com.sap.security.saml2.cfg.nameidformat.SAML2NameIdFormatX509TrustedIdPImpl;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import com.sap.security.saml2.cfg.util.CfgConstants;
import com.sap.security.saml2.lib.common.SAML2Utils;
import com.sap.tc.logging.Location;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SAML2TrustedIdPImpl
extends SAML2UpdateableProviderBase
implements SAML2TrustedIdP {
    private static final long serialVersionUID = 1L;
    private static final Location LOCATION = Location.getLocation(SAML2TrustedIdPImpl.class);
    private SAML2LocalProvider localProvider;
    private List<SAML2Endpoint> endpointsALL;
    private List<SAML2Endpoint> endpointsARS;
    private List<SAML2Endpoint> endpointsSSO;
    private List<SAML2Endpoint> endpointsSLO;
    private List<SAML2Endpoint> endpointsMNI;
    private List<SAML2ExtensionSupplierDescriptor> extensionSupplierDescriptors = null;
    private SAML2NameIdFormatEmailTrustedIdPImpl nameIdFormatEmailTrustedIdP;
    private SAML2NameIdFormatUnspecifiedTrustedIdPImpl nameIdFormatUnspecifiedTrustedIdP;
    private SAML2NameIdFormatTransientTrustedIdPImpl nameIdFormatTransientTrustedIdP;
    private SAML2NameIdFormatPersistentTrustedIdPImpl nameIdFormatPersistentTrustedIdP;
    private SAML2NameIdFormatKerberosTrustedIdPImpl nameIdFormatKerberosTrustedIdP;
    private SAML2NameIdFormatX509TrustedIdPImpl nameIdFormatX509TrustedIdP;
    private SAML2NameIdFormatWindowsTrustedIdPImpl nameIdFormatWindowsTrustedIdP;
    private Map<String, SAML2IdentityFederationTrustedIdP> identityFederations;
    protected static final String KEY_ENABLED = "enabled";
    protected static final String KEY_DESCRIPTION = "description";
    protected static final String KEY_ENCRYPTION_ALGORITHM = "enc_algorithm";
    protected static final String KEY_SIGNING_CERTIFICATE = "signing_cert";
    protected static final String KEY_SECONDARY_SIGNING_CERTIFICATE = "secondary_signing_cert";
    protected static final String KEY_ENCRYPTION_CERTIFICATE = "enc_cert";
    protected static final String KEY_SIGN_AUTHN_REQUESTS = "sign_authn_requests";
    protected static final String KEY_SIGN_ARS_MESSAGES = "sign_ars_messages";
    protected static final String KEY_SIGN_SLO_MESSAGES = "sign_slo_messages";
    protected static final String KEY_SIGN_MNI_MESSAGES = "sign_mni_messages";
    protected static final String KEY_REQUIRE_SIGNED_ASSERTIONS = "require_signed_assertions";
    protected static final String KEY_REQUIRE_SIGNED_AUTHN_RESPONSES = "require_signed_authn_responses";
    protected static final String KEY_REQUIRE_SIGNED_ARS_MESSAGES = "require_signed_ars_messages";
    protected static final String KEY_REQUIRE_SIGNED_SLO_MESSAGES = "require_signed_slo_messages";
    protected static final String KEY_REQUIRE_SIGNED_MNI_MESSAGES = "require_signed_mni_messages";
    protected static final String KEY_ENCRYPT_SLO_SUBJECT = "encrypt_slo_subject";
    protected static final String KEY_ENCRYPT_MNI_SUBJECT = "encrypt_mni_subject";
    protected static final String KEY_ENCRYPT_MNI_NEW_ID = "encrypt_mni_new_id";
    protected static final String KEY_REQUIRE_ENCRYPTED_SLO_SUBJECT = "require_encrypted_slo_subject";
    protected static final String KEY_REQUIRE_ENCRYPTED_MNI_SUBJECT = "require_encrypted_mni_subject";
    protected static final String KEY_REQUIRE_ENCRYPTED_MNI_NEW_ID = "require_encrypted_mni_new_id";
    protected static final String KEY_REQUIRED_ENCRYPTED_AUTHN_RESPONSE_ELEMENTS = "required_encrypted_authn_response_elements";
    protected static final String KEY_RESPONSE_REQUIREMENT_ACS_INDEX = "response_requirement_acs_index";
    protected static final String KEY_RESPONSE_REQUIREMENT_ACS_TYPE = "response_requirement_acs_type";
    protected static final String KEY_RESPONSE_REQUIREMENT_ACS_URL = "response_requirement_acs_url";
    protected static final String KEY_RESPONSE_REQUIREMENT_BINDING = "response_requirement_binding";
    protected static final String KEY_AUTHENTICATION_CONTEXTS = "authn_contexts";
    protected static final String KEY_REQUESTED_AUTHN_CONTEXT_COMPARISON_METHOD = "requested_comparison_method";
    protected static final String KEY_DEFAULT_NAME_ID_FORMAT = "default_name_id_format";
    protected static final String CFG_SHEET_NAME = "trusted_idp";
    protected static final String CFG_SUB_PATH_ENDPOINTS = "endpoints";
    protected static final String CFG_SUB_PATH_EXT_SUPPLIERS = "ext_suppliers";
    protected static final String KEY_SIGNATURE_ALGORITHM = "sig_algorithm";

    public SAML2TrustedIdPImpl(String cfgPath, SAML2LocalProvider localProvider) {
        super(cfgPath, CFG_SHEET_NAME);
        this.localProvider = localProvider;
    }

    @Override
    protected synchronized void cleanCachedObjects() {
        this.endpointsALL = null;
        this.endpointsARS = null;
        this.endpointsSSO = null;
        this.endpointsSLO = null;
        this.endpointsMNI = null;
        this.nameIdFormatEmailTrustedIdP = null;
        this.nameIdFormatUnspecifiedTrustedIdP = null;
        this.nameIdFormatTransientTrustedIdP = null;
        this.nameIdFormatPersistentTrustedIdP = null;
        this.nameIdFormatKerberosTrustedIdP = null;
        this.nameIdFormatX509TrustedIdP = null;
        this.nameIdFormatWindowsTrustedIdP = null;
        this.extensionSupplierDescriptors = null;
        this.identityFederations = null;
    }

    public SAML2CfgUMEAttribute getUMEAttribute(String name, String namespace) {
        return ((SAML2LocalProviderImpl)this.localProvider).getUMEAttribute(name, namespace);
    }

    @Override
    public List<String> getAuthenticationContextNames() {
        return this.readAuthnContextNames();
    }

    @Override
    public ComparisonMethod getRequestedAuthnContextComparisonMethod() {
        return ComparisonMethod.getComparisonMethod(this.readProperty(KEY_REQUESTED_AUTHN_CONTEXT_COMPARISON_METHOD));
    }

    @Override
    public SAML2NameIdFormat getRequestedNameIdPolicyFormat() {
        return this.getDefaultNameIdFormat();
    }

    @Override
    public String getRequestedNameIdPolicySPNameQualifier() {
        return null;
    }

    @Override
    public Boolean getRequestedNameIdPolicyAllowCreate() {
        return null;
    }

    @Override
    public SAML2Endpoint getDefaultSingleSignOnEndpoint() {
        SAML2Endpoint result = null;
        Collection<SAML2Endpoint> ssoEndpoints = this.readSSOEndpoints();
        if (ssoEndpoints != null) {
            for (SAML2Endpoint endpoint : ssoEndpoints) {
                if (!endpoint.isDefault()) continue;
                result = endpoint;
                break;
            }
        }
        return result;
    }

    @Override
    public SAML2NameIdFormat getDefaultNameIdFormat() {
        String dbNameIdFormat = this.readProperty(KEY_DEFAULT_NAME_ID_FORMAT);
        SAML2NameIdFormat nameIdFormat = SAML2NameIdFormat.getNameIdFormatByName(dbNameIdFormat);
        return nameIdFormat;
    }

    @Override
    public String getDescription() {
        return this.readProperty(KEY_DESCRIPTION);
    }

    @Override
    public SAML2IdentityFederationTrustedIdP getIdentityFederation(String nameIdFormat) {
        return this.getIdentityFederations().get(nameIdFormat);
    }

    @Override
    public Map<String, SAML2IdentityFederationTrustedIdP> getAllIdentityFederations() {
        return this.getIdentityFederations();
    }

    @Override
    public synchronized SAML2NameIdFormatEmailTrustedIdP getNameIdFormatEmail() {
        if (this.getIdentityFederation(SAML2NameIdFormat.E_MAIL.getName()) instanceof SAML2IdentityFederationTrustedIdPImpl) {
            throw new IllegalStateException("Configuration of the identity federation for nameid format: " + SAML2NameIdFormat.E_MAIL + " is already written using the new identity federation format. It must be obtained using getIdentityFederation(String nameIdFormat) method.");
        }
        if (this.nameIdFormatEmailTrustedIdP == null) {
            this.nameIdFormatEmailTrustedIdP = new SAML2NameIdFormatEmailTrustedIdPImpl(this);
        }
        return this.nameIdFormatEmailTrustedIdP;
    }

    @Override
    public synchronized SAML2NameIdFormatKerberosTrustedIdP getNameIdFormatKerberos() {
        if (this.getIdentityFederation(SAML2NameIdFormat.KERBEROS.getName()) instanceof SAML2IdentityFederationTrustedIdPImpl) {
            throw new IllegalStateException("Configuration of the identity federation for nameid format: " + SAML2NameIdFormat.KERBEROS + " is already written using the new identity federation format. It must be obtained using getIdentityFederation(String nameIdFormat) method.");
        }
        if (this.nameIdFormatKerberosTrustedIdP == null) {
            this.nameIdFormatKerberosTrustedIdP = new SAML2NameIdFormatKerberosTrustedIdPImpl(this);
        }
        return this.nameIdFormatKerberosTrustedIdP;
    }

    @Override
    public synchronized SAML2NameIdFormatPersistentTrustedIdP getNameIdFormatPersistent() {
        if (this.getIdentityFederation(SAML2NameIdFormat.PERSISTENT.getName()) instanceof SAML2IdentityFederationTrustedIdPImpl) {
            throw new IllegalStateException("Configuration of the identity federation for nameid format: " + SAML2NameIdFormat.PERSISTENT + " is already written using the new identity federation format. It must be obtained using getIdentityFederation(String nameIdFormat) method.");
        }
        if (this.nameIdFormatPersistentTrustedIdP == null) {
            this.nameIdFormatPersistentTrustedIdP = new SAML2NameIdFormatPersistentTrustedIdPImpl(this);
        }
        return this.nameIdFormatPersistentTrustedIdP;
    }

    @Override
    public synchronized SAML2NameIdFormatTransientTrustedIdP getNameIdFormatTransient() {
        if (this.getIdentityFederation(SAML2NameIdFormat.TRANSIENT.getName()) instanceof SAML2IdentityFederationTrustedIdPImpl) {
            throw new IllegalStateException("Configuration of the identity federation for nameid format: " + SAML2NameIdFormat.TRANSIENT + " is already written using the new identity federation format. It must be obtained using getIdentityFederation(String nameIdFormat) method.");
        }
        if (this.nameIdFormatTransientTrustedIdP == null) {
            this.nameIdFormatTransientTrustedIdP = new SAML2NameIdFormatTransientTrustedIdPImpl(this);
        }
        return this.nameIdFormatTransientTrustedIdP;
    }

    @Override
    public synchronized SAML2NameIdFormatUnspecifiedTrustedIdP getNameIdFormatUnspecified() {
        if (this.getIdentityFederation(SAML2NameIdFormat.UNSPECIFIED.getName()) instanceof SAML2IdentityFederationTrustedIdPImpl) {
            throw new IllegalStateException("Configuration of the identity federation for nameid format: " + SAML2NameIdFormat.UNSPECIFIED + " is already written using the new identity federation format. It must be obtained using getIdentityFederation(String nameIdFormat) method.");
        }
        if (this.nameIdFormatUnspecifiedTrustedIdP == null) {
            this.nameIdFormatUnspecifiedTrustedIdP = new SAML2NameIdFormatUnspecifiedTrustedIdPImpl(this);
        }
        return this.nameIdFormatUnspecifiedTrustedIdP;
    }

    @Override
    public synchronized SAML2NameIdFormatWindowsTrustedIdP getNameIdFormatWindows() {
        if (this.getIdentityFederation(SAML2NameIdFormat.WINDOWS_DOMAIN_QUALIFIED_NAME.getName()) instanceof SAML2IdentityFederationTrustedIdPImpl) {
            throw new IllegalStateException("Configuration of the identity federation for nameid format: " + SAML2NameIdFormat.WINDOWS_DOMAIN_QUALIFIED_NAME + " is already written using the new identity federation format. It must be obtained using getIdentityFederation(String nameIdFormat) method.");
        }
        if (this.nameIdFormatWindowsTrustedIdP == null) {
            this.nameIdFormatWindowsTrustedIdP = new SAML2NameIdFormatWindowsTrustedIdPImpl(this);
        }
        return this.nameIdFormatWindowsTrustedIdP;
    }

    @Override
    public synchronized SAML2NameIdFormatX509TrustedIdP getNameIdFormatX509() {
        if (this.getIdentityFederation(SAML2NameIdFormat.X509_SUBJECT_NAME.getName()) instanceof SAML2IdentityFederationTrustedIdPImpl) {
            throw new IllegalStateException("Configuration of the identity federation for nameid format: " + SAML2NameIdFormat.X509_SUBJECT_NAME + " is already written using the new identity federation format. It must be obtained using getIdentityFederation(String nameIdFormat) method.");
        }
        if (this.nameIdFormatX509TrustedIdP == null) {
            this.nameIdFormatX509TrustedIdP = new SAML2NameIdFormatX509TrustedIdPImpl(this);
        }
        return this.nameIdFormatX509TrustedIdP;
    }

    @Override
    public EncryptionOption getRequiredEncryptedAuthnResponseElements() {
        return this.readEncryptionOption(KEY_REQUIRED_ENCRYPTED_AUTHN_RESPONSE_ELEMENTS, CfgConstants.DEFAULT_AUTHN_RESPONSE_ENCRYPT_ELEMENTS);
    }

    @Override
    public ResponseRequirementType getResponseRequirementType() {
        return this.readResponseRequirementType(KEY_RESPONSE_REQUIREMENT_ACS_TYPE, CfgConstants.DEFAULT_RESPONSE_REQUIREMENT_VALUE);
    }

    @Override
    public int getResponseRequirementAssertionConsumerIndex() {
        return this.readIntProperty(KEY_RESPONSE_REQUIREMENT_ACS_INDEX, -1);
    }

    @Override
    public String getResponseRequirementAssertionConsumerURL() {
        return this.readProperty(KEY_RESPONSE_REQUIREMENT_ACS_URL);
    }

    @Override
    public SAML2Binding getResponseRequirementBinding() {
        String bindingName = this.readProperty(KEY_RESPONSE_REQUIREMENT_BINDING);
        SAML2Binding result = SAML2Binding.getBinding(bindingName);
        return result;
    }

    @Override
    public Collection<SAML2Endpoint> getSSOEndpoints() {
        return this.readSSOEndpoints();
    }

    @Override
    public List<SAML2Endpoint> getSingleSignOnEndpoints(SAML2Binding binding) {
        ArrayList<SAML2Endpoint> result = new ArrayList<SAML2Endpoint>();
        Collection<SAML2Endpoint> ssoEndpoints = this.readSSOEndpoints();
        if (ssoEndpoints != null) {
            for (SAML2Endpoint endpoint : ssoEndpoints) {
                if (endpoint.getBinding() != binding) continue;
                result.add(endpoint);
            }
        }
        return result;
    }

    @Override
    public SignatureOption isToRequireSignedAssertions() {
        return this.readSignatureOption(KEY_REQUIRE_SIGNED_ASSERTIONS, CfgConstants.DEFAULT_SIGN_OR_REQUIRE_ASSERTIONS);
    }

    @Override
    public SignatureOption isToRequireSignedAuthnResponses() {
        return this.readSignatureOption(KEY_REQUIRE_SIGNED_AUTHN_RESPONSES, CfgConstants.DEFAULT_SIGN_OR_REQUIRE_AUTHN_RESPONSES);
    }

    @Override
    public SignatureOption isToSignAuthnRequests() {
        return this.readSignatureOption(KEY_SIGN_AUTHN_REQUESTS, CfgConstants.DEFAULT_SIGN_OR_REQUIRE_AUTHN_REQUESTS);
    }

    @Override
    public Collection<SAML2Endpoint> getARSEndpoints() {
        return this.readARSEndpoints();
    }

    @Override
    public Collection<SAML2Endpoint> getMNIEndpoints() {
        return this.readMNIEndpoints();
    }

    @Override
    public Collection<SAML2Endpoint> getAllEndpoints() {
        return this.readAllEndpoints();
    }

    @Override
    public SAML2Endpoint getArtifactResolutionEndpoint(int index) {
        SAML2Endpoint result = null;
        Collection<SAML2Endpoint> arsEndpoints = this.readARSEndpoints();
        if (arsEndpoints != null) {
            for (SAML2Endpoint endpoint : arsEndpoints) {
                if (endpoint.getIndex() != index) continue;
                result = endpoint;
                break;
            }
        }
        return result;
    }

    @Override
    public synchronized List<SAML2ExtensionSupplierDescriptor> getExtensionSupplierDescriptors() {
        if (this.extensionSupplierDescriptors == null) {
            this.extensionSupplierDescriptors = this.readExtensionSupplierDescriptors();
        }
        return this.extensionSupplierDescriptors;
    }

    @Override
    public Certificate getCertificateForSignature() throws SAML2ConfigurationException {
        String viewName = this.localProvider.getKeyStoreViewName();
        String entryName = this.getSigningCertificateName();
        try {
            return SAML2KeystoreWrapper.getInstance().getCertificate(viewName, entryName);
        }
        catch (Exception e) {
            throw new SAML2ConfigurationException("Could not obtain the primary certificate for signature verification with name: " + entryName + " from view: " + viewName, e);
        }
    }

    @Override
    public Certificate getSecondaryCertificateForSignature() throws SAML2ConfigurationException {
        String viewName = this.localProvider.getKeyStoreViewName();
        String entryName = this.getSecondarySigningCertificateName();
        try {
            return SAML2KeystoreWrapper.getInstance().getCertificate(viewName, entryName);
        }
        catch (Exception e) {
            throw new SAML2ConfigurationException("Could not obtain the secondary certificate for signature verification with name: " + entryName + " from view: " + viewName, e);
        }
    }

    @Override
    public SAML2Endpoint getDefaultSingleLogoutEndpoint() {
        SAML2Endpoint result = null;
        Collection<SAML2Endpoint> sloEndpoints = this.readSLOEndpoints();
        if (sloEndpoints != null) {
            for (SAML2Endpoint endpoint : sloEndpoints) {
                if (!endpoint.isDefault()) continue;
                result = endpoint;
                break;
            }
        }
        return result;
    }

    @Override
    public SAML2Endpoint getDefaultManageNameIDEndpoint() {
        for (SAML2Endpoint endpoint : this.readMNIEndpoints()) {
            if (!endpoint.isDefault()) continue;
            return endpoint;
        }
        return null;
    }

    @Override
    public EncryptionAlgorithm getEncryptionAlgorithm() {
        EncryptionAlgorithm result = CfgConstants.DEFAULT_ENCRYPTION_ALGORITHM;
        String encAlgorithmURI = this.readProperty(KEY_ENCRYPTION_ALGORITHM);
        if (encAlgorithmURI != null && encAlgorithmURI.length() > 0) {
            EncryptionAlgorithm encAlgorithm = EncryptionAlgorithm.getEncryptionAlgorithm(encAlgorithmURI);
            if (encAlgorithm != null) {
                result = encAlgorithm;
            } else if (LOCATION.beDebug()) {
                LOCATION.debugT("Configured value: {0} for encryption algorithm is not valid EncryptionAlgorithm uri. Will be used the default one: {1}", new Object[]{encAlgorithmURI, CfgConstants.DEFAULT_ENCRYPTION_ALGORITHM});
            }
        } else if (LOCATION.beDebug()) {
            LOCATION.debugT("There is no configured value for encryption algorithm. Will be used the default one: {0}", new Object[]{CfgConstants.DEFAULT_ENCRYPTION_ALGORITHM});
        }
        return result;
    }

    @Override
    public DigestAlgorithm getDigestAlgorithm() {
        DigestAlgorithm result = CfgConstants.DEFAULT_DIGEST;
        String digestAlgorithmURI = this.readProperty(KEY_SIGNATURE_ALGORITHM);
        if (digestAlgorithmURI != null && digestAlgorithmURI.length() > 0) {
            DigestAlgorithm sigAlgorithm = DigestAlgorithm.getDigestAlgorithm(digestAlgorithmURI);
            if (sigAlgorithm != null) {
                result = sigAlgorithm;
            } else if (LOCATION.beDebug()) {
                LOCATION.debugT("Configured value: {0} for digest algorithm is not valid DigestAlgorithm uri. Will be used the default one: {1}", new Object[]{digestAlgorithmURI, CfgConstants.DEFAULT_DIGEST});
            }
        } else if (LOCATION.beDebug()) {
            LOCATION.debugT("There is no configured value for digest algorithm. Will be used the default one: {0}", new Object[]{CfgConstants.DEFAULT_DIGEST});
        }
        return result;
    }

    @Override
    public String getEncryptionCertificateName() {
        return this.readProperty(KEY_ENCRYPTION_CERTIFICATE);
    }

    @Override
    public PublicKey getPublicKeyForEncryption() throws SAML2ConfigurationException {
        Certificate cert = this.getCertificateForEncryption();
        if (cert != null) {
            return cert.getPublicKey();
        }
        return null;
    }

    @Override
    public Certificate getCertificateForEncryption() throws SAML2ConfigurationException {
        String viewName = this.localProvider.getKeyStoreViewName();
        String entryName = this.getEncryptionCertificateName();
        try {
            Certificate cert = SAML2KeystoreWrapper.getInstance().getCertificate(viewName, entryName);
            return cert;
        }
        catch (Exception e) {
            throw new SAML2ConfigurationException("Could not obtain certificate for encryption with name: " + entryName + " from view: " + viewName, e);
        }
    }

    @Override
    public Collection<SAML2Endpoint> getSLOEndpoints() {
        return this.readSLOEndpoints();
    }

    @Override
    public String getSigningCertificateName() {
        return this.readProperty(KEY_SIGNING_CERTIFICATE);
    }

    @Override
    public String getSecondarySigningCertificateName() {
        return this.readProperty(KEY_SECONDARY_SIGNING_CERTIFICATE);
    }

    @Override
    public List<SAML2Endpoint> getSingleLogoutEndpoints(SAML2Binding binding) {
        ArrayList<SAML2Endpoint> result = new ArrayList<SAML2Endpoint>();
        Collection<SAML2Endpoint> sloEndpoints = this.readSLOEndpoints();
        if (sloEndpoints != null) {
            for (SAML2Endpoint endpoint : sloEndpoints) {
                if (endpoint.getBinding() != binding) continue;
                result.add(endpoint);
            }
        }
        return result;
    }

    @Override
    public List<SAML2Endpoint> getManageNameIDEndpoints(SAML2Binding binding) {
        ArrayList<SAML2Endpoint> result = new ArrayList<SAML2Endpoint>();
        for (SAML2Endpoint endpoint : this.readMNIEndpoints()) {
            if (endpoint.getBinding() != binding) continue;
            result.add(endpoint);
        }
        return result;
    }

    @Override
    public boolean isEnabled() {
        return Boolean.parseBoolean(this.readProperty(KEY_ENABLED, "false"));
    }

    @Override
    public boolean isToEncryptSingleLogoutSubject() {
        return Boolean.parseBoolean(this.readProperty(KEY_ENCRYPT_SLO_SUBJECT, "false"));
    }

    @Override
    public boolean isToEncryptManageNameIDSubject() {
        return Boolean.parseBoolean(this.readProperty(KEY_ENCRYPT_MNI_SUBJECT, "false"));
    }

    @Override
    public boolean isToEncryptManageNameIDNewID() {
        return Boolean.parseBoolean(this.readProperty(KEY_ENCRYPT_MNI_NEW_ID, "false"));
    }

    @Override
    public boolean isToRequireEncryptedSingleLogoutSubject() {
        return Boolean.parseBoolean(this.readProperty(KEY_REQUIRE_ENCRYPTED_SLO_SUBJECT, "false"));
    }

    @Override
    public boolean isToRequireEncryptedManageNameIDSubject() {
        return Boolean.parseBoolean(this.readProperty(KEY_REQUIRE_ENCRYPTED_MNI_SUBJECT, "false"));
    }

    @Override
    public boolean isToRequireEncryptedManageNameIDNewID() {
        return Boolean.parseBoolean(this.readProperty(KEY_REQUIRE_ENCRYPTED_MNI_NEW_ID, "false"));
    }

    @Override
    public SignatureOption isToRequireSignedArtifactResolutionMessages() {
        return this.readSignatureOption(KEY_REQUIRE_SIGNED_ARS_MESSAGES, CfgConstants.DEFAULT_SIGN_OR_REQUIRE_ARS_MESSAGES);
    }

    @Override
    public SignatureOption isToRequireSignedSingleLogoutMessages() {
        return this.readSignatureOption(KEY_REQUIRE_SIGNED_SLO_MESSAGES, CfgConstants.DEFAULT_SIGN_OR_REQUIRE_SLO_MESSAGES);
    }

    @Override
    public SignatureOption isToRequireSignedManageNameIDMessages() {
        return this.readSignatureOption(KEY_REQUIRE_SIGNED_MNI_MESSAGES, CfgConstants.DEFAULT_SIGN_OR_REQUIRE_MNI_MESSAGES);
    }

    @Override
    public SignatureOption isToSignArtifactResolutionMessages() {
        return this.readSignatureOption(KEY_SIGN_ARS_MESSAGES, CfgConstants.DEFAULT_SIGN_OR_REQUIRE_ARS_MESSAGES);
    }

    @Override
    public SignatureOption isToSignSingleLogoutMessages() {
        return this.readSignatureOption(KEY_SIGN_SLO_MESSAGES, CfgConstants.DEFAULT_SIGN_OR_REQUIRE_SLO_MESSAGES);
    }

    @Override
    public SignatureOption isToSignManageNameIDMessages() {
        return this.readSignatureOption(KEY_SIGN_MNI_MESSAGES, CfgConstants.DEFAULT_SIGN_OR_REQUIRE_MNI_MESSAGES);
    }

    private synchronized Map<String, SAML2IdentityFederationTrustedIdP> getIdentityFederations() {
        String[] nameIdFormatPaths;
        block26: {
            if (this.isStateDeleted()) {
                throw new IllegalStateException("Configuration for SAML2 Provider is already deleted. Configuration path: " + this.getCfgPath());
            }
            if (this.identityFederations != null) {
                return this.identityFederations;
            }
            this.identityFederations = new HashMap<String, SAML2IdentityFederationTrustedIdP>();
            String[] identityFederationPaths = null;
            try {
                identityFederationPaths = this.getSubCfgPaths("identity_federations");
            }
            catch (CfgStorageException e) {
                LOCATION.traceThrowableT(500, "Could not obtains sub configuration paths of the identity federations", (Throwable)e);
            }
            if (identityFederationPaths != null) {
                String[] stringArray = identityFederationPaths;
                int n = identityFederationPaths.length;
                int n2 = 0;
                while (n2 < n) {
                    String identityFederationPath = stringArray[n2];
                    SAML2IdentityFederationTrustedIdPImpl identityFederation = new SAML2IdentityFederationTrustedIdPImpl(this, identityFederationPath);
                    String nameIdFormat = identityFederation.getNameIdFormat();
                    if (nameIdFormat != null && nameIdFormat.length() > 0) {
                        this.identityFederations.put(nameIdFormat, identityFederation);
                    } else if (LOCATION.beWarning()) {
                        LOCATION.warningT("Could not load identity federation configuration under path: " + identityFederationPath + ", because it does not have nameId format configured");
                    }
                    ++n2;
                }
            }
            nameIdFormatPaths = null;
            try {
                nameIdFormatPaths = this.getSubCfgPaths("name_id_formats");
            }
            catch (CfgStorageException e) {
                if (!LOCATION.beWarning()) break block26;
                LOCATION.traceThrowableT(400, "Could not obtains sub configuration paths of name_id_formats", (Throwable)e);
            }
        }
        if (nameIdFormatPaths == null || nameIdFormatPaths.length < 1) {
            return this.identityFederations;
        }
        String idpName = this.getName();
        String[] stringArray = nameIdFormatPaths;
        int n = nameIdFormatPaths.length;
        int n3 = 0;
        while (n3 < n) {
            String nameIdFormatPath = stringArray[n3];
            if (nameIdFormatPath.endsWith("unspecified") && !this.identityFederations.containsKey(SAML2NameIdFormat.UNSPECIFIED.getName())) {
                this.identityFederations.put(SAML2NameIdFormat.UNSPECIFIED.getName(), new SAML2IdentityFederationTrustedIdPOldDataImpl((SAML2NameIdFormatCfgObjectBaseTrustedIdP)((Object)this.getNameIdFormatUnspecified()), idpName));
            } else if (nameIdFormatPath.endsWith("email") && !this.identityFederations.containsKey(SAML2NameIdFormat.E_MAIL.getName())) {
                this.identityFederations.put(SAML2NameIdFormat.E_MAIL.getName(), new SAML2IdentityFederationTrustedIdPOldDataImpl((SAML2NameIdFormatCfgObjectBaseTrustedIdP)((Object)this.getNameIdFormatEmail()), idpName));
            } else if (nameIdFormatPath.endsWith("kerberos") && !this.identityFederations.containsKey(SAML2NameIdFormat.KERBEROS.getName())) {
                this.identityFederations.put(SAML2NameIdFormat.KERBEROS.getName(), new SAML2IdentityFederationTrustedIdPOldDataImpl((SAML2NameIdFormatCfgObjectBaseTrustedIdP)((Object)this.getNameIdFormatKerberos()), idpName));
            } else if (nameIdFormatPath.endsWith("windows") && !this.identityFederations.containsKey(SAML2NameIdFormat.WINDOWS_DOMAIN_QUALIFIED_NAME.getName())) {
                this.identityFederations.put(SAML2NameIdFormat.WINDOWS_DOMAIN_QUALIFIED_NAME.getName(), new SAML2IdentityFederationTrustedIdPOldDataImpl((SAML2NameIdFormatCfgObjectBaseTrustedIdP)((Object)this.getNameIdFormatWindows()), idpName));
            } else if (nameIdFormatPath.endsWith("x509") && !this.identityFederations.containsKey(SAML2NameIdFormat.X509_SUBJECT_NAME.getName())) {
                this.identityFederations.put(SAML2NameIdFormat.X509_SUBJECT_NAME.getName(), new SAML2IdentityFederationTrustedIdPOldDataImpl((SAML2NameIdFormatCfgObjectBaseTrustedIdP)((Object)this.getNameIdFormatX509()), idpName));
            } else if (nameIdFormatPath.endsWith("transient") && !this.identityFederations.containsKey(SAML2NameIdFormat.TRANSIENT.getName())) {
                this.identityFederations.put(SAML2NameIdFormat.TRANSIENT.getName(), new SAML2IdentityFederationTrustedIdPOldDataImpl((SAML2NameIdFormatCfgObjectBaseTrustedIdP)((Object)this.getNameIdFormatTransient()), idpName));
            } else if (nameIdFormatPath.endsWith("persistent") && !this.identityFederations.containsKey(SAML2NameIdFormat.PERSISTENT.getName())) {
                this.identityFederations.put(SAML2NameIdFormat.PERSISTENT.getName(), new SAML2IdentityFederationTrustedIdPOldDataImpl((SAML2NameIdFormatCfgObjectBaseTrustedIdP)((Object)this.getNameIdFormatPersistent()), idpName));
            }
            ++n3;
        }
        return this.identityFederations;
    }

    private List<SAML2ExtensionSupplierDescriptor> readExtensionSupplierDescriptors() {
        if (this.isStateDeleted()) {
            throw new IllegalStateException("Configuration for SAML2 Provider is already deleted. Configuration path: " + this.getCfgPath());
        }
        this.extensionSupplierDescriptors = new ArrayList<SAML2ExtensionSupplierDescriptor>();
        String[] extSupplierDescriptors = null;
        try {
            extSupplierDescriptors = this.getSubCfgPropertySheetNames(CFG_SUB_PATH_EXT_SUPPLIERS);
        }
        catch (CfgStorageException e) {
            LOCATION.traceThrowableT(500, "Could not load extension supplier descriptors configuration", (Throwable)e);
        }
        if (extSupplierDescriptors != null) {
            String[] stringArray = extSupplierDescriptors;
            int n = extSupplierDescriptors.length;
            int n2 = 0;
            while (n2 < n) {
                String extSupplierDescriptor = stringArray[n2];
                SAML2ExtensionSupplierDescriptorImpl descriptor = new SAML2ExtensionSupplierDescriptorImpl(this, CFG_SUB_PATH_EXT_SUPPLIERS, extSupplierDescriptor);
                this.extensionSupplierDescriptors.add(descriptor);
                ++n2;
            }
        }
        return this.extensionSupplierDescriptors;
    }

    private synchronized Collection<SAML2Endpoint> readAllEndpoints() {
        if (this.isStateDeleted()) {
            throw new IllegalStateException("Configuration for SAML2 Provider is already deleted. Configuration path: " + this.getCfgPath());
        }
        if (this.endpointsALL != null) {
            return this.endpointsALL;
        }
        this.endpointsALL = new ArrayList<SAML2Endpoint>();
        this.endpointsSSO = new ArrayList<SAML2Endpoint>();
        this.endpointsARS = new ArrayList<SAML2Endpoint>();
        this.endpointsSLO = new ArrayList<SAML2Endpoint>();
        this.endpointsMNI = new ArrayList<SAML2Endpoint>();
        String[] endpointSheets = null;
        try {
            endpointSheets = this.getSubCfgPropertySheetNames(CFG_SUB_PATH_ENDPOINTS);
        }
        catch (CfgStorageException e) {
            LOCATION.traceThrowableT(500, "Could not load endpoints configuration", (Throwable)e);
        }
        if (endpointSheets != null) {
            String[] stringArray = endpointSheets;
            int n = endpointSheets.length;
            int n2 = 0;
            while (n2 < n) {
                String endpointSheet = stringArray[n2];
                SAML2EndpointImpl endpoint = new SAML2EndpointImpl(this, CFG_SUB_PATH_ENDPOINTS, endpointSheet);
                this.endpointsALL.add(endpoint);
                SAML2Service service = endpoint.getService();
                if (SAML2Service.ARTIFACT_RESOLUTION_SERVICE == service) {
                    this.endpointsARS.add(endpoint);
                } else if (SAML2Service.SINGLE_SIGN_ON_SERVICE == service) {
                    this.endpointsSSO.add(endpoint);
                } else if (SAML2Service.SINGLE_LOGOUT_SERVICE == service) {
                    this.endpointsSLO.add(endpoint);
                } else if (SAML2Service.MANAGE_NAMEID_SERVICE == service) {
                    this.endpointsMNI.add(endpoint);
                } else if (LOCATION.beDebug()) {
                    LOCATION.debugT("Unsupported service for trusted IdP: {0} is configured. Ignore this endpoint: {1}", new Object[]{service, endpoint});
                }
                ++n2;
            }
        }
        return this.endpointsALL;
    }

    private synchronized Collection<SAML2Endpoint> readSLOEndpoints() {
        if (this.endpointsSLO != null) {
            return this.endpointsSLO;
        }
        this.readAllEndpoints();
        return this.endpointsSLO;
    }

    private synchronized Collection<SAML2Endpoint> readMNIEndpoints() {
        if (this.endpointsMNI != null) {
            return this.endpointsMNI;
        }
        this.readAllEndpoints();
        return this.endpointsMNI;
    }

    private synchronized Collection<SAML2Endpoint> readARSEndpoints() {
        if (this.endpointsARS != null) {
            return this.endpointsARS;
        }
        this.readAllEndpoints();
        return this.endpointsARS;
    }

    private synchronized Collection<SAML2Endpoint> readSSOEndpoints() {
        if (this.endpointsSSO != null) {
            return this.endpointsSSO;
        }
        this.readAllEndpoints();
        return this.endpointsSSO;
    }

    private synchronized List<String> readAuthnContextNames() {
        if (this.isStateDeleted()) {
            throw new IllegalStateException("Configuration for SAML2 Provider is already deleted. Configuration path: " + this.getCfgPath());
        }
        List<Object> result = new ArrayList();
        String key = KEY_AUTHENTICATION_CONTEXTS;
        if (this.getCache().containsKey(key)) {
            result = (List)this.getCache().get(key);
        } else {
            String[] authnContextNames = this.getPropertyValue(key, null).getValues();
            if (authnContextNames != null) {
                result = Arrays.asList(authnContextNames);
            }
            this.getCache().put(key, result);
        }
        return result;
    }

    @Override
    public SAML2ModifiableTrustedIdP getModifiableTrustedIdP() throws SAML2ConfigurationException {
        return new SAML2ModifiableTrustedIdPImpl(this);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(1000);
        builder.append("\nCfg path: ").append(super.toString());
        builder.append("\nName: ").append(this.getName());
        builder.append("\nId: ").append(SAML2Utils.byteArrayToHEXString((byte[])this.getID()));
        builder.append("\nEnabled: ").append(this.isEnabled());
        builder.append("\nDescription: ").append(this.getDescription());
        builder.append("\nDefault nameId-format: ").append(this.getDefaultNameIdFormat());
        builder.append("\nAuthentication contexts: ").append(this.getAuthenticationContextNames());
        builder.append("\nRequested authentication context comparison method: ").append(this.getRequestedAuthnContextComparisonMethod());
        builder.append("\nResponse requirement type: ").append((Object)this.getResponseRequirementType());
        builder.append("\nResponse requirement ACS index: ").append(this.getResponseRequirementAssertionConsumerIndex());
        builder.append("\nResponse requirement ACS URL: ").append(this.getResponseRequirementAssertionConsumerURL());
        builder.append("\nResponse requirement binding: ").append(this.getResponseRequirementBinding());
        builder.append("\nCertificate for signature verification: ").append(this.getSigningCertificateName());
        builder.append("\nSecondary certificate for signature verification: ").append(this.getSecondarySigningCertificateName());
        builder.append("\nSign AuthnRequests: ").append((Object)this.isToSignAuthnRequests());
        builder.append("\nRequire signed assertions: ").append((Object)this.isToRequireSignedAssertions());
        builder.append("\nRequire signed AuthnResponses: ").append((Object)this.isToRequireSignedAuthnResponses());
        builder.append("\nSign SLO messages: ").append((Object)this.isToSignSingleLogoutMessages());
        builder.append("\nRequire signed SLO messages: ").append((Object)this.isToRequireSignedSingleLogoutMessages());
        builder.append("\nSign ARS messages: ").append((Object)this.isToSignArtifactResolutionMessages());
        builder.append("\nRequire signed ARS messages: ").append((Object)this.isToRequireSignedArtifactResolutionMessages());
        builder.append("\nSign MNI messages: ").append((Object)this.isToSignManageNameIDMessages());
        builder.append("\nRequire signed MNI messages: ").append((Object)this.isToRequireSignedManageNameIDMessages());
        builder.append("\nCertificate for encryption: ").append(this.getEncryptionCertificateName());
        builder.append("\nEncryption algorithm: ").append(this.getEncryptionAlgorithm());
        builder.append("\nDigest algorithm: ").append(this.getDigestAlgorithm());
        builder.append("\nRequired encrypted AuthnResponse elements: ").append((Object)this.getRequiredEncryptedAuthnResponseElements());
        builder.append("\nEncrypt SLO subject: ").append(this.isToEncryptSingleLogoutSubject());
        builder.append("\nRequire encrypted SLO subject: ").append(this.isToRequireEncryptedSingleLogoutSubject());
        builder.append("\nEncrypt MNI subject: ").append(this.isToEncryptManageNameIDSubject());
        builder.append("\nRequire encrypted MNI subject: ").append(this.isToRequireEncryptedManageNameIDSubject());
        builder.append("\nEncrypt MNI NewID: ").append(this.isToEncryptManageNameIDNewID());
        builder.append("\nRequire encrypted MNI NewID: ").append(this.isToRequireEncryptedManageNameIDNewID());
        builder.append("\n");
        builder.append("\nEndpoints:\n").append(this.getAllEndpointsForTrace());
        builder.append("\nExtension Suppliers:\n").append(this.getExtSupplierDescriptorsForTrace());
        builder.append("\nIdentity Federations:\n").append(this.getAllIdentityFederationsForTrace());
        return builder.toString();
    }

    private String getAllEndpointsForTrace() {
        StringBuilder builder = new StringBuilder();
        for (SAML2Endpoint endpoint : this.getAllEndpoints()) {
            builder.append("" + endpoint).append(";\n");
        }
        return builder.toString();
    }

    private String getExtSupplierDescriptorsForTrace() {
        StringBuilder builder = new StringBuilder();
        for (SAML2ExtensionSupplierDescriptor descriptor : this.getExtensionSupplierDescriptors()) {
            builder.append("" + descriptor).append(";\n");
        }
        return builder.toString();
    }

    private String getAllIdentityFederationsForTrace() {
        StringBuilder builder = new StringBuilder();
        for (SAML2IdentityFederationTrustedIdP identityFederation : this.getIdentityFederations().values()) {
            builder.append("NameId-Format ");
            SAML2NameIdFormat nameIdFormat = SAML2NameIdFormat.getNameIdFormatByName(identityFederation.getNameIdFormat());
            if (nameIdFormat != null) {
                builder.append(nameIdFormat.getKey());
            } else {
                builder.append(identityFederation.getNameIdFormat());
            }
            builder.append(": ");
            builder.append(identityFederation);
            builder.append(";\n");
        }
        return builder.toString();
    }
}

