/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg;

import com.sap.security.saml2.cfg.SAML2CfgDeletionReportImpl;
import com.sap.security.saml2.cfg.SAML2CfgInternalUtils;
import com.sap.security.saml2.cfg.SAML2ConfigImpl;
import com.sap.security.saml2.cfg.SAML2ModifiableTrustedIdPImpl;
import com.sap.security.saml2.cfg.SAML2TrustedIdPImpl;
import com.sap.security.saml2.cfg.SAML2TrustedProvidersConfigBase;
import com.sap.security.saml2.cfg.SAML2UpdateableProviderBase;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.exceptions.SAML2ProviderAlreadyExistsException;
import com.sap.security.saml2.cfg.interfaces.SAML2CfgDeletionReport;
import com.sap.security.saml2.cfg.interfaces.SAML2Config;
import com.sap.security.saml2.cfg.interfaces.SAML2TrustedIdPsConfig;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalProvider;
import com.sap.security.saml2.cfg.interfaces.read.SAML2TrustedIdP;
import com.sap.security.saml2.cfg.interfaces.write.SAML2ModifiableTrustedIdP;
import com.sap.security.saml2.cfg.metadata.SAML2MetadataTrustedIdP;
import com.sap.security.saml2.cfg.security.SAML2CfgSecurityManager;
import com.sap.security.saml2.cfg.storage.CfgChangeEvent;
import com.sap.security.saml2.cfg.storage.CfgPropertySetter;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import com.sap.security.saml2.cfg.storage.StorageChangedListener;
import com.sap.security.saml2.cfg.util.CfgConstants;
import com.sap.security.saml2.cfg.util.CfgUtils;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2Utils;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.SimpleLogger;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class SAML2TrustedIdPsConfigImpl
extends SAML2TrustedProvidersConfigBase
implements SAML2TrustedIdPsConfig,
StorageChangedListener {
    private static final long serialVersionUID = 1L;
    private static final String CFG_SHEET_NAME = "trusted_idps_config";
    static final String CFG_NODE_TRUSTED_IDPS_REL_PATH = "/trusted_providers/trusted_idps";
    private static final Location LOCATION = Location.getLocation(SAML2TrustedIdPsConfigImpl.class);
    private SAML2ConfigImpl parent;
    private Map<String, SAML2TrustedIdP> trustedIdPsByName = new HashMap<String, SAML2TrustedIdP>();
    private Map<String, SAML2TrustedIdP> trustedIdPsByID = new HashMap<String, SAML2TrustedIdP>();
    private Map<String, SAML2UpdateableProviderBase> updateableProviders = new HashMap<String, SAML2UpdateableProviderBase>();
    private Map<String, String> trustedIdPNames = new HashMap<String, String>();
    private static final String KEY_DEFAULT_TRUSTED_IDP_NAME = "default_trusted_idp";
    private String defaultTrustedIdPName;

    public SAML2TrustedIdPsConfigImpl(SAML2ConfigImpl parent) throws SAML2ConfigurationException {
        super(String.valueOf(parent.getCfgPath()) + CFG_NODE_TRUSTED_IDPS_REL_PATH, CFG_SHEET_NAME, false);
        this.parent = parent;
        try {
            this.registerAsStorageListener(this);
        }
        catch (CfgStorageException e) {
            LOCATION.traceThrowableT(500, "Could not register storage listener for trusted Identity Providers with path: {0}", new Object[]{this.getCfgPath()}, (Throwable)e);
        }
        this.loadAllTrustedIdPs();
    }

    private void addTrustedIdP(String name, byte[] id, String cfgPath, SAML2TrustedIdPImpl trustedIdP) {
        this.trustedIdPsByName.put(name, trustedIdP);
        String key = SAML2Utils.byteArrayToHEXString((byte[])id);
        this.trustedIdPsByID.put(key, trustedIdP);
        this.updateableProviders.put(cfgPath, trustedIdP);
        this.trustedIdPNames.put(cfgPath, name);
    }

    private void removeTrustedIdP(String cfgPath) {
        block3: {
            this.updateableProviders.remove(cfgPath);
            String trustedIdPName = this.trustedIdPNames.remove(cfgPath);
            if (trustedIdPName != null) {
                this.trustedIdPsByName.remove(trustedIdPName);
                try {
                    byte[] id = SAML2Utils.calculateSha1Hash((String)trustedIdPName);
                    String key = SAML2Utils.byteArrayToHEXString((byte[])id);
                    this.trustedIdPsByID.remove(key);
                }
                catch (SAML2Exception e) {
                    if (!LOCATION.beWarning()) break block3;
                    LOCATION.traceThrowableT(400, "Could not calculate the ID of the trusted IdP. It could not be cleaned now.", (Throwable)e);
                }
            }
        }
    }

    private void removeTrustedIdP(String name, byte[] id, String cfgPath) {
        this.trustedIdPsByName.remove(name);
        this.trustedIdPNames.remove(cfgPath);
        this.updateableProviders.remove(cfgPath);
        String key = SAML2Utils.byteArrayToHEXString((byte[])id);
        this.trustedIdPsByID.remove(key);
    }

    private synchronized void loadAllTrustedIdPs() throws SAML2ConfigurationException {
        try {
            SAML2LocalProvider localProvider = this.getParent().getLocalProvidersConfiguration().getLocalProvider();
            String[] trustedIdPPaths = this.getSubCfgPaths();
            if (trustedIdPPaths != null) {
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("Trusted Identity Providers paths are: {0}", new Object[]{Arrays.asList(trustedIdPPaths)});
                }
                String[] stringArray = trustedIdPPaths;
                int n = trustedIdPPaths.length;
                int n2 = 0;
                while (n2 < n) {
                    String trustedIdPPath = stringArray[n2];
                    if (trustedIdPPath != null && trustedIdPPath.length() > 0 && !trustedIdPPath.endsWith(CFG_SHEET_NAME)) {
                        SAML2TrustedIdPImpl trustedIdP = new SAML2TrustedIdPImpl(trustedIdPPath, localProvider);
                        String trustedIdPName = trustedIdP.getName();
                        byte[] trustedIdPId = trustedIdP.getID();
                        if (trustedIdPName != null && trustedIdPName.length() > 0) {
                            this.addTrustedIdP(trustedIdPName, trustedIdPId, trustedIdPPath, trustedIdP);
                        } else if (LOCATION.beDebug()) {
                            LOCATION.debugT("Trusted Identity Provider with path: {0} does not have a name. It cannot be added to the trusted providers list", new Object[]{trustedIdPPath});
                        }
                    }
                    ++n2;
                }
            } else if (LOCATION.beDebug()) {
                LOCATION.debugT("There are not any trusted Identity Providers to load");
            }
        }
        catch (CfgStorageException e) {
            throw new SAML2ConfigurationException("Could not load trusted Identity Providers", e);
        }
    }

    void destroy() {
        try {
            this.unregisterAsStorageListener(this);
        }
        catch (CfgStorageException e) {
            LOCATION.traceThrowableT(500, "Could not unregister storage listener for trusted SAML2 identity providers with path: {0}", new Object[]{this.getCfgPath()}, (Throwable)e);
        }
    }

    @Override
    public SAML2TrustedIdP getTrustedIdP(String name) {
        return this.trustedIdPsByName.get(name);
    }

    @Override
    public SAML2TrustedIdP getTrustedIdPByID(byte[] id) {
        String key = SAML2Utils.byteArrayToHEXString((byte[])id);
        return this.trustedIdPsByID.get(key);
    }

    @Override
    public synchronized SAML2ModifiableTrustedIdP createTrustedIdP(String name) throws SAML2ProviderAlreadyExistsException, SAML2ConfigurationException {
        return this.getModifiableTrustedIdP(name, false);
    }

    private synchronized SAML2ModifiableTrustedIdP getModifiableTrustedIdP(String name, boolean couldUseExisting) throws SAML2ProviderAlreadyExistsException, SAML2ConfigurationException {
        if (name == null || name.length() < 1) {
            throw new SAML2ConfigurationException("Provider name cannot be empty");
        }
        if (this.trustedIdPsByName.containsKey(name)) {
            if (!couldUseExisting) {
                throw new SAML2ProviderAlreadyExistsException("Trusted Identity Provider with name: " + name + " already exists");
            }
            SAML2TrustedIdP trustedIdP = this.trustedIdPsByName.get(name);
            SAML2ModifiableTrustedIdP modifiableTrustedIdP = trustedIdP.getModifiableTrustedIdP();
            return modifiableTrustedIdP;
        }
        SAML2ModifiableTrustedIdPImpl modifiableTrustedIdP = new SAML2ModifiableTrustedIdPImpl(this);
        modifiableTrustedIdP.setName(name);
        return modifiableTrustedIdP;
    }

    @Override
    public void createTrustedIdP(SAML2MetadataTrustedIdP trustedIdP) throws SAML2ProviderAlreadyExistsException, SAML2ConfigurationException {
        this.createTrustedIdP(trustedIdP, false, false);
    }

    @Override
    public synchronized void createTrustedIdP(SAML2MetadataTrustedIdP trustedIdP, boolean automatic, boolean overwrite) throws SAML2ProviderAlreadyExistsException, SAML2ConfigurationException {
        String defaultIdPName;
        String providerName = trustedIdP.getName();
        if (providerName == null || providerName.length() < 1) {
            throw new SAML2ConfigurationException("Trusted provider name cannot be empty");
        }
        SAML2ModifiableTrustedIdP modifiableTrustedIdP = this.getModifiableTrustedIdP(providerName, overwrite);
        if (automatic) {
            modifiableTrustedIdP.setEnabled(true);
        } else {
            modifiableTrustedIdP.setEnabled(false);
        }
        String keystoreView = this.getParent().getLocalProvidersConfiguration().getLocalProvider().getKeyStoreViewName();
        trustedIdP.fillInModifiableCfg(modifiableTrustedIdP, keystoreView, automatic);
        modifiableTrustedIdP.writeProvider();
        if (automatic && CfgUtils.isEmpty(defaultIdPName = this.getDefaultTrustedIdPName())) {
            this.setDefaultTrustedIdPName(providerName);
        }
    }

    @Override
    public synchronized void deleteTrustedIdP(String name) throws SAML2ConfigurationException {
        SAML2TrustedIdPImpl trustedIdP = (SAML2TrustedIdPImpl)this.trustedIdPsByName.get(name);
        if (trustedIdP != null) {
            String trustedIdPForTrace = null;
            if (LOCATION.beDebug()) {
                trustedIdPForTrace = trustedIdP.toString();
            }
            String cfgPath = trustedIdP.getCfgPath();
            byte[] id = trustedIdP.getID();
            SAML2ModifiableTrustedIdPImpl modifiableTrustedIdP = (SAML2ModifiableTrustedIdPImpl)trustedIdP.getModifiableTrustedIdP();
            modifiableTrustedIdP.deleteProvider();
            this.removeTrustedIdP(name, id, cfgPath);
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Deleted trusted IdP: {0}", new Object[]{trustedIdPForTrace});
            }
        } else {
            throw new SAML2ConfigurationException("Trusted IdP with name: " + name + " does not exists");
        }
        SimpleLogger.log((int)300, (Category)CfgConstants.CHANGE_LOG_CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_cfg.001007", (String)"SAML2 trusted identity provider with name: [{0}] was deleted.", (Object[])new Object[]{name});
    }

    @Override
    public synchronized SAML2CfgDeletionReport deleteTrustedIdP(String name, boolean deleteCertificates, boolean deleteDestinations) throws SAML2ConfigurationException {
        Set<String> usedCertificates = null;
        Set<String> usedDestinations = null;
        SAML2TrustedIdP trustedIdP = this.trustedIdPsByName.get(name);
        if (trustedIdP != null) {
            if (deleteCertificates) {
                usedCertificates = SAML2CfgInternalUtils.getUsedCertificates(trustedIdP);
            }
            if (deleteDestinations) {
                usedDestinations = SAML2CfgInternalUtils.getUsedDestinations(trustedIdP);
            }
        }
        this.deleteTrustedIdP(name);
        SAML2CfgDeletionReportImpl result = new SAML2CfgDeletionReportImpl();
        if (deleteCertificates) {
            String keystoreView = this.getParent().getLocalProvidersConfiguration().getLocalProvider().getKeyStoreViewName();
            if (keystoreView != null && keystoreView.length() > 0) {
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("Used certificate(s): {0} for trusted IdP: {1} will be deleted", new Object[]{usedCertificates, name});
                }
                SAML2CfgInternalUtils.deleteCertificates(keystoreView, usedCertificates, result);
            } else if (LOCATION.beWarning()) {
                LOCATION.warningT("Could not delete the used certificates for trusted IdP: {0}, because there is not configured keystore view: {1}", new Object[]{name, keystoreView});
            }
        }
        if (deleteDestinations) {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Used destination(s): {0} for trusted IdP: {1} will be deleted", new Object[]{usedDestinations, name});
            }
            SAML2CfgInternalUtils.deleteDestinations(usedDestinations, result);
        }
        return result;
    }

    @Override
    public Collection<SAML2TrustedIdP> getAllTrustedIdPs() {
        return this.trustedIdPsByName.values();
    }

    @Override
    public Collection<String> getAllTrustedIdPNames() {
        return this.trustedIdPsByName.keySet();
    }

    @Override
    public SAML2TrustedIdP getDefaultTrustedIdP() {
        String defaultIdPName = this.getDefaultTrustedIdPName();
        SAML2TrustedIdP result = this.trustedIdPsByName.get(defaultIdPName);
        return result;
    }

    @Override
    public String getDefaultTrustedIdPName() {
        return this.readDefaultTrustedIdPName();
    }

    @Override
    public synchronized void setDefaultTrustedIdPName(String name) throws SAML2ConfigurationException {
        SAML2CfgSecurityManager.getInstance().checkWritePermission();
        String changeLogOldValue = this.getDefaultTrustedIdPName();
        try {
            CfgPropertySetter propertySetter = this.getPropertySetter();
            propertySetter.setProperty(KEY_DEFAULT_TRUSTED_IDP_NAME, name);
            this.write(propertySetter);
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Default trusted IdP is changed to: {0}", new Object[]{name});
            }
        }
        catch (Exception e) {
            throw new SAML2ConfigurationException("Could not write default trusted IdP name", e);
        }
        this.cleanCachedObjects();
        SimpleLogger.log((int)300, (Category)CfgConstants.CHANGE_LOG_CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_cfg.001012", (String)"Property [SAML2 default trusted identity provider] was changed. Old version: [{0}], new version: [{1}].", (Object[])new Object[]{changeLogOldValue, this.getDefaultTrustedIdPName()});
    }

    @Override
    public void storageChanged(CfgChangeEvent event) {
        CfgChangeEvent[] detailedEvents = event.getDetailedChangeEvents();
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Received detailed change events: {0}", new Object[]{Arrays.asList(detailedEvents)});
        }
        CfgChangeEvent lastEvent = detailedEvents[detailedEvents.length - 1];
        String lastEventPath = lastEvent.getPath();
        int action = lastEvent.getAction();
        String pathToTrustedIdP = CfgUtils.extractRelativePathToFirstSubNode(lastEventPath, this.getCfgPath());
        if (lastEventPath.endsWith(CFG_SHEET_NAME)) {
            this.cleanCachedObjects();
        } else if (CfgUtils.isOneSubNode(lastEventPath, this.getCfgPath()) && action == 2) {
            this.handleEventForDeletedTrustedIdP(pathToTrustedIdP);
        } else if (lastEventPath.endsWith("trusted_idp") && action == 1) {
            this.handleEventForCreatedTrustedIdP(pathToTrustedIdP);
        } else {
            this.handleEventForUpdatedTrustedIdP(pathToTrustedIdP);
        }
    }

    private synchronized void cleanCachedObjects() {
        this.defaultTrustedIdPName = null;
    }

    protected synchronized void createdNewTrustedIdP(SAML2TrustedIdPImpl trustedIdP) {
        String name = trustedIdP.getName();
        byte[] id = trustedIdP.getID();
        if (name != null && name.length() > 0) {
            this.addTrustedIdP(name, id, trustedIdP.getCfgPath(), trustedIdP);
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Created trusted IdP: {0}", new Object[]{trustedIdP});
            }
        } else if (LOCATION.beWarning()) {
            LOCATION.warningT("Identity Provider does not have a name. Could not be added to the trusted Identity Providers list");
        }
    }

    private synchronized void handleEventForCreatedTrustedIdP(String cfgPath) {
        if (!this.updateableProviders.containsKey(cfgPath)) {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Received event for created trusted IdP with path: {0}", new Object[]{cfgPath});
            }
            SAML2LocalProvider localProvider = this.getParent().getLocalProvidersConfiguration().getLocalProvider();
            SAML2TrustedIdPImpl trustedIdP = new SAML2TrustedIdPImpl(cfgPath, localProvider);
            String name = trustedIdP.getName();
            byte[] id = trustedIdP.getID();
            if (name != null && name.length() > 0) {
                this.addTrustedIdP(name, id, trustedIdP.getCfgPath(), trustedIdP);
            } else if (LOCATION.beWarning()) {
                LOCATION.warningT("Identity provider does not have a name. Could not be added to the trusted Identity Providers list");
            }
        }
    }

    private synchronized void handleEventForDeletedTrustedIdP(String cfgPath) {
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Received event for deleted trusted IdP with path: {0}", new Object[]{cfgPath});
        }
        this.removeTrustedIdP(cfgPath);
    }

    private synchronized void handleEventForUpdatedTrustedIdP(String cfgPath) {
        SAML2UpdateableProviderBase updateableObject = this.updateableProviders.get(cfgPath);
        if (updateableObject != null) {
            updateableObject.update();
        } else if (LOCATION.beDebug()) {
            LOCATION.debugT("There is not trusted IdP to update with path: {0}", new Object[]{cfgPath});
        }
    }

    protected SAML2Config getParent() {
        return this.parent;
    }

    private synchronized String readDefaultTrustedIdPName() {
        if (this.defaultTrustedIdPName != null) {
            return this.defaultTrustedIdPName;
        }
        String dbTrustedIdPName = this.getPropertyValue(KEY_DEFAULT_TRUSTED_IDP_NAME, null).getValue();
        if (dbTrustedIdPName != null && dbTrustedIdPName.length() > 0) {
            this.defaultTrustedIdPName = dbTrustedIdPName;
            return dbTrustedIdPName;
        }
        if (LOCATION.beDebug()) {
            LOCATION.debugT("There is not configured default trusted IdP");
        }
        return null;
    }
}

