/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg;

import com.sap.security.saml2.cfg.SAML2EndpointImpl;
import com.sap.security.saml2.cfg.SAML2KeystoreWrapper;
import com.sap.security.saml2.cfg.SAML2LocalProviderImpl;
import com.sap.security.saml2.cfg.SAML2ModifiableTrustedSPImpl;
import com.sap.security.saml2.cfg.SAML2UpdateableProviderBase;
import com.sap.security.saml2.cfg.enums.DigestAlgorithm;
import com.sap.security.saml2.cfg.enums.EncryptionAlgorithm;
import com.sap.security.saml2.cfg.enums.EncryptionOption;
import com.sap.security.saml2.cfg.enums.SAML2Binding;
import com.sap.security.saml2.cfg.enums.SAML2NameIdFormat;
import com.sap.security.saml2.cfg.enums.SAML2Service;
import com.sap.security.saml2.cfg.enums.SignatureOption;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.interfaces.read.SAML2CfgUMEAttribute;
import com.sap.security.saml2.cfg.interfaces.read.SAML2Endpoint;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalProvider;
import com.sap.security.saml2.cfg.interfaces.read.SAML2TrustedSP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatEmailTrustedSP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatKerberosTrustedSP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatPersistentTrustedSP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatTransientTrustedSP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatUnspecifiedTrustedSP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatWindowsTrustedSP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatX509TrustedSP;
import com.sap.security.saml2.cfg.interfaces.write.SAML2ModifiableTrustedSP;
import com.sap.security.saml2.cfg.nameidformat.SAML2NameIdFormatEmailTrustedSPImpl;
import com.sap.security.saml2.cfg.nameidformat.SAML2NameIdFormatKerberosTrustedSPImpl;
import com.sap.security.saml2.cfg.nameidformat.SAML2NameIdFormatPersistentTrustedSPImpl;
import com.sap.security.saml2.cfg.nameidformat.SAML2NameIdFormatTransientTrustedSPImpl;
import com.sap.security.saml2.cfg.nameidformat.SAML2NameIdFormatUnspecifiedTrustedSPImpl;
import com.sap.security.saml2.cfg.nameidformat.SAML2NameIdFormatWindowsTrustedSPImpl;
import com.sap.security.saml2.cfg.nameidformat.SAML2NameIdFormatX509TrustedSPImpl;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import com.sap.security.saml2.cfg.util.CfgConstants;
import com.sap.security.saml2.lib.common.SAML2Utils;
import com.sap.tc.logging.Location;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SAML2TrustedSPImpl
extends SAML2UpdateableProviderBase
implements SAML2TrustedSP {
    private static final long serialVersionUID = 1L;
    private static final Location LOCATION = Location.getLocation(SAML2TrustedSPImpl.class);
    private SAML2LocalProvider localProvider;
    private List<SAML2Endpoint> endpointsALL;
    private List<SAML2Endpoint> endpointsARS;
    private List<SAML2Endpoint> endpointsACS;
    private List<SAML2Endpoint> endpointsSLO;
    private List<SAML2Endpoint> endpointsMNI;
    private SAML2NameIdFormatEmailTrustedSPImpl nameIdFormatEmailTrustedSP;
    private SAML2NameIdFormatUnspecifiedTrustedSPImpl nameIdFormatUnspecifiedTrustedSP;
    private SAML2NameIdFormatTransientTrustedSPImpl nameIdFormatTransientTrustedSP;
    private SAML2NameIdFormatPersistentTrustedSPImpl nameIdFormatPersistentTrustedSP;
    private SAML2NameIdFormatKerberosTrustedSPImpl nameIdFormatKerberosTrustedSP;
    private SAML2NameIdFormatX509TrustedSPImpl nameIdFormatX509TrustedSP;
    private SAML2NameIdFormatWindowsTrustedSPImpl nameIdFormatWindowsTrustedSP;
    protected static final String CFG_SHEET_NAME = "trusted_sp";
    protected static final String CFG_SUB_PATH_ENDPOINTS = "endpoints";
    protected static final String KEY_ENABLED = "enabled";
    protected static final String KEY_DESCRIPTION = "description";
    protected static final String KEY_ENCRYPTION_ALGORITHM = "enc_algorithm";
    protected static final String KEY_SIGNING_CERTIFICATE = "signing_cert";
    protected static final String KEY_SECONDARY_SIGNING_CERTIFICATE = "secondary_signing_cert";
    protected static final String KEY_ENCRYPTION_CERTIFICATE = "enc_cert";
    protected static final String KEY_SIGN_ASSERTIONS = "sign_assertions";
    protected static final String KEY_SIGN_AUTHN_RESPONSES = "sign_authn_responses";
    protected static final String KEY_SIGN_ARS_MESSAGES = "sign_ars_messages";
    protected static final String KEY_SIGN_SLO_MESSAGES = "sign_slo_messages";
    protected static final String KEY_SIGN_MNI_MESSAGES = "sign_mni_messages";
    protected static final String KEY_REQUIRE_SIGNED_AUTHN_REQUESTS = "require_signed_authn_requests";
    protected static final String KEY_REQUIRE_SIGNED_ARS_MESSAGES = "require_signed_ars_messages";
    protected static final String KEY_REQUIRE_SIGNED_SLO_MESSAGES = "require_signed_slo_messages";
    protected static final String KEY_REQUIRE_SIGNED_MNI_MESSAGES = "require_signed_mni_messages";
    protected static final String KEY_ENCRYPT_SLO_SUBJECT = "encrypt_slo_subject";
    protected static final String KEY_ENCRYPT_MNI_SUBJECT = "encrypt_mni_subject";
    protected static final String KEY_ENCRYPT_MNI_NEW_ID = "encrypt_mni_new_id";
    protected static final String KEY_REQUIRE_ENCRYPTED_SLO_SUBJECT = "require_encrypted_slo_subject";
    protected static final String KEY_REQUIRE_ENCRYPTED_MNI_SUBJECT = "require_encrypted_mni_subject";
    protected static final String KEY_REQUIRE_ENCRYPTED_MNI_NEW_ID = "require_encrypted_mni_new_id";
    protected static final String KEY_AUTHN_RESPONSE_ELEMENTS_TO_ENCRYPT = "authn_response_elements_to_encrypt";
    protected static final String KEY_REQUIRE_ENCRYPTED_AUTHN_RESPONSE = "require_encrypted_authn_response_elements";
    protected static final String KEY_DEFAULT_NAME_ID_FORMAT = "default_name_id_format";
    protected static final String KEY_SP_PROVIDED_ID_UME_ATTRIBUTE_NAME = "sp_provided_id_ume_attr_name";
    protected static final String KEY_SP_PROVIDED_ID_UME_ATTRIBUTE_NAMESPACE = "sp_provided_id_ume_attr_ns";
    protected static final String KEY_SIGNATURE_ALGORITHM = "sig_algorithm";

    public SAML2TrustedSPImpl(String cfgRootPath, SAML2LocalProvider localProvider) {
        super(cfgRootPath, CFG_SHEET_NAME);
        this.localProvider = localProvider;
    }

    @Override
    protected synchronized void cleanCachedObjects() {
        this.endpointsALL = null;
        this.endpointsARS = null;
        this.endpointsACS = null;
        this.endpointsSLO = null;
        this.endpointsMNI = null;
        this.nameIdFormatEmailTrustedSP = null;
        this.nameIdFormatUnspecifiedTrustedSP = null;
        this.nameIdFormatTransientTrustedSP = null;
        this.nameIdFormatPersistentTrustedSP = null;
        this.nameIdFormatKerberosTrustedSP = null;
        this.nameIdFormatX509TrustedSP = null;
        this.nameIdFormatWindowsTrustedSP = null;
    }

    public SAML2CfgUMEAttribute getUMEAttribute(String name, String namespace) {
        return ((SAML2LocalProviderImpl)this.localProvider).getUMEAttribute(name, namespace);
    }

    @Override
    public SAML2Endpoint getAssertionConsumerEndpoint(int index) {
        SAML2Endpoint result = null;
        Collection<SAML2Endpoint> acsEndpoints = this.readACSEndpoints();
        if (acsEndpoints != null) {
            for (SAML2Endpoint endpoint : acsEndpoints) {
                if (endpoint.getIndex() != index) continue;
                result = endpoint;
                break;
            }
        }
        return result;
    }

    @Override
    public List<SAML2Endpoint> getAssertionConsumerEndpoints(SAML2Binding binding) {
        ArrayList<SAML2Endpoint> result = new ArrayList<SAML2Endpoint>();
        Collection<SAML2Endpoint> acsEndpoints = this.readACSEndpoints();
        if (acsEndpoints != null) {
            for (SAML2Endpoint endpoint : acsEndpoints) {
                if (endpoint.getBinding() != binding) continue;
                result.add(endpoint);
            }
        }
        return result;
    }

    @Override
    public EncryptionOption getAuthnResponseElementsToEncrypt() {
        return this.readEncryptionOption(KEY_AUTHN_RESPONSE_ELEMENTS_TO_ENCRYPT, CfgConstants.DEFAULT_AUTHN_RESPONSE_ENCRYPT_ELEMENTS);
    }

    @Override
    public SAML2Endpoint getDefaultAssertionConsumerEndpoint() {
        SAML2Endpoint result = null;
        Collection<SAML2Endpoint> acsEndpoints = this.readACSEndpoints();
        if (acsEndpoints != null) {
            for (SAML2Endpoint endpoint : acsEndpoints) {
                if (!endpoint.isDefault()) continue;
                result = endpoint;
                break;
            }
        }
        return result;
    }

    @Override
    public SAML2NameIdFormat getDefaultNameIdFormat() {
        String dbNameIdFormat = this.readProperty(KEY_DEFAULT_NAME_ID_FORMAT);
        SAML2NameIdFormat nameIdFormat = SAML2NameIdFormat.getNameIdFormatByName(dbNameIdFormat);
        return nameIdFormat;
    }

    @Override
    public String getDescription() {
        return this.readProperty(KEY_DESCRIPTION);
    }

    @Override
    public String getSPProvidedIDUMEAttributeName() {
        return this.readProperty(KEY_SP_PROVIDED_ID_UME_ATTRIBUTE_NAME);
    }

    @Override
    public String getSPProvidedIDUMEAttributeNamespace() {
        return this.readProperty(KEY_SP_PROVIDED_ID_UME_ATTRIBUTE_NAMESPACE);
    }

    @Override
    public synchronized SAML2NameIdFormatEmailTrustedSP getNameIdFormatEmail() {
        if (this.nameIdFormatEmailTrustedSP == null) {
            this.nameIdFormatEmailTrustedSP = new SAML2NameIdFormatEmailTrustedSPImpl(this);
        }
        return this.nameIdFormatEmailTrustedSP;
    }

    @Override
    public synchronized SAML2NameIdFormatKerberosTrustedSP getNameIdFormatKerberos() {
        if (this.nameIdFormatKerberosTrustedSP == null) {
            this.nameIdFormatKerberosTrustedSP = new SAML2NameIdFormatKerberosTrustedSPImpl(this);
        }
        return this.nameIdFormatKerberosTrustedSP;
    }

    @Override
    public synchronized SAML2NameIdFormatPersistentTrustedSP getNameIdFormatPersistent() {
        if (this.nameIdFormatPersistentTrustedSP == null) {
            this.nameIdFormatPersistentTrustedSP = new SAML2NameIdFormatPersistentTrustedSPImpl(this);
        }
        return this.nameIdFormatPersistentTrustedSP;
    }

    @Override
    public synchronized SAML2NameIdFormatTransientTrustedSP getNameIdFormatTransient() {
        if (this.nameIdFormatTransientTrustedSP == null) {
            this.nameIdFormatTransientTrustedSP = new SAML2NameIdFormatTransientTrustedSPImpl(this);
        }
        return this.nameIdFormatTransientTrustedSP;
    }

    @Override
    public synchronized SAML2NameIdFormatUnspecifiedTrustedSP getNameIdFormatUnspecified() {
        if (this.nameIdFormatUnspecifiedTrustedSP == null) {
            this.nameIdFormatUnspecifiedTrustedSP = new SAML2NameIdFormatUnspecifiedTrustedSPImpl(this);
        }
        return this.nameIdFormatUnspecifiedTrustedSP;
    }

    @Override
    public synchronized SAML2NameIdFormatWindowsTrustedSP getNameIdFormatWindows() {
        if (this.nameIdFormatWindowsTrustedSP == null) {
            this.nameIdFormatWindowsTrustedSP = new SAML2NameIdFormatWindowsTrustedSPImpl(this);
        }
        return this.nameIdFormatWindowsTrustedSP;
    }

    @Override
    public synchronized SAML2NameIdFormatX509TrustedSP getNameIdFormatX509() {
        if (this.nameIdFormatX509TrustedSP == null) {
            this.nameIdFormatX509TrustedSP = new SAML2NameIdFormatX509TrustedSPImpl(this);
        }
        return this.nameIdFormatX509TrustedSP;
    }

    @Override
    public SignatureOption isToRequireSignedAuthnRequests() {
        return this.readSignatureOption(KEY_REQUIRE_SIGNED_AUTHN_REQUESTS, CfgConstants.DEFAULT_SIGN_OR_REQUIRE_AUTHN_RESPONSES);
    }

    @Override
    public SignatureOption isToSignAssertions() {
        return this.readSignatureOption(KEY_SIGN_ASSERTIONS, CfgConstants.DEFAULT_SIGN_OR_REQUIRE_ASSERTIONS);
    }

    @Override
    public SignatureOption isToSignAuthnResponses() {
        return this.readSignatureOption(KEY_SIGN_AUTHN_RESPONSES, CfgConstants.DEFAULT_SIGN_OR_REQUIRE_AUTHN_RESPONSES);
    }

    @Override
    public SAML2Endpoint getArtifactResolutionEndpoint(int index) {
        SAML2Endpoint result = null;
        Collection<SAML2Endpoint> arsEndpoints = this.readARSEndpoints();
        if (arsEndpoints != null) {
            for (SAML2Endpoint endpoint : arsEndpoints) {
                if (endpoint.getIndex() != index) continue;
                result = endpoint;
                break;
            }
        }
        return result;
    }

    @Override
    public Certificate getCertificateForSignature() throws SAML2ConfigurationException {
        String viewName = this.localProvider.getKeyStoreViewName();
        String entryName = this.getSigningCertificateName();
        try {
            return SAML2KeystoreWrapper.getInstance().getCertificate(viewName, entryName);
        }
        catch (Exception e) {
            throw new SAML2ConfigurationException("Could not obtain the primary certificate for signature verification with name: " + entryName + " from view: " + viewName, e);
        }
    }

    @Override
    public Certificate getSecondaryCertificateForSignature() throws SAML2ConfigurationException {
        String viewName = this.localProvider.getKeyStoreViewName();
        String entryName = this.getSecondarySigningCertificateName();
        try {
            return SAML2KeystoreWrapper.getInstance().getCertificate(viewName, entryName);
        }
        catch (Exception e) {
            throw new SAML2ConfigurationException("Could not obtain the secondary certificate for signature verification with name: " + entryName + " from view: " + viewName, e);
        }
    }

    @Override
    public SAML2Endpoint getDefaultSingleLogoutEndpoint() {
        SAML2Endpoint result = null;
        Collection<SAML2Endpoint> sloEndpoints = this.readSLOEndpoints();
        if (sloEndpoints != null) {
            for (SAML2Endpoint endpoint : sloEndpoints) {
                if (!endpoint.isDefault()) continue;
                result = endpoint;
                break;
            }
        }
        return result;
    }

    @Override
    public SAML2Endpoint getDefaultManageNameIDEndpoint() {
        for (SAML2Endpoint endpoint : this.readMNIEndpoints()) {
            if (!endpoint.isDefault()) continue;
            return endpoint;
        }
        return null;
    }

    @Override
    public EncryptionAlgorithm getEncryptionAlgorithm() {
        EncryptionAlgorithm result = CfgConstants.DEFAULT_ENCRYPTION_ALGORITHM;
        String encAlgorithmURI = this.readProperty(KEY_ENCRYPTION_ALGORITHM);
        if (encAlgorithmURI != null && encAlgorithmURI.length() > 0) {
            EncryptionAlgorithm encAlgorithm = EncryptionAlgorithm.getEncryptionAlgorithm(encAlgorithmURI);
            if (encAlgorithm != null) {
                result = encAlgorithm;
            } else if (LOCATION.beDebug()) {
                LOCATION.debugT("Configured value: {0} for encryption algorithm is not valid EncryptionAlgorithm uri. Will be used the default one: {1}", new Object[]{encAlgorithmURI, CfgConstants.DEFAULT_ENCRYPTION_ALGORITHM});
            }
        } else if (LOCATION.beDebug()) {
            LOCATION.debugT("There is not configured value for encryption algorithm. Will be used the default one: {0}", new Object[]{CfgConstants.DEFAULT_ENCRYPTION_ALGORITHM});
        }
        return result;
    }

    @Override
    public DigestAlgorithm getDigestAlgorithm() {
        DigestAlgorithm result = CfgConstants.DEFAULT_DIGEST;
        String digestAlgorithm = this.readProperty(KEY_SIGNATURE_ALGORITHM);
        if (digestAlgorithm != null && digestAlgorithm.length() > 0) {
            DigestAlgorithm digAlgorithm = DigestAlgorithm.getDigestAlgorithm(digestAlgorithm);
            if (digAlgorithm != null) {
                result = digAlgorithm;
            } else if (LOCATION.beDebug()) {
                LOCATION.debugT("Configured value: {0} for signature algorithm is not valid DigestAlgorithm uri. Will be used the default one: {1}", new Object[]{digestAlgorithm, CfgConstants.DEFAULT_DIGEST});
            }
        } else if (LOCATION.beDebug()) {
            LOCATION.debugT("There is no configured value for signature algorithm. Will be used the default one: {0}", new Object[]{CfgConstants.DEFAULT_DIGEST});
        }
        return result;
    }

    @Override
    public String getEncryptionCertificateName() {
        return this.readProperty(KEY_ENCRYPTION_CERTIFICATE);
    }

    @Override
    public Collection<SAML2Endpoint> getAllEndpoints() {
        return this.readAllEndpoints();
    }

    @Override
    public Collection<SAML2Endpoint> getACSEndpoints() {
        return this.readACSEndpoints();
    }

    @Override
    public Collection<SAML2Endpoint> getARSEndpoints() {
        return this.readARSEndpoints();
    }

    @Override
    public Collection<SAML2Endpoint> getSLOEndpoints() {
        return this.readSLOEndpoints();
    }

    @Override
    public Collection<SAML2Endpoint> getMNIEndpoints() {
        return this.readMNIEndpoints();
    }

    @Override
    public PublicKey getPublicKeyForEncryption() throws SAML2ConfigurationException {
        Certificate cert = this.getCertificateForEncryption();
        if (cert != null) {
            return cert.getPublicKey();
        }
        return null;
    }

    @Override
    public Certificate getCertificateForEncryption() throws SAML2ConfigurationException {
        String viewName = this.localProvider.getKeyStoreViewName();
        String entryName = this.getEncryptionCertificateName();
        try {
            Certificate cert = SAML2KeystoreWrapper.getInstance().getCertificate(viewName, entryName);
            return cert;
        }
        catch (Exception e) {
            throw new SAML2ConfigurationException("Could not obtain certificate for encryption with name: " + entryName + " from view: " + viewName, e);
        }
    }

    @Override
    public String getSigningCertificateName() {
        return this.readProperty(KEY_SIGNING_CERTIFICATE);
    }

    @Override
    public String getSecondarySigningCertificateName() {
        return this.readProperty(KEY_SECONDARY_SIGNING_CERTIFICATE);
    }

    @Override
    public List<SAML2Endpoint> getSingleLogoutEndpoints(SAML2Binding binding) {
        ArrayList<SAML2Endpoint> result = new ArrayList<SAML2Endpoint>();
        Collection<SAML2Endpoint> sloEndpoints = this.readSLOEndpoints();
        if (sloEndpoints != null) {
            for (SAML2Endpoint endpoint : sloEndpoints) {
                if (endpoint.getBinding() != binding) continue;
                result.add(endpoint);
            }
        }
        return result;
    }

    @Override
    public List<SAML2Endpoint> getManageNameIDEndpoints(SAML2Binding binding) {
        ArrayList<SAML2Endpoint> result = new ArrayList<SAML2Endpoint>();
        for (SAML2Endpoint endpoint : this.readMNIEndpoints()) {
            if (endpoint.getBinding() != binding) continue;
            result.add(endpoint);
        }
        return result;
    }

    @Override
    public boolean isEnabled() {
        return Boolean.parseBoolean(this.readProperty(KEY_ENABLED, "false"));
    }

    @Override
    public boolean isToEncryptSingleLogoutSubject() {
        return Boolean.parseBoolean(this.readProperty(KEY_ENCRYPT_SLO_SUBJECT, "false"));
    }

    @Override
    public boolean isToEncryptManageNameIDSubject() {
        return Boolean.parseBoolean(this.readProperty(KEY_ENCRYPT_MNI_SUBJECT, "false"));
    }

    @Override
    public boolean isToEncryptManageNameIDNewID() {
        return Boolean.parseBoolean(this.readProperty(KEY_ENCRYPT_MNI_NEW_ID, "false"));
    }

    @Override
    public boolean isToRequireEncryptedSingleLogoutSubject() {
        return Boolean.parseBoolean(this.readProperty(KEY_REQUIRE_ENCRYPTED_SLO_SUBJECT, "false"));
    }

    @Override
    public boolean isToRequireEncryptedManageNameIDSubject() {
        return Boolean.parseBoolean(this.readProperty(KEY_REQUIRE_ENCRYPTED_MNI_SUBJECT, "false"));
    }

    @Override
    public boolean isToRequireEncryptedManageNameIDNewID() {
        return Boolean.parseBoolean(this.readProperty(KEY_REQUIRE_ENCRYPTED_MNI_NEW_ID, "false"));
    }

    @Override
    public SignatureOption isToRequireSignedArtifactResolutionMessages() {
        return this.readSignatureOption(KEY_REQUIRE_SIGNED_ARS_MESSAGES, CfgConstants.DEFAULT_SIGN_OR_REQUIRE_ARS_MESSAGES);
    }

    @Override
    public SignatureOption isToRequireSignedSingleLogoutMessages() {
        return this.readSignatureOption(KEY_REQUIRE_SIGNED_SLO_MESSAGES, CfgConstants.DEFAULT_SIGN_OR_REQUIRE_SLO_MESSAGES);
    }

    @Override
    public SignatureOption isToRequireSignedManageNameIDMessages() {
        return this.readSignatureOption(KEY_REQUIRE_SIGNED_MNI_MESSAGES, CfgConstants.DEFAULT_SIGN_OR_REQUIRE_MNI_MESSAGES);
    }

    @Override
    public SignatureOption isToSignArtifactResolutionMessages() {
        return this.readSignatureOption(KEY_SIGN_ARS_MESSAGES, CfgConstants.DEFAULT_SIGN_OR_REQUIRE_ARS_MESSAGES);
    }

    @Override
    public SignatureOption isToSignSingleLogoutMessages() {
        return this.readSignatureOption(KEY_SIGN_SLO_MESSAGES, CfgConstants.DEFAULT_SIGN_OR_REQUIRE_SLO_MESSAGES);
    }

    @Override
    public SignatureOption isToSignManageNameIDMessages() {
        return this.readSignatureOption(KEY_SIGN_MNI_MESSAGES, CfgConstants.DEFAULT_SIGN_OR_REQUIRE_MNI_MESSAGES);
    }

    private synchronized Collection<SAML2Endpoint> readAllEndpoints() {
        if (this.isStateDeleted()) {
            throw new IllegalStateException("Configuration for SAML2 Provider is already deleted. Configuration path: " + this.getCfgPath());
        }
        if (this.endpointsALL != null) {
            return this.endpointsALL;
        }
        this.endpointsALL = new ArrayList<SAML2Endpoint>();
        this.endpointsACS = new ArrayList<SAML2Endpoint>();
        this.endpointsARS = new ArrayList<SAML2Endpoint>();
        this.endpointsSLO = new ArrayList<SAML2Endpoint>();
        this.endpointsMNI = new ArrayList<SAML2Endpoint>();
        String[] endpointSheets = null;
        try {
            endpointSheets = this.getSubCfgPropertySheetNames(CFG_SUB_PATH_ENDPOINTS);
        }
        catch (CfgStorageException e) {
            LOCATION.traceThrowableT(500, "Could not load endpoints configuration", (Throwable)e);
        }
        if (endpointSheets != null) {
            String[] stringArray = endpointSheets;
            int n = endpointSheets.length;
            int n2 = 0;
            while (n2 < n) {
                String endpointSheet = stringArray[n2];
                SAML2EndpointImpl endpoint = new SAML2EndpointImpl(this, CFG_SUB_PATH_ENDPOINTS, endpointSheet);
                this.endpointsALL.add(endpoint);
                SAML2Service service = endpoint.getService();
                if (SAML2Service.ARTIFACT_RESOLUTION_SERVICE == service) {
                    this.endpointsARS.add(endpoint);
                } else if (SAML2Service.ASSERTION_CONSUMER_SERVICE == service) {
                    this.endpointsACS.add(endpoint);
                } else if (SAML2Service.SINGLE_LOGOUT_SERVICE == service) {
                    this.endpointsSLO.add(endpoint);
                } else if (SAML2Service.MANAGE_NAMEID_SERVICE == service) {
                    this.endpointsMNI.add(endpoint);
                } else if (LOCATION.beDebug()) {
                    LOCATION.debugT("Unsupported service for trusted SP: {0} is configured. Ignore this endpoint: {1}", new Object[]{service, endpoint});
                }
                ++n2;
            }
        }
        return this.endpointsALL;
    }

    private synchronized Collection<SAML2Endpoint> readACSEndpoints() {
        if (this.endpointsACS != null) {
            return this.endpointsACS;
        }
        this.readAllEndpoints();
        return this.endpointsACS;
    }

    private synchronized Collection<SAML2Endpoint> readARSEndpoints() {
        if (this.endpointsARS != null) {
            return this.endpointsARS;
        }
        this.readAllEndpoints();
        return this.endpointsARS;
    }

    private synchronized Collection<SAML2Endpoint> readSLOEndpoints() {
        if (this.endpointsSLO != null) {
            return this.endpointsSLO;
        }
        this.readAllEndpoints();
        return this.endpointsSLO;
    }

    private synchronized Collection<SAML2Endpoint> readMNIEndpoints() {
        if (this.endpointsMNI != null) {
            return this.endpointsMNI;
        }
        this.readAllEndpoints();
        return this.endpointsMNI;
    }

    @Override
    public SAML2ModifiableTrustedSP getModifiableTrustedSP() throws SAML2ConfigurationException {
        return new SAML2ModifiableTrustedSPImpl(this);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("\nCfg path: ").append(super.toString());
        builder.append("\nName: ").append(this.getName());
        builder.append("\nId: ").append(SAML2Utils.byteArrayToHEXString((byte[])this.getID()));
        builder.append("\nEnabled: ").append(this.isEnabled());
        builder.append("\nDescription: ").append(this.getDescription());
        builder.append("\nDefault nameId-format: ").append(this.getDefaultNameIdFormat());
        builder.append("\nCertificate for signature verification: ").append(this.getSigningCertificateName());
        builder.append("\nSecondary certificate for signature verification: ").append(this.getSecondarySigningCertificateName());
        builder.append("\nRequire signed AuthnRequests: ").append((Object)this.isToRequireSignedAuthnRequests());
        builder.append("\nSign assertions: ").append((Object)this.isToSignAssertions());
        builder.append("\nSign AuthnResponses: ").append((Object)this.isToSignAuthnResponses());
        builder.append("\nSign SLO messages: ").append((Object)this.isToSignSingleLogoutMessages());
        builder.append("\nRequire signed SLO messages: ").append((Object)this.isToRequireSignedSingleLogoutMessages());
        builder.append("\nSign ARS messages: ").append((Object)this.isToSignArtifactResolutionMessages());
        builder.append("\nRequire signed ARS messages: ").append((Object)this.isToRequireSignedArtifactResolutionMessages());
        builder.append("\nSign MNI messages: ").append((Object)this.isToSignManageNameIDMessages());
        builder.append("\nRequire signed MNI messages: ").append((Object)this.isToRequireSignedManageNameIDMessages());
        builder.append("\nCertificate for encryption: ").append(this.getEncryptionCertificateName());
        builder.append("\nEncryption algorithm: ").append(this.getEncryptionAlgorithm());
        builder.append("\nDigest algorithm: ").append(this.getDigestAlgorithm());
        builder.append("\nAuthnResponse elements to encrypt: ").append((Object)this.getAuthnResponseElementsToEncrypt());
        builder.append("\nEncrypt SLO subject: ").append(this.isToEncryptSingleLogoutSubject());
        builder.append("\nRequire encrypted SLO subject: ").append(this.isToRequireEncryptedSingleLogoutSubject());
        builder.append("\nEncrypt MNI subject: ").append(this.isToEncryptManageNameIDSubject());
        builder.append("\nRequire encrypted MNI subject: ").append(this.isToRequireEncryptedManageNameIDSubject());
        builder.append("\nEncrypt MNI NewID: ").append(this.isToEncryptManageNameIDNewID());
        builder.append("\nRequire encrypted MNI NewID: ").append(this.isToRequireEncryptedManageNameIDNewID());
        builder.append("\n");
        builder.append("\nEndpoints:\n").append(this.getAllEndpointsForTrace());
        builder.append("\n");
        builder.append(this.getAllNameIDFormatsForTrace());
        return builder.toString();
    }

    private String getAllEndpointsForTrace() {
        StringBuilder builder = new StringBuilder();
        for (SAML2Endpoint endpoint : this.getAllEndpoints()) {
            builder.append("" + endpoint).append(";\n");
        }
        return builder.toString();
    }

    private String getAllNameIDFormatsForTrace() {
        StringBuilder builder = new StringBuilder();
        com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormat nameIdFormat = this.getNameIdFormatEmail();
        builder.append("NameId-Format E-mail: ").append(nameIdFormat).append(";\n");
        nameIdFormat = this.getNameIdFormatKerberos();
        builder.append("NameId-Format Kerberos: ").append(nameIdFormat).append(";\n");
        nameIdFormat = this.getNameIdFormatPersistent();
        builder.append("NameId-Format Persistent: ").append(nameIdFormat).append(";\n");
        nameIdFormat = this.getNameIdFormatTransient();
        builder.append("NameId-Format Transient: ").append(nameIdFormat).append(";\n");
        nameIdFormat = this.getNameIdFormatUnspecified();
        builder.append("NameId-Format Unspecified: ").append(nameIdFormat).append(";\n");
        nameIdFormat = this.getNameIdFormatWindows();
        builder.append("NameId-Format Windows: ").append(nameIdFormat).append(";\n");
        nameIdFormat = this.getNameIdFormatX509();
        builder.append("NameId-Format X509: ").append(nameIdFormat).append(";\n");
        return builder.toString();
    }
}

