/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg;

import com.sap.security.saml2.cfg.SAML2CfgDeletionReportImpl;
import com.sap.security.saml2.cfg.SAML2CfgInternalUtils;
import com.sap.security.saml2.cfg.SAML2ConfigImpl;
import com.sap.security.saml2.cfg.SAML2ModifiableTrustedSPImpl;
import com.sap.security.saml2.cfg.SAML2TrustedProvidersConfigBase;
import com.sap.security.saml2.cfg.SAML2TrustedSPImpl;
import com.sap.security.saml2.cfg.SAML2UpdateableProviderBase;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.exceptions.SAML2ProviderAlreadyExistsException;
import com.sap.security.saml2.cfg.interfaces.SAML2CfgDeletionReport;
import com.sap.security.saml2.cfg.interfaces.SAML2TrustedSPsConfig;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalProvider;
import com.sap.security.saml2.cfg.interfaces.read.SAML2TrustedSP;
import com.sap.security.saml2.cfg.interfaces.write.SAML2ModifiableTrustedSP;
import com.sap.security.saml2.cfg.metadata.SAML2MetadataTrustedSP;
import com.sap.security.saml2.cfg.storage.CfgChangeEvent;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import com.sap.security.saml2.cfg.storage.StorageChangedListener;
import com.sap.security.saml2.cfg.util.CfgConstants;
import com.sap.security.saml2.cfg.util.CfgUtils;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2Utils;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.SimpleLogger;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class SAML2TrustedSPsConfigImpl
extends SAML2TrustedProvidersConfigBase
implements SAML2TrustedSPsConfig,
StorageChangedListener {
    private static final long serialVersionUID = 1L;
    static final String CFG_NODE_TRUSTED_SPS_REL_PATH = "/trusted_providers/trusted_sps";
    private static final Location LOCATION = Location.getLocation(SAML2TrustedSPsConfigImpl.class);
    private SAML2ConfigImpl parent;
    private Map<String, SAML2TrustedSP> trustedSPsByName = new HashMap<String, SAML2TrustedSP>();
    private Map<String, SAML2TrustedSP> trustedSPsByID = new HashMap<String, SAML2TrustedSP>();
    private Map<String, SAML2UpdateableProviderBase> updateableProviders = new HashMap<String, SAML2UpdateableProviderBase>();
    private Map<String, String> trustedSPNames = new HashMap<String, String>();

    public SAML2TrustedSPsConfigImpl(SAML2ConfigImpl parent) throws SAML2ConfigurationException {
        super(String.valueOf(parent.getCfgPath()) + CFG_NODE_TRUSTED_SPS_REL_PATH, null, false);
        this.parent = parent;
        try {
            this.registerAsStorageListener(this);
        }
        catch (CfgStorageException e) {
            LOCATION.traceThrowableT(500, "Could not register storage listener for trusted Service Providers with path: {0}", new Object[]{this.getCfgPath()}, (Throwable)e);
        }
        this.loadAllTrustedSPs();
    }

    private void addTrustedSP(String name, byte[] id, String cfgPath, SAML2TrustedSPImpl trustedSP) {
        this.trustedSPsByName.put(name, trustedSP);
        String key = SAML2Utils.byteArrayToHEXString((byte[])id);
        this.trustedSPsByID.put(key, trustedSP);
        this.updateableProviders.put(cfgPath, trustedSP);
        this.trustedSPNames.put(cfgPath, name);
    }

    private void removeTrustedSP(String cfgPath) {
        block3: {
            this.updateableProviders.remove(cfgPath);
            String trustedSPName = this.trustedSPNames.remove(cfgPath);
            if (trustedSPName != null) {
                this.trustedSPsByName.remove(trustedSPName);
                try {
                    byte[] id = SAML2Utils.calculateSha1Hash((String)trustedSPName);
                    String key = SAML2Utils.byteArrayToHEXString((byte[])id);
                    this.trustedSPsByID.remove(key);
                }
                catch (SAML2Exception e) {
                    if (!LOCATION.beWarning()) break block3;
                    LOCATION.traceThrowableT(400, "Could not calculate the ID of the trusted SP. It could not be cleaned now.", (Throwable)e);
                }
            }
        }
    }

    private void removeTrustedSP(String name, byte[] id, String cfgPath) {
        this.trustedSPsByName.remove(name);
        this.trustedSPNames.remove(cfgPath);
        this.updateableProviders.remove(cfgPath);
        String key = SAML2Utils.byteArrayToHEXString((byte[])id);
        this.trustedSPsByID.remove(key);
    }

    private synchronized void loadAllTrustedSPs() throws SAML2ConfigurationException {
        try {
            SAML2LocalProvider localProvider = this.getParent().getLocalProvidersConfiguration().getLocalProvider();
            String[] trustedSPPaths = this.getSubCfgPaths();
            if (trustedSPPaths != null) {
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("Trusted Service Providers paths are: {0}", new Object[]{Arrays.asList(trustedSPPaths)});
                }
                String[] stringArray = trustedSPPaths;
                int n = trustedSPPaths.length;
                int n2 = 0;
                while (n2 < n) {
                    String trustedSPPath = stringArray[n2];
                    if (trustedSPPath != null && trustedSPPath.length() > 0) {
                        SAML2TrustedSPImpl trustedSP = new SAML2TrustedSPImpl(trustedSPPath, localProvider);
                        String trustedSPName = trustedSP.getName();
                        byte[] trustedSPId = trustedSP.getID();
                        if (trustedSPName != null && trustedSPName.length() > 0) {
                            this.addTrustedSP(trustedSPName, trustedSPId, trustedSPPath, trustedSP);
                        } else if (LOCATION.beDebug()) {
                            LOCATION.debugT("Trusted Service Provider with path: {0} does not have a name. It cannot be added to the trusted providers list", new Object[]{trustedSPPath});
                        }
                    }
                    ++n2;
                }
            } else if (LOCATION.beDebug()) {
                LOCATION.debugT("There are not any trusted Service Providers to load");
            }
        }
        catch (CfgStorageException e) {
            throw new SAML2ConfigurationException("Could not load trusted Service Providers", e);
        }
    }

    void destroy() {
        try {
            this.unregisterAsStorageListener(this);
        }
        catch (CfgStorageException e) {
            LOCATION.traceThrowableT(500, "Could not unregister storage listener for trusted SAML2 service providers with path: {0}", new Object[]{this.getCfgPath()}, (Throwable)e);
        }
    }

    @Override
    public SAML2TrustedSP getTrustedSP(String name) {
        return this.trustedSPsByName.get(name);
    }

    @Override
    public SAML2TrustedSP getTrustedSPByID(byte[] id) {
        String key = SAML2Utils.byteArrayToHEXString((byte[])id);
        return this.trustedSPsByID.get(key);
    }

    @Override
    public synchronized SAML2ModifiableTrustedSP createTrustedSP(String name) throws SAML2ProviderAlreadyExistsException, SAML2ConfigurationException {
        return this.getModifiableTrustedSP(name, false);
    }

    private synchronized SAML2ModifiableTrustedSP getModifiableTrustedSP(String name, boolean couldUseExisting) throws SAML2ProviderAlreadyExistsException, SAML2ConfigurationException {
        if (name == null || name.length() < 1) {
            throw new SAML2ConfigurationException("Provider name cannot be empty");
        }
        if (this.trustedSPsByName.containsKey(name)) {
            if (!couldUseExisting) {
                throw new SAML2ProviderAlreadyExistsException("Trusted Service Provider with name: " + name + " already exists");
            }
            SAML2TrustedSP trustedSP = this.trustedSPsByName.get(name);
            SAML2ModifiableTrustedSP modifiableTrustedSP = trustedSP.getModifiableTrustedSP();
            return modifiableTrustedSP;
        }
        SAML2ModifiableTrustedSPImpl modifiableTrustedSP = new SAML2ModifiableTrustedSPImpl(this);
        modifiableTrustedSP.setName(name);
        return modifiableTrustedSP;
    }

    @Override
    public void createTrustedSP(SAML2MetadataTrustedSP trustedSP) throws SAML2ProviderAlreadyExistsException, SAML2ConfigurationException {
        this.createTrustedSP(trustedSP, false, false);
    }

    @Override
    public void createTrustedSP(SAML2MetadataTrustedSP trustedSP, boolean automatic, boolean overwrite) throws SAML2ProviderAlreadyExistsException, SAML2ConfigurationException {
        String providerName = trustedSP.getName();
        if (providerName == null || providerName.length() < 1) {
            throw new SAML2ConfigurationException("Trusted provider name cannot be empty");
        }
        SAML2ModifiableTrustedSP modifiableTrustedSP = this.getModifiableTrustedSP(providerName, overwrite);
        if (automatic) {
            modifiableTrustedSP.setEnabled(true);
        } else {
            modifiableTrustedSP.setEnabled(false);
        }
        String keystoreView = this.getParent().getLocalProvidersConfiguration().getLocalProvider().getKeyStoreViewName();
        trustedSP.fillInModifiableCfg(modifiableTrustedSP, keystoreView, automatic);
        modifiableTrustedSP.writeProvider();
    }

    @Override
    public synchronized void deleteTrustedSP(String name) throws SAML2ConfigurationException {
        SAML2TrustedSPImpl trustedSP = (SAML2TrustedSPImpl)this.trustedSPsByName.get(name);
        if (trustedSP != null) {
            String trustedSPForTrace = null;
            if (LOCATION.beDebug()) {
                trustedSPForTrace = trustedSP.toString();
            }
            String cfgPath = trustedSP.getCfgPath();
            byte[] id = trustedSP.getID();
            SAML2ModifiableTrustedSPImpl modifiableTrustedSP = (SAML2ModifiableTrustedSPImpl)trustedSP.getModifiableTrustedSP();
            modifiableTrustedSP.deleteProvider();
            this.removeTrustedSP(name, id, cfgPath);
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Deleted trusted SP: {0}", new Object[]{trustedSPForTrace});
            }
        } else {
            throw new SAML2ConfigurationException("Trusted SP with name: " + name + " does not exists");
        }
        SimpleLogger.log((int)300, (Category)CfgConstants.CHANGE_LOG_CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_cfg.001010", (String)"SAML2 trusted service provider with name: [{0}] was deleted.", (Object[])new Object[]{name});
    }

    @Override
    public synchronized SAML2CfgDeletionReport deleteTrustedSP(String name, boolean deleteCertificates, boolean deleteDestinations) throws SAML2ConfigurationException {
        Set<String> usedCertificates = null;
        Set<String> usedDestinations = null;
        SAML2TrustedSP trustedSP = this.trustedSPsByName.get(name);
        if (trustedSP != null) {
            if (deleteCertificates) {
                usedCertificates = SAML2CfgInternalUtils.getUsedCertificates(trustedSP);
            }
            if (deleteDestinations) {
                usedDestinations = SAML2CfgInternalUtils.getUsedDestinations(trustedSP);
            }
        }
        this.deleteTrustedSP(name);
        SAML2CfgDeletionReportImpl result = new SAML2CfgDeletionReportImpl();
        if (deleteCertificates) {
            String keystoreView = this.getParent().getLocalProvidersConfiguration().getLocalProvider().getKeyStoreViewName();
            if (keystoreView != null && keystoreView.length() > 0) {
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("Used certificate(s): {0} for trusted SP: {1} will be deleted", new Object[]{usedCertificates, name});
                }
                SAML2CfgInternalUtils.deleteCertificates(keystoreView, usedCertificates, result);
            } else if (LOCATION.beWarning()) {
                LOCATION.warningT("Could not delete the used certificates for trusted SP: {0}, because there is not configured keystore view: {1}", new Object[]{name, keystoreView});
            }
        }
        if (deleteDestinations) {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Used destination(s): {0} for trusted SP: {1} will be deleted", new Object[]{usedDestinations, name});
            }
            SAML2CfgInternalUtils.deleteDestinations(usedDestinations, result);
        }
        return result;
    }

    @Override
    public Collection<SAML2TrustedSP> getAllTrustedSPs() {
        return this.trustedSPsByName.values();
    }

    @Override
    public Collection<String> getAllTrustedSPNames() {
        return this.trustedSPsByName.keySet();
    }

    @Override
    public void storageChanged(CfgChangeEvent event) {
        CfgChangeEvent[] detailedEvents = event.getDetailedChangeEvents();
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Received detailed change events: {0}", new Object[]{Arrays.asList(detailedEvents)});
        }
        CfgChangeEvent lastEvent = detailedEvents[detailedEvents.length - 1];
        String lastEventPath = lastEvent.getPath();
        int action = lastEvent.getAction();
        String pathToTrustedSP = CfgUtils.extractRelativePathToFirstSubNode(lastEventPath, this.getCfgPath());
        if (CfgUtils.isOneSubNode(lastEventPath, this.getCfgPath()) && action == 2) {
            this.handleEventForDeletedTrustedSP(pathToTrustedSP);
        } else if (lastEventPath.endsWith("trusted_sp") && action == 1) {
            this.handleEventForCreatedTrustedSP(pathToTrustedSP);
        } else {
            this.handleEventForUpdatedTrustedSP(pathToTrustedSP);
        }
    }

    protected synchronized void createdNewTrustedSP(SAML2TrustedSPImpl trustedSP) {
        String name = trustedSP.getName();
        byte[] id = trustedSP.getID();
        if (name != null && name.length() > 0) {
            this.addTrustedSP(name, id, trustedSP.getCfgPath(), trustedSP);
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Created trusted SP: {0}", new Object[]{trustedSP});
            }
        } else if (LOCATION.beWarning()) {
            LOCATION.warningT("Service provider does not have a name. Could not be added to the trusted Service Providers list");
        }
    }

    private synchronized void handleEventForCreatedTrustedSP(String cfgPath) {
        if (!this.updateableProviders.containsKey(cfgPath)) {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Received event for created trusted SP with path: {0}", new Object[]{cfgPath});
            }
            SAML2LocalProvider localProvider = this.getParent().getLocalProvidersConfiguration().getLocalProvider();
            SAML2TrustedSPImpl trustedSP = new SAML2TrustedSPImpl(cfgPath, localProvider);
            String name = trustedSP.getName();
            byte[] id = trustedSP.getID();
            if (name != null && name.length() > 0) {
                this.addTrustedSP(name, id, trustedSP.getCfgPath(), trustedSP);
            } else if (LOCATION.beWarning()) {
                LOCATION.warningT("Service provider does not have a name. Could not be added to the trusted Service Providers list");
            }
        }
    }

    private synchronized void handleEventForDeletedTrustedSP(String cfgPath) {
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Received event for deleted trusted SP with path: {0}", new Object[]{cfgPath});
        }
        this.removeTrustedSP(cfgPath);
    }

    private synchronized void handleEventForUpdatedTrustedSP(String cfgPath) {
        SAML2UpdateableProviderBase updateableObject = this.updateableProviders.get(cfgPath);
        if (updateableObject != null) {
            updateableObject.update();
        } else if (LOCATION.beDebug()) {
            LOCATION.debugT("There is not trusted SP to update with path: {0}", new Object[]{cfgPath});
        }
    }

    protected SAML2ConfigImpl getParent() {
        return this.parent;
    }
}

