/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg;

import com.sap.security.saml2.cfg.SAML2CfgObject;
import com.sap.security.saml2.cfg.util.CfgUtils;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

abstract class SAML2UpdateableCfgObjectBase
extends SAML2CfgObject {
    private static final Location LOCATION = Location.getLocation(SAML2UpdateableCfgObjectBase.class);
    private Map<String, Object> cache = new HashMap<String, Object>();
    private boolean isStateDeleted = false;

    SAML2UpdateableCfgObjectBase(String cfgPath, String cfgSheet) {
        super(cfgPath, cfgSheet, true);
    }

    synchronized void delete() {
        this.isStateDeleted = true;
        this.cache.clear();
        this.cleanCachedObjects();
    }

    synchronized void update() {
        this.cache.clear();
        this.cleanCachedObjects();
    }

    protected abstract void cleanCachedObjects();

    protected String readProperty(String key) {
        return this.readProperty(key, null);
    }

    protected synchronized String readProperty(String key, String defaultValue) {
        String result;
        if (this.isStateDeleted) {
            throw new IllegalStateException("Configuration for SAML2 Provider is already deleted. Configuration path: " + this.getCfgPath());
        }
        if (this.cache.containsKey(key)) {
            result = (String)this.cache.get(key);
        } else {
            result = this.getPropertyValue(key, defaultValue).getValue();
            this.cache.put(key, result);
        }
        return result;
    }

    protected synchronized int readIntProperty(String key, int defaultValue) {
        Integer result;
        if (this.isStateDeleted) {
            throw new IllegalStateException("Configuration for SAML2 Provider is already deleted. Configuration path: " + this.getCfgPath());
        }
        if (this.cache.containsKey(key)) {
            result = (Integer)this.cache.get(key);
        } else {
            block8: {
                String dbValue = this.getPropertyValue(key, null).getValue();
                if (dbValue == null || dbValue.length() < 1) {
                    if (LOCATION.beDebug()) {
                        LOCATION.debugT("There is not configured property: {0}. Use default value: {1}", new Object[]{key, defaultValue});
                    }
                    result = new Integer(defaultValue);
                } else {
                    try {
                        result = Integer.parseInt(dbValue);
                    }
                    catch (Exception exception) {
                        result = new Integer(defaultValue);
                        if (!LOCATION.beDebug()) break block8;
                        LOCATION.debugT("Could not parse configured property: {0}. Use default value: {1}", new Object[]{key, defaultValue});
                    }
                }
            }
            this.cache.put(key, result);
        }
        return result;
    }

    protected Integer readIntegerProperty(String key) {
        Integer result;
        block3: {
            result = null;
            String dbValue = this.readProperty(key);
            if (!CfgUtils.isEmpty(dbValue)) {
                try {
                    result = Integer.parseInt(dbValue);
                }
                catch (NumberFormatException numberFormatException) {
                    if (!LOCATION.beDebug()) break block3;
                    LOCATION.debugT("Could not parse the value:{0} of the configured property: {1} as Integer", new Object[]{dbValue, key});
                }
            }
        }
        return result;
    }

    protected synchronized List<String> readMultiValueProperty(String key) {
        List<Object> result;
        if (this.isStateDeleted()) {
            throw new IllegalStateException("Configuration for SAML2 object is deleted. Configuration path: " + this.getCfgPath());
        }
        if (this.getCache().containsKey(key)) {
            result = (List)this.getCache().get(key);
        } else {
            String[] values = this.getPropertyValue(key, null).getValues();
            result = values == null || values.length < 1 ? Collections.unmodifiableList(new ArrayList(0)) : Collections.unmodifiableList(Arrays.asList(values));
            this.getCache().put(key, result);
        }
        return result;
    }

    protected boolean isStateDeleted() {
        return this.isStateDeleted;
    }

    protected Map<String, Object> getCache() {
        return this.cache;
    }
}

