/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg;

import com.sap.security.saml2.cfg.SAML2UpdateableCfgObjectBase;
import com.sap.security.saml2.cfg.enums.EncryptionOption;
import com.sap.security.saml2.cfg.enums.ResponseRequirementType;
import com.sap.security.saml2.cfg.enums.SAML2Binding;
import com.sap.security.saml2.cfg.enums.SAML2IdPSelectionMode;
import com.sap.security.saml2.cfg.enums.SignatureOption;
import com.sap.security.saml2.cfg.interfaces.read.SAML2Provider;
import com.sap.security.saml2.cfg.util.CfgUtils;
import com.sap.security.saml2.lib.common.SAML2Utils;
import com.sap.tc.logging.Location;
import java.util.Set;

abstract class SAML2UpdateableProviderBase
extends SAML2UpdateableCfgObjectBase
implements SAML2Provider {
    private static final Location LOCATION = Location.getLocation(SAML2UpdateableProviderBase.class);
    protected static final String KEY_ID = "id";
    protected static final String KEY_NAME = "name";

    SAML2UpdateableProviderBase(String cfgPath, String cfgSheet) {
        super(cfgPath, cfgSheet);
    }

    @Override
    public String getName() {
        return this.readProperty(KEY_NAME);
    }

    @Override
    public byte[] getID() {
        return this.readProviderID();
    }

    protected synchronized byte[] readProviderID() {
        if (this.isStateDeleted()) {
            throw new IllegalStateException("Configuration for SAML2 Provider is already deleted. Configuration path: " + this.getCfgPath());
        }
        byte[] result = new byte[20];
        if (this.getCache().containsKey(KEY_ID)) {
            result = (byte[])this.getCache().get(KEY_ID);
        } else {
            String providerName = this.getName();
            if (providerName != null && providerName.length() > 0) {
                try {
                    result = SAML2Utils.calculateSha1Hash((String)providerName);
                    this.getCache().put(KEY_ID, result);
                }
                catch (Exception e) {
                    if (LOCATION.beError()) {
                        LOCATION.traceThrowableT(500, "Failed to calculate provider ID", (Throwable)e);
                    }
                }
            } else if (LOCATION.beDebug()) {
                LOCATION.debugT("Provider name is empty. Could not calculate provider ID. Provider configuration path is: {0}", new Object[]{this.getCfgPath()});
            }
        }
        return result;
    }

    protected synchronized Set<SAML2Binding> readSupportedBindings(String key) {
        Set<SAML2Binding> result;
        if (this.isStateDeleted()) {
            throw new IllegalStateException("Configuration for SAML2 Provider is already deleted. Configuration path: " + this.getCfgPath());
        }
        if (this.getCache().containsKey(key)) {
            result = (Set<SAML2Binding>)this.getCache().get(key);
        } else {
            String[] bindingNames = this.getPropertyValue(key, null).getValues();
            result = CfgUtils.deserializeSAML2Bindings(bindingNames);
            this.getCache().put(key, result);
        }
        return result;
    }

    protected SignatureOption readSignatureOption(String key) {
        return this.readSignatureOption(key, SignatureOption.ALWAYS);
    }

    protected SignatureOption readSignatureOption(String key, SignatureOption defaultValue) {
        SignatureOption result = defaultValue;
        String optionName = this.readProperty(key);
        if (optionName != null && optionName.length() > 0) {
            SignatureOption option = SignatureOption.valueOf(optionName);
            if (option != null) {
                result = option;
            } else if (LOCATION.beDebug()) {
                LOCATION.debugT("Configured value: {0} for property: {1} is not valid SignatureOption value. Will be used the default one: {2}", new Object[]{optionName, key, defaultValue});
            }
        } else if (LOCATION.beDebug()) {
            LOCATION.debugT("There is not configured value for property: {0}. Will be used the default one: {1}", new Object[]{key, defaultValue});
        }
        return result;
    }

    protected EncryptionOption readEncryptionOption(String key) {
        return this.readEncryptionOption(key, EncryptionOption.NONE);
    }

    protected EncryptionOption readEncryptionOption(String key, EncryptionOption defaultValue) {
        EncryptionOption result = defaultValue;
        String optionName = this.readProperty(key);
        if (optionName != null && optionName.length() > 0) {
            EncryptionOption option = EncryptionOption.valueOf(optionName);
            if (option != null) {
                result = option;
            } else if (LOCATION.beDebug()) {
                LOCATION.debugT("Configured value: {0} for property: {1} is not valid EncryptionOption value. Will be used the default one: {2}", new Object[]{optionName, key, defaultValue});
            }
        } else if (LOCATION.beDebug()) {
            LOCATION.debugT("There is not configured value for property: {0}. Will be used the default one: {1}", new Object[]{key, defaultValue});
        }
        return result;
    }

    protected ResponseRequirementType readResponseRequirementType(String key, ResponseRequirementType defaultValue) {
        ResponseRequirementType result = defaultValue;
        String optionName = this.readProperty(key);
        if (optionName != null && optionName.length() > 0) {
            ResponseRequirementType option = ResponseRequirementType.valueOf(optionName);
            if (option != null) {
                result = option;
            } else if (LOCATION.beDebug()) {
                LOCATION.debugT("Configured value: {0} for property: {1} is not valid ResponseRequirementType value. Will be used the default one: {2}", new Object[]{optionName, key, defaultValue});
            }
        } else if (LOCATION.beDebug()) {
            LOCATION.debugT("There is not configured value for property: {0}. Will be used the default one: {1}", new Object[]{key, defaultValue});
        }
        return result;
    }

    protected SAML2IdPSelectionMode readIdPSelectionMode(String key, SAML2IdPSelectionMode defaultValue) {
        SAML2IdPSelectionMode result = defaultValue;
        String optionName = this.readProperty(key);
        if (optionName != null && optionName.length() > 0) {
            SAML2IdPSelectionMode mode = SAML2IdPSelectionMode.valueOf(optionName);
            if (mode != null) {
                result = mode;
            } else if (LOCATION.beDebug()) {
                LOCATION.debugT("Configured value: {0} for property: {1} is not valid SAML2IdPSelectionMode value. Will be used the default one: {2}", new Object[]{optionName, key, defaultValue});
            }
        } else if (LOCATION.beDebug()) {
            LOCATION.debugT("There is not configured value for property: {0}. Will be used the default one: {1}", new Object[]{key, defaultValue});
        }
        return result;
    }
}

