/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.custom;

import com.sap.security.core.server.destinations.api.HTTPDestination;
import com.sap.security.saml2.cfg.enums.SAML2Binding;
import com.sap.security.saml2.cfg.enums.SAML2Service;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.interfaces.read.SAML2Endpoint;

public class SAML2EndpointCustomImpl
implements SAML2Endpoint {
    private SAML2Service service;
    private SAML2Binding binding;
    private String location;
    private String responseLocation;
    private String destinationName;
    private Integer index;
    private boolean isDefault;

    public SAML2EndpointCustomImpl(SAML2Service service, SAML2Binding binding, String location) throws IllegalArgumentException {
        if (service == null) {
            throw new IllegalArgumentException("SAML2 service argument is mandatory attribute.");
        }
        if (binding == null) {
            throw new IllegalArgumentException("SAML2 binding argument is mandatory attribute.");
        }
        if (location == null) {
            throw new IllegalArgumentException("Location argument is mandatory attribute.");
        }
        this.service = service;
        this.binding = binding;
        this.location = location;
    }

    public SAML2EndpointCustomImpl(SAML2Service service, String destinationName) throws IllegalArgumentException {
        if (service == null) {
            throw new IllegalArgumentException("SAML2 service argument is mandatory attribute.");
        }
        if (destinationName == null) {
            throw new IllegalArgumentException("Destination name argument is mandatory attribute.");
        }
        this.service = service;
        this.binding = SAML2Binding.SOAP_BINDING;
        this.destinationName = destinationName;
    }

    public void setService(SAML2Service service) {
        this.service = service;
    }

    public void setBinding(SAML2Binding binding) {
        this.binding = binding;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setResponseLocation(String responseLocation) {
        this.responseLocation = responseLocation;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    @Override
    public SAML2Binding getBinding() {
        return this.binding;
    }

    @Override
    public String getDestinationName() {
        return this.destinationName;
    }

    @Override
    public HTTPDestination getDestination() throws SAML2ConfigurationException {
        return null;
    }

    @Override
    public int getIndex() {
        if (this.index != null) {
            return this.index;
        }
        return -1;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public String getResponseLocation() {
        return this.responseLocation;
    }

    @Override
    public SAML2Service getService() {
        return this.service;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }
}

