/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.custom;

import com.sap.security.saml2.cfg.custom.SAML2ConfigurationCustomConstants;
import com.sap.security.saml2.cfg.custom.SAML2LocalProviderCustomImpl;
import com.sap.security.saml2.cfg.enums.SAML2Binding;
import com.sap.security.saml2.cfg.enums.SAML2BindingDirection;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.interfaces.read.SAML2Affiliation;
import com.sap.security.saml2.cfg.interfaces.read.SAML2IdPAuthenticationContext;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalIdP;
import com.sap.security.saml2.cfg.interfaces.read.SAML2RedirectApplicationConfiguration;
import com.sap.security.saml2.cfg.interfaces.write.SAML2ModifiableLocalIdP;
import java.security.PrivateKey;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class SAML2LocalIdPCustomImpl
extends SAML2LocalProviderCustomImpl
implements SAML2LocalIdP {
    private int assertionValidityNotAfterInMinutes;
    private int assertionValidityNotBeforeInMinutes;
    private int sessionLifetimeInMinutes;
    private String ssoLocationRelative = null;
    private Set<SAML2Binding> ssoSupportedBindings = null;
    private String mniLocationRelative = null;
    private Set<SAML2Binding> mniSupportedBindings = null;
    private String sloLocationRelative = null;
    private Set<SAML2Binding> sloSupportedBindings = null;

    public SAML2LocalIdPCustomImpl(String name, PrivateKey signingKey, PrivateKey decryptionKey) throws IllegalArgumentException {
        super(name, signingKey, decryptionKey);
    }

    public void setAssertionValidityNotAfter(int assertionValidityNotAfterInMinutes) {
        this.assertionValidityNotAfterInMinutes = assertionValidityNotAfterInMinutes;
    }

    public void setAssertionValidityNotBefore(int assertionValidityNotBeforeInMinutes) {
        this.assertionValidityNotBeforeInMinutes = assertionValidityNotBeforeInMinutes;
    }

    public void setSessionLifetime(int sessionLifetimeInMinutes) {
        this.sessionLifetimeInMinutes = sessionLifetimeInMinutes;
    }

    @Override
    public SAML2Affiliation getAffiliation(String affiliationName) {
        return null;
    }

    @Override
    public Collection<SAML2Affiliation> getAffiliations() {
        return null;
    }

    @Override
    public int getAssertionValidityNotAfterInMinutes() {
        if (this.assertionValidityNotAfterInMinutes > 0) {
            return this.assertionValidityNotAfterInMinutes;
        }
        return 10;
    }

    @Override
    public int getAssertionValidityNotBeforeInMinutes() {
        if (this.assertionValidityNotBeforeInMinutes > 0) {
            return this.assertionValidityNotBeforeInMinutes;
        }
        return 5;
    }

    @Override
    public String getCDCDomain() {
        return null;
    }

    @Override
    public int getCDCDomainRelaxationLevel() {
        return 1;
    }

    @Override
    public int getCDCMaxAge() {
        return -1;
    }

    @Override
    public List<SAML2IdPAuthenticationContext> getDefaultIdPAuthnContextsHTTP() {
        return null;
    }

    @Override
    public List<SAML2IdPAuthenticationContext> getDefaultIdPAuthnContextsHTTPS() {
        return null;
    }

    @Override
    public String getExternalIdPDiscoveryWriteServiceUrl() {
        return null;
    }

    @Override
    public int getGlobalSessionLifetimeInSeconds() {
        if (this.sessionLifetimeInMinutes > 0) {
            return this.sessionLifetimeInMinutes * 60;
        }
        return 3600;
    }

    @Override
    public SAML2IdPAuthenticationContext getIdPAuthnContextByAlias(String authnContextAlias) {
        return null;
    }

    @Override
    public SAML2IdPAuthenticationContext getIdPAuthnContextByName(String authnContextName) {
        return null;
    }

    @Override
    public Collection<SAML2IdPAuthenticationContext> getIdPAuthnContexts() {
        return null;
    }

    @Override
    public SAML2BindingDirection getIdPInitiatedSingleLogoutDirection() {
        return null;
    }

    @Override
    public SAML2ModifiableLocalIdP getModifiableLocalIdP() throws SAML2ConfigurationException {
        return null;
    }

    @Override
    public Integer getProxyRestriction() {
        return 1;
    }

    @Override
    public String getManageNameIDLocationHardCoded() {
        return this.getManageNameIDLocation();
    }

    public String getManageNameIDLocation() {
        if (this.mniLocationRelative != null) {
            return this.mniLocationRelative;
        }
        return "/saml2/idp/mni";
    }

    public void setManageNameIDLocation(String location) {
        this.mniLocationRelative = location;
    }

    @Override
    public Set<SAML2Binding> getManageNameIDSupportedBindings() {
        if (this.mniSupportedBindings != null) {
            return this.mniSupportedBindings;
        }
        return SAML2ConfigurationCustomConstants.SUPPORTED_BINDINGS_MANAGE_NAME_ID;
    }

    public void setManageNameIDSupportedBindings(Set<SAML2Binding> supportedBindings) {
        this.mniSupportedBindings = supportedBindings;
    }

    @Override
    public String getSingleLogoutLocationHardCoded() {
        return this.getSingleLogoutLocation();
    }

    public String getSingleLogoutLocation() {
        if (this.sloLocationRelative != null) {
            return this.sloLocationRelative;
        }
        return "/saml2/idp/slo";
    }

    public void setSingleLogoutLocation(String location) {
        this.sloLocationRelative = location;
    }

    @Override
    public Set<SAML2Binding> getSingleLogoutSupportedBindings() {
        if (this.sloSupportedBindings != null) {
            return this.sloSupportedBindings;
        }
        return SAML2ConfigurationCustomConstants.SUPPORTED_BINDINGS_SINGLE_LOGOUT;
    }

    public void setSingleLogoutSupportedBindings(Set<SAML2Binding> supportedBindings) {
        this.sloSupportedBindings = supportedBindings;
    }

    @Override
    public String getSingleSignOnLocationHardCoded() {
        return this.getSingleSignOnLocation();
    }

    public String getSingleSignOnLocation() {
        if (this.ssoLocationRelative != null) {
            return this.ssoLocationRelative;
        }
        return "/saml2/idp/sso";
    }

    public void setSingleSignOnLocation(String location) {
        this.ssoLocationRelative = location;
    }

    @Override
    public Set<SAML2Binding> getSingleSignOnSupportedBindings() {
        if (this.ssoSupportedBindings != null) {
            return this.ssoSupportedBindings;
        }
        return SAML2ConfigurationCustomConstants.SUPPORTED_BINDINGS_SINGLE_SIGN_ON;
    }

    public void setSingleSignOnSupportedBindings(Set<SAML2Binding> supportedBindings) {
        this.ssoSupportedBindings = supportedBindings;
    }

    @Override
    public Set<String> getSupportedIdPAuthnContextNames() {
        return EMPTY_SET;
    }

    @Override
    public boolean isDisplaySAML2ErrorPageEnabled() {
        return false;
    }

    @Override
    public boolean isIdPInitiatedSLOEnabled() {
        return true;
    }

    @Override
    public boolean isIdPInitiatedSSOEnabled() {
        return true;
    }

    @Override
    public boolean isIdPInitiatedMNIEnabled() {
        return false;
    }

    @Override
    public boolean isMultipleGlobalSessionsAllowed() {
        return true;
    }

    @Override
    public boolean isProxyingEnforced() {
        return false;
    }

    @Override
    public boolean isSPInitiatedSLOEnabled() {
        return true;
    }

    @Override
    public boolean isSPInitiatedSSOEnabled() {
        return true;
    }

    @Override
    public boolean isSPInitiatedMNIEnabled() {
        return false;
    }

    @Override
    public boolean isToUseExternalIdPDiscoveryWriteService() {
        return false;
    }

    @Override
    public boolean isToUseInternalIdPDiscoveryWriteService() {
        return false;
    }

    @Override
    public boolean isToAddSessionNotOnOrAfter() {
        return false;
    }

    @Override
    public SAML2RedirectApplicationConfiguration getRedirectApplicationConfiguration() {
        return null;
    }
}

