/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.custom;

import com.sap.security.saml2.cfg.custom.SAML2ConfigurationCustomConstants;
import com.sap.security.saml2.cfg.custom.SAML2ProviderCustomImpl;
import com.sap.security.saml2.cfg.enums.SAML2Binding;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.interfaces.read.SAML2BackChannelSecurityPolicy;
import com.sap.security.saml2.cfg.interfaces.read.SAML2CfgAuthenticationContext;
import com.sap.security.saml2.cfg.interfaces.read.SAML2CfgUMEAttribute;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalProvider;
import com.sap.security.saml2.cfg.interfaces.read.SAML2MetadataSettings;
import com.sap.security.saml2.cfg.interfaces.write.SAML2ModifiableLocalProvider;
import java.security.PrivateKey;
import java.util.Collection;
import java.util.Set;

public abstract class SAML2LocalProviderCustomImpl
extends SAML2ProviderCustomImpl
implements SAML2LocalProvider {
    private PrivateKey signingKey;
    private PrivateKey decryptionKey;
    private Integer clockSkewToleranceInSeconds;
    private Integer issueInstantValidityNotBeforeInMinutes;
    private Integer issueInstantValidityNotAfterInMinutes;
    private Boolean plainHTTPConnectionsEnabled;
    private Boolean isToIncludeCertInSignatures;
    private Boolean isToSignMetadata;
    private String arsLocationRelative = null;
    private Set<SAML2Binding> arsSupportedBindings = null;
    private SAML2MetadataSettings metadataSettings = null;

    public SAML2LocalProviderCustomImpl(String name, PrivateKey signingKey, PrivateKey decryptionKey) throws IllegalArgumentException {
        super(name);
        this.signingKey = signingKey;
        this.decryptionKey = decryptionKey;
    }

    public void setSigningPrivateKey(PrivateKey signingKey) {
        this.signingKey = signingKey;
    }

    public void setDecryptionPrivateKey(PrivateKey decryptionKey) {
        this.decryptionKey = decryptionKey;
    }

    public void setClockSkewToleranceInSeconds(Integer clockSkewToleranceInSeconds) {
        this.clockSkewToleranceInSeconds = clockSkewToleranceInSeconds;
    }

    public void setIssueInstantValidityNotBeforeInMinutes(Integer issueInstantValidityNotBeforeInMinutes) {
        this.issueInstantValidityNotBeforeInMinutes = issueInstantValidityNotBeforeInMinutes;
    }

    public void setIssueInstantValidityNotAfterInMinutes(Integer issueInstantValidityNotAfterInMinutes) {
        this.issueInstantValidityNotAfterInMinutes = issueInstantValidityNotAfterInMinutes;
    }

    public void setPlainHTTPConnectionsEnabled(Boolean plainHTTPConnectionsEnabled) {
        this.plainHTTPConnectionsEnabled = plainHTTPConnectionsEnabled;
    }

    public void setIsToIncludeCertInSignatures(Boolean isToIncludeCertInSignatures) {
        this.isToIncludeCertInSignatures = isToIncludeCertInSignatures;
    }

    public void setIsToSignMetadata(Boolean isToSignMetadata) {
        this.isToSignMetadata = isToSignMetadata;
    }

    @Override
    public PrivateKey getPrivateKeyForEncryption() throws SAML2ConfigurationException {
        return this.decryptionKey;
    }

    @Override
    public PrivateKey getPrivateKeyForSignature() throws SAML2ConfigurationException {
        return this.signingKey;
    }

    @Override
    public String getArtifactResolutionLocationHardCoded() {
        return this.getArtifactResolutionLocation();
    }

    public String getArtifactResolutionLocation() {
        if (this.arsLocationRelative != null) {
            return this.arsLocationRelative;
        }
        return "/saml2/ars";
    }

    public void setArtifactResolutionLocation(String location) {
        this.arsLocationRelative = location;
    }

    @Override
    public Set<SAML2Binding> getArtifactResolutionSupportedBindings() {
        if (this.arsSupportedBindings != null) {
            return this.arsSupportedBindings;
        }
        return SAML2ConfigurationCustomConstants.SUPPORTED_BINDINGS_ARTIFACT_RESOLUTION;
    }

    public void setArtifactResolutionSupportedBindings(Set<SAML2Binding> supportedBindings) {
        this.arsSupportedBindings = supportedBindings;
    }

    @Override
    public int getArtifactValidityPeriodInSeconds() {
        return 60;
    }

    @Override
    public SAML2CfgAuthenticationContext getAuthenticationContextByAlias(String arg0) {
        return null;
    }

    @Override
    public SAML2CfgAuthenticationContext getAuthenticationContextByName(String arg0) {
        return null;
    }

    @Override
    public Collection<SAML2CfgAuthenticationContext> getAuthenticationContexts() {
        return EMPTY_COLLECTION_AUTHN_CONTEXTS;
    }

    @Override
    public SAML2BackChannelSecurityPolicy getBackChannelSecurityPolicy() {
        return null;
    }

    @Override
    public SAML2MetadataSettings getMetadataSettings() {
        return this.metadataSettings;
    }

    public void setMetadataSettings(SAML2MetadataSettings metadataSettings) {
        this.metadataSettings = metadataSettings;
    }

    @Override
    public int getClockSkewToleranceInSeconds() {
        if (this.clockSkewToleranceInSeconds == null || this.clockSkewToleranceInSeconds < 0) {
            return 120;
        }
        return this.clockSkewToleranceInSeconds;
    }

    @Override
    public String getCustomLogonPageAlias() {
        return null;
    }

    @Override
    public String getEncryptionKeyPairName() {
        return null;
    }

    @Override
    public int getIssueInstantValidityNotAfterInMinutes() {
        if (this.issueInstantValidityNotAfterInMinutes == null || this.issueInstantValidityNotAfterInMinutes < 1) {
            return 10;
        }
        return this.issueInstantValidityNotAfterInMinutes;
    }

    @Override
    public int getIssueInstantValidityNotBeforeInMinutes() {
        if (this.issueInstantValidityNotBeforeInMinutes == null || this.issueInstantValidityNotBeforeInMinutes < 1) {
            return 5;
        }
        return this.issueInstantValidityNotBeforeInMinutes;
    }

    @Override
    public String getKeyStoreViewName() {
        return null;
    }

    @Override
    public SAML2ModifiableLocalProvider getModifiableLocalProvider() throws SAML2ConfigurationException {
        return null;
    }

    @Override
    public String getSigningKeyPairName() {
        return null;
    }

    @Override
    public String getTrustedCAsViewName() {
        return null;
    }

    @Override
    public SAML2CfgUMEAttribute getUMEAttributeByAlias(String arg0) {
        return null;
    }

    @Override
    public Collection<SAML2CfgUMEAttribute> getUMEAttributes() {
        return EMPTY_COLLECTION_UME_ATTRIBUTES;
    }

    @Override
    public boolean isPlainHTTPConnectionsEnabled() {
        if (this.plainHTTPConnectionsEnabled == null) {
            return true;
        }
        return this.plainHTTPConnectionsEnabled;
    }

    @Override
    public boolean isToIncludeCertInSignature() {
        if (this.isToIncludeCertInSignatures == null) {
            return false;
        }
        return this.isToIncludeCertInSignatures;
    }

    @Override
    public boolean isToSignMetadata() {
        if (this.isToSignMetadata == null) {
            return false;
        }
        return this.isToSignMetadata;
    }

    @Override
    public boolean issueSAPLogonTickets() {
        return false;
    }
}

