/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.custom;

import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.interfaces.read.SAML2CfgAuthenticationContext;
import com.sap.security.saml2.cfg.interfaces.read.SAML2CfgUMEAttribute;
import com.sap.security.saml2.cfg.interfaces.read.SAML2Provider;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2Utils;
import com.sap.tc.logging.Location;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class SAML2ProviderCustomImpl
implements SAML2Provider {
    protected static final Map<String, String> EMPTY_MAP = new HashMap<String, String>(0);
    protected static final Set<String> EMPTY_SET = new HashSet<String>(0);
    protected static final Collection<SAML2CfgUMEAttribute> EMPTY_COLLECTION_UME_ATTRIBUTES = new ArrayList<SAML2CfgUMEAttribute>(0);
    protected static final Collection<SAML2CfgAuthenticationContext> EMPTY_COLLECTION_AUTHN_CONTEXTS = new ArrayList<SAML2CfgAuthenticationContext>(0);
    private static final Location LOCATION = Location.getLocation(SAML2ProviderCustomImpl.class);
    private String name;
    private Certificate signingCertificate;
    private Certificate encryptionCertificate;

    public SAML2ProviderCustomImpl(String name) throws IllegalArgumentException {
        if (name == null || name.length() < 1) {
            throw new IllegalArgumentException("Name is mandatory argument.");
        }
        this.name = name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSigningCertificate(X509Certificate certificate) {
        this.signingCertificate = certificate;
    }

    public void setEncryptionCertificate(X509Certificate certificate) {
        this.encryptionCertificate = certificate;
    }

    @Override
    public Certificate getCertificateForEncryption() throws SAML2ConfigurationException {
        return this.encryptionCertificate;
    }

    @Override
    public Certificate getCertificateForSignature() throws SAML2ConfigurationException {
        return this.signingCertificate;
    }

    @Override
    public byte[] getID() {
        try {
            return SAML2Utils.calculateSha1Hash((String)this.name);
        }
        catch (SAML2Exception e) {
            if (LOCATION.beWarning()) {
                LOCATION.traceThrowableT(400, "Could not generate provider ID from the name: {0}", new Object[]{this.name}, (Throwable)e);
            }
            return new byte[0];
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public PublicKey getPublicKeyForEncryption() throws SAML2ConfigurationException {
        Certificate certificate = this.getCertificateForEncryption();
        if (certificate != null) {
            return certificate.getPublicKey();
        }
        return null;
    }
}

