/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.custom;

import com.sap.security.saml2.cfg.custom.SAML2ConfigurationCustomConstants;
import com.sap.security.saml2.cfg.custom.SAML2EndpointCustomImpl;
import com.sap.security.saml2.cfg.custom.SAML2TrustedProviderCustomImpl;
import com.sap.security.saml2.cfg.enums.ComparisonMethod;
import com.sap.security.saml2.cfg.enums.EncryptionOption;
import com.sap.security.saml2.cfg.enums.ResponseRequirementType;
import com.sap.security.saml2.cfg.enums.SAML2Binding;
import com.sap.security.saml2.cfg.enums.SAML2NameIdFormat;
import com.sap.security.saml2.cfg.enums.SAML2Service;
import com.sap.security.saml2.cfg.enums.SignatureOption;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.interfaces.read.SAML2Endpoint;
import com.sap.security.saml2.cfg.interfaces.read.SAML2ExtensionSupplierDescriptor;
import com.sap.security.saml2.cfg.interfaces.read.SAML2TrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2IdentityFederationTrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatEmail;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatKerberosTrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatPersistentTrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatTransientTrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatUnspecified;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatWindows;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatX509TrustedIdP;
import com.sap.security.saml2.cfg.interfaces.write.SAML2ModifiableTrustedIdP;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class SAML2TrustedIdPCustomImpl
extends SAML2TrustedProviderCustomImpl
implements SAML2TrustedIdP {
    private List<String> requestedAuthenticationContexts;
    private String requestedSPNameQualifier;
    private Boolean requestedAllowCreate;
    private Integer responseRequirementAssertionConsumerIndex;
    private String responseRequirementAssertionConsumerURL;
    private SAML2Binding responseRequirementBinding;
    private SignatureOption signAuthnRequests;
    private SignatureOption requireSignedAssertions;
    private SignatureOption requireSignedAuthnResponses;
    private ResponseRequirementType responseRequirementType;

    public SAML2TrustedIdPCustomImpl(String name, X509Certificate signingCert, String ssoLocationUrl) throws IllegalArgumentException {
        this(name, signingCert, ssoLocationUrl, null, null);
    }

    public SAML2TrustedIdPCustomImpl(String name, X509Certificate signingCert, String ssoLocationUrl, String sloLocationUrl, String arsLocationUrl) throws IllegalArgumentException {
        this(name, signingCert, SAML2TrustedIdPCustomImpl.convertToFrontChannelEndpoints(ssoLocationUrl, sloLocationUrl, arsLocationUrl));
    }

    private static Collection<SAML2Endpoint> convertToFrontChannelEndpoints(String ssoLocationUrl, String sloLocationUrl, String arsLocationUrl) {
        ArrayList<SAML2Endpoint> result = new ArrayList<SAML2Endpoint>();
        if (ssoLocationUrl != null && ssoLocationUrl.length() > 0) {
            SAML2EndpointCustomImpl defaultSSOEndpoint = new SAML2EndpointCustomImpl(SAML2Service.SINGLE_SIGN_ON_SERVICE, SAML2Binding.HTTP_REDIRECT_BINDING, ssoLocationUrl);
            defaultSSOEndpoint.setDefault(true);
            result.add(defaultSSOEndpoint);
            result.add(new SAML2EndpointCustomImpl(SAML2Service.SINGLE_SIGN_ON_SERVICE, SAML2Binding.HTTP_POST_BINDING, ssoLocationUrl));
        }
        if (sloLocationUrl != null && sloLocationUrl.length() > 0) {
            SAML2EndpointCustomImpl defaltSLOEndpoint = new SAML2EndpointCustomImpl(SAML2Service.SINGLE_LOGOUT_SERVICE, SAML2Binding.HTTP_REDIRECT_BINDING, sloLocationUrl);
            defaltSLOEndpoint.setDefault(true);
            result.add(defaltSLOEndpoint);
            result.add(new SAML2EndpointCustomImpl(SAML2Service.SINGLE_LOGOUT_SERVICE, SAML2Binding.HTTP_POST_BINDING, sloLocationUrl));
        }
        if (arsLocationUrl != null && arsLocationUrl.length() > 0) {
            SAML2EndpointCustomImpl arsEndpoint = new SAML2EndpointCustomImpl(SAML2Service.ARTIFACT_RESOLUTION_SERVICE, SAML2Binding.SOAP_BINDING, arsLocationUrl);
            arsEndpoint.setIndex(0);
            result.add(arsEndpoint);
        }
        return result;
    }

    public SAML2TrustedIdPCustomImpl(String name, X509Certificate signingCert, Collection<SAML2Endpoint> endpoints) throws IllegalArgumentException {
        super(name, signingCert, endpoints);
    }

    public void setRequestedNameIdFormat(SAML2NameIdFormat requestedNameIdFormat) {
        this.setDefaultNameIdFormat(requestedNameIdFormat);
    }

    public void setRequestedAuthenticationContexts(List<String> requestedAuthenticationContexts) {
        this.requestedAuthenticationContexts = requestedAuthenticationContexts;
    }

    public void setRequestedNameIdPolicyFormat(String nameIdFormatURI) {
        SAML2NameIdFormat nameIdFormat = SAML2NameIdFormat.fromName(nameIdFormatURI);
        this.setDefaultNameIdFormat(nameIdFormat);
    }

    public void setRequestedNameIdPolicySPNameQualifier(String spNameQualifier) {
        this.requestedSPNameQualifier = spNameQualifier;
    }

    public void setRequestedNameIdPolicyAllowCreate(Boolean allowCreate) {
        this.requestedAllowCreate = allowCreate;
    }

    public void setResponseRequirementAssertionConsumerIndex(Integer responseRequirementAssertionConsumerIndex) {
        this.responseRequirementAssertionConsumerIndex = responseRequirementAssertionConsumerIndex;
        this.responseRequirementType = ResponseRequirementType.ASSERTION_CONSUMER_INDEX;
    }

    public void setResponseRequirementAssertionConsumerURL(String responseRequirementAssertionConsumerURL) {
        this.responseRequirementAssertionConsumerURL = responseRequirementAssertionConsumerURL;
        this.responseRequirementType = ResponseRequirementType.ASSERTION_CONSUMER_URL;
    }

    public void setResponseRequirementBinding(SAML2Binding responseRequirementBinding) {
        this.responseRequirementBinding = responseRequirementBinding;
        this.responseRequirementType = ResponseRequirementType.ASSERTION_CONSUMER_URL;
    }

    public void setSignAuthnRequests(Boolean signAuthnRequests) {
        this.signAuthnRequests = signAuthnRequests != null ? (signAuthnRequests.booleanValue() ? SignatureOption.ALWAYS : SignatureOption.NEVER) : SAML2ConfigurationCustomConstants.DEFAULT_SIGN_OR_REQUIRE_AUTHN_REQUESTS;
    }

    public void setRequireSignedAssertions(Boolean requireSignedAssertions) {
        this.requireSignedAssertions = requireSignedAssertions != null ? (requireSignedAssertions.booleanValue() ? SignatureOption.ALWAYS : SignatureOption.FRONT_CHANNEL_ONLY) : SAML2ConfigurationCustomConstants.DEFAULT_SIGN_OR_REQUIRE_ASSERTIONS;
    }

    public void setRequireSignedAuthnResponses(Boolean requireSignedAuthnResponses) {
        this.requireSignedAuthnResponses = requireSignedAuthnResponses != null ? (requireSignedAuthnResponses.booleanValue() ? SignatureOption.ALWAYS : SignatureOption.NEVER) : SAML2ConfigurationCustomConstants.DEFAULT_SIGN_OR_REQUIRE_AUTHN_RESPONSES;
    }

    @Override
    public List<String> getAuthenticationContextNames() {
        return this.requestedAuthenticationContexts;
    }

    @Override
    public SAML2Endpoint getDefaultSingleSignOnEndpoint() {
        for (SAML2Endpoint endpoint : this.getSSOEndpoints()) {
            if (!endpoint.isDefault()) continue;
            return endpoint;
        }
        return null;
    }

    @Override
    public SAML2ModifiableTrustedIdP getModifiableTrustedIdP() throws SAML2ConfigurationException {
        return null;
    }

    @Override
    public List<SAML2ExtensionSupplierDescriptor> getExtensionSupplierDescriptors() {
        return null;
    }

    @Override
    public SAML2IdentityFederationTrustedIdP getIdentityFederation(String nameIdFormat) {
        return null;
    }

    @Override
    public Map<String, SAML2IdentityFederationTrustedIdP> getAllIdentityFederations() {
        return null;
    }

    @Override
    public SAML2NameIdFormatEmail getNameIdFormatEmail() {
        return null;
    }

    @Override
    public SAML2NameIdFormatKerberosTrustedIdP getNameIdFormatKerberos() {
        return null;
    }

    @Override
    public SAML2NameIdFormatPersistentTrustedIdP getNameIdFormatPersistent() {
        return null;
    }

    @Override
    public SAML2NameIdFormatTransientTrustedIdP getNameIdFormatTransient() {
        return null;
    }

    @Override
    public SAML2NameIdFormatUnspecified getNameIdFormatUnspecified() {
        return null;
    }

    @Override
    public SAML2NameIdFormatWindows getNameIdFormatWindows() {
        return null;
    }

    @Override
    public SAML2NameIdFormatX509TrustedIdP getNameIdFormatX509() {
        return null;
    }

    @Override
    public SAML2NameIdFormat getRequestedNameIdPolicyFormat() {
        return this.getDefaultNameIdFormat();
    }

    @Override
    public String getRequestedNameIdPolicySPNameQualifier() {
        return this.requestedSPNameQualifier;
    }

    @Override
    public Boolean getRequestedNameIdPolicyAllowCreate() {
        return this.requestedAllowCreate;
    }

    @Override
    public EncryptionOption getRequiredEncryptedAuthnResponseElements() {
        return SAML2ConfigurationCustomConstants.DEFAULT_AUTHN_RESPONSE_ENCRYPT_ELEMENTS;
    }

    @Override
    public int getResponseRequirementAssertionConsumerIndex() {
        if (this.responseRequirementAssertionConsumerIndex != null) {
            return this.responseRequirementAssertionConsumerIndex;
        }
        return -1;
    }

    @Override
    public String getResponseRequirementAssertionConsumerURL() {
        return this.responseRequirementAssertionConsumerURL;
    }

    @Override
    public SAML2Binding getResponseRequirementBinding() {
        return this.responseRequirementBinding;
    }

    @Override
    public ResponseRequirementType getResponseRequirementType() {
        if (this.responseRequirementType != null) {
            return this.responseRequirementType;
        }
        return SAML2ConfigurationCustomConstants.DEFAULT_RESPONSE_REQUIREMENT_VALUE;
    }

    @Override
    public Collection<SAML2Endpoint> getSSOEndpoints() {
        return this.getEndpoints(SAML2Service.SINGLE_SIGN_ON_SERVICE);
    }

    @Override
    public List<SAML2Endpoint> getSingleSignOnEndpoints(SAML2Binding binding) {
        return this.getEndpoints(SAML2Service.SINGLE_SIGN_ON_SERVICE, binding);
    }

    @Override
    public SignatureOption isToRequireSignedAssertions() {
        if (this.requireSignedAssertions != null) {
            return this.requireSignedAssertions;
        }
        return SAML2ConfigurationCustomConstants.DEFAULT_SIGN_OR_REQUIRE_ASSERTIONS;
    }

    @Override
    public SignatureOption isToRequireSignedAuthnResponses() {
        if (this.requireSignedAuthnResponses != null) {
            return this.requireSignedAuthnResponses;
        }
        return SAML2ConfigurationCustomConstants.DEFAULT_SIGN_OR_REQUIRE_AUTHN_RESPONSES;
    }

    @Override
    public SignatureOption isToSignAuthnRequests() {
        if (this.signAuthnRequests != null) {
            return this.signAuthnRequests;
        }
        return SAML2ConfigurationCustomConstants.DEFAULT_SIGN_OR_REQUIRE_AUTHN_REQUESTS;
    }

    @Override
    public ComparisonMethod getRequestedAuthnContextComparisonMethod() {
        return null;
    }
}

