/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.custom;

import com.sap.security.saml2.cfg.custom.SAML2ConfigurationCustomConstants;
import com.sap.security.saml2.cfg.custom.SAML2ProviderCustomImpl;
import com.sap.security.saml2.cfg.enums.DigestAlgorithm;
import com.sap.security.saml2.cfg.enums.EncryptionAlgorithm;
import com.sap.security.saml2.cfg.enums.SAML2Binding;
import com.sap.security.saml2.cfg.enums.SAML2NameIdFormat;
import com.sap.security.saml2.cfg.enums.SAML2Service;
import com.sap.security.saml2.cfg.enums.SignatureOption;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.interfaces.read.SAML2Endpoint;
import com.sap.security.saml2.cfg.interfaces.read.SAML2TrustedProvider;
import com.sap.security.saml2.cfg.util.CfgConstants;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class SAML2TrustedProviderCustomImpl
extends SAML2ProviderCustomImpl
implements SAML2TrustedProvider {
    protected static final List<SAML2Endpoint> EMPTY_LIST_SAML2_ENDPOINTS = new ArrayList<SAML2Endpoint>(0);
    private SAML2NameIdFormat defaultNameIdFormat;
    private X509Certificate secondarySigningCertificate;
    private SignatureOption signARSMessages;
    private SignatureOption requireSignedARSMessages;
    private SignatureOption signSLOMessages;
    private SignatureOption requireSignedSLOMessages;
    private EncryptionAlgorithm encryptionAlgorithm;
    private DigestAlgorithm signatureAlgorithm;
    private Collection<SAML2Endpoint> endpoints;

    public SAML2TrustedProviderCustomImpl(String name, X509Certificate signingCert, Collection<SAML2Endpoint> endpoints) throws IllegalArgumentException {
        super(name);
        if (signingCert == null) {
            throw new IllegalArgumentException("Signing certificate is mandatory argument.");
        }
        this.setSigningCertificate(signingCert);
        this.setEndpoints(endpoints);
    }

    public void setEndpoints(Collection<SAML2Endpoint> endpoints) {
        this.endpoints = endpoints;
    }

    public void setSecondarySigningCertificate(X509Certificate secondarySigningCertificate) {
        this.secondarySigningCertificate = secondarySigningCertificate;
    }

    public void setSignArtifactResolutionMessages(Boolean signARSMessages) {
        this.signARSMessages = signARSMessages != null ? (signARSMessages.booleanValue() ? SignatureOption.ALWAYS : SignatureOption.NEVER) : SAML2ConfigurationCustomConstants.DEFAULT_SIGN_OR_REQUIRE_ARS_MESSAGES;
    }

    public void setSignSingleLogoutMessages(Boolean signSLOMessages) {
        this.signSLOMessages = signSLOMessages != null ? (signSLOMessages.booleanValue() ? SignatureOption.ALWAYS : SignatureOption.FRONT_CHANNEL_ONLY) : SAML2ConfigurationCustomConstants.DEFAULT_SIGN_OR_REQUIRE_SLO_MESSAGES;
    }

    public void setRequireSignedArtifactResolutionMessages(Boolean requireSignedARSMessages) {
        this.requireSignedARSMessages = requireSignedARSMessages != null ? (requireSignedARSMessages.booleanValue() ? SignatureOption.ALWAYS : SignatureOption.NEVER) : SAML2ConfigurationCustomConstants.DEFAULT_SIGN_OR_REQUIRE_ARS_MESSAGES;
    }

    public void setRequireSignedSingleLogoutMessages(Boolean requireSignedSLOMessages) {
        this.requireSignedSLOMessages = requireSignedSLOMessages != null ? (requireSignedSLOMessages.booleanValue() ? SignatureOption.ALWAYS : SignatureOption.FRONT_CHANNEL_ONLY) : SAML2ConfigurationCustomConstants.DEFAULT_SIGN_OR_REQUIRE_SLO_MESSAGES;
    }

    public void setEncryptionAlgorithm(EncryptionAlgorithm encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
    }

    public void setDigestAlgorithm(DigestAlgorithm signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
    }

    @Override
    public Collection<SAML2Endpoint> getARSEndpoints() {
        return this.getEndpoints(SAML2Service.ARTIFACT_RESOLUTION_SERVICE);
    }

    @Override
    public Collection<SAML2Endpoint> getAllEndpoints() {
        if (this.endpoints != null) {
            return this.endpoints;
        }
        return EMPTY_LIST_SAML2_ENDPOINTS;
    }

    @Override
    public SAML2Endpoint getArtifactResolutionEndpoint(int index) {
        if (this.endpoints != null) {
            for (SAML2Endpoint endpoint : this.endpoints) {
                if (endpoint == null || SAML2Service.ARTIFACT_RESOLUTION_SERVICE != endpoint.getService() || index != endpoint.getIndex()) continue;
                return endpoint;
            }
        }
        return null;
    }

    @Override
    public SAML2NameIdFormat getDefaultNameIdFormat() {
        return this.defaultNameIdFormat;
    }

    @Override
    public SAML2Endpoint getDefaultSingleLogoutEndpoint() {
        if (this.endpoints != null) {
            for (SAML2Endpoint endpoint : this.endpoints) {
                if (endpoint == null || SAML2Service.SINGLE_LOGOUT_SERVICE != endpoint.getService() || !endpoint.isDefault()) continue;
                return endpoint;
            }
        }
        return null;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public EncryptionAlgorithm getEncryptionAlgorithm() {
        if (this.encryptionAlgorithm != null) {
            return this.encryptionAlgorithm;
        }
        return SAML2ConfigurationCustomConstants.DEFAULT_ENCRYPTION_ALGORITHM;
    }

    @Override
    public DigestAlgorithm getDigestAlgorithm() {
        if (this.signatureAlgorithm != null) {
            return this.signatureAlgorithm;
        }
        return SAML2ConfigurationCustomConstants.DEFAULT_SIGNATURE_ALGORITHM;
    }

    @Override
    public String getEncryptionCertificateName() {
        return null;
    }

    @Override
    public Collection<SAML2Endpoint> getSLOEndpoints() {
        return this.getEndpoints(SAML2Service.SINGLE_LOGOUT_SERVICE);
    }

    @Override
    public Certificate getSecondaryCertificateForSignature() throws SAML2ConfigurationException {
        return this.secondarySigningCertificate;
    }

    @Override
    public String getSecondarySigningCertificateName() {
        return null;
    }

    @Override
    public String getSigningCertificateName() {
        return null;
    }

    @Override
    public List<SAML2Endpoint> getSingleLogoutEndpoints(SAML2Binding binding) {
        return this.getEndpoints(SAML2Service.SINGLE_LOGOUT_SERVICE, binding);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean isToEncryptSingleLogoutSubject() {
        return SAML2ConfigurationCustomConstants.DEFAULT_ENCRYPT_OR_REQUIRE_SLO_SUBJECT;
    }

    @Override
    public boolean isToEncryptManageNameIDNewID() {
        return SAML2ConfigurationCustomConstants.DEFAULT_ENCRYPT_OR_REQUIRE_MNI_NEW_ID;
    }

    @Override
    public boolean isToEncryptManageNameIDSubject() {
        return SAML2ConfigurationCustomConstants.DEFAULT_ENCRYPT_OR_REQUIRE_MNI_SUBJECT;
    }

    @Override
    public boolean isToRequireEncryptedSingleLogoutSubject() {
        return SAML2ConfigurationCustomConstants.DEFAULT_ENCRYPT_OR_REQUIRE_SLO_SUBJECT;
    }

    @Override
    public boolean isToRequireEncryptedManageNameIDNewID() {
        return SAML2ConfigurationCustomConstants.DEFAULT_ENCRYPT_OR_REQUIRE_MNI_NEW_ID;
    }

    @Override
    public boolean isToRequireEncryptedManageNameIDSubject() {
        return SAML2ConfigurationCustomConstants.DEFAULT_ENCRYPT_OR_REQUIRE_MNI_SUBJECT;
    }

    @Override
    public SignatureOption isToRequireSignedArtifactResolutionMessages() {
        if (this.requireSignedARSMessages != null) {
            return this.requireSignedARSMessages;
        }
        return SAML2ConfigurationCustomConstants.DEFAULT_SIGN_OR_REQUIRE_ARS_MESSAGES;
    }

    @Override
    public SignatureOption isToRequireSignedSingleLogoutMessages() {
        if (this.requireSignedSLOMessages != null) {
            return this.requireSignedSLOMessages;
        }
        return SAML2ConfigurationCustomConstants.DEFAULT_SIGN_OR_REQUIRE_SLO_MESSAGES;
    }

    @Override
    public SignatureOption isToRequireSignedManageNameIDMessages() {
        return CfgConstants.DEFAULT_SIGN_OR_REQUIRE_MNI_MESSAGES;
    }

    @Override
    public SignatureOption isToSignArtifactResolutionMessages() {
        if (this.signARSMessages != null) {
            return this.signARSMessages;
        }
        return SAML2ConfigurationCustomConstants.DEFAULT_SIGN_OR_REQUIRE_ARS_MESSAGES;
    }

    @Override
    public SignatureOption isToSignSingleLogoutMessages() {
        if (this.signSLOMessages != null) {
            return this.signSLOMessages;
        }
        return SAML2ConfigurationCustomConstants.DEFAULT_SIGN_OR_REQUIRE_SLO_MESSAGES;
    }

    @Override
    public SignatureOption isToSignManageNameIDMessages() {
        return CfgConstants.DEFAULT_SIGN_OR_REQUIRE_MNI_MESSAGES;
    }

    protected void setDefaultNameIdFormat(SAML2NameIdFormat defaultNameIdFormat) {
        this.defaultNameIdFormat = defaultNameIdFormat;
    }

    protected Collection<SAML2Endpoint> getEndpoints(SAML2Service service) {
        if (this.endpoints != null) {
            ArrayList<SAML2Endpoint> result = new ArrayList<SAML2Endpoint>();
            for (SAML2Endpoint endpoint : this.endpoints) {
                if (endpoint == null || service != endpoint.getService()) continue;
                result.add(endpoint);
            }
            return result;
        }
        return EMPTY_LIST_SAML2_ENDPOINTS;
    }

    protected List<SAML2Endpoint> getEndpoints(SAML2Service service, SAML2Binding binding) {
        if (this.endpoints != null) {
            ArrayList<SAML2Endpoint> result = new ArrayList<SAML2Endpoint>();
            for (SAML2Endpoint endpoint : this.endpoints) {
                if (endpoint == null || service != endpoint.getService() || endpoint.getBinding() != binding) continue;
                result.add(endpoint);
            }
            return result;
        }
        return EMPTY_LIST_SAML2_ENDPOINTS;
    }

    @Override
    public Collection<SAML2Endpoint> getMNIEndpoints() {
        return EMPTY_LIST_SAML2_ENDPOINTS;
    }

    @Override
    public List<SAML2Endpoint> getManageNameIDEndpoints(SAML2Binding binding) {
        return EMPTY_LIST_SAML2_ENDPOINTS;
    }

    @Override
    public SAML2Endpoint getDefaultManageNameIDEndpoint() {
        return null;
    }
}

