/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.custom;

import com.sap.security.saml2.cfg.custom.SAML2ConfigurationCustomConstants;
import com.sap.security.saml2.cfg.custom.SAML2EndpointCustomImpl;
import com.sap.security.saml2.cfg.custom.SAML2TrustedProviderCustomImpl;
import com.sap.security.saml2.cfg.enums.EncryptionOption;
import com.sap.security.saml2.cfg.enums.SAML2Binding;
import com.sap.security.saml2.cfg.enums.SAML2NameIdFormat;
import com.sap.security.saml2.cfg.enums.SAML2Service;
import com.sap.security.saml2.cfg.enums.SignatureOption;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.interfaces.read.SAML2Endpoint;
import com.sap.security.saml2.cfg.interfaces.read.SAML2TrustedSP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatEmail;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatKerberosTrustedSP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatPersistentTrustedSP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatTransientTrustedSP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatUnspecified;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatWindows;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatX509TrustedSP;
import com.sap.security.saml2.cfg.interfaces.write.SAML2ModifiableTrustedSP;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SAML2TrustedSPCustomImpl
extends SAML2TrustedProviderCustomImpl
implements SAML2TrustedSP {
    private EncryptionOption authnResponseElementsToEncrypt;
    private SignatureOption signAuthnResponses;
    private SignatureOption signAssertions;
    private SignatureOption requireSignedAuthnRequests;

    public SAML2TrustedSPCustomImpl(String name, X509Certificate signingCert, String acsLocationUrl) throws IllegalArgumentException {
        this(name, signingCert, acsLocationUrl, null);
    }

    public SAML2TrustedSPCustomImpl(String name, X509Certificate signingCert, String acsLocationUrl, String sloLocationUrl) throws IllegalArgumentException {
        this(name, signingCert, SAML2TrustedSPCustomImpl.convertToFrontChannelEndpoints(acsLocationUrl, sloLocationUrl));
    }

    private static Collection<SAML2Endpoint> convertToFrontChannelEndpoints(String acsLocationUrl, String sloLocationUrl) {
        ArrayList<SAML2Endpoint> result = new ArrayList<SAML2Endpoint>();
        if (acsLocationUrl != null && acsLocationUrl.length() > 0) {
            SAML2EndpointCustomImpl defaultACSEndpoint = new SAML2EndpointCustomImpl(SAML2Service.ASSERTION_CONSUMER_SERVICE, SAML2Binding.HTTP_POST_BINDING, acsLocationUrl);
            defaultACSEndpoint.setDefault(true);
            result.add(defaultACSEndpoint);
        }
        if (sloLocationUrl != null && sloLocationUrl.length() > 0) {
            SAML2EndpointCustomImpl defaltSLOEndpoint = new SAML2EndpointCustomImpl(SAML2Service.SINGLE_LOGOUT_SERVICE, SAML2Binding.HTTP_REDIRECT_BINDING, sloLocationUrl);
            defaltSLOEndpoint.setDefault(true);
            result.add(defaltSLOEndpoint);
            result.add(new SAML2EndpointCustomImpl(SAML2Service.SINGLE_LOGOUT_SERVICE, SAML2Binding.HTTP_POST_BINDING, sloLocationUrl));
        }
        return result;
    }

    public SAML2TrustedSPCustomImpl(String name, X509Certificate signingCert, Collection<SAML2Endpoint> endpoints) {
        super(name, signingCert, endpoints);
    }

    public void setAuthnResponseElementsToEncrypt(EncryptionOption authnResponseElementsToEncrypt) {
        this.authnResponseElementsToEncrypt = authnResponseElementsToEncrypt;
    }

    public void setSignAssertions(Boolean signAssertions) {
        this.signAssertions = signAssertions != null ? (signAssertions.booleanValue() ? SignatureOption.ALWAYS : SignatureOption.FRONT_CHANNEL_ONLY) : SAML2ConfigurationCustomConstants.DEFAULT_SIGN_OR_REQUIRE_ASSERTIONS;
    }

    public void setRequreSignedAuthnRequests(Boolean requireSignedAuthnRequests) {
        this.requireSignedAuthnRequests = requireSignedAuthnRequests != null ? (requireSignedAuthnRequests.booleanValue() ? SignatureOption.ALWAYS : SignatureOption.NEVER) : SAML2ConfigurationCustomConstants.DEFAULT_SIGN_OR_REQUIRE_AUTHN_REQUESTS;
    }

    public void setSignAuthnResponses(Boolean signAuthnResponses) {
        this.signAuthnResponses = signAuthnResponses != null ? (signAuthnResponses.booleanValue() ? SignatureOption.ALWAYS : SignatureOption.NEVER) : SAML2ConfigurationCustomConstants.DEFAULT_SIGN_OR_REQUIRE_AUTHN_RESPONSES;
    }

    @Override
    public void setDefaultNameIdFormat(SAML2NameIdFormat defaultNameIdFormat) {
        super.setDefaultNameIdFormat(defaultNameIdFormat);
    }

    @Override
    public Collection<SAML2Endpoint> getACSEndpoints() {
        return this.getEndpoints(SAML2Service.ASSERTION_CONSUMER_SERVICE);
    }

    @Override
    public SAML2Endpoint getAssertionConsumerEndpoint(int index) {
        for (SAML2Endpoint endpoint : this.getACSEndpoints()) {
            if (index != endpoint.getIndex()) continue;
            return endpoint;
        }
        return null;
    }

    @Override
    public List<SAML2Endpoint> getAssertionConsumerEndpoints(SAML2Binding binding) {
        return this.getEndpoints(SAML2Service.ASSERTION_CONSUMER_SERVICE, binding);
    }

    @Override
    public EncryptionOption getAuthnResponseElementsToEncrypt() {
        if (this.authnResponseElementsToEncrypt != null) {
            return this.authnResponseElementsToEncrypt;
        }
        return SAML2ConfigurationCustomConstants.DEFAULT_AUTHN_RESPONSE_ENCRYPT_ELEMENTS;
    }

    @Override
    public SAML2Endpoint getDefaultAssertionConsumerEndpoint() {
        for (SAML2Endpoint endpoint : this.getACSEndpoints()) {
            if (!endpoint.isDefault()) continue;
            return endpoint;
        }
        return null;
    }

    @Override
    public SAML2ModifiableTrustedSP getModifiableTrustedSP() throws SAML2ConfigurationException {
        return null;
    }

    @Override
    public SAML2NameIdFormatEmail getNameIdFormatEmail() {
        return null;
    }

    @Override
    public SAML2NameIdFormatKerberosTrustedSP getNameIdFormatKerberos() {
        return null;
    }

    @Override
    public SAML2NameIdFormatPersistentTrustedSP getNameIdFormatPersistent() {
        return null;
    }

    @Override
    public SAML2NameIdFormatTransientTrustedSP getNameIdFormatTransient() {
        return null;
    }

    @Override
    public SAML2NameIdFormatUnspecified getNameIdFormatUnspecified() {
        return null;
    }

    @Override
    public SAML2NameIdFormatWindows getNameIdFormatWindows() {
        return null;
    }

    @Override
    public SAML2NameIdFormatX509TrustedSP getNameIdFormatX509() {
        return null;
    }

    @Override
    public String getSPProvidedIDUMEAttributeName() {
        return null;
    }

    @Override
    public String getSPProvidedIDUMEAttributeNamespace() {
        return null;
    }

    @Override
    public SignatureOption isToRequireSignedAuthnRequests() {
        if (this.requireSignedAuthnRequests != null) {
            return this.requireSignedAuthnRequests;
        }
        return SAML2ConfigurationCustomConstants.DEFAULT_SIGN_OR_REQUIRE_AUTHN_REQUESTS;
    }

    @Override
    public SignatureOption isToSignAssertions() {
        if (this.signAssertions != null) {
            return this.signAssertions;
        }
        return SAML2ConfigurationCustomConstants.DEFAULT_SIGN_OR_REQUIRE_ASSERTIONS;
    }

    @Override
    public SignatureOption isToSignAuthnResponses() {
        if (this.signAuthnResponses != null) {
            return this.signAuthnResponses;
        }
        return SAML2ConfigurationCustomConstants.DEFAULT_SIGN_OR_REQUIRE_AUTHN_RESPONSES;
    }
}

