/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.enums;

import com.sap.security.saml2.cfg.util.CfgUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ComparisonMethod
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String alias;
    public static final ComparisonMethod EXACT = new ComparisonMethod("exact", "Exact");
    public static final ComparisonMethod MINIMUM = new ComparisonMethod("minimum", "Minimum");
    public static final ComparisonMethod MAXIMUM = new ComparisonMethod("maximum", "Maximum");
    public static final ComparisonMethod BETTER = new ComparisonMethod("better", "Better");
    private static final Map<String, ComparisonMethod> comparisonMethodsByName = new HashMap<String, ComparisonMethod>(4);
    private static final Map<String, ComparisonMethod> comparisonMethodsByAlias = new HashMap<String, ComparisonMethod>(4);

    static {
        comparisonMethodsByName.put(EXACT.getName(), EXACT);
        comparisonMethodsByName.put(MINIMUM.getName(), MINIMUM);
        comparisonMethodsByName.put(MAXIMUM.getName(), MAXIMUM);
        comparisonMethodsByName.put(BETTER.getName(), BETTER);
        comparisonMethodsByAlias.put(EXACT.getAlias(), EXACT);
        comparisonMethodsByAlias.put(MINIMUM.getAlias(), MINIMUM);
        comparisonMethodsByAlias.put(MAXIMUM.getAlias(), MAXIMUM);
        comparisonMethodsByAlias.put(BETTER.getAlias(), BETTER);
    }

    public static Set<ComparisonMethod> getAllComparisonMethods() {
        return new HashSet<ComparisonMethod>(comparisonMethodsByName.values());
    }

    private ComparisonMethod(String name, String alias) {
        this.name = name;
        this.alias = alias;
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public static ComparisonMethod getComparisonMethod(String name) {
        if (CfgUtils.isEmpty(name)) {
            return null;
        }
        return comparisonMethodsByName.get(name);
    }

    public static ComparisonMethod getComparisonMethodByAlias(String alias) {
        if (CfgUtils.isEmpty(alias)) {
            return null;
        }
        return comparisonMethodsByAlias.get(alias);
    }

    public String toString() {
        return this.getName();
    }
}

