/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.enums;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DigestAlgorithm
implements Serializable {
    private static final long serialVersionUID = 1134303157500622981L;
    protected final String name;
    protected final String text;
    public static final DigestAlgorithm SHA1 = new DigestAlgorithm("http://www.w3.org/2000/09/xmldsig#sha1", "SHA1");
    public static final DigestAlgorithm SHA256 = new DigestAlgorithm("http://www.w3.org/2001/04/xmlenc#sha256", "SHA256");
    public static final DigestAlgorithm SHA512 = new DigestAlgorithm("http://www.w3.org/2001/04/xmlenc#sha512", "SHA512");
    private static final Map<String, DigestAlgorithm> nameDigestMap = new HashMap<String, DigestAlgorithm>(5);

    static {
        nameDigestMap.put("http://www.w3.org/2000/09/xmldsig#sha1", SHA1);
        nameDigestMap.put("http://www.w3.org/2001/04/xmlenc#sha256", SHA256);
        nameDigestMap.put("http://www.w3.org/2001/04/xmlenc#sha512", SHA512);
    }

    public static Set<DigestAlgorithm> getAllDigestAlgorithms() {
        return new HashSet<DigestAlgorithm>(nameDigestMap.values());
    }

    private DigestAlgorithm(String name, String text) {
        this.name = name;
        this.text = text;
    }

    public String getName() {
        return this.name;
    }

    public String getText() {
        return this.text;
    }

    public static DigestAlgorithm getDigestAlgorithm(String uri) {
        DigestAlgorithm ea = nameDigestMap.get(uri);
        return ea;
    }

    public String toString() {
        return this.getName();
    }
}

