/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.enums;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class EncryptionAlgorithm
implements Serializable {
    private static final long serialVersionUID = 9148966435998181950L;
    protected final String name;
    protected final String text;
    public static final EncryptionAlgorithm AES_128 = new EncryptionAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc", "AES-128");
    public static final EncryptionAlgorithm AES_192 = new EncryptionAlgorithm("http://www.w3.org/2001/04/xmlenc#aes192-cbc", "AES-192");
    public static final EncryptionAlgorithm AES_256 = new EncryptionAlgorithm("http://www.w3.org/2001/04/xmlenc#aes256-cbc", "AES-256");
    public static final EncryptionAlgorithm TRIPLEDES = new EncryptionAlgorithm("http://www.w3.org/2001/04/xmlenc#tripledes-cbc", "TRIPLE DES");
    private static final Map<String, EncryptionAlgorithm> nameEncryptionMap = new HashMap<String, EncryptionAlgorithm>(5);

    static {
        nameEncryptionMap.put("http://www.w3.org/2001/04/xmlenc#aes128-cbc", AES_128);
        nameEncryptionMap.put("http://www.w3.org/2001/04/xmlenc#aes192-cbc", AES_192);
        nameEncryptionMap.put("http://www.w3.org/2001/04/xmlenc#aes256-cbc", AES_256);
        nameEncryptionMap.put("http://www.w3.org/2001/04/xmlenc#tripledes-cbc", TRIPLEDES);
    }

    public static Set<EncryptionAlgorithm> getAllEncryptionAlgorithms() {
        return new HashSet<EncryptionAlgorithm>(nameEncryptionMap.values());
    }

    private EncryptionAlgorithm(String name, String text) {
        this.name = name;
        this.text = text;
    }

    public String getName() {
        return this.name;
    }

    public String getText() {
        return this.text;
    }

    public static EncryptionAlgorithm getEncryptionAlgorithm(String uri) {
        EncryptionAlgorithm ea = nameEncryptionMap.get(uri);
        return ea;
    }

    public String toString() {
        return this.getName();
    }
}

