/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.enums;

import com.sap.security.saml2.cfg.util.CfgUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SAML2AttributeFormat
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String alias;
    public static final SAML2AttributeFormat BASIC = new SAML2AttributeFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:basic", "Basic");
    public static final SAML2AttributeFormat URI = new SAML2AttributeFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:uri", "URI");
    public static final SAML2AttributeFormat UNSPECIFIED = new SAML2AttributeFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified", "Unspecified");
    private static final Map<String, SAML2AttributeFormat> attributeFormatsByName = new HashMap<String, SAML2AttributeFormat>(3);
    private static final Map<String, SAML2AttributeFormat> attributeFormatsByAlias = new HashMap<String, SAML2AttributeFormat>(3);

    static {
        attributeFormatsByName.put(BASIC.getName(), BASIC);
        attributeFormatsByName.put(URI.getName(), URI);
        attributeFormatsByName.put(UNSPECIFIED.getName(), UNSPECIFIED);
        attributeFormatsByAlias.put(BASIC.getAlias(), BASIC);
        attributeFormatsByAlias.put(URI.getAlias(), URI);
        attributeFormatsByAlias.put(UNSPECIFIED.getAlias(), UNSPECIFIED);
    }

    public static Set<SAML2AttributeFormat> getAllAttributeFormats() {
        return new HashSet<SAML2AttributeFormat>(attributeFormatsByName.values());
    }

    private SAML2AttributeFormat(String name, String alias) {
        this.name = name;
        this.alias = alias;
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public static SAML2AttributeFormat getAttributeFormat(String name) {
        if (CfgUtils.isEmpty(name)) {
            return null;
        }
        return attributeFormatsByName.get(name);
    }

    public static SAML2AttributeFormat getAttributeFormatByAlias(String alias) {
        if (CfgUtils.isEmpty(alias)) {
            return null;
        }
        return attributeFormatsByAlias.get(alias);
    }

    public String toString() {
        return this.getName();
    }
}

