/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.enums;

import com.sap.security.saml2.cfg.util.CfgUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SAML2AuthenticationContext
implements Serializable {
    private static final long serialVersionUID = 6800303728358481356L;
    public static final SAML2AuthenticationContext PASSWORD = new SAML2AuthenticationContext("urn:oasis:names:tc:SAML:2.0:ac:classes:Password", "Password");
    public static final SAML2AuthenticationContext PASSWORD_PROTECTED = new SAML2AuthenticationContext("urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport", "PasswordProtectedTransport");
    public static final SAML2AuthenticationContext KERBEROS = new SAML2AuthenticationContext("urn:oasis:names:tc:SAML:2.0:ac:classes:Kerberos", "Kerberos");
    public static final SAML2AuthenticationContext TLS_CLIENT = new SAML2AuthenticationContext("urn:oasis:names:tc:SAML:2.0:ac:classes:TLSClient", "TLSClient");
    public static final SAML2AuthenticationContext INTERNET_PROTOCOL = new SAML2AuthenticationContext("urn:oasis:names:tc:SAML:2.0:ac:classes:InternetProtocol", "InternetProtocol");
    public static final SAML2AuthenticationContext INTERNET_PROTOCOL_PASSWORD = new SAML2AuthenticationContext("urn:oasis:names:tc:SAML:2.0:ac:classes:InternetProtocolPassword", "InternetProtocolPassword");
    public static final SAML2AuthenticationContext MOBILE_ONE_FACTOR_UNREGISTERED = new SAML2AuthenticationContext("urn:oasis:names:tc:SAML:2.0:ac:classes:MobileOneFactorUnregistered", "MobileOneFactorUnregistered");
    public static final SAML2AuthenticationContext MOBILE_TWO_FACTOR_UNREGISTERED = new SAML2AuthenticationContext("urn:oasis:names:tc:SAML:2.0:ac:classes:MobileTwoFactorUnregistered", "MobileTwoFactorUnregistered");
    public static final SAML2AuthenticationContext MOBILE_ONE_FACTOR_CONTRACT = new SAML2AuthenticationContext("urn:oasis:names:tc:SAML:2.0:ac:classes:MobileOneFactorContract", "MobileOneFactorContract");
    public static final SAML2AuthenticationContext MOBILE_TWO_FACTOR_CONTRACT = new SAML2AuthenticationContext("urn:oasis:names:tc:SAML:2.0:ac:classes:MobileTwoFactorContract", "MobileTwoFactorContract");
    public static final SAML2AuthenticationContext PREVIOUS_SESSION = new SAML2AuthenticationContext("urn:oasis:names:tc:SAML:2.0:ac:classes:PreviousSession", "PreviousSession");
    public static final SAML2AuthenticationContext X509 = new SAML2AuthenticationContext("urn:oasis:names:tc:SAML:2.0:ac:classes:X509", "X509");
    public static final SAML2AuthenticationContext PGP = new SAML2AuthenticationContext("urn:oasis:names:tc:SAML:2.0:ac:classes:PGP", "PGP");
    public static final SAML2AuthenticationContext SPKI = new SAML2AuthenticationContext("urn:oasis:names:tc:SAML:2.0:ac:classes:SPKI", "SPKI");
    public static final SAML2AuthenticationContext XML_DSIG = new SAML2AuthenticationContext("urn:oasis:names:tc:SAML:2.0:ac:classes:XMLDSig", "XMLDSig");
    public static final SAML2AuthenticationContext SMART_CARD = new SAML2AuthenticationContext("urn:oasis:names:tc:SAML:2.0:ac:classes:Smartcard", "Smartcard");
    public static final SAML2AuthenticationContext SMART_CARD_PKI = new SAML2AuthenticationContext("urn:oasis:names:tc:SAML:2.0:ac:classes:SmartcardPKI", "SmartcardPKI");
    public static final SAML2AuthenticationContext SOFTWARE_PKI = new SAML2AuthenticationContext("urn:oasis:names:tc:SAML:2.0:ac:classes:SoftwarePKI", "SoftwarePKI");
    public static final SAML2AuthenticationContext TELEPHONY = new SAML2AuthenticationContext("urn:oasis:names:tc:SAML:2.0:ac:classes:Telephony", "Telephony");
    public static final SAML2AuthenticationContext NOMAD_TELEPHONY = new SAML2AuthenticationContext("urn:oasis:names:tc:SAML:2.0:ac:classes:NomadTelephony", "NomadTelephony");
    public static final SAML2AuthenticationContext PERSONAL_TELEPHONY = new SAML2AuthenticationContext("urn:oasis:names:tc:SAML:2.0:ac:classes:PersonalTelephony", "PersonalTelephony");
    public static final SAML2AuthenticationContext AUTHENTICATED_TELEPHONY = new SAML2AuthenticationContext("urn:oasis:names:tc:SAML:2.0:ac:classes:AuthenticatedTelephony", "AuthenticatedTelephony");
    public static final SAML2AuthenticationContext SECURE_REMOTE_PASSWORD = new SAML2AuthenticationContext("urn:oasis:names:tc:SAML:2.0:ac:classes:SecureRemotePassword", "SecureRemotePassword");
    public static final SAML2AuthenticationContext TIME_SYNC_TOKEN = new SAML2AuthenticationContext("urn:oasis:names:tc:SAML:2.0:ac:classes:TimeSyncToken", "TimeSyncToken");
    public static final SAML2AuthenticationContext UNSPECIFIED = new SAML2AuthenticationContext("urn:oasis:names:tc:SAML:2.0:ac:classes:unspecified", "unspecified");
    public static final SAML2AuthenticationContext SAP_LOGON_TICKET = new SAML2AuthenticationContext("urn:sap:names:SAML:2.0:ac:classes:SAPLogonTicket", "SAPLogonTicket");
    private static final Map<String, SAML2AuthenticationContext> stringAuthnContextMap = new HashMap<String, SAML2AuthenticationContext>();
    private static final Set<SAML2AuthenticationContext> httpContexts = new HashSet<SAML2AuthenticationContext>();
    private static final Set<SAML2AuthenticationContext> httpsContexts = new HashSet<SAML2AuthenticationContext>();
    private static final Set<SAML2AuthenticationContext> interactiveContexts = new HashSet<SAML2AuthenticationContext>();
    private final String name;
    private final String alias;

    static {
        stringAuthnContextMap.put(KERBEROS.getName(), KERBEROS);
        stringAuthnContextMap.put(PASSWORD.getName(), PASSWORD);
        stringAuthnContextMap.put(PASSWORD_PROTECTED.getName(), PASSWORD_PROTECTED);
        stringAuthnContextMap.put(TLS_CLIENT.getName(), TLS_CLIENT);
        stringAuthnContextMap.put(INTERNET_PROTOCOL.getName(), INTERNET_PROTOCOL);
        stringAuthnContextMap.put(INTERNET_PROTOCOL_PASSWORD.getName(), INTERNET_PROTOCOL_PASSWORD);
        stringAuthnContextMap.put(MOBILE_ONE_FACTOR_CONTRACT.getName(), MOBILE_ONE_FACTOR_CONTRACT);
        stringAuthnContextMap.put(MOBILE_ONE_FACTOR_UNREGISTERED.getName(), MOBILE_ONE_FACTOR_UNREGISTERED);
        stringAuthnContextMap.put(MOBILE_TWO_FACTOR_CONTRACT.getName(), MOBILE_TWO_FACTOR_CONTRACT);
        stringAuthnContextMap.put(MOBILE_TWO_FACTOR_UNREGISTERED.getName(), MOBILE_TWO_FACTOR_UNREGISTERED);
        stringAuthnContextMap.put(NOMAD_TELEPHONY.getName(), NOMAD_TELEPHONY);
        stringAuthnContextMap.put(PERSONAL_TELEPHONY.getName(), PERSONAL_TELEPHONY);
        stringAuthnContextMap.put(PGP.getName(), PGP);
        stringAuthnContextMap.put(PREVIOUS_SESSION.getName(), PREVIOUS_SESSION);
        stringAuthnContextMap.put(SECURE_REMOTE_PASSWORD.getName(), SECURE_REMOTE_PASSWORD);
        stringAuthnContextMap.put(SMART_CARD.getName(), SMART_CARD);
        stringAuthnContextMap.put(SMART_CARD_PKI.getName(), SMART_CARD_PKI);
        stringAuthnContextMap.put(SOFTWARE_PKI.getName(), SOFTWARE_PKI);
        stringAuthnContextMap.put(SPKI.getName(), SPKI);
        stringAuthnContextMap.put(TELEPHONY.getName(), TELEPHONY);
        stringAuthnContextMap.put(TIME_SYNC_TOKEN.getName(), TIME_SYNC_TOKEN);
        stringAuthnContextMap.put(UNSPECIFIED.getName(), UNSPECIFIED);
        stringAuthnContextMap.put(X509.getName(), X509);
        stringAuthnContextMap.put(XML_DSIG.getName(), XML_DSIG);
        stringAuthnContextMap.put(AUTHENTICATED_TELEPHONY.getName(), AUTHENTICATED_TELEPHONY);
        stringAuthnContextMap.put(SAP_LOGON_TICKET.getName(), SAP_LOGON_TICKET);
        httpContexts.add(KERBEROS);
        httpContexts.add(PASSWORD);
        httpContexts.add(INTERNET_PROTOCOL);
        httpContexts.add(INTERNET_PROTOCOL_PASSWORD);
        httpContexts.add(MOBILE_ONE_FACTOR_CONTRACT);
        httpContexts.add(MOBILE_ONE_FACTOR_UNREGISTERED);
        httpContexts.add(MOBILE_TWO_FACTOR_CONTRACT);
        httpContexts.add(MOBILE_TWO_FACTOR_UNREGISTERED);
        httpContexts.add(NOMAD_TELEPHONY);
        httpContexts.add(PERSONAL_TELEPHONY);
        httpContexts.add(PGP);
        httpContexts.add(SECURE_REMOTE_PASSWORD);
        httpContexts.add(SMART_CARD);
        httpContexts.add(SMART_CARD_PKI);
        httpContexts.add(SOFTWARE_PKI);
        httpContexts.add(SPKI);
        httpContexts.add(TELEPHONY);
        httpContexts.add(TIME_SYNC_TOKEN);
        httpContexts.add(X509);
        httpContexts.add(XML_DSIG);
        httpContexts.add(AUTHENTICATED_TELEPHONY);
        httpContexts.add(SAP_LOGON_TICKET);
        httpsContexts.add(KERBEROS);
        httpsContexts.add(PASSWORD_PROTECTED);
        httpsContexts.add(TLS_CLIENT);
        httpsContexts.add(INTERNET_PROTOCOL);
        httpsContexts.add(INTERNET_PROTOCOL_PASSWORD);
        httpsContexts.add(MOBILE_ONE_FACTOR_CONTRACT);
        httpsContexts.add(MOBILE_ONE_FACTOR_UNREGISTERED);
        httpsContexts.add(MOBILE_TWO_FACTOR_CONTRACT);
        httpsContexts.add(MOBILE_TWO_FACTOR_UNREGISTERED);
        httpsContexts.add(NOMAD_TELEPHONY);
        httpsContexts.add(PERSONAL_TELEPHONY);
        httpsContexts.add(PGP);
        httpsContexts.add(SECURE_REMOTE_PASSWORD);
        httpsContexts.add(SMART_CARD);
        httpsContexts.add(SMART_CARD_PKI);
        httpsContexts.add(SPKI);
        httpsContexts.add(TELEPHONY);
        httpsContexts.add(TIME_SYNC_TOKEN);
        httpsContexts.add(X509);
        httpsContexts.add(XML_DSIG);
        httpsContexts.add(AUTHENTICATED_TELEPHONY);
        httpsContexts.add(SAP_LOGON_TICKET);
        interactiveContexts.add(PASSWORD);
        interactiveContexts.add(PASSWORD_PROTECTED);
        interactiveContexts.add(INTERNET_PROTOCOL_PASSWORD);
        interactiveContexts.add(MOBILE_TWO_FACTOR_UNREGISTERED);
        interactiveContexts.add(MOBILE_TWO_FACTOR_CONTRACT);
        interactiveContexts.add(SMART_CARD_PKI);
        interactiveContexts.add(AUTHENTICATED_TELEPHONY);
        interactiveContexts.add(SECURE_REMOTE_PASSWORD);
    }

    public static Set<SAML2AuthenticationContext> getAllAuthenticationContexts() {
        return new HashSet<SAML2AuthenticationContext>(stringAuthnContextMap.values());
    }

    private SAML2AuthenticationContext(String name, String alias) {
        this.name = name;
        this.alias = alias;
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public static final SAML2AuthenticationContext getAuthenticationContextByName(String name) {
        if (CfgUtils.isEmpty(name)) {
            return null;
        }
        return stringAuthnContextMap.get(name);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Name: ").append(this.getName());
        builder.append("\nAlias: ").append(this.getAlias());
        builder.append("\nHTTP: ").append(this.isHTTP());
        builder.append("\nHTTPS: ").append(this.isHTTPS());
        builder.append("\nInteractive: ").append(this.isInteractive());
        builder.append("\n");
        return builder.toString();
    }

    public boolean isHTTP() {
        return httpContexts.contains(this);
    }

    public boolean isHTTPS() {
        return httpsContexts.contains(this);
    }

    public boolean isInteractive() {
        return interactiveContexts.contains(this);
    }
}

