/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.enums;

import com.sap.security.saml2.cfg.util.CfgUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SAML2Binding
implements Serializable {
    private static final long serialVersionUID = -5594110314235155005L;
    private final String name;
    private final String text;
    public static final SAML2Binding SOAP_BINDING = new SAML2Binding("urn:oasis:names:tc:SAML:2.0:bindings:SOAP", "SOAP");
    public static final SAML2Binding HTTP_REDIRECT_BINDING = new SAML2Binding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", "HTTP-Redirect");
    public static final SAML2Binding HTTP_POST_BINDING = new SAML2Binding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", "HTTP-POST");
    public static final SAML2Binding HTTP_ARTIFACT_BINDING = new SAML2Binding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", "HTTP-Artifact");
    public static final SAML2Binding PAOS_BINDING = new SAML2Binding("urn:oasis:names:tc:SAML:2.0:bindings:PAOS", "PAOS");
    private static final Map<String, SAML2Binding> stringBindingMap = new HashMap<String, SAML2Binding>(5);
    private static final Map<String, SAML2Binding> textBindingMap = new HashMap<String, SAML2Binding>(5);

    static {
        stringBindingMap.put(SOAP_BINDING.getName(), SOAP_BINDING);
        stringBindingMap.put(HTTP_REDIRECT_BINDING.getName(), HTTP_REDIRECT_BINDING);
        stringBindingMap.put(HTTP_ARTIFACT_BINDING.getName(), HTTP_ARTIFACT_BINDING);
        stringBindingMap.put(HTTP_POST_BINDING.getName(), HTTP_POST_BINDING);
        stringBindingMap.put(PAOS_BINDING.getName(), PAOS_BINDING);
        textBindingMap.put(SOAP_BINDING.getText(), SOAP_BINDING);
        textBindingMap.put(HTTP_REDIRECT_BINDING.getText(), HTTP_REDIRECT_BINDING);
        textBindingMap.put(HTTP_ARTIFACT_BINDING.getText(), HTTP_ARTIFACT_BINDING);
        textBindingMap.put(HTTP_POST_BINDING.getText(), HTTP_POST_BINDING);
        textBindingMap.put(PAOS_BINDING.getText(), PAOS_BINDING);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SAML2Binding other = (SAML2Binding)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }

    public static Set<SAML2Binding> getAllBindings() {
        return new HashSet<SAML2Binding>(stringBindingMap.values());
    }

    private SAML2Binding(String name, String text) {
        this.name = name;
        this.text = text;
    }

    public String getName() {
        return this.name;
    }

    public String getText() {
        return this.text;
    }

    public boolean usesFrontChannel() {
        return !"urn:oasis:names:tc:SAML:2.0:bindings:SOAP".equals(this.name);
    }

    public static SAML2Binding getBinding(String bindingString) {
        if (CfgUtils.isEmpty(bindingString)) {
            return null;
        }
        return stringBindingMap.get(bindingString);
    }

    public static SAML2Binding getBindingByText(String text) {
        if (CfgUtils.isEmpty(text)) {
            return null;
        }
        return textBindingMap.get(text);
    }

    public String toString() {
        return this.getName();
    }
}

