/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.enums;

import com.sap.security.saml2.cfg.util.CfgUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SAML2NameIdFormat
implements Serializable {
    private static final long serialVersionUID = -7557208390139520850L;
    public static final SAML2NameIdFormat UNSPECIFIED = new SAML2NameIdFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified", "Unspecified", "Unspecified");
    public static final SAML2NameIdFormat TRANSIENT = new SAML2NameIdFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:transient", "Transient", "Transient");
    public static final SAML2NameIdFormat PERSISTENT = new SAML2NameIdFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent", "Persistent", "Persistent");
    public static final SAML2NameIdFormat E_MAIL = new SAML2NameIdFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress", "E-mail", "Email");
    public static final SAML2NameIdFormat X509_SUBJECT_NAME = new SAML2NameIdFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName", "X509 Subject Name", "X509");
    public static final SAML2NameIdFormat WINDOWS_DOMAIN_QUALIFIED_NAME = new SAML2NameIdFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:WindowsDomainQualifiedName", "Windows Name", "WindowsName");
    public static final SAML2NameIdFormat KERBEROS = new SAML2NameIdFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:kerberos", "Kerberos", "Kerberos");
    private static final Map<String, SAML2NameIdFormat> stringNameIdFormatMap = new HashMap<String, SAML2NameIdFormat>();
    private final String name;
    private final String text;
    private final String key;

    static {
        stringNameIdFormatMap.put(UNSPECIFIED.getName(), UNSPECIFIED);
        stringNameIdFormatMap.put(TRANSIENT.getName(), TRANSIENT);
        stringNameIdFormatMap.put(PERSISTENT.getName(), PERSISTENT);
        stringNameIdFormatMap.put(E_MAIL.getName(), E_MAIL);
        stringNameIdFormatMap.put(KERBEROS.getName(), KERBEROS);
        stringNameIdFormatMap.put(WINDOWS_DOMAIN_QUALIFIED_NAME.getName(), WINDOWS_DOMAIN_QUALIFIED_NAME);
        stringNameIdFormatMap.put(X509_SUBJECT_NAME.getName(), X509_SUBJECT_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<SAML2NameIdFormat> getAllNameIdFormats() {
        Map<String, SAML2NameIdFormat> map = stringNameIdFormatMap;
        synchronized (map) {
            return new HashSet<SAML2NameIdFormat>(stringNameIdFormatMap.values());
        }
    }

    private SAML2NameIdFormat(String name, String text, String key) {
        this.name = name;
        this.text = text;
        this.key = key;
    }

    public String getName() {
        return this.name;
    }

    public String getText() {
        return this.text;
    }

    public String getKey() {
        return this.key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final SAML2NameIdFormat getNameIdFormatByKey(String key) {
        if (CfgUtils.isEmpty(key)) {
            return null;
        }
        Map<String, SAML2NameIdFormat> map = stringNameIdFormatMap;
        synchronized (map) {
            Set<String> keys = stringNameIdFormatMap.keySet();
            for (String s : keys) {
                if (!key.equalsIgnoreCase(stringNameIdFormatMap.get(s).getKey())) continue;
                return stringNameIdFormatMap.get(s);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final SAML2NameIdFormat getNameIdFormatByName(String name) {
        if (CfgUtils.isEmpty(name)) {
            return null;
        }
        Map<String, SAML2NameIdFormat> map = stringNameIdFormatMap;
        synchronized (map) {
            return stringNameIdFormatMap.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final SAML2NameIdFormat fromName(String name) {
        if (CfgUtils.isEmpty(name)) {
            return null;
        }
        Map<String, SAML2NameIdFormat> map = stringNameIdFormatMap;
        synchronized (map) {
            if (!stringNameIdFormatMap.containsKey(name)) {
                stringNameIdFormatMap.put(name, new SAML2NameIdFormat(name, name, name));
            }
            return stringNameIdFormatMap.get(name);
        }
    }

    public String toString() {
        return this.getName();
    }
}

