/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.enums;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class SAML2PredefinedUMEAttribute
implements Serializable,
Comparable<SAML2PredefinedUMEAttribute> {
    private static final long serialVersionUID = 1L;
    private static final Set<SAML2PredefinedUMEAttribute> all = new TreeSet<SAML2PredefinedUMEAttribute>();
    private static final Map<String, SAML2PredefinedUMEAttribute> attributesByAlias = new HashMap<String, SAML2PredefinedUMEAttribute>();
    public static final SAML2PredefinedUMEAttribute DISPLAY_NAME = new SAML2PredefinedUMEAttribute("Display Name", "displayname", "com.sap.security.core.usermanagement");
    public static final SAML2PredefinedUMEAttribute FIRST_NAME = new SAML2PredefinedUMEAttribute("First Name", "firstname", "com.sap.security.core.usermanagement");
    public static final SAML2PredefinedUMEAttribute LAST_NAME = new SAML2PredefinedUMEAttribute("Last Name", "lastname", "com.sap.security.core.usermanagement");
    public static final SAML2PredefinedUMEAttribute SALUTATION = new SAML2PredefinedUMEAttribute("Salutation", "salutation", "com.sap.security.core.usermanagement");
    public static final SAML2PredefinedUMEAttribute TITLE = new SAML2PredefinedUMEAttribute("Title", "title", "com.sap.security.core.usermanagement");
    public static final SAML2PredefinedUMEAttribute JOB_TITLE = new SAML2PredefinedUMEAttribute("Job Title", "jobtitle", "com.sap.security.core.usermanagement");
    public static final SAML2PredefinedUMEAttribute COMPANY = new SAML2PredefinedUMEAttribute("Company", "company", "com.sap.security.core.usermanagement");
    public static final SAML2PredefinedUMEAttribute DEPARTMENT = new SAML2PredefinedUMEAttribute("Department", "department", "com.sap.security.core.usermanagement");
    public static final SAML2PredefinedUMEAttribute CURRENCY = new SAML2PredefinedUMEAttribute("Currency", "currency", "com.sap.security.core.usermanagement");
    public static final SAML2PredefinedUMEAttribute DESCRIPTION = new SAML2PredefinedUMEAttribute("Description", "description", "com.sap.security.core.usermanagement");
    public static final SAML2PredefinedUMEAttribute EMAIL = new SAML2PredefinedUMEAttribute("E-mail", "email", "com.sap.security.core.usermanagement");
    public static final SAML2PredefinedUMEAttribute TELEPHONE = new SAML2PredefinedUMEAttribute("Telephone", "telephone", "com.sap.security.core.usermanagement");
    public static final SAML2PredefinedUMEAttribute MOBILE = new SAML2PredefinedUMEAttribute("Mobile", "mobile", "com.sap.security.core.usermanagement");
    public static final SAML2PredefinedUMEAttribute FAX = new SAML2PredefinedUMEAttribute("Fax", "fax", "com.sap.security.core.usermanagement");
    public static final SAML2PredefinedUMEAttribute STREET_ADDRESS = new SAML2PredefinedUMEAttribute("Street Address", "streetaddress", "com.sap.security.core.usermanagement");
    public static final SAML2PredefinedUMEAttribute CITY = new SAML2PredefinedUMEAttribute("City", "city", "com.sap.security.core.usermanagement");
    public static final SAML2PredefinedUMEAttribute ZIP_CODE = new SAML2PredefinedUMEAttribute("ZIP Code", "zip", "com.sap.security.core.usermanagement");
    public static final SAML2PredefinedUMEAttribute POST_OFFICE_BOX = new SAML2PredefinedUMEAttribute("Post Office Box", "pobox", "com.sap.security.core.usermanagement");
    public static final SAML2PredefinedUMEAttribute COUNTRY = new SAML2PredefinedUMEAttribute("Country", "country", "com.sap.security.core.usermanagement");
    public static final SAML2PredefinedUMEAttribute STATE = new SAML2PredefinedUMEAttribute("State", "state", "com.sap.security.core.usermanagement");
    public static final SAML2PredefinedUMEAttribute LOCALE = new SAML2PredefinedUMEAttribute("Locale", "locale", "com.sap.security.core.usermanagement");
    public static final SAML2PredefinedUMEAttribute TIMEZONE = new SAML2PredefinedUMEAttribute("Time Zone", "timezone", "com.sap.security.core.usermanagement");
    public static final SAML2PredefinedUMEAttribute ORGANIZATIONAL_UNIT = new SAML2PredefinedUMEAttribute("Organizational Unit", "orgunit", "com.sap.security.core.usermanagement");
    public static final SAML2PredefinedUMEAttribute SAP_CLIENT = new SAML2PredefinedUMEAttribute("SAP Client", "SAP_CLIENT", "$usermapping$");
    public static final SAML2PredefinedUMEAttribute USER_MAPPING = new SAML2PredefinedUMEAttribute("SAP R/3 User", "REFERENCE_SYSTEM_USER", "$usermapping$");
    private final String alias;
    private final String name;
    private final String namespace;

    private SAML2PredefinedUMEAttribute(String alias, String name, String namespace) {
        this.alias = alias;
        this.name = name;
        this.namespace = namespace;
        all.add(this);
        attributesByAlias.put(alias, this);
    }

    public static Set<SAML2PredefinedUMEAttribute> getAll() {
        return Collections.unmodifiableSet(all);
    }

    public static SAML2PredefinedUMEAttribute getUMEAttributeByAlias(String alias) {
        return attributesByAlias.get(alias);
    }

    public String getAlias() {
        return this.alias;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public int compareTo(SAML2PredefinedUMEAttribute o) {
        return this.alias.compareTo(o.alias);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.alias == null ? 0 : this.alias.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SAML2PredefinedUMEAttribute other = (SAML2PredefinedUMEAttribute)obj;
        return !(this.alias == null ? other.alias != null : !this.alias.equals(other.alias));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Alias: ").append(this.getAlias());
        builder.append("\nName: ").append(this.getName());
        builder.append("\nNamespace: ").append(this.getNamespace());
        return builder.toString();
    }
}

