/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.enums;

import com.sap.security.saml2.cfg.util.CfgUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SAML2Service
implements Serializable {
    private static final long serialVersionUID = -5081021313690802566L;
    private static final String MNI_SERVICE = "ManageNameIDService";
    private static final String AC_SERVICE = "AssertionConsumerService";
    private static final String SSO_SERVICE = "SingleSignOnService";
    private static final String ARTIFACT_SERVICE = "ArtifactResolutionService";
    private static final String SLO_SERVICE = "SingleLogoutService";
    private final String name;
    private final String text;
    public static final SAML2Service SINGLE_LOGOUT_SERVICE = new SAML2Service("SingleLogoutService", "SingleLogout");
    public static final SAML2Service ARTIFACT_RESOLUTION_SERVICE = new SAML2Service("ArtifactResolutionService", "ArtifactResolution");
    public static final SAML2Service SINGLE_SIGN_ON_SERVICE = new SAML2Service("SingleSignOnService", "SingleSignOn");
    public static final SAML2Service ASSERTION_CONSUMER_SERVICE = new SAML2Service("AssertionConsumerService", "AssertionConsumer");
    public static final SAML2Service MANAGE_NAMEID_SERVICE = new SAML2Service("ManageNameIDService", "ManageNameID");
    private static final Map<String, SAML2Service> stringServiceMapping = new HashMap<String, SAML2Service>(6);
    private static final List<SAML2Service> indexedServices;

    static {
        stringServiceMapping.put(SINGLE_LOGOUT_SERVICE.getName(), SINGLE_LOGOUT_SERVICE);
        stringServiceMapping.put(ARTIFACT_RESOLUTION_SERVICE.getName(), ARTIFACT_RESOLUTION_SERVICE);
        stringServiceMapping.put(SINGLE_SIGN_ON_SERVICE.getName(), SINGLE_SIGN_ON_SERVICE);
        stringServiceMapping.put(ASSERTION_CONSUMER_SERVICE.getName(), ASSERTION_CONSUMER_SERVICE);
        stringServiceMapping.put(MNI_SERVICE, MANAGE_NAMEID_SERVICE);
        indexedServices = new ArrayList<SAML2Service>();
        indexedServices.add(ARTIFACT_RESOLUTION_SERVICE);
        indexedServices.add(ASSERTION_CONSUMER_SERVICE);
    }

    public static Set<SAML2Service> getAllServices() {
        return new HashSet<SAML2Service>(stringServiceMapping.values());
    }

    private SAML2Service(String name, String text) {
        this.name = name;
        this.text = text;
    }

    public String getName() {
        return this.name;
    }

    public String getText() {
        return this.text;
    }

    public String toString() {
        return this.getName();
    }

    public static SAML2Service getService(String name) {
        if (CfgUtils.isEmpty(name)) {
            return null;
        }
        return stringServiceMapping.get(name);
    }

    public boolean isIndexedService() {
        return indexedServices.contains(this);
    }
}

