/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.ljsadapters;

import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.interfaces.services.SAML2CfgKeystoreService;
import com.sap.security.saml2.cfg.ljsadapters.SAML2LJSAdapters;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import com.sap.tc.logging.Location;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class SAML2CfgKeystoreServiceLJSAdapter
implements SAML2CfgKeystoreService {
    private Map<String, KeyStore> keystoreCache = new HashMap<String, KeyStore>();
    public static final String SYSTEM_KEYSTORE_TYPE = "LJSKS";
    public static final String MASTER_SAML2_KEY = "com.sap.security.saml2.cfg";
    public static final char[] MASTER_PASSWORD = new char[0];
    public static final char[] DEFAULT_PASSWORD = new char[]{'S', 'A', 'M', 'L', '2', '.', '0'};
    private static final Location LOCATION = Location.getLocation(SAML2CfgKeystoreServiceLJSAdapter.class);
    private char[] keystorePassword = DEFAULT_PASSWORD;

    public SAML2CfgKeystoreServiceLJSAdapter() {
        try {
            this.keystorePassword = this.getKeystorePassword();
        }
        catch (SAML2ConfigurationException e) {
            this.keystorePassword = DEFAULT_PASSWORD;
            LOCATION.traceThrowableT(100, "Could not obtain keystore password!", (Throwable)e);
        }
    }

    @Override
    public void createKeystore(String keystoreName) throws SAML2ConfigurationException {
    }

    @Override
    public synchronized KeyStore getKeystore(String viewName) throws SAML2ConfigurationException {
        KeyStore result;
        block15: {
            result = null;
            if (this.keystoreCache.containsKey(viewName)) {
                result = this.keystoreCache.get(viewName);
            } else {
                File keystoreFile = null;
                FileInputStream fis = null;
                try {
                    try {
                        keystoreFile = new File(SAML2LJSAdapters.getConfigurationRoot(), viewName);
                        result = KeyStore.getInstance(KeyStore.getDefaultType());
                        fis = new FileInputStream(keystoreFile);
                        result.load(fis, this.useKeystorePassword());
                        this.keystoreCache.put(viewName, result);
                    }
                    catch (IOException e) {
                        throw new SAML2ConfigurationException("Could not obtain keystore view with name: " + viewName, e);
                    }
                    catch (Exception e) {
                        throw new SAML2ConfigurationException("Could not obtain keystore view with name: " + viewName, e);
                    }
                }
                catch (Throwable throwable) {
                    block14: {
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (Exception e) {
                                if (!LOCATION.beWarning()) break block14;
                                LOCATION.traceThrowableT(400, "Could not close keystore file: {0}", new Object[]{keystoreFile.getAbsolutePath()}, (Throwable)e);
                            }
                        }
                    }
                    throw throwable;
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Exception e) {
                        if (!LOCATION.beWarning()) break block15;
                        LOCATION.traceThrowableT(400, "Could not close keystore file: {0}", new Object[]{keystoreFile.getAbsolutePath()}, (Throwable)e);
                    }
                }
            }
        }
        return result;
    }

    @Override
    public synchronized void refresh() {
        this.keystoreCache.clear();
    }

    @Override
    public synchronized void storeKeystore(KeyStore keystore, String viewName) throws SAML2ConfigurationException {
        block12: {
            File keystoreFile = null;
            FileOutputStream fos = null;
            try {
                try {
                    keystoreFile = new File(SAML2LJSAdapters.getConfigurationRoot(), viewName);
                    fos = new FileOutputStream(keystoreFile);
                    keystore.store(fos, this.useKeystorePassword());
                    this.keystoreCache.put(viewName, keystore);
                }
                catch (Exception e) {
                    throw new SAML2ConfigurationException("Could not store keystore file with name: " + viewName, e);
                }
            }
            catch (Throwable throwable) {
                block11: {
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (Exception e) {
                            if (!LOCATION.beWarning()) break block11;
                            LOCATION.traceThrowableT(400, "Could not close keystore file: {0}", new Object[]{keystoreFile.getAbsolutePath()}, (Throwable)e);
                        }
                    }
                }
                throw throwable;
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e) {
                    if (!LOCATION.beWarning()) break block12;
                    LOCATION.traceThrowableT(400, "Could not close keystore file: {0}", new Object[]{keystoreFile.getAbsolutePath()}, (Throwable)e);
                }
            }
        }
    }

    @Override
    public String[] getCommonNameRDNs(X509Certificate cert) throws Exception {
        return new String[0];
    }

    @Override
    public void grantKeystorePermissions(String viewName) throws SAML2ConfigurationException {
    }

    @Override
    public boolean keystoreExists(String viewName) throws SAML2ConfigurationException {
        try {
            File keystoreFile = new File(SAML2LJSAdapters.getConfigurationRoot(), viewName);
            return keystoreFile.exists();
        }
        catch (CfgStorageException e) {
            if (LOCATION.beWarning()) {
                LOCATION.traceThrowableT(400, "Could not locate keystore file!", (Throwable)e);
            }
            return false;
        }
    }

    @Override
    public String getCertificateExtendedInfo(String certificateBase64) throws Exception {
        certificateBase64 = "-----BEGIN CERTIFICATE-----\n" + certificateBase64 + "\n-----END CERTIFICATE-----";
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        Certificate cert = factory.generateCertificate(new ByteArrayInputStream(certificateBase64.getBytes("UTF-8")));
        return cert.toString();
    }

    @Override
    public Key readKeyEntry(KeyStore keystore, String entryName) throws SAML2ConfigurationException {
        try {
            return keystore.getKey(entryName, this.useKeystorePassword());
        }
        catch (Exception e) {
            throw new SAML2ConfigurationException("Could not obtain the key entry with name: " + entryName, e);
        }
    }

    private final char[] useKeystorePassword() {
        if (this.keystorePassword == DEFAULT_PASSWORD && LOCATION.beDebug()) {
            LOCATION.debugT("Using default password to access keystore");
        }
        return (char[])this.keystorePassword.clone();
    }

    private char[] getKeystorePassword() throws SAML2ConfigurationException {
        KeyStore systemKeystore;
        char[] password = null;
        try {
            systemKeystore = KeyStore.getInstance(SYSTEM_KEYSTORE_TYPE);
        }
        catch (KeyStoreException e) {
            if (LOCATION.beDebug()) {
                LOCATION.traceThrowableT(100, "Could not open system keystore!", (Throwable)e);
            }
            return (char[])DEFAULT_PASSWORD.clone();
        }
        try {
            systemKeystore.load(null, MASTER_PASSWORD);
            Key key = systemKeystore.getKey(MASTER_SAML2_KEY, MASTER_PASSWORD);
            if (key instanceof SecretKey) {
                password = this.toPassword((SecretKey)key);
            }
            if (password == null) {
                password = DEFAULT_PASSWORD;
            }
            return password;
        }
        catch (KeyStoreException e) {
            throw new SAML2ConfigurationException("Unable to access the keystore key!", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SAML2ConfigurationException("Unable to access the keystore key!", e);
        }
        catch (CertificateException e) {
            throw new SAML2ConfigurationException("Unable to access the keystore key!", e);
        }
        catch (IOException e) {
            throw new SAML2ConfigurationException("Unable to access the keystore key!", e);
        }
        catch (UnrecoverableKeyException e) {
            throw new SAML2ConfigurationException("Unable to access the keystore key!", e);
        }
        catch (InvalidKeyException e) {
            throw new SAML2ConfigurationException("Unable to access the keystore key!", e);
        }
        catch (InvalidKeySpecException e) {
            throw new SAML2ConfigurationException("Unable to access the keystore key!", e);
        }
    }

    private final char[] toPassword(SecretKey rawKey) throws InvalidKeyException, InvalidKeySpecException, NoSuchAlgorithmException {
        SecretKey pbeKey;
        SecretKeyFactory skf = SecretKeyFactory.getInstance(rawKey.getAlgorithm());
        PBEKeySpec spec = (PBEKeySpec)skf.getKeySpec(pbeKey = skf.translateKey(rawKey), PBEKeySpec.class);
        if (spec != null) {
            return spec.getPassword();
        }
        return null;
    }
}

