/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.ljsadapters.filestorage;

import com.sap.security.saml2.cfg.interfaces.services.CfgStorage;
import com.sap.security.saml2.cfg.ljsadapters.filestorage.CfgFileStorageAccessor;
import com.sap.security.saml2.cfg.ljsadapters.filestorage.CfgNode;
import com.sap.security.saml2.cfg.ljsadapters.filestorage.CfgPropertySheet;
import com.sap.security.saml2.cfg.storage.CfgObject;
import com.sap.security.saml2.cfg.storage.CfgProperty;
import com.sap.security.saml2.cfg.storage.CfgPropertySetter;
import com.sap.security.saml2.cfg.storage.CfgPropertyValue;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import com.sap.security.saml2.cfg.storage.CfgStorageUtils;
import com.sap.security.saml2.cfg.storage.StorageChangedListener;
import com.sap.security.saml2.cfg.util.CfgUtils;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class CfgFileStorage
implements CfgStorage {
    private static final Location LOCATION = Location.getLocation(CfgFileStorage.class);
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock(true);
    private final Lock r = this.rwl.readLock();
    private final Lock w = this.rwl.writeLock();
    private String cfgRoot;

    CfgFileStorage(String cfgRoot) {
        this.cfgRoot = cfgRoot;
    }

    @Override
    public String createAnonymousPropertySheet(String cfgPath, String prefix) throws CfgStorageException {
        String psName = null;
        this.w.lock();
        try {
            CfgNode cfg = this.obtainWriteableConfiguration(cfgPath);
            List<String> names = cfg.getAllPropertySheetNames();
            psName = CfgStorageUtils.formNewAnonymousName(prefix, names);
            cfg.createPropertySheet(psName);
            String string = psName;
            return string;
        }
        catch (Exception exception) {
            throw new CfgStorageException("Could not create anonymous property sheet with name: " + psName + " under path: " + cfgPath);
        }
        finally {
            this.w.unlock();
        }
    }

    @Override
    public String createAnonymousSubCfg(String cfgPath, String prefix) throws CfgStorageException {
        String subCfgName = null;
        this.w.lock();
        try {
            CfgNode cfg = this.obtainWriteableConfiguration(cfgPath);
            List<String> names = cfg.getAllSubNodeNames();
            subCfgName = CfgStorageUtils.formNewAnonymousName(prefix, names);
            cfg.createSubNode(subCfgName);
            String newCfgPath = cfgPath;
            if (!newCfgPath.endsWith("/")) {
                newCfgPath = String.valueOf(newCfgPath) + "/";
            }
            String string = newCfgPath = String.valueOf(newCfgPath) + subCfgName;
            return string;
        }
        catch (Exception exception) {
            throw new CfgStorageException("Could not create anonymous sub node with name: " + subCfgName + " under path: " + cfgPath);
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void deleteCfgObject(CfgObject obj) throws CfgStorageException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[WHILELOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void exportConfiguration(String destinationFilePath) throws CfgStorageException {
    }

    @Override
    public String[] getCfgPropertySheetNames(String cfgPath, String prefix) throws CfgStorageException {
        this.r.lock();
        try {
            CfgNode cfg = this.obtainReadableConfiguration(cfgPath);
            if (cfg == null) {
                return null;
            }
            List<String> names = cfg.getAllPropertySheetNames();
            ArrayList<String> result = new ArrayList<String>();
            if (names != null) {
                Collections.sort(names, CfgStorageUtils.CFG_NAME_COMPARATOR);
                for (String psName : names) {
                    if (!CfgUtils.isEmpty(prefix) && !psName.startsWith(prefix)) continue;
                    result.add(psName);
                }
            }
            String[] stringArray = result.toArray(new String[result.size()]);
            return stringArray;
        }
        catch (Exception e) {
            throw new CfgStorageException("Could not obtain the property sheet names", e);
        }
        finally {
            this.r.unlock();
        }
    }

    @Override
    public String getCfgRoot() {
        return this.cfgRoot;
    }

    @Override
    public String[] getPropertySheetKeys(CfgObject obj) {
        if (obj != null && obj.getCfgPropertySheet() != null) {
            String psName = obj.getCfgPropertySheet();
            this.r.lock();
            try {
                CfgNode cfg = this.obtainReadableConfiguration(obj.getCfgPath());
                if (cfg != null && cfg.existsPropertySheet(psName)) {
                    CfgPropertySheet ps = cfg.getPropertySheet(psName);
                    String[] stringArray = ps.getAllPropertyEntryNames();
                    return stringArray;
                }
            }
            catch (Exception e) {
                LOCATION.traceThrowableT(500, "Error on reading all keys in one propertysheet", (Throwable)e);
            }
            finally {
                this.r.unlock();
            }
        }
        return new String[0];
    }

    @Override
    public CfgPropertyValue getPropertyValue(CfgProperty property, String defaultValue) {
        String propName;
        CfgPropertyValue result;
        block10: {
            block9: {
                CfgPropertySheet ps;
                result = null;
                propName = property.getName();
                String propSheetName = property.getCfgPropertySheet();
                this.r.lock();
                if (CfgUtils.isEmpty(propSheetName)) break block9;
                CfgNode cfg = this.obtainReadableConfiguration(property.getCfgPath());
                if (cfg != null && cfg.existsPropertySheet(propSheetName) && (ps = cfg.getPropertySheet(propSheetName)) != null && ps.existsPropertyEntry(propName)) {
                    Object value = ps.getPropertyEntry(propName);
                    CfgPropertyValue cfgPropertyValue = CfgPropertyValue.getInstance(value);
                    this.r.unlock();
                    return cfgPropertyValue;
                }
                break block10;
            }
            try {
                try {
                    if (property.isFile()) {
                        throw new CfgStorageException("Unsuported feature. Property specified as a file could not be readed yet");
                    }
                    throw new CfgStorageException("Unsuported feature. Properties without specified property sheet could not be readed yet");
                }
                catch (Exception e) {
                    LOCATION.traceThrowableT(500, "Error on reading all keys in one propertysheet", (Throwable)e);
                    this.r.unlock();
                }
            }
            catch (Throwable throwable) {
                this.r.unlock();
                throw throwable;
            }
        }
        this.r.unlock();
        if (LOCATION.beDebug() && result == null) {
            LOCATION.debugT("Property " + propName + " not found");
        }
        if (result == null || result.getValues() == null) {
            result = CfgPropertyValue.getInstance(defaultValue);
        }
        return result;
    }

    @Override
    public String[] getSubCfgNames(String cfgPath) throws CfgStorageException {
        this.r.lock();
        try {
            CfgNode cfg = this.obtainReadableConfiguration(cfgPath);
            if (cfg == null) {
                return null;
            }
            List<String> subNodeNames = cfg.getAllSubNodeNames();
            String[] cfgPaths = new String[subNodeNames.size()];
            String endPath = cfgPath;
            if (!endPath.endsWith("/")) {
                endPath = String.valueOf(endPath) + "/";
            }
            int i = 0;
            while (i < subNodeNames.size()) {
                cfgPaths[i] = String.valueOf(endPath) + subNodeNames.get(i);
                ++i;
            }
            String[] stringArray = cfgPaths;
            return stringArray;
        }
        catch (Exception e) {
            throw new CfgStorageException("Could not obtain sub configurations for cfg path: " + cfgPath, e);
        }
        finally {
            this.r.unlock();
        }
    }

    @Override
    public void importConfiguration(String sourceFilePath) throws CfgStorageException {
    }

    @Override
    public void registerStorageChangedListener(StorageChangedListener listener, String subPath) throws CfgStorageException {
    }

    @Override
    public void unregisterAllConfigurationChangedListener() throws CfgStorageException {
    }

    @Override
    public void unregisterStorageChangedListener(StorageChangedListener listener, String subPath) throws CfgStorageException {
    }

    @Override
    public void write(CfgPropertySetter setterCfg) throws CfgStorageException {
        String cfgPath = setterCfg.getCfgPath();
        this.w.lock();
        try {
            try {
                CfgNode cfg = this.obtainWriteableConfiguration(cfgPath);
                String propertySheetName = setterCfg.getCfgPropertySheetName();
                if (CfgUtils.isEmpty(propertySheetName)) {
                    throw new CfgStorageException("Unsuported feature. Properties without specified property sheet could not be written yet");
                }
                CfgPropertySheet propertySheet = !cfg.existsPropertySheet(propertySheetName) ? cfg.createPropertySheet(propertySheetName) : cfg.getPropertySheet(propertySheetName);
                Properties originalProperties = propertySheet.getPropertyEntries();
                Map<CfgProperty, Object> props = setterCfg.getProperties();
                Set<CfgProperty> set = props.keySet();
                Object obj = null;
                for (CfgProperty key : set) {
                    if (key.isFile()) {
                        throw new CfgStorageException("Unsuported feature. Property specified as a file could not be written yet");
                    }
                    obj = props.get(key);
                    String propertyName = key.getName();
                    if (obj == null) {
                        originalProperties.remove(propertyName);
                        continue;
                    }
                    if (obj instanceof String[]) {
                        String newValue = CfgPropertyValue.convert((String[])obj);
                        if (newValue == null) {
                            originalProperties.remove(propertyName);
                            continue;
                        }
                        originalProperties.setProperty(propertyName, newValue);
                        continue;
                    }
                    if (obj instanceof String) {
                        originalProperties.setProperty(propertyName, (String)obj);
                        continue;
                    }
                    throw new CfgStorageException("Unsuported feature. Property value type is: " + obj.getClass() + ". It could be either String or String[].");
                }
                propertySheet.storePropertyEntries(originalProperties, null);
            }
            catch (Exception e) {
                throw new CfgStorageException("Could not write properties into: " + setterCfg.getCfgPath(), e);
            }
        }
        finally {
            this.w.unlock();
        }
    }

    private CfgNode obtainReadableConfiguration(String cfgPath) throws CfgStorageException {
        String[] path = CfgStorageUtils.parseRelativePath(cfgPath);
        CfgNode root = CfgFileStorageAccessor.getInstance().getReadableConfiguration(this.cfgRoot);
        if (root == null) {
            return null;
        }
        CfgNode cfg = CfgFileStorage.traversePath(root, path);
        return cfg;
    }

    private CfgNode obtainWriteableConfiguration(String cfgPath) throws CfgStorageException {
        String[] relativePath = CfgStorageUtils.parseRelativePath(cfgPath);
        CfgNode root = CfgFileStorageAccessor.getInstance().getWriteableConfiguration(this.cfgRoot);
        CfgNode cfg = CfgFileStorage.ensureRelativePath(root, relativePath);
        return cfg;
    }

    private static final CfgNode ensureRelativePath(CfgNode writableRoot, String[] path) throws CfgStorageException {
        CfgNode leaf = writableRoot;
        String[] stringArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            String subNode = stringArray[n2];
            leaf = !leaf.existsSubNode(subNode) ? leaf.createSubNode(subNode) : leaf.getSubNode(subNode);
            ++n2;
        }
        return leaf;
    }

    private static final CfgNode traversePath(CfgNode readableRoot, String[] path) {
        CfgNode leaf = readableRoot;
        String[] stringArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            String subNode = stringArray[n2];
            if (leaf.existsSubNode(subNode)) {
                try {
                    leaf = leaf.getSubNode(subNode);
                }
                catch (CfgStorageException e) {
                    if (LOCATION.beDebug()) {
                        LOCATION.traceThrowableT(100, "Could not obtain sub node: {0} from configuration: {1}", new Object[]{subNode, leaf.getPath()}, (Throwable)e);
                    }
                    return null;
                }
            } else {
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("Node " + leaf.getPath() + " does not have " + subNode);
                }
                return null;
            }
            ++n2;
        }
        return leaf;
    }
}

