/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.ljsadapters.filestorage;

import com.sap.security.saml2.cfg.ljsadapters.filestorage.CfgPropertySheet;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CfgNode {
    private static final Location LOCATION = Location.getLocation(CfgNode.class);
    private File node;

    public CfgNode(File node) throws CfgStorageException {
        if (!node.exists() || !node.isDirectory()) {
            throw new CfgStorageException("Configuration node specified with directory: " + node + " does not exist");
        }
        this.node = node;
    }

    public String getPath() {
        return this.node.getAbsolutePath();
    }

    public boolean existsSubNode(String subNode) {
        String[] children = this.node.list();
        if (children != null) {
            String[] stringArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File childFile;
                String child = stringArray[n2];
                if (child.equals(subNode) && (childFile = new File(this.node, child)).isDirectory()) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean existsPropertySheet(String name) {
        String[] children = this.node.list();
        if (children != null) {
            String[] stringArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File childFile;
                String child = stringArray[n2];
                if (child.equals(name) && (childFile = new File(this.node, child)).isFile()) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public CfgPropertySheet createPropertySheet(String name) throws IOException, CfgStorageException {
        File childFile = new File(this.node, name);
        childFile.createNewFile();
        return new CfgPropertySheet(childFile);
    }

    public CfgPropertySheet getPropertySheet(String name) throws IOException, CfgStorageException {
        File childFile = new File(this.node, name);
        return new CfgPropertySheet(childFile);
    }

    public CfgNode createSubNode(String subNode) throws CfgStorageException {
        File childNode = new File(this.node, subNode);
        boolean isCreated = childNode.mkdir();
        if (!isCreated) {
            throw new CfgStorageException("Could not create sub configuration with name: " + subNode + " under directory: " + this.node);
        }
        return new CfgNode(childNode);
    }

    public CfgNode getSubNode(String subNode) throws CfgStorageException {
        File childNode = new File(this.node, subNode);
        return new CfgNode(childNode);
    }

    public List<String> getAllSubNodeNames() {
        ArrayList<String> result = new ArrayList<String>();
        String[] children = this.node.list();
        if (children != null) {
            String[] stringArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                String child = stringArray[n2];
                File childNode = new File(this.node, child);
                if (childNode.isDirectory()) {
                    result.add(child);
                }
                ++n2;
            }
        }
        return result;
    }

    public List<String> getAllPropertySheetNames() {
        ArrayList<String> result = new ArrayList<String>();
        String[] children = this.node.list();
        if (children != null) {
            String[] stringArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                String child = stringArray[n2];
                File childNode = new File(this.node, child);
                if (childNode.isFile()) {
                    result.add(child);
                }
                ++n2;
            }
        }
        return result;
    }

    public void delete() {
        boolean isDeleted = this.deleteDirectory(this.node);
        if (!isDeleted && LOCATION.beWarning()) {
            LOCATION.warningT("Could not delete configuration node: [{0}]", new Object[]{this.node});
        }
    }

    private boolean deleteDirectory(File directory) {
        if (directory.exists()) {
            File[] files = directory.listFiles();
            if (files != null) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    boolean isDeleted;
                    File file = fileArray[n2];
                    if (file.isDirectory()) {
                        isDeleted = this.deleteDirectory(file);
                        if (!isDeleted) {
                            if (LOCATION.beWarning()) {
                                LOCATION.warningT("Could not delete directory: [{0}]", new Object[]{file});
                            }
                            return false;
                        }
                    } else {
                        isDeleted = file.delete();
                        if (!isDeleted) {
                            if (LOCATION.beWarning()) {
                                LOCATION.warningT("Could not delete file: [{0}], contained in directory: [{1}]", new Object[]{file, directory});
                            }
                            return false;
                        }
                    }
                    ++n2;
                }
            }
        } else if (LOCATION.beDebug()) {
            LOCATION.debugT("Nothing to delete - directory: [{0}] does not exist", new Object[]{this.node});
        }
        return directory.delete();
    }

    public void deleteContainedPropertySheets() {
        File[] children = this.node.listFiles();
        if (children != null) {
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                boolean isDeleted = file.delete();
                if (!isDeleted && LOCATION.beWarning()) {
                    LOCATION.warningT("Could not delete property sheet: [{0}], contained in directory: [{1}]", new Object[]{this.node});
                }
                ++n2;
            }
        }
    }

    public void deletePropertySheet(String psName) {
        File child = new File(this.node, psName);
        if (child.exists() && child.isFile()) {
            boolean isDeleted = child.delete();
            if (!isDeleted && LOCATION.beWarning()) {
                LOCATION.warningT("Could not delete property sheet: [{0}], contained in directory: [{1}]", new Object[]{psName, this.node});
            }
        } else if (LOCATION.beDebug()) {
            LOCATION.debugT("Nothing to delete - property sheet: [{0}] does not exist in directory: [{1}]", new Object[]{psName, this.node});
        }
    }
}

