/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.ljsadapters.filestorage;

import com.sap.security.saml2.cfg.storage.CfgStorageException;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Properties;
import java.util.Set;

public class CfgPropertySheet {
    private static final Location LOCATION = Location.getLocation(CfgPropertySheet.class);
    private File file;

    public CfgPropertySheet(File file) throws CfgStorageException {
        if (!file.exists() || !file.isFile()) {
            throw new CfgStorageException("Property sheet specified with file: " + file + " does not exist");
        }
        this.file = file;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties read(File file) throws CfgStorageException {
        Properties properties;
        Properties result = new Properties();
        Reader reader = null;
        try {
            reader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
            result.load(reader);
            properties = result;
            if (reader == null) return properties;
        }
        catch (Exception e) {
            try {
                throw new CfgStorageException("Could not read the properties from property sheet file: " + file, e);
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (Exception e2) {
                    if (!LOCATION.beWarning()) throw throwable;
                    LOCATION.traceThrowableT(400, "Could not close configuration file: {0}", new Object[]{file}, (Throwable)e2);
                }
                throw throwable;
            }
        }
        try {
            reader.close();
            return properties;
        }
        catch (Exception e) {
            if (!LOCATION.beWarning()) return properties;
            LOCATION.traceThrowableT(400, "Could not close configuration file: {0}", new Object[]{file}, (Throwable)e);
        }
        return properties;
    }

    public Properties getPropertyEntries() throws CfgStorageException {
        return this.read(this.file);
    }

    public String[] getAllPropertyEntryNames() throws CfgStorageException {
        Set<Object> keys = this.read(this.file).keySet();
        String[] result = keys.toArray(new String[keys.size()]);
        return result;
    }

    public void storePropertyEntries(Properties properties, String comments) throws CfgStorageException {
        Writer writer = null;
        try {
            try {
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), "UTF-8");
                properties.store(writer, comments);
            }
            catch (Exception e) {
                throw new CfgStorageException("Could not store properties into property sheet file: " + this.file, e);
            }
        }
        finally {
            block11: {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Exception e) {
                        if (!LOCATION.beWarning()) break block11;
                        LOCATION.traceThrowableT(400, "Could not close property sheet file: " + this.file, (Throwable)e);
                    }
                }
            }
        }
    }

    public boolean existsPropertyEntry(String name) throws CfgStorageException {
        Set<Object> keys = this.read(this.file).keySet();
        return keys.contains(name);
    }

    public void deletePropertyEntry(String name) {
    }

    public void updatePropertyEntry(String name, Object value) {
    }

    public Object getPropertyEntry(String propName) throws CfgStorageException {
        return this.read(this.file).getProperty(propName);
    }
}

