/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.metadata;

import com.sap.security.saml2.cfg.enums.SAML2EndpointLocationProtocol;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.util.CfgUtils;
import java.net.MalformedURLException;
import java.net.URL;

public class SAML2EndpointURL {
    private SAML2EndpointLocationProtocol protocol;
    private String host;
    private int port;
    private String baseUrl;

    public SAML2EndpointURL(String baseUrl) throws MalformedURLException {
        URL url = new URL(baseUrl);
        String protocol = url.getProtocol();
        if ("http".equalsIgnoreCase(protocol)) {
            this.protocol = SAML2EndpointLocationProtocol.HTTP;
        } else if ("https".equalsIgnoreCase(protocol)) {
            this.protocol = SAML2EndpointLocationProtocol.HTTPS;
        } else {
            throw new MalformedURLException("Only protocols \"http\" or \"https\" are supported for SAML2 endpoints. Specified protocol: " + protocol);
        }
        this.host = url.getHost();
        this.port = url.getPort();
    }

    public SAML2EndpointURL(SAML2EndpointLocationProtocol protocol, String host, int port) throws SAML2ConfigurationException {
        if (protocol == null) {
            throw new SAML2ConfigurationException("Protocol cannot be null");
        }
        if (CfgUtils.isEmpty(host)) {
            throw new SAML2ConfigurationException("Host cannot be empty");
        }
        this.protocol = protocol;
        this.host = host;
        this.port = port;
    }

    String formUrl(String relativePath, String additionalSAML2CfgName) {
        StringBuilder result = new StringBuilder();
        relativePath = relativePath.trim();
        if (this.getBaseUrl().endsWith("/") && relativePath.startsWith("/")) {
            result.append(this.getBaseUrl()).append(relativePath.substring(1));
        } else if (this.getBaseUrl().endsWith("/") || relativePath.startsWith("/")) {
            result.append(this.getBaseUrl()).append(relativePath);
        } else {
            result.append(this.getBaseUrl()).append('/').append(relativePath);
        }
        if (!CfgUtils.isEmpty(additionalSAML2CfgName)) {
            result.append('/').append(additionalSAML2CfgName);
        }
        return result.toString();
    }

    private String getBaseUrl() {
        if (this.baseUrl == null) {
            StringBuilder builder = new StringBuilder();
            if (SAML2EndpointLocationProtocol.HTTP == this.protocol) {
                builder.append("http://");
                if (this.port == 80) {
                    this.port = -1;
                }
            } else {
                builder.append("https://");
                if (this.port == 443) {
                    this.port = -1;
                }
            }
            builder.append(this.host);
            if (this.port > -1) {
                builder.append(':').append(this.port);
            }
            this.baseUrl = builder.toString();
        }
        return this.baseUrl;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("protocol: ").append((Object)this.protocol);
        builder.append("; host: ").append(this.host);
        builder.append("; port").append(this.port);
        return builder.toString();
    }
}

