/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.metadata;

import com.sap.security.saml2.cfg.exceptions.SAML2MetadataParseException;
import com.sap.security.saml2.cfg.metadata.SAML2MetadataParser;
import com.sap.security.saml2.cfg.metadata.SAML2MetadataTrustedProvider;
import com.sap.security.saml2.lib.assertions.SAML2SignatureKeyInfoImpl;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2Utils;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2SignatureKeyInfo;
import com.sap.security.saml2.lib.jaxb.metadata.EntitiesDescriptorType;
import com.sap.security.saml2.lib.jaxb.metadata.EntityDescriptorType;
import com.sap.security.saml2.lib.jaxb.xmldsig.KeyInfoType;
import com.sap.security.saml2.lib.jaxb.xmldsig.SignatureType;
import com.sap.security.saml2.lib.xmlsecurity.XMLSignature;
import com.sap.security.saml2.lib.xmlsecurity.XMLSignatureManager;
import com.sap.tc.logging.Location;
import java.security.cert.Certificate;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class SAML2Metadata {
    private static final Location LOCATION = Location.getLocation(SAML2Metadata.class);
    private String metadataId;
    private String rootEntityId;
    private boolean isSigned;
    private SAML2SignatureKeyInfo signatureKeyInfo;
    private Element domForSecOperations;
    private String metadataXML;
    private List<SAML2MetadataTrustedProvider> metadataTrustedProviders;

    public SAML2Metadata(String xml) throws SAML2MetadataParseException {
        this.metadataXML = xml;
        JAXBElement descriptorElement = SAML2MetadataParser.parseSAML2MetadataToJAXBElement(xml);
        Object rootDescriptor = descriptorElement.getValue();
        SignatureType jaxbSignature = null;
        if (rootDescriptor instanceof EntityDescriptorType) {
            EntityDescriptorType entityDescriptor = (EntityDescriptorType)rootDescriptor;
            jaxbSignature = entityDescriptor.getSignature();
            this.metadataId = entityDescriptor.getID();
            this.rootEntityId = entityDescriptor.getEntityID();
        } else if (rootDescriptor instanceof EntitiesDescriptorType) {
            EntitiesDescriptorType entitiesDescriptor = (EntitiesDescriptorType)rootDescriptor;
            jaxbSignature = entitiesDescriptor.getSignature();
            this.metadataId = entitiesDescriptor.getID();
        }
        if (jaxbSignature != null) {
            this.isSigned = true;
            KeyInfoType jaxbKeyInfo = jaxbSignature.getKeyInfo();
            if (jaxbKeyInfo != null) {
                this.signatureKeyInfo = new SAML2SignatureKeyInfoImpl(jaxbKeyInfo);
            }
        }
        this.metadataTrustedProviders = SAML2MetadataParser.extractSAML2MetadataTrustedProviders(descriptorElement);
    }

    public boolean isSigned() {
        return this.isSigned;
    }

    public SAML2SignatureKeyInfo getSignatureKeyInfo() {
        return this.signatureKeyInfo;
    }

    public String getRootEntityId() {
        return this.rootEntityId;
    }

    public List<SAML2MetadataTrustedProvider> getMetadataTrustedProviders() {
        return this.metadataTrustedProviders;
    }

    public void validateSignature(Certificate senderCert) throws SAML2Exception {
        Element parent;
        if (!this.isSigned) {
            throw new SAML2Exception("The metadata is not signed.");
        }
        try {
            parent = this.getDomForSecOperations();
        }
        catch (Exception e) {
            throw new SAML2Exception("Failed to check signature.", (Throwable)e);
        }
        XMLSignature verifier = XMLSignatureManager.getXMLSignatureInstance();
        String idAttributeLocalName = null;
        String idAttributeNS = null;
        NamedNodeMap attributes = parent.getAttributes();
        if (attributes != null) {
            int i = 0;
            while (i < attributes.getLength()) {
                Attr attribute = (Attr)attributes.item(i);
                if ("id".equalsIgnoreCase(attribute.getLocalName())) {
                    idAttributeLocalName = attribute.getLocalName();
                    idAttributeNS = attribute.getNamespaceURI();
                    break;
                }
                ++i;
            }
        }
        if (!verifier.verify(parent, senderCert, idAttributeLocalName, idAttributeNS)) {
            if (LOCATION.beWarning()) {
                LOCATION.warningT("Signature verification for Metadata with Id: " + this.metadataId + " failed.");
            }
            throw new SAML2Exception("Signature not valid!");
        }
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Signature for Metadata with Id: " + this.metadataId + " verified successfuly.");
        }
    }

    private Element getDomForSecOperations() throws SAML2Exception {
        if (this.domForSecOperations != null) {
            return this.domForSecOperations;
        }
        Document doc = SAML2Utils.transformXMLtoDOM((String)this.metadataXML);
        this.domForSecOperations = doc.getDocumentElement();
        return this.domForSecOperations;
    }
}

