/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.metadata;

import com.sap.security.saml2.cfg.SAML2LocalProvidersConfigImpl;
import com.sap.security.saml2.cfg.enums.DigestAlgorithm;
import com.sap.security.saml2.cfg.enums.SAML2Binding;
import com.sap.security.saml2.cfg.enums.SAML2MetadataContactPersonType;
import com.sap.security.saml2.cfg.enums.SAML2MetadataMode;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.interfaces.SAML2IdPConfiguration;
import com.sap.security.saml2.cfg.interfaces.SAML2SPConfiguration;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalIdP;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalProvider;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalSP;
import com.sap.security.saml2.cfg.interfaces.read.SAML2MetadataSettings;
import com.sap.security.saml2.cfg.metadata.SAML2EndpointURL;
import com.sap.security.saml2.cfg.util.CfgUtils;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2JAXBUtils;
import com.sap.security.saml2.lib.common.SAML2Utils;
import com.sap.security.saml2.lib.jaxb.metadata.ContactType;
import com.sap.security.saml2.lib.jaxb.metadata.ContactTypeType;
import com.sap.security.saml2.lib.jaxb.metadata.EndpointType;
import com.sap.security.saml2.lib.jaxb.metadata.EntityDescriptorType;
import com.sap.security.saml2.lib.jaxb.metadata.IDPSSODescriptorType;
import com.sap.security.saml2.lib.jaxb.metadata.IndexedEndpointType;
import com.sap.security.saml2.lib.jaxb.metadata.KeyDescriptorType;
import com.sap.security.saml2.lib.jaxb.metadata.KeyTypes;
import com.sap.security.saml2.lib.jaxb.metadata.LocalizedNameType;
import com.sap.security.saml2.lib.jaxb.metadata.LocalizedURIType;
import com.sap.security.saml2.lib.jaxb.metadata.ObjectFactory;
import com.sap.security.saml2.lib.jaxb.metadata.OrganizationType;
import com.sap.security.saml2.lib.jaxb.metadata.SPSSODescriptorType;
import com.sap.security.saml2.lib.jaxb.metadata.SSODescriptorType;
import com.sap.security.saml2.lib.jaxb.xmldsig.KeyInfoType;
import com.sap.security.saml2.lib.jaxb.xmldsig.X509DataType;
import com.sap.security.saml2.lib.xmlsecurity.XMLSignature;
import com.sap.security.saml2.lib.xmlsecurity.XMLSignatureManager;
import com.sap.tc.logging.Location;
import java.io.StringWriter;
import java.io.Writer;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SAML2MetadataGenerator {
    private static final Location LOCATION = Location.getLocation(SAML2MetadataGenerator.class);
    private static final SAML2MetadataGenerator instance = new SAML2MetadataGenerator();
    private ObjectFactory metadataFactory = new ObjectFactory();
    private com.sap.security.saml2.lib.jaxb.xmldsig.ObjectFactory sigFactory = new com.sap.security.saml2.lib.jaxb.xmldsig.ObjectFactory();

    public static SAML2MetadataGenerator getInstance() {
        return instance;
    }

    private SAML2MetadataGenerator() {
    }

    public String generateMetadata(SAML2LocalProvidersConfigImpl localProviderConfig, SAML2EndpointURL url, PrivateKey privateKey, Certificate certificate, SAML2MetadataMode mode) throws SAML2ConfigurationException {
        if (url == null) {
            throw new SAML2ConfigurationException("SAML2 endpoint URL given for the metadata generation cannot be null");
        }
        if (mode == null) {
            mode = SAML2MetadataMode.ALL_SUPPORTED_DESCRIPTORS;
        }
        if (!localProviderConfig.isSAML2FunctionalityEnabled()) {
            if (LOCATION.beWarning()) {
                LOCATION.warningT("Could not generate metadata, because SAML2 functionality is disabled.");
            }
            throw new SAML2ConfigurationException("Could not generate SAML2 metadata, because SAML2 functionality is disabled.");
        }
        SAML2LocalProvider localProvider = localProviderConfig.getLocalProvider();
        boolean isDefaultSAML2Configuration = localProviderConfig.isDefaultSAML2Configuration();
        EntityDescriptorType entityDescriptor = this.metadataFactory.createEntityDescriptorType();
        String entityDescriptorID = SAML2Utils.generateUUID();
        entityDescriptor.setID(entityDescriptorID);
        entityDescriptor.setEntityID(localProvider.getName());
        SAML2MetadataSettings metadataSettings = localProvider.getMetadataSettings();
        OrganizationType organization = this.getOrganization(metadataSettings);
        entityDescriptor.setOrganization(organization);
        ContactType contactPerson = this.getContactPerson(metadataSettings);
        if (contactPerson != null) {
            entityDescriptor.getContactPerson().add(contactPerson);
        }
        List descriptorList = entityDescriptor.getRoleDescriptorOrIDPSSODescriptorOrSPSSODescriptor();
        if (mode == SAML2MetadataMode.ONLY_IDP_SSO_DESCRIPTOR || mode == SAML2MetadataMode.ALL_SUPPORTED_DESCRIPTORS) {
            if (localProviderConfig.isIdentityProviderEnabled()) {
                IDPSSODescriptorType idpDescriptor = this.metadataFactory.createIDPSSODescriptorType();
                this.fillSSODescriptor((SSODescriptorType)idpDescriptor, localProvider, url, isDefaultSAML2Configuration);
                this.fillIdPDescriptor(idpDescriptor, localProviderConfig.getLocalIdP(), url, isDefaultSAML2Configuration);
                descriptorList.add(idpDescriptor);
            } else if (mode == SAML2MetadataMode.ONLY_IDP_SSO_DESCRIPTOR) {
                if (LOCATION.beWarning()) {
                    LOCATION.warningT("Could not generate metadata, because SAML2 Identity Provider is disabled.");
                }
                throw new SAML2ConfigurationException("Could not generate metadata, because SAML2 Identity Provider is disabled.");
            }
        }
        if (mode == SAML2MetadataMode.ONLY_SP_SSO_DESCRIPTOR || mode == SAML2MetadataMode.ALL_SUPPORTED_DESCRIPTORS) {
            if (localProviderConfig.isServiceProviderEnabled()) {
                SPSSODescriptorType spSSODescriptor = this.metadataFactory.createSPSSODescriptorType();
                this.fillSSODescriptor((SSODescriptorType)spSSODescriptor, localProvider, url, isDefaultSAML2Configuration);
                this.fillSPDescriptor(spSSODescriptor, localProviderConfig.getLocalSP(), url, isDefaultSAML2Configuration);
                descriptorList.add(spSSODescriptor);
            } else if (mode == SAML2MetadataMode.ONLY_SP_SSO_DESCRIPTOR) {
                if (LOCATION.beWarning()) {
                    LOCATION.warningT("Could not generate metadata, because SAML2 Service Provider is disabled.");
                }
                throw new SAML2ConfigurationException("Could not generate metadata, because SAML2 Service Provider is disabled.");
            }
        }
        JAXBElement entityJAXBElement = this.metadataFactory.createEntityDescriptor(entityDescriptor);
        try {
            if (localProvider.isToSignMetadata()) {
                if (privateKey == null) {
                    throw new SAML2ConfigurationException("Could not generated signed metadata, because the private key for signature is null");
                }
                if (certificate == null) {
                    throw new SAML2ConfigurationException("Could not generated signed metadata, because the certificate to be included in the signature is null");
                }
                entityDescriptor.setSignature(this.sigFactory.createSignatureType());
                return this.marshalSignedMetadataTokenToText((JAXBElement<EntityDescriptorType>)entityJAXBElement, entityDescriptorID, privateKey, certificate, metadataSettings.getDigestAlgorithm());
            }
            return SAML2JAXBUtils.marshalMetadataTokenToText((JAXBElement)entityJAXBElement);
        }
        catch (Exception e) {
            throw new SAML2ConfigurationException("Could not generate SAML2 metadata", e);
        }
    }

    public String generateMetadata(SAML2SPConfiguration spConfiguration, SAML2EndpointURL url, PrivateKey privateKey, Certificate certificate) throws SAML2Exception, SAML2ConfigurationException, IllegalArgumentException {
        if (spConfiguration == null) {
            throw new IllegalArgumentException("SP configuration is mandatory argument");
        }
        SAML2LocalSP localSP = spConfiguration.getLocalSP();
        if (localSP == null) {
            throw new SAML2ConfigurationException("The specified SAML2 SP configuration does not contains local SP settings");
        }
        return this.generateMetadata(localSP, url, privateKey, certificate);
    }

    public String generateMetadata(SAML2IdPConfiguration idpConfiguration, SAML2EndpointURL url, PrivateKey privateKey, Certificate certificate) throws SAML2Exception, SAML2ConfigurationException, IllegalArgumentException {
        if (idpConfiguration == null) {
            throw new IllegalArgumentException("IdP configuration is mandatory argument");
        }
        SAML2LocalIdP localIdP = idpConfiguration.getLocalIdP();
        if (localIdP == null) {
            throw new SAML2ConfigurationException("The specified SAML2 IdP configuration does not contains local IdP settings");
        }
        return this.generateMetadata(localIdP, url, privateKey, certificate);
    }

    public String generateMetadata(List<SAML2LocalProvider> providers, SAML2EndpointURL url, PrivateKey privateKey, Certificate certificate) throws SAML2Exception, SAML2ConfigurationException, IllegalArgumentException {
        if (url == null) {
            throw new IllegalArgumentException("Endpoint url is mandatory argument");
        }
        if (providers == null || providers.size() == 0) {
            throw new IllegalArgumentException("Local provider's list has to contain at least one local provider.");
        }
        SAML2LocalProvider localProvider = providers.get(0);
        if (localProvider == null) {
            throw new IllegalArgumentException("Local provider's list has to contain non null elements.");
        }
        EntityDescriptorType entityDescriptor = this.metadataFactory.createEntityDescriptorType();
        String name = localProvider.getName();
        String entityDescriptorID = SAML2Utils.generateUUID();
        entityDescriptor.setID(entityDescriptorID);
        entityDescriptor.setEntityID(name);
        SAML2MetadataSettings metadataSettings = localProvider.getMetadataSettings();
        if (metadataSettings != null) {
            OrganizationType organization = this.getOrganization(metadataSettings);
            entityDescriptor.setOrganization(organization);
            ContactType contactPerson = this.getContactPerson(metadataSettings);
            if (contactPerson != null) {
                entityDescriptor.getContactPerson().add(contactPerson);
            }
        }
        List descriptorList = entityDescriptor.getRoleDescriptorOrIDPSSODescriptorOrSPSSODescriptor();
        SPSSODescriptorType ssoDescriptor = null;
        for (SAML2LocalProvider provider : providers) {
            if (provider instanceof SAML2LocalSP) {
                ssoDescriptor = this.metadataFactory.createSPSSODescriptorType();
                this.fillSPDescriptor(ssoDescriptor, (SAML2LocalSP)provider, url, true);
            } else if (provider instanceof SAML2LocalIdP) {
                ssoDescriptor = this.metadataFactory.createIDPSSODescriptorType();
                this.fillIdPDescriptor((IDPSSODescriptorType)ssoDescriptor, (SAML2LocalIdP)provider, url, true);
            } else {
                throw new IllegalStateException("Specified SAML2LocalProvider is neither SAML2LocalSP nor SAML2LocalIdP. Actual type is: " + provider.getClass().getName());
            }
            this.fillSSODescriptor((SSODescriptorType)ssoDescriptor, provider, url, true);
            descriptorList.add(ssoDescriptor);
        }
        JAXBElement entityJAXBElement = this.metadataFactory.createEntityDescriptor(entityDescriptor);
        if (localProvider.isToSignMetadata()) {
            if (privateKey == null) {
                privateKey = localProvider.getPrivateKeyForSignature();
                certificate = localProvider.getCertificateForSignature();
                if (privateKey == null) {
                    throw new SAML2ConfigurationException("Could not generate signed metadata, because both the specified private key and the configured one are empty.");
                }
            }
            entityDescriptor.setSignature(this.sigFactory.createSignatureType());
            if (metadataSettings != null) {
                return this.marshalSignedMetadataTokenToText((JAXBElement<EntityDescriptorType>)entityJAXBElement, entityDescriptorID, privateKey, certificate, metadataSettings.getDigestAlgorithm());
            }
            return this.marshalSignedMetadataTokenToText((JAXBElement<EntityDescriptorType>)entityJAXBElement, entityDescriptorID, privateKey, certificate, DigestAlgorithm.SHA1);
        }
        return SAML2JAXBUtils.marshalMetadataTokenToText((JAXBElement)entityJAXBElement);
    }

    private String generateMetadata(SAML2LocalProvider localProvider, SAML2EndpointURL url, PrivateKey privateKey, Certificate certificate) throws SAML2Exception, SAML2ConfigurationException, IllegalArgumentException {
        return this.generateMetadata(Arrays.asList(localProvider), url, privateKey, certificate);
    }

    private ContactType getContactPerson(SAML2MetadataSettings metadataSettings) {
        boolean isEmptyContactPerson = true;
        String company = metadataSettings.getContactCompany();
        String givenName = metadataSettings.getContactGivenName();
        String surname = metadataSettings.getContactSurname();
        String email = metadataSettings.getContactEmail();
        String phone = metadataSettings.getContactPhone();
        SAML2MetadataContactPersonType type = metadataSettings.getContactType();
        ContactType contactPerson = this.metadataFactory.createContactType();
        if (!CfgUtils.isEmpty(company)) {
            contactPerson.setCompany(company);
            isEmptyContactPerson = false;
        }
        if (!CfgUtils.isEmpty(givenName)) {
            contactPerson.setGivenName(givenName);
            isEmptyContactPerson = false;
        }
        if (!CfgUtils.isEmpty(surname)) {
            contactPerson.setSurName(surname);
            isEmptyContactPerson = false;
        }
        if (!CfgUtils.isEmpty(email)) {
            contactPerson.getEmailAddress().add(email);
            isEmptyContactPerson = false;
        }
        if (!CfgUtils.isEmpty(phone)) {
            contactPerson.getTelephoneNumber().add(phone);
            isEmptyContactPerson = false;
        }
        if (!isEmptyContactPerson && type != null) {
            contactPerson.setContactType(SAML2MetadataGenerator.getContactTypeTypeForString(type));
            return contactPerson;
        }
        return null;
    }

    private OrganizationType getOrganization(SAML2MetadataSettings metadataSettings) {
        String name = metadataSettings.getOrganizationName();
        String language = metadataSettings.getOrganizationLanguage();
        String displayName = metadataSettings.getOrganizationDisplayName();
        String orgUrl = metadataSettings.getOrganizationURL();
        if (CfgUtils.isEmpty(name) || CfgUtils.isEmpty(displayName) || CfgUtils.isEmpty(orgUrl) || CfgUtils.isEmpty(language)) {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Organization data is missing and will not be added to metadata. ");
            }
            return null;
        }
        OrganizationType organizationType = this.metadataFactory.createOrganizationType();
        LocalizedNameType organizationName = this.metadataFactory.createLocalizedNameType();
        organizationName.setLang(language);
        organizationName.setValue(name);
        LocalizedNameType organizationDisplayName = this.metadataFactory.createLocalizedNameType();
        organizationDisplayName.setValue(displayName);
        organizationDisplayName.setLang(language);
        LocalizedURIType organizationURI = this.metadataFactory.createLocalizedURIType();
        organizationURI.setValue(orgUrl);
        organizationType.getOrganizationName().add(organizationName);
        organizationType.getOrganizationDisplayName().add(organizationDisplayName);
        organizationType.getOrganizationURL().add(organizationURI);
        return organizationType;
    }

    private void fillSSODescriptor(SSODescriptorType ssoDescriptor, SAML2LocalProvider localProvider, SAML2EndpointURL url, boolean isDefaultSAML2Configuration) throws SAML2ConfigurationException {
        Certificate certForEncryption;
        List protocolSupportEnumeration = ssoDescriptor.getProtocolSupportEnumeration();
        protocolSupportEnumeration.add("urn:oasis:names:tc:SAML:2.0:protocol");
        List keyDescriptorList = ssoDescriptor.getKeyDescriptor();
        Certificate certForSigning = localProvider.getCertificateForSignature();
        if (certForSigning != null) {
            this.addKeyDescriptor(keyDescriptorList, KeyTypes.SIGNING, localProvider.getName(), certForSigning);
        }
        if ((certForEncryption = localProvider.getCertificateForEncryption()) != null) {
            this.addKeyDescriptor(keyDescriptorList, KeyTypes.ENCRYPTION, localProvider.getName(), certForEncryption);
        }
        String arsLocation = isDefaultSAML2Configuration ? url.formUrl(localProvider.getArtifactResolutionLocationHardCoded(), null) : url.formUrl(localProvider.getArtifactResolutionLocationHardCoded(), localProvider.getName());
        List endpoints = ssoDescriptor.getArtifactResolutionService();
        int index = 0;
        for (SAML2Binding binding : localProvider.getArtifactResolutionSupportedBindings()) {
            IndexedEndpointType endpoint = this.metadataFactory.createIndexedEndpointType();
            endpoint.setLocation(arsLocation);
            endpoint.setBinding(binding.getName());
            endpoint.setIndex(index++);
            if (binding.equals(SAML2Binding.SOAP_BINDING)) {
                endpoint.setIsDefault(Boolean.valueOf(true));
            }
            endpoints.add(endpoint);
        }
    }

    private static ContactTypeType getContactTypeTypeForString(SAML2MetadataContactPersonType type) {
        switch (type) {
            case ADMINISTRATIVE: {
                return ContactTypeType.ADMINISTRATIVE;
            }
            case BILLING: {
                return ContactTypeType.BILLING;
            }
            case SUPPORT: {
                return ContactTypeType.SUPPORT;
            }
            case TECHNICAL: {
                return ContactTypeType.TECHNICAL;
            }
            case OTHER: {
                return ContactTypeType.OTHER;
            }
        }
        return null;
    }

    private void addKeyDescriptor(List<KeyDescriptorType> keyDescriptorList, KeyTypes keyTypes, String providerName, Certificate cert) throws SAML2ConfigurationException {
        KeyDescriptorType keyDescriptorType = this.metadataFactory.createKeyDescriptorType();
        keyDescriptorList.add(keyDescriptorType);
        keyDescriptorType.setUse(keyTypes);
        KeyInfoType keyInfoType = this.sigFactory.createKeyInfoType();
        keyDescriptorType.setKeyInfo(keyInfoType);
        List keyInfoContent = keyInfoType.getContent();
        JAXBElement keyNameElement = this.sigFactory.createKeyName(providerName);
        keyInfoContent.add(keyNameElement);
        X509DataType x509Data = this.sigFactory.createX509DataType();
        JAXBElement x509DataElement = this.sigFactory.createX509Data(x509Data);
        keyInfoContent.add(x509DataElement);
        List certificateList = x509Data.getX509IssuerSerialOrX509SKIOrX509SubjectName();
        try {
            JAXBElement x509CertElement = this.sigFactory.createX509DataTypeX509Certificate(cert.getEncoded());
            certificateList.add(x509CertElement);
        }
        catch (CertificateEncodingException e) {
            throw new SAML2ConfigurationException("Could not encode the certificate for metadata", e);
        }
    }

    private void fillIdPDescriptor(IDPSSODescriptorType idpDescriptor, SAML2LocalIdP localIdP, SAML2EndpointURL url, boolean isDefaultSAML2Configuration) throws SAML2ConfigurationException {
        idpDescriptor.setWantAuthnRequestsSigned(Boolean.valueOf(true));
        String ssoLocation = isDefaultSAML2Configuration ? url.formUrl(localIdP.getSingleSignOnLocationHardCoded(), null) : url.formUrl(localIdP.getSingleSignOnLocationHardCoded(), localIdP.getName());
        List endpoints = idpDescriptor.getSingleSignOnService();
        for (SAML2Binding binding : localIdP.getSingleSignOnSupportedBindings()) {
            EndpointType endpoint = this.metadataFactory.createEndpointType();
            endpoint.setLocation(ssoLocation);
            endpoint.setBinding(binding.getName());
            endpoints.add(endpoint);
        }
        String sloLocation = isDefaultSAML2Configuration ? url.formUrl(localIdP.getSingleLogoutLocationHardCoded(), null) : url.formUrl(localIdP.getSingleLogoutLocationHardCoded(), localIdP.getName());
        List sloEndpoints = idpDescriptor.getSingleLogoutService();
        for (SAML2Binding binding : localIdP.getSingleLogoutSupportedBindings()) {
            EndpointType endpoint = this.metadataFactory.createEndpointType();
            endpoint.setLocation(sloLocation);
            endpoint.setBinding(binding.getName());
            sloEndpoints.add(endpoint);
        }
        String mniLocation = isDefaultSAML2Configuration ? url.formUrl(localIdP.getManageNameIDLocationHardCoded(), null) : url.formUrl(localIdP.getManageNameIDLocationHardCoded(), localIdP.getName());
        List mniEndpoints = idpDescriptor.getManageNameIDService();
        for (SAML2Binding binding : localIdP.getManageNameIDSupportedBindings()) {
            EndpointType endpoint = this.metadataFactory.createEndpointType();
            endpoint.setLocation(mniLocation);
            endpoint.setBinding(binding.getName());
            mniEndpoints.add(endpoint);
        }
    }

    private void fillSPDescriptor(SPSSODescriptorType spDescriptor, SAML2LocalSP localSP, SAML2EndpointURL url, boolean isDefaultSAML2Configuration) throws SAML2ConfigurationException {
        spDescriptor.setAuthnRequestsSigned(Boolean.valueOf(true));
        String sloLocation = isDefaultSAML2Configuration ? url.formUrl(localSP.getSingleLogoutLocationHardCoded(), null) : url.formUrl(localSP.getSingleLogoutLocationHardCoded(), localSP.getName());
        List endpoints = spDescriptor.getSingleLogoutService();
        for (SAML2Binding binding : localSP.getSingleLogoutSupportedBindings()) {
            EndpointType endpoint = this.metadataFactory.createEndpointType();
            endpoint.setLocation(sloLocation);
            endpoint.setBinding(binding.getName());
            endpoints.add(endpoint);
        }
        String acsLocation = isDefaultSAML2Configuration ? url.formUrl(localSP.getAssertionConsumerLocationHardCoded(), null) : url.formUrl(localSP.getAssertionConsumerLocationHardCoded(), localSP.getName());
        List acsEndpoints = spDescriptor.getAssertionConsumerService();
        for (SAML2Binding binding : localSP.getAssertionConsumerSupportedBindings()) {
            IndexedEndpointType endpoint = this.metadataFactory.createIndexedEndpointType();
            endpoint.setLocation(acsLocation);
            endpoint.setBinding(binding.getName());
            if (binding.equals(SAML2Binding.HTTP_POST_BINDING)) {
                endpoint.setIndex(0);
                endpoint.setIsDefault(Boolean.valueOf(true));
            } else if (binding.equals(SAML2Binding.HTTP_ARTIFACT_BINDING)) {
                endpoint.setIndex(1);
            } else if (binding.equals(SAML2Binding.PAOS_BINDING)) {
                endpoint.setIndex(2);
            }
            acsEndpoints.add(endpoint);
        }
        String mniLocation = isDefaultSAML2Configuration ? url.formUrl(localSP.getManageNameIDLocationHardCoded(), null) : url.formUrl(localSP.getManageNameIDLocationHardCoded(), localSP.getName());
        List mniEndpoints = spDescriptor.getManageNameIDService();
        for (SAML2Binding binding : localSP.getManageNameIDSupportedBindings()) {
            EndpointType endpoint = this.metadataFactory.createEndpointType();
            endpoint.setLocation(mniLocation);
            endpoint.setBinding(binding.getName());
            mniEndpoints.add(endpoint);
        }
    }

    private String marshalSignedMetadataTokenToText(JAXBElement<EntityDescriptorType> entityJAXBElement, String entityDescriptorID, PrivateKey keyForSigning, Certificate certForSigning, DigestAlgorithm digestAlgorithm) throws SAML2Exception {
        Document doc;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.newDocument();
            Marshaller marshaller = SAML2JAXBUtils.getMetadataMarshaller();
            marshaller.marshal(entityJAXBElement, (Node)doc);
        }
        catch (Exception e) {
            throw new SAML2Exception("Could not generate metadata XML", (Throwable)e);
        }
        XMLSignature signer = XMLSignatureManager.getXMLSignatureInstance();
        StringWriter signedXML = new StringWriter();
        signer.sign(doc.getDocumentElement(), entityDescriptorID, keyForSigning, certForSigning, (Writer)signedXML, digestAlgorithm.getName());
        return signedXML.toString();
    }
}

