/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.metadata;

import com.sap.security.saml2.cfg.enums.SAML2Binding;
import com.sap.security.saml2.cfg.enums.SAML2NameIdFormat;
import com.sap.security.saml2.cfg.enums.SAML2Service;
import com.sap.security.saml2.cfg.exceptions.SAML2MetadataParseException;
import com.sap.security.saml2.cfg.metadata.SAML2MetadataEndpoint;
import com.sap.security.saml2.cfg.metadata.SAML2MetadataTrustedIdP;
import com.sap.security.saml2.cfg.metadata.SAML2MetadataTrustedProvider;
import com.sap.security.saml2.cfg.metadata.SAML2MetadataTrustedSP;
import com.sap.security.saml2.lib.assertions.SAML2SignatureKeyInfoImpl;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2JAXBUtils;
import com.sap.security.saml2.lib.jaxb.metadata.EndpointType;
import com.sap.security.saml2.lib.jaxb.metadata.EntitiesDescriptorType;
import com.sap.security.saml2.lib.jaxb.metadata.EntityDescriptorType;
import com.sap.security.saml2.lib.jaxb.metadata.IDPSSODescriptorType;
import com.sap.security.saml2.lib.jaxb.metadata.IndexedEndpointType;
import com.sap.security.saml2.lib.jaxb.metadata.KeyDescriptorType;
import com.sap.security.saml2.lib.jaxb.metadata.KeyTypes;
import com.sap.security.saml2.lib.jaxb.metadata.RoleDescriptorType;
import com.sap.security.saml2.lib.jaxb.metadata.SPSSODescriptorType;
import com.sap.security.saml2.lib.jaxb.metadata.SSODescriptorType;
import com.sap.tc.logging.Location;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;

public class SAML2MetadataParser {
    private static final Location LOCATION = Location.getLocation(SAML2MetadataParser.class);

    public static List<SAML2MetadataTrustedProvider> parseSAML2Metadata(InputStream input) throws SAML2MetadataParseException {
        StringBuilder builder = new StringBuilder(2000);
        try {
            int len;
            InputStreamReader reader = new InputStreamReader(input, "UTF-8");
            char[] cbuf = new char[100];
            while ((len = reader.read(cbuf)) != -1) {
                builder.append(cbuf, 0, len);
            }
        }
        catch (Exception e) {
            throw new SAML2MetadataParseException("Could not read the metadata input", e);
        }
        return SAML2MetadataParser.parseSAML2Metadata(builder.toString());
    }

    public static List<SAML2MetadataTrustedProvider> parseSAML2Metadata(String xml) throws SAML2MetadataParseException {
        JAXBElement descriptorElement = SAML2MetadataParser.parseSAML2MetadataToJAXBElement(xml);
        List<SAML2MetadataTrustedProvider> result = SAML2MetadataParser.extractSAML2MetadataTrustedProviders(descriptorElement);
        return result;
    }

    public static JAXBElement parseSAML2MetadataToJAXBElement(String xml) throws SAML2MetadataParseException {
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Metadata for parsing:\n{0}", new Object[]{xml});
        }
        String localXML = xml;
        try {
            byte[] bytes = xml.getBytes("UTF-8");
            if (bytes.length > 2 && bytes[0] == -17 && bytes[1] == -69 && bytes[2] == -65) {
                byte[] newBytes = new byte[bytes.length - 3];
                System.arraycopy(bytes, 3, newBytes, 0, bytes.length - 3);
                localXML = new String(newBytes, "UTF-8");
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new SAML2MetadataParseException("Could not convert the read metadata to byte array", e);
        }
        try {
            JAXBElement descriptorElement = SAML2JAXBUtils.unmarshalMetadataTokenFromXMLText((String)localXML);
            return descriptorElement;
        }
        catch (SAML2Exception e) {
            LOCATION.traceThrowableT(500, "Could not parse SAML2 metadata", (Throwable)e);
            throw new SAML2MetadataParseException(e);
        }
    }

    public static List<SAML2MetadataTrustedProvider> extractSAML2MetadataTrustedProviders(JAXBElement descriptorElement) throws SAML2MetadataParseException {
        Object rootDescriptor = descriptorElement.getValue();
        if (!(rootDescriptor instanceof EntityDescriptorType) && !(rootDescriptor instanceof EntitiesDescriptorType)) {
            throw new SAML2MetadataParseException("Root element of the SAML2 metadata must be either EntityDescryptor or EntitiesDescriptor. Root type found: " + (rootDescriptor != null ? rootDescriptor.getClass() : null));
        }
        ArrayList<SAML2MetadataTrustedProvider> result = new ArrayList<SAML2MetadataTrustedProvider>();
        ArrayList<Object> entityOrEntitiesDescriptors = new ArrayList<Object>();
        entityOrEntitiesDescriptors.add(rootDescriptor);
        int i = 0;
        while (i < entityOrEntitiesDescriptors.size()) {
            Object currentDescriptor = entityOrEntitiesDescriptors.get(i);
            if (currentDescriptor instanceof EntityDescriptorType) {
                SAML2MetadataParser.processEntityDescriptor((EntityDescriptorType)currentDescriptor, result);
            } else if (currentDescriptor instanceof EntitiesDescriptorType) {
                entityOrEntitiesDescriptors.addAll(((EntitiesDescriptorType)currentDescriptor).getEntityDescriptorOrEntitiesDescriptor());
            } else {
                throw new SAML2MetadataParseException("Non valid descriptor type has been found: " + (currentDescriptor != null ? currentDescriptor.getClass() : null) + "Must be either EntityDescryptor or EntitiesDescriptor");
            }
            ++i;
        }
        return result;
    }

    private static void processEntityDescriptor(EntityDescriptorType descriptor, List<SAML2MetadataTrustedProvider> trustedProviders) {
        String trustedProviderName = descriptor.getEntityID();
        List ssoDescriptors = descriptor.getRoleDescriptorOrIDPSSODescriptorOrSPSSODescriptor();
        if (ssoDescriptors.isEmpty()) {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Entity descriptor with entity id: {0} does not have SP or IdP SSO descriptors", new Object[]{trustedProviderName});
            }
            return;
        }
        for (RoleDescriptorType roleDescriptor : ssoDescriptors) {
            if (roleDescriptor == null) continue;
            List supportedProtocols = roleDescriptor.getProtocolSupportEnumeration();
            if (!supportedProtocols.contains("urn:oasis:names:tc:SAML:2.0:protocol")) {
                if (!LOCATION.beDebug()) continue;
                LOCATION.debugT("Role descriptor for entity with id: {0} does not support SAML 2.0 will be skipped. Its supported protocols are: {1}", new Object[]{trustedProviderName, supportedProtocols});
                continue;
            }
            if (roleDescriptor instanceof IDPSSODescriptorType) {
                IDPSSODescriptorType idpSSODescriptor = (IDPSSODescriptorType)roleDescriptor;
                SAML2MetadataTrustedIdP trustedIdP = new SAML2MetadataTrustedIdP();
                trustedIdP.setName(trustedProviderName);
                SAML2MetadataParser.processIdPSSODescriptor(idpSSODescriptor, trustedIdP);
                trustedProviders.add(trustedIdP);
                continue;
            }
            if (roleDescriptor instanceof SPSSODescriptorType) {
                SPSSODescriptorType spSSODescriptor = (SPSSODescriptorType)roleDescriptor;
                SAML2MetadataTrustedSP trustedSP = new SAML2MetadataTrustedSP();
                trustedSP.setName(trustedProviderName);
                SAML2MetadataParser.processSPSSODescriptor(spSSODescriptor, trustedSP);
                trustedProviders.add(trustedSP);
                continue;
            }
            if (!LOCATION.beDebug()) continue;
            LOCATION.debugT("Unsupported role descriptor with type: {0} has been found in entity descriptor with entity id: {1}. Skip it from the metadata processing", new Object[]{roleDescriptor != null ? roleDescriptor.getClass() : null});
        }
    }

    private static void processIdPSSODescriptor(IDPSSODescriptorType idpSSODescriptor, SAML2MetadataTrustedIdP trustedIdP) {
        SAML2MetadataParser.processSSODescriptor((SSODescriptorType)idpSSODescriptor, trustedIdP);
        List<SAML2MetadataEndpoint> ssoEndpoints = SAML2MetadataParser.extractSSOEndpoints(idpSSODescriptor);
        trustedIdP.setSingleSignOnEndpoints(ssoEndpoints);
        Boolean wantAuthReqSigned = idpSSODescriptor.isWantAuthnRequestsSigned();
        trustedIdP.setWantAuthnRequestsSigned(wantAuthReqSigned);
    }

    private static void processSPSSODescriptor(SPSSODescriptorType spSSODescriptor, SAML2MetadataTrustedSP trustedSP) {
        SAML2MetadataParser.processSSODescriptor((SSODescriptorType)spSSODescriptor, trustedSP);
        List<SAML2MetadataEndpoint> acsEndpoints = SAML2MetadataParser.extractACSEndpoints(spSSODescriptor);
        trustedSP.setAssertionConsumerEndpoints(acsEndpoints);
        Boolean isAuthnRequestSigned = spSSODescriptor.isAuthnRequestsSigned();
        trustedSP.setAuthnRequestSigned(isAuthnRequestSigned);
        Boolean isWantAssertionsSigned = spSSODescriptor.isWantAssertionsSigned();
        trustedSP.setWantAssertionsSigned(isWantAssertionsSigned);
    }

    private static void processSSODescriptor(SSODescriptorType ssoDescriptor, SAML2MetadataTrustedProvider trustedProvider) {
        String commonViewEntryName = null;
        String commonCertificateBase64 = null;
        String signingViewEntryName = null;
        String signingCertificateBase64 = null;
        String encViewEntryName = null;
        String encCertificateBase64 = null;
        List keyDescriptors = ssoDescriptor.getKeyDescriptor();
        for (KeyDescriptorType keyDesc : keyDescriptors) {
            KeyTypes keyType;
            SAML2SignatureKeyInfoImpl saml2KeyInfo = new SAML2SignatureKeyInfoImpl(keyDesc.getKeyInfo());
            String keyName = saml2KeyInfo.getKeyName();
            String keyBase64 = saml2KeyInfo.getX509CertificateBase64();
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Entity with name: " + trustedProvider.getName() + " has certificate: " + keyBase64);
            }
            if ((keyType = keyDesc.getUse()) == null) {
                commonViewEntryName = keyName;
                commonCertificateBase64 = keyBase64;
                continue;
            }
            if (KeyTypes.SIGNING.equals((Object)keyType)) {
                signingViewEntryName = keyName;
                signingCertificateBase64 = keyBase64;
                continue;
            }
            if (KeyTypes.ENCRYPTION.equals((Object)keyType)) {
                encViewEntryName = keyName;
                encCertificateBase64 = keyBase64;
                continue;
            }
            if (!LOCATION.beDebug()) continue;
            LOCATION.debugT("Invalid \"use\" attribute: {0} of the Key descriptor", new Object[]{keyType});
        }
        if (commonViewEntryName != null) {
            if (signingViewEntryName == null) {
                signingViewEntryName = commonViewEntryName;
            }
            if (encViewEntryName == null) {
                encViewEntryName = commonViewEntryName;
            }
        }
        if (commonCertificateBase64 != null) {
            if (signingCertificateBase64 == null) {
                signingCertificateBase64 = commonCertificateBase64;
            }
            if (encCertificateBase64 == null) {
                encCertificateBase64 = commonCertificateBase64;
            }
        }
        trustedProvider.setSigningEntryName(signingViewEntryName);
        trustedProvider.setSigningCertificateString(signingCertificateBase64);
        trustedProvider.setEncryptionEntryName(encViewEntryName);
        trustedProvider.setEncryptionCertificateString(encCertificateBase64);
        trustedProvider.setSupportedNameIDFormats(SAML2MetadataParser.extractNameIDFormats(ssoDescriptor));
        trustedProvider.setArtifactResolutionEndpoints(SAML2MetadataParser.extractARSEndpoints(ssoDescriptor));
        trustedProvider.setSingleLogoutEndpoints(SAML2MetadataParser.extractSLOEndpoints(ssoDescriptor));
        trustedProvider.setManageNameIdEndpoints(SAML2MetadataParser.extractMNIEndpoints(ssoDescriptor));
    }

    private static List<SAML2MetadataEndpoint> extractSSOEndpoints(IDPSSODescriptorType idpSSODescriptor) {
        ArrayList<SAML2MetadataEndpoint> result = new ArrayList<SAML2MetadataEndpoint>();
        List ssoEndpoints = idpSSODescriptor.getSingleSignOnService();
        for (EndpointType endpoint : ssoEndpoints) {
            SAML2Binding binding = SAML2Binding.getBinding(endpoint.getBinding());
            if (binding == null) {
                if (!LOCATION.beDebug()) continue;
                LOCATION.debugT("Metadata SSO endpoint has binding: {0} which is not supported. Skip it.", new Object[]{endpoint.getBinding()});
                continue;
            }
            SAML2MetadataEndpoint e = new SAML2MetadataEndpoint();
            e.setService(SAML2Service.SINGLE_SIGN_ON_SERVICE);
            e.setBinding(binding);
            e.setLocation(endpoint.getLocation());
            e.setResponseLocation(endpoint.getResponseLocation());
            result.add(e);
        }
        return result;
    }

    private static List<SAML2MetadataEndpoint> extractACSEndpoints(SPSSODescriptorType spSSODescriptor) {
        ArrayList<SAML2MetadataEndpoint> result = new ArrayList<SAML2MetadataEndpoint>();
        List acsEndpoints = spSSODescriptor.getAssertionConsumerService();
        for (IndexedEndpointType acsEndpoint : acsEndpoints) {
            SAML2Binding binding = SAML2Binding.getBinding(acsEndpoint.getBinding());
            if (binding == null) {
                if (!LOCATION.beDebug()) continue;
                LOCATION.debugT("Metadata ACS endpoint has binding: {0} which is not supported. Skip it.", new Object[]{acsEndpoint.getBinding()});
                continue;
            }
            SAML2MetadataEndpoint e = new SAML2MetadataEndpoint();
            e.setService(SAML2Service.ASSERTION_CONSUMER_SERVICE);
            e.setBinding(binding);
            e.setLocation(acsEndpoint.getLocation());
            e.setResponseLocation(acsEndpoint.getResponseLocation());
            e.setIndex(acsEndpoint.getIndex());
            e.setDefault(acsEndpoint.isIsDefault());
            result.add(e);
        }
        return result;
    }

    private static List<SAML2MetadataEndpoint> extractSLOEndpoints(SSODescriptorType ssoDescriptor) {
        ArrayList<SAML2MetadataEndpoint> result = new ArrayList<SAML2MetadataEndpoint>();
        List sloEndpoints = ssoDescriptor.getSingleLogoutService();
        for (EndpointType sloEndpoint : sloEndpoints) {
            SAML2Binding binding = SAML2Binding.getBinding(sloEndpoint.getBinding());
            if (binding == null) {
                if (!LOCATION.beDebug()) continue;
                LOCATION.debugT("Metadata SLO endpoint has binding: {0} which is not supported. Skip it.", new Object[]{sloEndpoint.getBinding()});
                continue;
            }
            SAML2MetadataEndpoint e = new SAML2MetadataEndpoint();
            e.setBinding(binding);
            e.setService(SAML2Service.SINGLE_LOGOUT_SERVICE);
            e.setLocation(sloEndpoint.getLocation());
            e.setResponseLocation(sloEndpoint.getResponseLocation());
            result.add(e);
        }
        return result;
    }

    private static List<SAML2MetadataEndpoint> extractARSEndpoints(SSODescriptorType ssoDescriptor) {
        ArrayList<SAML2MetadataEndpoint> result = new ArrayList<SAML2MetadataEndpoint>();
        List artifactEndpoints = ssoDescriptor.getArtifactResolutionService();
        for (IndexedEndpointType endpoint : artifactEndpoints) {
            SAML2Binding binding = SAML2Binding.getBinding(endpoint.getBinding());
            if (binding == null) {
                if (!LOCATION.beDebug()) continue;
                LOCATION.debugT("Metadata ARS endpoint has binding: {0} which is not supported. Skip it.", new Object[]{endpoint.getBinding()});
                continue;
            }
            SAML2MetadataEndpoint e = new SAML2MetadataEndpoint();
            e.setService(SAML2Service.ARTIFACT_RESOLUTION_SERVICE);
            e.setBinding(binding);
            e.setLocation(endpoint.getLocation());
            e.setResponseLocation(endpoint.getResponseLocation());
            e.setIndex(endpoint.getIndex());
            e.setDefault(endpoint.isIsDefault());
            result.add(e);
        }
        return result;
    }

    private static List<SAML2MetadataEndpoint> extractMNIEndpoints(SSODescriptorType ssoDescriptor) {
        ArrayList<SAML2MetadataEndpoint> result = new ArrayList<SAML2MetadataEndpoint>();
        List mniEndpoints = ssoDescriptor.getManageNameIDService();
        for (EndpointType mniEndpoint : mniEndpoints) {
            SAML2Binding binding = SAML2Binding.getBinding(mniEndpoint.getBinding());
            if (binding == null) {
                if (!LOCATION.beDebug()) continue;
                LOCATION.debugT("Metadata MNI endpoint has binding: {0} which is not supported. Skip it.", new Object[]{mniEndpoint.getBinding()});
                continue;
            }
            SAML2MetadataEndpoint e = new SAML2MetadataEndpoint();
            e.setBinding(binding);
            e.setService(SAML2Service.MANAGE_NAMEID_SERVICE);
            e.setLocation(mniEndpoint.getLocation());
            e.setResponseLocation(mniEndpoint.getResponseLocation());
            result.add(e);
        }
        return result;
    }

    private static List<SAML2NameIdFormat> extractNameIDFormats(SSODescriptorType ssoDescriptor) {
        ArrayList<SAML2NameIdFormat> result = new ArrayList<SAML2NameIdFormat>();
        List formats = ssoDescriptor.getNameIDFormat();
        for (String format : formats) {
            SAML2NameIdFormat nameIdFormat = SAML2NameIdFormat.getNameIdFormatByName(format);
            if (nameIdFormat != null) {
                result.add(nameIdFormat);
                continue;
            }
            if (!LOCATION.beDebug()) continue;
            LOCATION.debugT("NameId-format: {0} is not supported. Skip it.", new Object[]{format});
        }
        return result;
    }
}

